#ifndef NEWBUTTONDLG_H
#define NEWBUTTONDLG_H

#include <QtGui/QDialog>
#include <QFile>
#include <QTextStream>
#include "qtirreco.h"
#include "layoutwidget.h"
#include "buttonselectdlg.h"
#include "commandchaindlg.h"
#include "buttonwidget.h"

class ButtonWidget;
class ButtonSelectDlg;
class CommandChainDlg;

namespace Ui {
    class NewButtonDlg;
}

class NewButtonDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(NewButtonDlg)
public:
    //! Constructor.
    explicit NewButtonDlg(QWidget *parent = 0, QVector<ButtonWidget*> *vector = 0);
    //! Constructor used when editing button.
    explicit NewButtonDlg(QWidget *parent, ButtonWidget *child, QVector<ButtonWidget*> *vector);
    //! Destructor.
    virtual ~NewButtonDlg();

protected:
    void mousePressEvent(QMouseEvent *event);

private:
    Ui::NewButtonDlg *m_ui;
    ButtonSelectDlg *bsDlg;
    CommandChainDlg *ccDlg;
    //! Method for reading button config.
    void process_line(QString line);
    //! Pixmap for button unpressed.
    QPixmap *pix;
    //! Button datas.
    QString fileNameUnPressedToEmit;
    QString fileNamePressedToEmit;
    QString confFileNameToEmit;
    QString buttonTextToEmit;
    QStringList commandChain;
    //! Time between button commands in milliseconds.
    int timeOut;
    //! Has remote buttons.
    QVector<ButtonWidget*> *buttons;
    //! If edit mode.
    bool editMode;
    //! Buttonwidget to check if name is same in edit mode.
    ButtonWidget *button;

private slots:
    //! Slots for commandchain navigation and deleting items.
    void on_downPushButton_clicked();
    void on_upPushButton_clicked();
    void on_removePushButton_clicked();
    void on_addPushButton_clicked();
    //! Emits buttondata to layout.
    void on_OkPushButton_clicked();
    void setTimeOut(int timeValue);
    void allowCreatingButton();

public slots:
    //! Opens button select dialog.
    void on_styleChangePushButton_clicked();
    //! Adds command to listwidget.
    void getCommand(QString commandName,QString modelName);
    //! Slot for adding preview pixmap to style label.
    void addPreviewImage(QString fileNameUnPressed, QString fileNamePressed, QString confFileName);

signals:
    //! Signal emitted when adding button to layout / OK clicked.
    void addButtonToLayoutSignal(QString fileNameUnPressed, QString fileNamePressed, QString confFileName, QString buttonTextToEmit, QStringList commands, int number, int timeOut);
};
#endif // NEWBUTTONDLG_H
