#include "downloaduserremotedlg.h"
#include "ui_downloaduserremotedlg.h"

DownloadUserRemoteDlg::DownloadUserRemoteDlg(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::DownloadUserRemoteDlg)
{
    m_ui->setupUi(this);
    m_ui->previousPushButton->setDisabled(true);
    this->setWindowTitle("Download remote");
    replaceRemote = false;

    QUrl url;
    url.setHost("mercury.wipsl.com");
    url.setPath("/qtirreco/webdb/");
    url.setPort(80);

    client = new QxtXmlRpcClient(this, url);
    connect(client,SIGNAL(finish(int,QVariant)),this,SLOT(processReturnValue(int,QVariant)));
    connect(client,SIGNAL(networkError(int,QString)),this,SLOT(error(int,QString )));
    connect(client,SIGNAL(fault(int,int,QString )),this,SLOT(fault(int,int,QString)));

    connect(m_ui->listWidget,SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(updateListWidget(QListWidgetItem*)));

    listState = 0;

    params.clear();
    listId = client->call("getRemoteCategories",params);

}

DownloadUserRemoteDlg::~DownloadUserRemoteDlg()
{
    delete m_ui;
}

void DownloadUserRemoteDlg::processReturnValue(int Id,QVariant data)
{
    if (Id == listId) {
        m_ui->listWidget->clear();
        m_ui->listWidget->insertItems(0,data.toStringList());
        this->setEnabled(true);
    }
    else if (Id == remoteIdcall) {
        QMap<QString,QVariant> array = data.toMap();
        QVariant categoryV = array.value("category");
        QVariant modelV = array.value("model");
        QVariant creatorV = array.value("user");
        QVariant downloadedV = array.value("downloaded");
        QVariant commentV = array.value("comment");
        QVariant hashV = array.value("file_hash");
        fileHash = hashV.toString();
        QVariant fname = array.value("file_name");
        fileName = fname.toString();
        m_ui->typeLabel->setText(categoryV.toString()); //2
        m_ui->modelLabel->setText(modelV.toString());
        m_ui->creatorLabel->setText(creatorV.toString());
        // TODO: add themes label
        //m_ui->themesLabel->setText(remoteValues->at());
        m_ui->downloadedLabel->setText(downloadedV.toString());
        m_ui->commentLabel->setText(commentV.toString());
        m_ui->downloadPushButton->setEnabled(true);
        this->setEnabled(true);
    }
    else if (Id == dataId) {
        QMap<QString,QVariant> array = data.toMap();
        QVariant dataVar = array.value("data");
        QString data = dataVar.toString();

        QFile file(remotesPath + fileName);
        if (file.exists()) {
            replaceRemote = false;
             /*QMessageBox::warning(this,"Remote name already exists!","Cannot download remote, please delete remote with same name before downloading.",
                                 QMessageBox::NoButton,QMessageBox::NoButton);*/
            QDialog *dlg = new QDialog(this);
            dlg->resize(800,200);
            dlg->setWindowTitle("Filename already exists!");
            QLabel *label = new QLabel(dlg);
            label->setGeometry(100,20,800,50);
            label->setText("Do you want to replace remote: " + fileName + " ?");
            label->show();
            QPushButton *button = new QPushButton(dlg);
            button->setGeometry(300,75,200,72);
            button->setText("Replace");
            button->show();
            connect(button,SIGNAL(clicked()),this,SLOT(replaceRemoteSlot()));
            connect(button,SIGNAL(clicked()),dlg,SLOT(deleteLater()));
            dlg->exec();
        }

        if(replaceRemote || !file.exists()) {
            if (!file.open(QIODevice::WriteOnly | QIODevice::Text))
                return;

            QTextStream stream( &file );
            stream << data;
            file.close();

            emit remoteDownloaded(fileName);
            fileName.clear();
            this->close();
        }
    }
    else if (Id == remoteIds) {
        remoteIdList.clear();
        versions.clear();
        versionIndex = 0;
        remoteVersions.clear();

        remoteIdList = data.toStringList();
        this->getRemoteVersionById(remoteIdList.at(versionIndex));
    }
    else if (Id == remoteVersion) {
        versionIndex++;
        versions.append(data.toString());
        remoteVersions.insert(data.toString(),remoteId);


        if(remoteIdList.count() == 1) {
             m_ui->listWidget->clear();
             m_ui->listWidget->addItems(versions);
             this->setEnabled(true);
        }
        if(versionIndex >= remoteIdList.count()) {
            m_ui->listWidget->clear();
            m_ui->listWidget->addItems(versions);
            this->setEnabled(true);
        }
        else this->getRemoteVersionById(remoteIdList.at(versionIndex));

    }
}
void DownloadUserRemoteDlg::replaceRemoteSlot()
{
    replaceRemote = true;
}
void DownloadUserRemoteDlg::getRemoteVersionById(const QString &id)
{
      if(versionIndex < remoteIdList.count()) {
            params.clear();
            bool ok;
            remoteId = id.toInt(&ok,10);
            params.append(remoteId);

            remoteVersion = client->call("getRemoteVersionById",params);
        }
}

void DownloadUserRemoteDlg::error(int i ,QString string)
{
        QMessageBox::warning(this,"Error: "+QString::number(i,10), string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}
void DownloadUserRemoteDlg::fault(int i,int j,QString string)
{
    Q_UNUSED(j);
    QMessageBox::warning(this,"Fault: "+QString::number(i,10),string,
                     QMessageBox::NoButton,QMessageBox::NoButton);
}
void DownloadUserRemoteDlg::updateListWidget(QListWidgetItem* item)
{
    params.clear();

    switch(listState) {
        case 0: // categories
            m_ui->previousPushButton->setEnabled(true);
            m_ui->label->setText("Remote manufacturer");
            category = item->text();
            params.append(category);
            this->setDisabled(true);
            listId = client->call("getRemoteManufacturers",params);
            listState = 1;
        break;
        case 1: //manufacturers
            m_ui->label->setText("Remote model");
            manufacturer = item->text();
            params.append(category);
            params.append(manufacturer);
            this->setDisabled(true);
            listId = client->call("getRemoteModels",params);
            listState = 2;
        break;
         case 2: //models
            m_ui->label->setText("Remote creator");
            model = item->text();
            params.append(category);
            params.append(manufacturer);
            params.append(model);
            this->setDisabled(true);
            listId = client->call("getRemoteCreators",params);
            listState = 3;
        break;
         case 3: //creators
            m_ui->label->setText("Remote version");
            creator = item->text();
            params.append(category);
            params.append(manufacturer);
            params.append(model);
            params.append(creator);
            this->setDisabled(true);
            remoteIds = client->call("getRemotes",params);
            listState = 4;
        break;
         case 4: //remotes
            remId = remoteVersions.value(item->text());
            params.append(remId);
            this->setDisabled(true);
            remoteIdcall = client->call("getRemoteById",params);
        break;
    }

}

void DownloadUserRemoteDlg::on_previousPushButton_clicked()
{
    this->setDisabled(true);
    m_ui->commentLabel->clear();
    m_ui->creatorLabel->clear();
    m_ui->downloadedLabel->clear();
    m_ui->typeLabel->clear();
    m_ui->modelLabel->clear();
    m_ui->downloadPushButton->setDisabled(true);

    params.clear();

    if(listState > -1)
        listState--;

    switch(listState) {
        case 0:
            m_ui->label->setText("Remote type");
            m_ui->previousPushButton->setDisabled(true);
            listId = client->call("getRemoteCategories",params);

        break;
        case 1:
            m_ui->previousPushButton->setEnabled(true);
            m_ui->label->setText("Remote manufacturer");
            params.append(category);
            listId = client->call("getRemoteManufacturers",params);
        break;
        case 2:
            m_ui->label->setText("Remote model");
            params.append(category);
            params.append(manufacturer);
            listId = client->call("getRemoteModels",params);
        break;
         case 3:
            m_ui->label->setText("Remote creator");
            params.append(category);
            params.append(manufacturer);
            params.append(model);
            listId = client->call("getRemoteCreators",params);
        break;
    }

}

void DownloadUserRemoteDlg::on_downloadPushButton_clicked()
{
    params.clear();
    params.append(remId);
    dataId = client->call("getRemoteData",params);
}
