#ifndef COMMANDCHAINDLG_H
#define COMMANDCHAINDLG_H

#include <QtGui/QDialog>
#include <QListWidgetItem>
#include <QDir>

#include "newbuttondlg.h"
#include "definitions.h"

class DownloadRemoteDlg;

namespace Ui {
    class CommandChainDlg;
}

class CommandChainDlg : public QDialog {
    Q_OBJECT
    Q_DISABLE_COPY(CommandChainDlg)
public:
    //! Constructor.
    explicit CommandChainDlg(QWidget *parent = 0);
    //! Destructor.
    virtual ~CommandChainDlg();

private:
    Ui::CommandChainDlg *m_ui;
    //! Pushbutton used for selecting wanted commands to commandchain.
    QPushButton *commandButton;
    //! Stringlist containing remote models on device.
    QStringList models;

    QString remoteName;
    bool confFileInUse;
    QStringList lircConfs;
    QString remoteUsingLircConf;
    //! If config contains normal codes flag is true.
    bool flag;
    //! If config contains raw codes raw_flag is true.
    bool raw_flag;
    //! Stringlist containing remote commands.
    QStringList commands;
    //! Method for reading remote config file.
    void process_line(QString line);
    //! Method for reading remote config file for deleting.
    void read_line(QString line, int readIndex);
    //! DownloadremoteDlg object.
    DownloadRemoteDlg *dloadRmDlg;


signals:
    //! Adds command to NewButtonDlg and closes this.
    void signalAddCommand(QString commandName,QString modelName);

private slots:
    //! Opens DownloadRemoteDlg.
    void on_downloadRemoteButton_clicked();
    //! Emits signalAddCommand with proper item values.
    void commandItemClicked(QListWidgetItem* item);
    //! Reads remote commands from file and adds pushbuttons to listwidget.
    void getCommands(QListWidgetItem* item);
    //! Removes remote file.
    void deleteRemote();
};
#endif // COMMANDCHAINDLG_H
