#include <QSettings>

#include "qthellosettings.h"

QthelloSettings::QthelloSettings()
{
    QSettings settings;
    startNewGame_ = settings.value("StartNewGame", true).toBool();
    animationSpeed_ = settings.value("AnimationSpeed", 2).toInt();
    saveMode_ = settings.value("SaveMode", true).toBool();
    if (saveMode_)
    {
        mode_ = settings.value("Mode", 1).toInt();
        AILevel_ = settings.value("AILevel", 1).toInt();
    }
    else
    {
        mode_ = 1;
        AILevel_ = 1;
    }
}

QthelloSettings::~QthelloSettings()
{
    QSettings settings;
    settings.setValue("StartNewGame", startNewGame_);
    settings.setValue("AnimationSpeed", animationSpeed_);
    settings.setValue("SaveMode", saveMode_);
    if (saveMode_)
    {
        settings.setValue("Mode", mode_);
        settings.setValue("AILevel", AILevel_);
    }
}
