#include <QtGui/QPainter>
#include <QMouseEvent>

//#include "pixmaps/EmptyCell.xpm"
//#include "pixmaps/WhiteCell.xpm"
//#include "pixmaps/BlackCell.xpm"

#include "fieldview.h"
#include "reversigame.h"
#include "reversiscene.h"


FieldView::FieldView(ReversiGame &reversiGame, QWidget *parent) :
    QGraphicsView(parent),
    reversiGame_(reversiGame)
{
    scene_ = new ReversiScene(reversiGame_);
    setScene(scene_);

    setMinimumSize(scene_->fieldWidth(), scene_->fieldHeight());
    setMaximumSize(scene_->fieldWidth(), scene_->fieldHeight());

    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setFrameStyle(QFrame::NoFrame);

    connect(scene_, SIGNAL(playerStep(int,int)), parent, SLOT(slotPlayerStep(int,int)));
}

QSize FieldView::sizeHint () const
{
    return QSize(scene_->fieldWidth(), scene_->fieldHeight());
}
void FieldView::setAnimationSpeed(int animationSpeed)
{
    scene_->setAnimationSpeed(animationSpeed);
}
