//    QtBatteryWidget
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "widgetmanager.h"
#include "settings.h"
#include "mainwindow.h"
#include <QDebug>

WidgetManager::WidgetManager(QObject *parent) :
    QObject(parent)
{
}

void WidgetManager::RestoreWidgets()
{
    QList<QString> appletIds = Settings::GetAppletIds();

    if (appletIds.count() > 0){
        //Restore widgets:
        foreach(QString id, appletIds){
            MainWindow* w = new MainWindow(NULL, id);
            w->show();
        }
    }else{
        //Create new widget:
        MainWindow* w = new MainWindow(NULL, "");
        appletIds.append(w->GetAppletId());
        w->show();
    }
    Settings::SaveAppletIds(appletIds);
}

void WidgetManager::receiveMessage(const QString& message)
{
    qDebug() << QString("Received message: %1").arg(message);
    if (message == MESSAGE_ADD_WIDGET){
        //Create new widget:
        QList<QString> appletIds = Settings::GetAppletIds();
        MainWindow* w = new MainWindow(NULL, "");
        appletIds.append(w->GetAppletId());
        w->show();
        Settings::SaveAppletIds(appletIds);
    }
}

void WidgetManager::RemoveWidget(QString appletId)
{
    qDebug() << QString("Removing widget: %1").arg(appletId);
    Settings::RemoveWidget(appletId);
}
