#ifndef SEARCH_H
#define SEARCH_H
#include <libspotify/api.h>
#include "trackcollection.h"
#include "album.h"
namespace Spotify
{
    class Link;
    class Search : public TrackCollection
    {

        public:
            Search(sp_session* session, sp_search* search, QObject* parent = 0);
            ~Search();

            virtual bool load();

            sp_search* getSearch() const { return m_search; }
            QString getSearchQuery() const { return m_searchQuery; }
            QString getSugguestions() const { return m_sugguestions; }
            QList< Spotify::Artist* > getArtists() const { return m_artists; }
            QList< Spotify::Album* > getAlbums() const { return m_albums; }

        private:
            sp_session* m_session;
            sp_search* m_search;
            QString m_searchQuery;
            QString m_sugguestions;
            QList< Spotify::Artist* > m_artists;
            QList< Spotify::Album* > m_albums;

    };

} // namespace Spotify

#endif // SEARCH_H
