#ifndef UTILS_H
#define UTILS_H

#include <QObject>
#include <QVariantList>

class QWidget;

//using namespace QtMobility;

#include "qmlapplicationviewer.h"

class Utils : public QObject {
    Q_OBJECT

    Q_PROPERTY(QString currentTime
               READ getCurrentTime
               NOTIFY currentTimeChanged)

public:
    explicit Utils(QObject *parent = 0);

    void setView(QmlApplicationViewer* view);
    QString getCurrentTime() const;

public slots:

    QVariantList getInstalledMediaPlayers() const;
    void minimize();

private:
    QmlApplicationViewer *viewer;

signals:
    void alert(const QString &message);
    void windowMinimized();
    void currentTimeChanged();
};

#endif // UTILS_H
