#ifndef YouTube_H
#define YouTube_H

#include <QObject>
#include <QtNetwork/QNetworkReply>

class YouTube : public QObject {
    Q_OBJECT

public:
    explicit YouTube(QObject *parent = 0);

public slots:
    void setPlaybackQuality(const int &quality);
    void getVideoUrl(const QString &playerUrl);

private slots:
    void parseVideoPage(QNetworkReply *reply);

signals:
    void gotVideoUrl(const QString &videoUrl);
    void videoUrlError();

private:
    int playbackQuality;

};

#endif // YouTube_H
