/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_PHONON_PYTHON_H
#define SBK_PHONON_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_PHONON_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_PHONON_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_PHONON_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>

// Binded library includes
#include <phononnamespace.h>
#include <backendinterface.h>
#include <mediaobjectinterface.h>
#include <audiooutput.h>
#include <videowidget.h>
#include <effectparameter.h>
#include <path.h>
#include <mediacontroller.h>
#include <abstractmediastream.h>
#include <streaminterface.h>
#include "pyside_phonon.h"
#include <seekslider.h>
#include <effectinterface.h>
#include <objectdescriptionmodel.h>
#include <abstractvideooutput.h>
#include <objectdescription.h>
#include <mediaobject.h>
#include <abstractaudiooutput.h>
#include <volumeslider.h>
#include <platformplugin.h>
#include <volumefadereffect.h>
#include <mediasource.h>
#include <medianode.h>
#include <backendcapabilities.h>
#include <videoplayer.h>
#include <effectwidget.h>
#include <volumefaderinterface.h>
#include <addoninterface.h>
#include <videowidgetinterface.h>
#include <effect.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_PHONON_IDX                                               0
#define SBK_PHONON_DISCTYPE_IDX                                      1
#define SBK_PHONON_METADATA_IDX                                      2
#define SBK_PHONON_CATEGORY_IDX                                      3
#define SBK_PHONON_OBJECTDESCRIPTIONTYPE_IDX                         4
#define SBK_PHONON_STATE_IDX                                         5
#define SBK_PHONON_ERRORTYPE_IDX                                     6
#define SBK_PHONON_BACKENDCAPABILITIES_IDX                           7
#define SBK_PHONON_AUDIOCHANNELDESCRIPTION_IDX                       8
#define SBK_PHONON_AUDIOOUTPUTDEVICE_IDX                             9
#define SBK_PHONON_AUDIOCAPTUREDEVICE_IDX                            10
#define SBK_PHONON_SUBTITLEDESCRIPTION_IDX                           11
#define SBK_PHONON_EFFECTDESCRIPTION_IDX                             12
#define SBK_PHONON_VOLUMEFADERINTERFACE_IDX                          13
#define SBK_PHONON_BACKENDINTERFACE_IDX                              14
#define SBK_PHONON_BACKENDINTERFACE_CLASS_IDX                        15
#define SBK_PHONON_EFFECTINTERFACE_IDX                               16
#define SBK_PHONON_ADDONINTERFACE_IDX                                17
#define SBK_PHONON_ADDONINTERFACE_SUBTITLECOMMAND_IDX                18
#define SBK_PHONON_ADDONINTERFACE_TITLECOMMAND_IDX                   19
#define SBK_PHONON_ADDONINTERFACE_INTERFACE_IDX                      20
#define SBK_PHONON_ADDONINTERFACE_AUDIOCHANNELCOMMAND_IDX            21
#define SBK_PHONON_ADDONINTERFACE_CHAPTERCOMMAND_IDX                 22
#define SBK_PHONON_ADDONINTERFACE_NAVIGATIONCOMMAND_IDX              23
#define SBK_PHONON_ADDONINTERFACE_ANGLECOMMAND_IDX                   24
#define SBK_PHONON_MEDIAOBJECTINTERFACE_IDX                          25
#define SBK_PHONON_PATH_IDX                                          26
#define SBK_PHONON_MEDIANODE_IDX                                     27
#define SBK_PHONON_ABSTRACTVIDEOOUTPUT_IDX                           28
#define SBK_PHONON_VIDEOWIDGETINTERFACE_IDX                          29
#define SBK_PHONON_STREAMINTERFACE_IDX                               30
#define SBK_PHONON_EFFECTDESCRIPTIONMODEL_IDX                        31
#define SBK_PHONON_AUDIOOUTPUTDEVICEMODEL_IDX                        32
#define SBK_PHONON_PLATFORMPLUGIN_IDX                                33
#define SBK_PHONON_BACKENDCAPABILITIES_NOTIFIERWRAPPER_IDX           34
#define SBK_PHONON_MEDIACONTROLLER_IDX                               35
#define SBK_PHONON_MEDIACONTROLLER_FEATURE_IDX                       36
#define SBK_QFLAGS_PHONON_MEDIACONTROLLER_FEATURE__IDX               37
#define SBK_PHONON_MEDIAOBJECT_IDX                                   38
#define SBK_PHONON_ABSTRACTAUDIOOUTPUT_IDX                           39
#define SBK_PHONON_AUDIOOUTPUT_IDX                                   40
#define SBK_PHONON_EFFECT_IDX                                        41
#define SBK_PHONON_VOLUMEFADEREFFECT_IDX                             42
#define SBK_PHONON_VOLUMEFADEREFFECT_FADECURVE_IDX                   43
#define SBK_PHONON_ABSTRACTMEDIASTREAM_IDX                           44
#define SBK_PHONON_VIDEOWIDGET_IDX                                   45
#define SBK_PHONON_VIDEOWIDGET_ASPECTRATIO_IDX                       46
#define SBK_PHONON_VIDEOWIDGET_SCALEMODE_IDX                         47
#define SBK_PHONON_VOLUMESLIDER_IDX                                  48
#define SBK_PHONON_VIDEOPLAYER_IDX                                   49
#define SBK_PHONON_SEEKSLIDER_IDX                                    50
#define SBK_PHONON_EFFECTWIDGET_IDX                                  51
#define SBK_PHONON_EFFECTPARAMETER_IDX                               52
#define SBK_PHONON_EFFECTPARAMETER_HINT_IDX                          53
#define SBK_QFLAGS_PHONON_EFFECTPARAMETER_HINT__IDX                  54
#define SBK_PHONON_MEDIASOURCE_IDX                                   55
#define SBK_PHONON_MEDIASOURCE_TYPE_IDX                              56
#define SBK_phonon_IDX_COUNT                                         57

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_phononTypes;

// Macros for type check
#define SbkPySide_phonon_Phonon_DiscType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_DISCTYPE_IDX])
#define SbkPySide_phonon_Phonon_MetaData_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_METADATA_IDX])
#define SbkPySide_phonon_Phonon_Category_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_CATEGORY_IDX])
#define SbkPySide_phonon_Phonon_ObjectDescriptionType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_OBJECTDESCRIPTIONTYPE_IDX])
#define SbkPySide_phonon_Phonon_State_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_STATE_IDX])
#define SbkPySide_phonon_Phonon_ErrorType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ERRORTYPE_IDX])
#define SbkPhonon_AudioChannelDescription_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_AUDIOCHANNELDESCRIPTION_IDX])
#define SbkPhonon_AudioOutputDevice_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUTDEVICE_IDX])
#define SbkPhonon_AudioCaptureDevice_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_AUDIOCAPTUREDEVICE_IDX])
#define SbkPhonon_SubtitleDescription_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_SUBTITLEDESCRIPTION_IDX])
#define SbkPhonon_EffectDescription_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECTDESCRIPTION_IDX])
#define SbkPhonon_VolumeFaderInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADERINTERFACE_IDX])
#define SbkPySide_phonon_Phonon_BackendInterface_Class_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_CLASS_IDX])
#define SbkPhonon_BackendInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_IDX])
#define SbkPhonon_EffectInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECTINTERFACE_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_SubtitleCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_SUBTITLECOMMAND_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_TitleCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_TITLECOMMAND_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_Interface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_INTERFACE_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_AudioChannelCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_AUDIOCHANNELCOMMAND_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_ChapterCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_CHAPTERCOMMAND_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_NavigationCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_NAVIGATIONCOMMAND_IDX])
#define SbkPySide_phonon_Phonon_AddonInterface_AngleCommand_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_ANGLECOMMAND_IDX])
#define SbkPhonon_AddonInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_IDX])
#define SbkPhonon_MediaObjectInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIAOBJECTINTERFACE_IDX])
#define SbkPhonon_Path_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_PATH_IDX])
#define SbkPhonon_MediaNode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX])
#define SbkPhonon_AbstractVideoOutput_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ABSTRACTVIDEOOUTPUT_IDX])
#define SbkPhonon_VideoWidgetInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGETINTERFACE_IDX])
#define SbkPhonon_StreamInterface_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_STREAMINTERFACE_IDX])
#define SbkPhonon_EffectDescriptionModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECTDESCRIPTIONMODEL_IDX])
#define SbkPhonon_AudioOutputDeviceModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUTDEVICEMODEL_IDX])
#define SbkPhonon_PlatformPlugin_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_PLATFORMPLUGIN_IDX])
#define SbkPhonon_BackendCapabilities_NotifierWrapper_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_BACKENDCAPABILITIES_NOTIFIERWRAPPER_IDX])
#define SbkPySide_phonon_Phonon_MediaController_Feature_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIACONTROLLER_FEATURE_IDX])
#define SbkPySide_phonon_Phonon_MediaController_Features_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_QFLAGS_PHONON_MEDIACONTROLLER_FEATURE__IDX])
#define SbkPhonon_MediaController_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIACONTROLLER_IDX])
#define SbkPhonon_MediaObject_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIAOBJECT_IDX])
#define SbkPhonon_AbstractAudioOutput_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ABSTRACTAUDIOOUTPUT_IDX])
#define SbkPhonon_AudioOutput_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUT_IDX])
#define SbkPhonon_Effect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECT_IDX])
#define SbkPySide_phonon_Phonon_VolumeFaderEffect_FadeCurve_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADEREFFECT_FADECURVE_IDX])
#define SbkPhonon_VolumeFaderEffect_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADEREFFECT_IDX])
#define SbkPhonon_AbstractMediaStream_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_ABSTRACTMEDIASTREAM_IDX])
#define SbkPySide_phonon_Phonon_VideoWidget_AspectRatio_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGET_ASPECTRATIO_IDX])
#define SbkPySide_phonon_Phonon_VideoWidget_ScaleMode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGET_SCALEMODE_IDX])
#define SbkPhonon_VideoWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGET_IDX])
#define SbkPhonon_VolumeSlider_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VOLUMESLIDER_IDX])
#define SbkPhonon_VideoPlayer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_VIDEOPLAYER_IDX])
#define SbkPhonon_SeekSlider_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_SEEKSLIDER_IDX])
#define SbkPhonon_EffectWidget_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECTWIDGET_IDX])
#define SbkPySide_phonon_Phonon_EffectParameter_Hint_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECTPARAMETER_HINT_IDX])
#define SbkPySide_phonon_Phonon_EffectParameter_Hints_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_QFLAGS_PHONON_EFFECTPARAMETER_HINT__IDX])
#define SbkPhonon_EffectParameter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_EFFECTPARAMETER_IDX])
#define SbkPySide_phonon_Phonon_MediaSource_Type_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIASOURCE_TYPE_IDX])
#define SbkPhonon_MediaSource_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_phononTypes[SBK_PHONON_MEDIASOURCE_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<Phonon::DiscType >() { return SbkPySide_phononTypes[SBK_PHONON_DISCTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::MetaData >() { return SbkPySide_phononTypes[SBK_PHONON_METADATA_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::Category >() { return SbkPySide_phononTypes[SBK_PHONON_CATEGORY_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::ObjectDescriptionType >() { return SbkPySide_phononTypes[SBK_PHONON_OBJECTDESCRIPTIONTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::State >() { return SbkPySide_phononTypes[SBK_PHONON_STATE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::ErrorType >() { return SbkPySide_phononTypes[SBK_PHONON_ERRORTYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AudioChannelDescription >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_AUDIOCHANNELDESCRIPTION_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AudioOutputDevice >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUTDEVICE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AudioCaptureDevice >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_AUDIOCAPTUREDEVICE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::SubtitleDescription >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_SUBTITLEDESCRIPTION_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::EffectDescription >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_EFFECTDESCRIPTION_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::VolumeFaderInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADERINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::BackendInterface::Class >() { return SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_CLASS_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::BackendInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::EffectInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_EFFECTINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::SubtitleCommand >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_SUBTITLECOMMAND_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::TitleCommand >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_TITLECOMMAND_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::Interface >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_INTERFACE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::AudioChannelCommand >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_AUDIOCHANNELCOMMAND_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::ChapterCommand >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_CHAPTERCOMMAND_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::NavigationCommand >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_NAVIGATIONCOMMAND_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface::AngleCommand >() { return SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_ANGLECOMMAND_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::AddonInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_ADDONINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::MediaObjectInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_MEDIAOBJECTINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::Path >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_PATH_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::MediaNode >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_MEDIANODE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AbstractVideoOutput >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_ABSTRACTVIDEOOUTPUT_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::VideoWidgetInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGETINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::StreamInterface >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_STREAMINTERFACE_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::EffectDescriptionModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_EFFECTDESCRIPTIONMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AudioOutputDeviceModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUTDEVICEMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::PlatformPlugin >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_PLATFORMPLUGIN_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::BackendCapabilities::NotifierWrapper >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_BACKENDCAPABILITIES_NOTIFIERWRAPPER_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::MediaController::Feature >() { return SbkPySide_phononTypes[SBK_PHONON_MEDIACONTROLLER_FEATURE_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Phonon::MediaController::Feature> >() { return SbkPySide_phononTypes[SBK_QFLAGS_PHONON_MEDIACONTROLLER_FEATURE__IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::MediaController >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_MEDIACONTROLLER_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::MediaObject >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_MEDIAOBJECT_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AbstractAudioOutput >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_ABSTRACTAUDIOOUTPUT_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AudioOutput >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_AUDIOOUTPUT_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::Effect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_EFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::VolumeFaderEffect::FadeCurve >() { return SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADEREFFECT_FADECURVE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::VolumeFaderEffect >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_VOLUMEFADEREFFECT_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::AbstractMediaStream >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_ABSTRACTMEDIASTREAM_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::VideoWidget::AspectRatio >() { return SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGET_ASPECTRATIO_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::VideoWidget::ScaleMode >() { return SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGET_SCALEMODE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::VideoWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_VIDEOWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::VolumeSlider >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_VOLUMESLIDER_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::VideoPlayer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_VIDEOPLAYER_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::SeekSlider >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_SEEKSLIDER_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::EffectWidget >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_EFFECTWIDGET_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::EffectParameter::Hint >() { return SbkPySide_phononTypes[SBK_PHONON_EFFECTPARAMETER_HINT_IDX]; }
template<> inline PyTypeObject* SbkType<QFlags<Phonon::EffectParameter::Hint> >() { return SbkPySide_phononTypes[SBK_QFLAGS_PHONON_EFFECTPARAMETER_HINT__IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::EffectParameter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_EFFECTPARAMETER_IDX]); }
template<> inline PyTypeObject* SbkType<Phonon::MediaSource::Type >() { return SbkPySide_phononTypes[SBK_PHONON_MEDIASOURCE_TYPE_IDX]; }
template<> inline PyTypeObject* SbkType<Phonon::MediaSource >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_phononTypes[SBK_PHONON_MEDIASOURCE_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<Phonon::DiscType > : EnumConverter<Phonon::DiscType >
{
};

template<>
struct Converter<Phonon::MetaData > : EnumConverter<Phonon::MetaData >
{
};

template<>
struct Converter<Phonon::Category > : EnumConverter<Phonon::Category >
{
};

template<>
struct Converter<Phonon::ObjectDescriptionType > : EnumConverter<Phonon::ObjectDescriptionType >
{
};

template<>
struct Converter<Phonon::State > : EnumConverter<Phonon::State >
{
};

template<>
struct Converter<Phonon::ErrorType > : EnumConverter<Phonon::ErrorType >
{
};

template<>
struct Converter<Phonon::AudioChannelDescription > : ValueTypeConverter<Phonon::AudioChannelDescription >
{
};

template<>
struct Converter<Phonon::AudioOutputDevice > : ValueTypeConverter<Phonon::AudioOutputDevice >
{
};

template<>
struct Converter<Phonon::AudioCaptureDevice > : ValueTypeConverter<Phonon::AudioCaptureDevice >
{
};

template<>
struct Converter<Phonon::SubtitleDescription > : ValueTypeConverter<Phonon::SubtitleDescription >
{
};

template<>
struct Converter<Phonon::EffectDescription > : ValueTypeConverter<Phonon::EffectDescription >
{
};

template<>
struct Converter<Phonon::VolumeFaderInterface* > : ObjectTypeConverter<Phonon::VolumeFaderInterface >
{
};

template<>
struct Converter<Phonon::VolumeFaderInterface& > : ObjectTypeReferenceConverter<Phonon::VolumeFaderInterface >
{
};

template<>
struct Converter<Phonon::BackendInterface::Class > : EnumConverter<Phonon::BackendInterface::Class >
{
};

template<>
struct Converter<Phonon::BackendInterface* > : ObjectTypeConverter<Phonon::BackendInterface >
{
};

template<>
struct Converter<Phonon::BackendInterface& > : ObjectTypeReferenceConverter<Phonon::BackendInterface >
{
};

template<>
struct Converter<Phonon::EffectInterface* > : ObjectTypeConverter<Phonon::EffectInterface >
{
};

template<>
struct Converter<Phonon::EffectInterface& > : ObjectTypeReferenceConverter<Phonon::EffectInterface >
{
};

template<>
struct Converter<Phonon::AddonInterface::SubtitleCommand > : EnumConverter<Phonon::AddonInterface::SubtitleCommand >
{
};

template<>
struct Converter<Phonon::AddonInterface::TitleCommand > : EnumConverter<Phonon::AddonInterface::TitleCommand >
{
};

template<>
struct Converter<Phonon::AddonInterface::Interface > : EnumConverter<Phonon::AddonInterface::Interface >
{
};

template<>
struct Converter<Phonon::AddonInterface::AudioChannelCommand > : EnumConverter<Phonon::AddonInterface::AudioChannelCommand >
{
};

template<>
struct Converter<Phonon::AddonInterface::ChapterCommand > : EnumConverter<Phonon::AddonInterface::ChapterCommand >
{
};

template<>
struct Converter<Phonon::AddonInterface::NavigationCommand > : EnumConverter<Phonon::AddonInterface::NavigationCommand >
{
};

template<>
struct Converter<Phonon::AddonInterface::AngleCommand > : EnumConverter<Phonon::AddonInterface::AngleCommand >
{
};

template<>
struct Converter<Phonon::AddonInterface* > : ObjectTypeConverter<Phonon::AddonInterface >
{
};

template<>
struct Converter<Phonon::AddonInterface& > : ObjectTypeReferenceConverter<Phonon::AddonInterface >
{
};

template<>
struct Converter<Phonon::MediaObjectInterface* > : ObjectTypeConverter<Phonon::MediaObjectInterface >
{
};

template<>
struct Converter<Phonon::MediaObjectInterface& > : ObjectTypeReferenceConverter<Phonon::MediaObjectInterface >
{
};

template<>
struct Converter<Phonon::Path > : ValueTypeConverter<Phonon::Path >
{
};

template<>
struct Converter<Phonon::MediaNode* > : ObjectTypeConverter<Phonon::MediaNode >
{
};

template<>
struct Converter<Phonon::MediaNode& > : ObjectTypeReferenceConverter<Phonon::MediaNode >
{
};

template<>
struct Converter<Phonon::AbstractVideoOutput* > : ObjectTypeConverter<Phonon::AbstractVideoOutput >
{
};

template<>
struct Converter<Phonon::AbstractVideoOutput& > : ObjectTypeReferenceConverter<Phonon::AbstractVideoOutput >
{
};

template<>
struct Converter<Phonon::VideoWidgetInterface* > : ObjectTypeConverter<Phonon::VideoWidgetInterface >
{
};

template<>
struct Converter<Phonon::VideoWidgetInterface& > : ObjectTypeReferenceConverter<Phonon::VideoWidgetInterface >
{
};

template<>
struct Converter<Phonon::StreamInterface* > : ObjectTypeConverter<Phonon::StreamInterface >
{
};

template<>
struct Converter<Phonon::StreamInterface& > : ObjectTypeReferenceConverter<Phonon::StreamInterface >
{
};

template<>
struct Converter<Phonon::EffectDescriptionModel* > : ObjectTypeConverter<Phonon::EffectDescriptionModel >
{
};

template<>
struct Converter<Phonon::EffectDescriptionModel& > : ObjectTypeReferenceConverter<Phonon::EffectDescriptionModel >
{
};

template<>
struct Converter<Phonon::AudioOutputDeviceModel* > : ObjectTypeConverter<Phonon::AudioOutputDeviceModel >
{
};

template<>
struct Converter<Phonon::AudioOutputDeviceModel& > : ObjectTypeReferenceConverter<Phonon::AudioOutputDeviceModel >
{
};

template<>
struct Converter<Phonon::PlatformPlugin* > : ObjectTypeConverter<Phonon::PlatformPlugin >
{
};

template<>
struct Converter<Phonon::PlatformPlugin& > : ObjectTypeReferenceConverter<Phonon::PlatformPlugin >
{
};

template<>
struct Converter<Phonon::BackendCapabilities::NotifierWrapper* > : ObjectTypeConverter<Phonon::BackendCapabilities::NotifierWrapper >
{
};

template<>
struct Converter<Phonon::BackendCapabilities::NotifierWrapper& > : ObjectTypeReferenceConverter<Phonon::BackendCapabilities::NotifierWrapper >
{
};

template<>
struct Converter<Phonon::MediaController::Feature > : EnumConverter<Phonon::MediaController::Feature >
{
};
template<>
struct Converter<QFlags<Phonon::MediaController::Feature> > : EnumConverter<QFlags<Phonon::MediaController::Feature> >
{
};

template<>
struct Converter<Phonon::MediaController* > : ObjectTypeConverter<Phonon::MediaController >
{
};

template<>
struct Converter<Phonon::MediaController& > : ObjectTypeReferenceConverter<Phonon::MediaController >
{
};

template<>
struct Converter<Phonon::MediaObject* > : ObjectTypeConverter<Phonon::MediaObject >
{
};

template<>
struct Converter<Phonon::MediaObject& > : ObjectTypeReferenceConverter<Phonon::MediaObject >
{
};

template<>
struct Converter<Phonon::AbstractAudioOutput* > : ObjectTypeConverter<Phonon::AbstractAudioOutput >
{
};

template<>
struct Converter<Phonon::AbstractAudioOutput& > : ObjectTypeReferenceConverter<Phonon::AbstractAudioOutput >
{
};

template<>
struct Converter<Phonon::AudioOutput* > : ObjectTypeConverter<Phonon::AudioOutput >
{
};

template<>
struct Converter<Phonon::AudioOutput& > : ObjectTypeReferenceConverter<Phonon::AudioOutput >
{
};

template<>
struct Converter<Phonon::Effect* > : ObjectTypeConverter<Phonon::Effect >
{
};

template<>
struct Converter<Phonon::Effect& > : ObjectTypeReferenceConverter<Phonon::Effect >
{
};

template<>
struct Converter<Phonon::VolumeFaderEffect::FadeCurve > : EnumConverter<Phonon::VolumeFaderEffect::FadeCurve >
{
};

template<>
struct Converter<Phonon::VolumeFaderEffect* > : ObjectTypeConverter<Phonon::VolumeFaderEffect >
{
};

template<>
struct Converter<Phonon::VolumeFaderEffect& > : ObjectTypeReferenceConverter<Phonon::VolumeFaderEffect >
{
};

template<>
struct Converter<Phonon::AbstractMediaStream* > : ObjectTypeConverter<Phonon::AbstractMediaStream >
{
};

template<>
struct Converter<Phonon::AbstractMediaStream& > : ObjectTypeReferenceConverter<Phonon::AbstractMediaStream >
{
};

template<>
struct Converter<Phonon::VideoWidget::AspectRatio > : EnumConverter<Phonon::VideoWidget::AspectRatio >
{
};

template<>
struct Converter<Phonon::VideoWidget::ScaleMode > : EnumConverter<Phonon::VideoWidget::ScaleMode >
{
};

template<>
struct Converter<Phonon::VideoWidget* > : ObjectTypeConverter<Phonon::VideoWidget >
{
};

template<>
struct Converter<Phonon::VideoWidget& > : ObjectTypeReferenceConverter<Phonon::VideoWidget >
{
};

template<>
struct Converter<Phonon::VolumeSlider* > : ObjectTypeConverter<Phonon::VolumeSlider >
{
};

template<>
struct Converter<Phonon::VolumeSlider& > : ObjectTypeReferenceConverter<Phonon::VolumeSlider >
{
};

template<>
struct Converter<Phonon::VideoPlayer* > : ObjectTypeConverter<Phonon::VideoPlayer >
{
};

template<>
struct Converter<Phonon::VideoPlayer& > : ObjectTypeReferenceConverter<Phonon::VideoPlayer >
{
};

template<>
struct Converter<Phonon::SeekSlider* > : ObjectTypeConverter<Phonon::SeekSlider >
{
};

template<>
struct Converter<Phonon::SeekSlider& > : ObjectTypeReferenceConverter<Phonon::SeekSlider >
{
};

template<>
struct Converter<Phonon::EffectWidget* > : ObjectTypeConverter<Phonon::EffectWidget >
{
};

template<>
struct Converter<Phonon::EffectWidget& > : ObjectTypeReferenceConverter<Phonon::EffectWidget >
{
};

template<>
struct Converter<Phonon::EffectParameter::Hint > : EnumConverter<Phonon::EffectParameter::Hint >
{
};
template<>
struct Converter<QFlags<Phonon::EffectParameter::Hint> > : EnumConverter<QFlags<Phonon::EffectParameter::Hint> >
{
};

template<>
struct Converter<Phonon::EffectParameter > : ValueTypeConverter<Phonon::EffectParameter >
{
};

template<>
struct Converter<Phonon::MediaSource::Type > : EnumConverter<Phonon::MediaSource::Type >
{
};

template<>
struct Converter<Phonon::MediaSource > : ValueTypeConverter<Phonon::MediaSource >
{
    static Phonon::MediaSource toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<Phonon::MediaSource >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<Phonon::MediaSource >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<Phonon::MediaSource >());
    return Shiboken::Converter<Phonon::AbstractMediaStream * >::isConvertible(pyobj)
         || Shiboken::Converter<Phonon::DiscType >::isConvertible(pyobj)
         || Shiboken::Converter<QIODevice * >::isConvertible(pyobj)
         || Shiboken::Converter<QString & >::isConvertible(pyobj)
         || Shiboken::Converter<QUrl & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline Phonon::MediaSource Shiboken::Converter<Phonon::MediaSource >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, Phonon::MediaSource)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<Phonon::MediaSource >());
        if (Shiboken::Converter<Phonon::AbstractMediaStream * >::isConvertible(pyobj))
            return Phonon::MediaSource(Shiboken::Converter<Phonon::AbstractMediaStream * >::toCpp(pyobj));
        else if (Shiboken::Converter<Phonon::DiscType >::isConvertible(pyobj))
            return Phonon::MediaSource(Shiboken::Converter<Phonon::DiscType >::toCpp(pyobj));
        else if (Shiboken::Converter<QIODevice * >::isConvertible(pyobj))
            return Phonon::MediaSource(Shiboken::Converter<QIODevice * >::toCpp(pyobj));
        else if (Shiboken::Converter<QString & >::isConvertible(pyobj))
            return Phonon::MediaSource(Shiboken::Converter<QString & >::toCpp(pyobj));
        else if (Shiboken::Converter<QUrl & >::isConvertible(pyobj))
            return Phonon::MediaSource(Shiboken::Converter<QUrl & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            Phonon::MediaSource* cptr = reinterpret_cast<Phonon::MediaSource*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<Phonon::MediaSource > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_PHONON_PYTHON_H

