/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_streaminterface_wrapper.h"

// Extra includes
#include <mediasource.h>
#include <qbytearray.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

StreamInterfaceWrapper::StreamInterfaceWrapper() : Phonon::StreamInterface() {
    // ... middle
}

void StreamInterfaceWrapper::endOfData()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endOfData"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.endOfData()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void StreamInterfaceWrapper::setStreamSeekable(bool s)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setStreamSeekable"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.setStreamSeekable()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(s)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void StreamInterfaceWrapper::setStreamSize(qint64 newSize)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setStreamSize"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.setStreamSize()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(newSize)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void StreamInterfaceWrapper::writeData(const QByteArray & data)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "writeData"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.writeData()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QByteArray & >::toPython(data)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

StreamInterfaceWrapper::~StreamInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_StreamInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    StreamInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_STREAMINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::StreamInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // StreamInterface()
    cptr = new StreamInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::StreamInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_connectToSource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::MediaSource & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<Phonon::MediaSource > cpp_arg0_auto_ptr;
        Phonon::MediaSource* cpp_arg0 = Shiboken::Converter<Phonon::MediaSource* >::toCpp(arg);
        if (!SbkPhonon_MediaSource_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<Phonon::MediaSource >(cpp_arg0);
        // connectToSource(Phonon::MediaSource)
        Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
        cppSelf->Phonon::StreamInterface::connectToSource(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_StreamInterfaceFunc_connectToSource_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_StreamInterfaceFunc_connectToSource_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::MediaSource", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.StreamInterface.connectToSource", overloads);
        return 0;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_endOfData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endOfData()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.endOfData()' not implemented.");
        return 0;
    }
    Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
    cppSelf->endOfData();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_enoughData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // enoughData()
    Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
    cppSelf->Phonon::StreamInterface::enoughData();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_needData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // needData()
    Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
    cppSelf->Phonon::StreamInterface::needData();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_reset(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // reset()
    Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
    cppSelf->Phonon::StreamInterface::reset();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_seekStream(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seekStream(qint64)
        Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
        cppSelf->Phonon::StreamInterface::seekStream(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_StreamInterfaceFunc_seekStream_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_StreamInterfaceFunc_seekStream_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.StreamInterface.seekStream", overloads);
        return 0;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_setStreamSeekable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStreamSeekable(bool)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.setStreamSeekable()' not implemented.");
            return 0;
        }
        Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
        cppSelf->setStreamSeekable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_StreamInterfaceFunc_setStreamSeekable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_StreamInterfaceFunc_setStreamSeekable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.StreamInterface.setStreamSeekable", overloads);
        return 0;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_setStreamSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setStreamSize(qint64)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.setStreamSize()' not implemented.");
            return 0;
        }
        Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
        cppSelf->setStreamSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_StreamInterfaceFunc_setStreamSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_StreamInterfaceFunc_setStreamSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.StreamInterface.setStreamSize", overloads);
        return 0;
}

static PyObject* SbkPhonon_StreamInterfaceFunc_writeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // writeData(QByteArray)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'StreamInterface.writeData()' not implemented.");
            return 0;
        }
        Phonon::StreamInterface* cppSelf = Shiboken::Converter<Phonon::StreamInterface* >::toCpp((PyObject*)self);
        cppSelf->writeData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_StreamInterfaceFunc_writeData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_StreamInterfaceFunc_writeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.StreamInterface.writeData", overloads);
        return 0;
}

static PyMethodDef SbkPhonon_StreamInterface_methods[] = {
    {"connectToSource", (PyCFunction)SbkPhonon_StreamInterfaceFunc_connectToSource, METH_O},
    {"endOfData", (PyCFunction)SbkPhonon_StreamInterfaceFunc_endOfData, METH_NOARGS},
    {"enoughData", (PyCFunction)SbkPhonon_StreamInterfaceFunc_enoughData, METH_NOARGS},
    {"needData", (PyCFunction)SbkPhonon_StreamInterfaceFunc_needData, METH_NOARGS},
    {"reset", (PyCFunction)SbkPhonon_StreamInterfaceFunc_reset, METH_NOARGS},
    {"seekStream", (PyCFunction)SbkPhonon_StreamInterfaceFunc_seekStream, METH_O},
    {"setStreamSeekable", (PyCFunction)SbkPhonon_StreamInterfaceFunc_setStreamSeekable, METH_O},
    {"setStreamSize", (PyCFunction)SbkPhonon_StreamInterfaceFunc_setStreamSize, METH_O},
    {"writeData", (PyCFunction)SbkPhonon_StreamInterfaceFunc_writeData, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_StreamInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.StreamInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_StreamInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_StreamInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::StreamInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_StreamInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_StreamInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::StreamInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_Phonon_StreamInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_STREAMINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_StreamInterface_Type);

    // Fill type discovery information
    SbkPhonon_StreamInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_StreamInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_StreamInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_StreamInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"StreamInterface", (PyObject*)&SbkPhonon_StreamInterface_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::StreamInterface >("Phonon::StreamInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::StreamInterface >(typeid(Phonon::StreamInterface).name());
}


} // extern "C"

