/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_phonon_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef phonon_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_Phonon(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_BackendCapabilities(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AudioChannelDescription(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AudioOutputDevice(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AudioCaptureDevice(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_SubtitleDescription(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_EffectDescription(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_VolumeFaderInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_BackendInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_EffectInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AddonInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_MediaObjectInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_Path(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_MediaNode(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AbstractVideoOutput(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_VideoWidgetInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_StreamInterface(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_EffectDescriptionModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AudioOutputDeviceModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_PlatformPlugin(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_BackendCapabilities_NotifierWrapper(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_MediaController(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_MediaObject(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AbstractAudioOutput(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AudioOutput(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_Effect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_VolumeFaderEffect(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_AbstractMediaStream(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_VideoWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_VolumeSlider(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_VideoPlayer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_SeekSlider(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_EffectWidget(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_EffectParameter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_Phonon_MediaSource(PyObject* module);

PyTypeObject** SbkPySide_phononTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_PHONON_API PyMODINIT_FUNC
initphonon()
{
    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("phonon", phonon_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_phonon_IDX_COUNT];
    SbkPySide_phononTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_Phonon(module);
    init_Phonon_BackendCapabilities(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AudioChannelDescription(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AudioOutputDevice(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AudioCaptureDevice(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_SubtitleDescription(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_EffectDescription(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_VolumeFaderInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_BackendInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_EffectInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AddonInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_MediaObjectInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_Path(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_MediaNode(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AbstractVideoOutput(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_VideoWidgetInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_StreamInterface(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_EffectDescriptionModel(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AudioOutputDeviceModel(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_PlatformPlugin(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_BackendCapabilities_NotifierWrapper(SbkPySide_phononTypes[SBK_PHONON_BACKENDCAPABILITIES_IDX]->tp_dict);
    init_Phonon_MediaController(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_MediaObject(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AbstractAudioOutput(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AudioOutput(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_Effect(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_VolumeFaderEffect(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_AbstractMediaStream(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_VideoWidget(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_VolumeSlider(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_VideoPlayer(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_SeekSlider(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_EffectWidget(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_EffectParameter(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);
    init_Phonon_MediaSource(SbkPySide_phononTypes[SBK_PHONON_IDX]->tp_dict);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module phonon");
    }
}

} // extern "C"

