/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_mediasource_wrapper.h"

// Extra includes
#include <abstractmediastream.h>
#include <mediasource.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qurl.h>

using namespace Shiboken;

static int
SbkPhonon_MediaSource_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    Phonon::MediaSource* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "MediaSource", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // MediaSource()
        cptr = new Phonon::MediaSource();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // MediaSource(QString)
        cptr = new Phonon::MediaSource(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // MediaSource(QUrl)
        cptr = new Phonon::MediaSource(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        // MediaSource(QIODevice*)
        cptr = new Phonon::MediaSource(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Phonon::DiscType >::isConvertible(pyargs[0])) {
        Phonon::DiscType cpp_arg0 = Shiboken::Converter<Phonon::DiscType >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // MediaSource(Phonon::DiscType,QString)
            cptr = new Phonon::MediaSource(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // MediaSource(Phonon::DiscType,QString)
            cptr = new Phonon::MediaSource(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkPhonon_MediaSource_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<Phonon::AbstractMediaStream * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        Phonon::AbstractMediaStream* cpp_arg0 = Shiboken::Converter<Phonon::AbstractMediaStream* >::toCpp(pyargs[0]);
        // MediaSource(Phonon::AbstractMediaStream*)
        cptr = new Phonon::MediaSource(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<Phonon::MediaSource & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<Phonon::MediaSource > cpp_arg0_auto_ptr;
        Phonon::MediaSource* cpp_arg0 = Shiboken::Converter<Phonon::MediaSource* >::toCpp(pyargs[0]);
        if (!SbkPhonon_MediaSource_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<Phonon::MediaSource >(cpp_arg0);
        // MediaSource(Phonon::MediaSource)
        cptr = new Phonon::MediaSource(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaSource_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::MediaSource >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_MediaSource_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_MediaSource_Init_TypeError:
        const char* overloads[] = {"", "PySide.phonon.Phonon::AbstractMediaStream", "PySide.phonon.Phonon.DiscType, PySide.QtCore.QString = QString()", "PySide.QtCore.QIODevice", "PySide.phonon.Phonon::MediaSource", "PySide.QtCore.QString", "PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.MediaSource", overloads);
        return -1;
}

static PyObject* SbkPhonon_MediaSourceFunc_autoDelete(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoDelete()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::MediaSource::autoDelete();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaSourceFunc_deviceName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // deviceName()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->Phonon::MediaSource::deviceName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaSourceFunc_discType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // discType()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    Phonon::DiscType cpp_result = cppSelf->Phonon::MediaSource::discType();
    py_result = Shiboken::Converter<Phonon::DiscType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaSourceFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->Phonon::MediaSource::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaSourceFunc_setAutoDelete(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoDelete(bool)
        Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaSource::setAutoDelete(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaSourceFunc_setAutoDelete_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaSourceFunc_setAutoDelete_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaSource.setAutoDelete", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaSourceFunc_stream(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stream()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    Phonon::AbstractMediaStream * cpp_result = cppSelf->Phonon::MediaSource::stream();
    py_result = Shiboken::Converter<Phonon::AbstractMediaStream * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaSourceFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    Phonon::MediaSource::Type cpp_result = cppSelf->Phonon::MediaSource::type();
    py_result = Shiboken::Converter<Phonon::MediaSource::Type >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaSourceFunc_url(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // url()const
    Phonon::MediaSource* cppSelf = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->Phonon::MediaSource::url();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_MediaSource_methods[] = {
    {"autoDelete", (PyCFunction)SbkPhonon_MediaSourceFunc_autoDelete, METH_NOARGS},
    {"deviceName", (PyCFunction)SbkPhonon_MediaSourceFunc_deviceName, METH_NOARGS},
    {"discType", (PyCFunction)SbkPhonon_MediaSourceFunc_discType, METH_NOARGS},
    {"fileName", (PyCFunction)SbkPhonon_MediaSourceFunc_fileName, METH_NOARGS},
    {"setAutoDelete", (PyCFunction)SbkPhonon_MediaSourceFunc_setAutoDelete, METH_O},
    {"stream", (PyCFunction)SbkPhonon_MediaSourceFunc_stream, METH_NOARGS},
    {"type", (PyCFunction)SbkPhonon_MediaSourceFunc_type, METH_NOARGS},
    {"url", (PyCFunction)SbkPhonon_MediaSourceFunc_url, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkPhonon_MediaSource_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    Phonon::MediaSource& cpp_self = *Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_EQ:
            if (Shiboken::Converter<Phonon::MediaSource & >::isConvertible(other)) {
                // operator==(const Phonon::MediaSource & rhs) const
                Phonon::MediaSource* cpp_other = Shiboken::Converter<Phonon::MediaSource* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<Phonon::MediaSource  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<Phonon::MediaSource >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<Phonon::MediaSource > cpp_other_auto_ptr;
                Phonon::MediaSource* cpp_other = Shiboken::Converter<Phonon::MediaSource* >::toCpp(other);
                if (!SbkPhonon_MediaSource_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<Phonon::MediaSource >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkPhonon_MediaSource_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkPhonon_MediaSource_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_MediaSource_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.MediaSource",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkPhonon_MediaSource_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_MediaSource_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_MediaSource_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::MediaSource >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_phonon_Phonon_MediaSource_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_MediaSource_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_MediaSource_Type_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_MediaSource_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_MediaSource_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_MediaSource_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_Phonon_MediaSource(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_MEDIASOURCE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_MediaSource_Type);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_MediaSource_Type) < 0)
        return;

    PyDict_SetItemString(module,"MediaSource", (PyObject*)&SbkPhonon_MediaSource_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: Type
    SbkPySide_phononTypes[SBK_PHONON_MEDIASOURCE_TYPE_IDX] = &SbkPySide_phonon_Phonon_MediaSource_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_MediaSource_Type_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_MediaSource_Type_Type);
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkPySide_phonon_Phonon_MediaSource_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaSource_Type_Type,
        (long) Phonon::MediaSource::Invalid, "Invalid");
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
        "Invalid", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaSource_Type_Type.tp_dict,
        "Invalid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaSource_Type_Type,
        (long) Phonon::MediaSource::LocalFile, "LocalFile");
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
        "LocalFile", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaSource_Type_Type.tp_dict,
        "LocalFile", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaSource_Type_Type,
        (long) Phonon::MediaSource::Url, "Url");
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
        "Url", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaSource_Type_Type.tp_dict,
        "Url", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaSource_Type_Type,
        (long) Phonon::MediaSource::Disc, "Disc");
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
        "Disc", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaSource_Type_Type.tp_dict,
        "Disc", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaSource_Type_Type,
        (long) Phonon::MediaSource::Stream, "Stream");
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
        "Stream", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaSource_Type_Type.tp_dict,
        "Stream", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaSource_Type_Type,
        (long) Phonon::MediaSource::Empty, "Empty");
    PyDict_SetItemString(SbkPhonon_MediaSource_Type.super.ht_type.tp_dict,
        "Empty", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaSource_Type_Type.tp_dict,
        "Empty", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::MediaSource::Type");

    Shiboken::TypeResolver::createValueTypeResolver<Phonon::MediaSource >("Phonon::MediaSource");
    Shiboken::TypeResolver::createValueTypeResolver<Phonon::MediaSource >(typeid(Phonon::MediaSource).name());
}


} // extern "C"

