/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_phonon_python.h"

#include "phonon_mediacontroller_wrapper.h"

// Extra includes
#include <QList>
#include <mediaobject.h>
#include <objectdescription.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

MediaControllerWrapper::MediaControllerWrapper(Phonon::MediaObject * parent) : Phonon::MediaController(parent), m_metaObject(0) {
    // ... middle
}

void MediaControllerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void MediaControllerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void MediaControllerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void MediaControllerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool MediaControllerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaController.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool MediaControllerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "MediaController.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void MediaControllerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* MediaControllerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &Phonon::MediaController::staticMetaObject);
}
    return m_metaObject;
}

int MediaControllerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = Phonon::MediaController::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

MediaControllerWrapper::~MediaControllerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkPhonon_MediaController_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    MediaControllerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "MediaController", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<Phonon::MediaObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        Phonon::MediaObject* cpp_arg0 = Shiboken::Converter<Phonon::MediaObject* >::toCpp(pyargs[0]);
        // MediaController(Phonon::MediaObject*)
        cptr = new MediaControllerWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkPhonon_MediaController_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::MediaController >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_MediaController_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_MediaController_Init_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::MediaObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.MediaController", overloads);
        return -1;
}

static PyObject* SbkPhonon_MediaControllerFunc_autoplayTitles(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoplayTitles()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::MediaController::autoplayTitles();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_availableAngles(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableAngles()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::MediaController::availableAngles();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_availableAudioChannels(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableAudioChannels()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    QList<Phonon::AudioChannelDescription > cpp_result = cppSelf->Phonon::MediaController::availableAudioChannels();
    py_result = Shiboken::Converter<QList<Phonon::AudioChannelDescription > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_availableChapters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableChapters()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::MediaController::availableChapters();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_availableSubtitles(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableSubtitles()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    QList<Phonon::SubtitleDescription > cpp_result = cppSelf->Phonon::MediaController::availableSubtitles();
    py_result = Shiboken::Converter<QList<Phonon::SubtitleDescription > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_availableTitles(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableTitles()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::MediaController::availableTitles();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_currentAngle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentAngle()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::MediaController::currentAngle();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_currentAudioChannel(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentAudioChannel()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    Phonon::AudioChannelDescription cpp_result = cppSelf->Phonon::MediaController::currentAudioChannel();
    py_result = Shiboken::Converter<Phonon::AudioChannelDescription >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_currentChapter(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentChapter()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::MediaController::currentChapter();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_currentSubtitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentSubtitle()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    Phonon::SubtitleDescription cpp_result = cppSelf->Phonon::MediaController::currentSubtitle();
    py_result = Shiboken::Converter<Phonon::SubtitleDescription >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_currentTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentTitle()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->Phonon::MediaController::currentTitle();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_MediaControllerFunc_nextTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // nextTitle()
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    cppSelf->Phonon::MediaController::nextTitle();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_MediaControllerFunc_previousTitle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // previousTitle()
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    cppSelf->Phonon::MediaController::previousTitle();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkPhonon_MediaControllerFunc_setAutoplayTitles(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoplayTitles(bool)
        Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaController::setAutoplayTitles(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaControllerFunc_setAutoplayTitles_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaControllerFunc_setAutoplayTitles_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaController.setAutoplayTitles", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaControllerFunc_setCurrentAngle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentAngle(int)
        Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaController::setCurrentAngle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaControllerFunc_setCurrentAngle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaControllerFunc_setCurrentAngle_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaController.setCurrentAngle", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaControllerFunc_setCurrentAudioChannel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::AudioChannelDescription & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        Phonon::AudioChannelDescription* cpp_arg0 = Shiboken::Converter<Phonon::AudioChannelDescription* >::toCpp(arg);
        // setCurrentAudioChannel(Phonon::AudioChannelDescription)
        Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaController::setCurrentAudioChannel(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaControllerFunc_setCurrentAudioChannel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaControllerFunc_setCurrentAudioChannel_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::AudioChannelDescription", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaController.setCurrentAudioChannel", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaControllerFunc_setCurrentChapter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentChapter(int)
        Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaController::setCurrentChapter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaControllerFunc_setCurrentChapter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaControllerFunc_setCurrentChapter_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaController.setCurrentChapter", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaControllerFunc_setCurrentSubtitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Phonon::SubtitleDescription & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        Phonon::SubtitleDescription* cpp_arg0 = Shiboken::Converter<Phonon::SubtitleDescription* >::toCpp(arg);
        // setCurrentSubtitle(Phonon::SubtitleDescription)
        Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaController::setCurrentSubtitle(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaControllerFunc_setCurrentSubtitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaControllerFunc_setCurrentSubtitle_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::SubtitleDescription", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaController.setCurrentSubtitle", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaControllerFunc_setCurrentTitle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentTitle(int)
        Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
        cppSelf->Phonon::MediaController::setCurrentTitle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_MediaControllerFunc_setCurrentTitle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_MediaControllerFunc_setCurrentTitle_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.MediaController.setCurrentTitle", overloads);
        return 0;
}

static PyObject* SbkPhonon_MediaControllerFunc_supportedFeatures(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedFeatures()const
    Phonon::MediaController* cppSelf = Shiboken::Converter<Phonon::MediaController* >::toCpp((PyObject*)self);
    QFlags<Phonon::MediaController::Feature> cpp_result = cppSelf->Phonon::MediaController::supportedFeatures();
    py_result = Shiboken::Converter<QFlags<Phonon::MediaController::Feature> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_MediaController_methods[] = {
    {"autoplayTitles", (PyCFunction)SbkPhonon_MediaControllerFunc_autoplayTitles, METH_NOARGS},
    {"availableAngles", (PyCFunction)SbkPhonon_MediaControllerFunc_availableAngles, METH_NOARGS},
    {"availableAudioChannels", (PyCFunction)SbkPhonon_MediaControllerFunc_availableAudioChannels, METH_NOARGS},
    {"availableChapters", (PyCFunction)SbkPhonon_MediaControllerFunc_availableChapters, METH_NOARGS},
    {"availableSubtitles", (PyCFunction)SbkPhonon_MediaControllerFunc_availableSubtitles, METH_NOARGS},
    {"availableTitles", (PyCFunction)SbkPhonon_MediaControllerFunc_availableTitles, METH_NOARGS},
    {"currentAngle", (PyCFunction)SbkPhonon_MediaControllerFunc_currentAngle, METH_NOARGS},
    {"currentAudioChannel", (PyCFunction)SbkPhonon_MediaControllerFunc_currentAudioChannel, METH_NOARGS},
    {"currentChapter", (PyCFunction)SbkPhonon_MediaControllerFunc_currentChapter, METH_NOARGS},
    {"currentSubtitle", (PyCFunction)SbkPhonon_MediaControllerFunc_currentSubtitle, METH_NOARGS},
    {"currentTitle", (PyCFunction)SbkPhonon_MediaControllerFunc_currentTitle, METH_NOARGS},
    {"nextTitle", (PyCFunction)SbkPhonon_MediaControllerFunc_nextTitle, METH_NOARGS},
    {"previousTitle", (PyCFunction)SbkPhonon_MediaControllerFunc_previousTitle, METH_NOARGS},
    {"setAutoplayTitles", (PyCFunction)SbkPhonon_MediaControllerFunc_setAutoplayTitles, METH_O},
    {"setCurrentAngle", (PyCFunction)SbkPhonon_MediaControllerFunc_setCurrentAngle, METH_O},
    {"setCurrentAudioChannel", (PyCFunction)SbkPhonon_MediaControllerFunc_setCurrentAudioChannel, METH_O},
    {"setCurrentChapter", (PyCFunction)SbkPhonon_MediaControllerFunc_setCurrentChapter, METH_O},
    {"setCurrentSubtitle", (PyCFunction)SbkPhonon_MediaControllerFunc_setCurrentSubtitle, METH_O},
    {"setCurrentTitle", (PyCFunction)SbkPhonon_MediaControllerFunc_setCurrentTitle, METH_O},
    {"supportedFeatures", (PyCFunction)SbkPhonon_MediaControllerFunc_supportedFeatures, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_MediaController_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.MediaController",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_MediaController_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_MediaController_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::MediaController >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_phonon_Phonon_MediaController_Feature___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::MediaController::Features >::toPython(
        ((Phonon::MediaController::Features) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Phonon::MediaController::Features >::toCpp(arg)
    );
}

PyObject*
SbkPySide_phonon_Phonon_MediaController_Feature___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::MediaController::Features >::toPython(
        ((Phonon::MediaController::Features) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Phonon::MediaController::Features >::toCpp(arg)
    );
}

PyObject*
SbkPySide_phonon_Phonon_MediaController_Feature___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::MediaController::Features >::toPython(
        ((Phonon::MediaController::Features) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Phonon::MediaController::Features >::toCpp(arg)
    );
}

PyObject*
SbkPySide_phonon_Phonon_MediaController_Feature___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::MediaController::Features >::toPython(
        ~ Shiboken::Converter< Phonon::MediaController::Features >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_phonon_Phonon_MediaController_Feature_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_phonon_Phonon_MediaController_Feature___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_phonon_Phonon_MediaController_Feature___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_phonon_Phonon_MediaController_Feature___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_phonon_Phonon_MediaController_Feature___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_phonon_Phonon_MediaController_Feature_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_MediaController_Feature_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_MediaController_Feature_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Feature",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_phonon_Phonon_MediaController_Feature_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_MediaController_Feature_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_MediaController_Feature_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_MediaController_Feature_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_MediaController_Features_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_MediaController_Features_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Features",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_phonon_Phonon_MediaController_Feature_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_MediaController_Features_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_MediaController_Features_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_phonon_Phonon_MediaController_Features_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_Phonon_MediaController(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_MEDIACONTROLLER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_MediaController_Type);

    SbkPhonon_MediaController_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkPhonon_MediaController_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_MediaController_Type) < 0)
        return;

    PyDict_SetItemString(module,"MediaController", (PyObject*)&SbkPhonon_MediaController_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: Feature
    SbkPySide_phononTypes[SBK_PHONON_MEDIACONTROLLER_FEATURE_IDX] = &SbkPySide_phonon_Phonon_MediaController_Feature_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_MediaController_Feature_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_MediaController_Feature_Type);
    PyDict_SetItemString(SbkPhonon_MediaController_Type.super.ht_type.tp_dict,
            "Feature",((PyObject*)&SbkPySide_phonon_Phonon_MediaController_Feature_Type));

    // init flags class: QFlags<Phonon::MediaController::Feature>
    SbkPySide_phononTypes[SBK_QFLAGS_PHONON_MEDIACONTROLLER_FEATURE__IDX] = &SbkPySide_phonon_Phonon_MediaController_Features_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_MediaController_Features_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_MediaController_Features_Type);
    PyDict_SetItemString(SbkPhonon_MediaController_Type.super.ht_type.tp_dict,
            "Features",((PyObject*)&SbkPySide_phonon_Phonon_MediaController_Features_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaController_Feature_Type,
        (long) Phonon::MediaController::Angles, "Angles");
    PyDict_SetItemString(SbkPhonon_MediaController_Type.super.ht_type.tp_dict,
        "Angles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaController_Feature_Type.tp_dict,
        "Angles", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaController_Feature_Type,
        (long) Phonon::MediaController::Chapters, "Chapters");
    PyDict_SetItemString(SbkPhonon_MediaController_Type.super.ht_type.tp_dict,
        "Chapters", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaController_Feature_Type.tp_dict,
        "Chapters", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_MediaController_Feature_Type,
        (long) Phonon::MediaController::Titles, "Titles");
    PyDict_SetItemString(SbkPhonon_MediaController_Type.super.ht_type.tp_dict,
        "Titles", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_MediaController_Feature_Type.tp_dict,
        "Titles", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::MediaController::Feature");

    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::MediaController >("Phonon::MediaController*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::MediaController >(typeid(Phonon::MediaController).name());
}


} // extern "C"

