/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_effectinterface_wrapper.h"

// Extra includes
#include <QList>
#include <effectparameter.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

EffectInterfaceWrapper::EffectInterfaceWrapper() : Phonon::EffectInterface() {
    // ... middle
}

QVariant EffectInterfaceWrapper::parameterValue(const Phonon::EffectParameter & arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parameterValue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'EffectInterface.parameterValue()' not implemented.");
        return QVariant();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::EffectParameter & >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "EffectInterface.parameterValue", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QList<Phonon::EffectParameter > EffectInterfaceWrapper::parameters() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parameters"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'EffectInterface.parameters()' not implemented.");
        return QList<Phonon::EffectParameter >();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<Phonon::EffectParameter >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<Phonon::EffectParameter > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "EffectInterface.parameters", "list", py_result->ob_type->tp_name);
        return QList<Phonon::EffectParameter >();
    }
    QList<Phonon::EffectParameter > cpp_result(Shiboken::Converter<QList<Phonon::EffectParameter > >::toCpp(py_result));
    return cpp_result;
}

void EffectInterfaceWrapper::setParameterValue(const Phonon::EffectParameter & arg__1, const QVariant & newValue)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setParameterValue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'EffectInterface.setParameterValue()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<Phonon::EffectParameter & >::toPython(arg__1),
        Shiboken::Converter<QVariant & >::toPython(newValue)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

EffectInterfaceWrapper::~EffectInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_EffectInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    EffectInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_EFFECTINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::EffectInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // EffectInterface()
    cptr = new EffectInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::EffectInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_EffectInterfaceFunc_parameterValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::EffectParameter & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        Phonon::EffectParameter* cpp_arg0 = Shiboken::Converter<Phonon::EffectParameter* >::toCpp(arg);
        // parameterValue(Phonon::EffectParameter)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'EffectInterface.parameterValue()' not implemented.");
            return 0;
        }
        Phonon::EffectInterface* cppSelf = Shiboken::Converter<Phonon::EffectInterface* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->parameterValue(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_EffectInterfaceFunc_parameterValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_EffectInterfaceFunc_parameterValue_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::EffectParameter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.EffectInterface.parameterValue", overloads);
        return 0;
}

static PyObject* SbkPhonon_EffectInterfaceFunc_parameters(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parameters()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'EffectInterface.parameters()' not implemented.");
        return 0;
    }
    Phonon::EffectInterface* cppSelf = Shiboken::Converter<Phonon::EffectInterface* >::toCpp((PyObject*)self);
    QList<Phonon::EffectParameter > cpp_result = cppSelf->parameters();
    py_result = Shiboken::Converter<QList<Phonon::EffectParameter > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectInterfaceFunc_setParameterValue(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setParameterValue", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Phonon::EffectParameter & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        Phonon::EffectParameter* cpp_arg0 = Shiboken::Converter<Phonon::EffectParameter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setParameterValue(Phonon::EffectParameter,QVariant)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'EffectInterface.setParameterValue()' not implemented.");
            return 0;
        }
        Phonon::EffectInterface* cppSelf = Shiboken::Converter<Phonon::EffectInterface* >::toCpp((PyObject*)self);
        cppSelf->setParameterValue(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_EffectInterfaceFunc_setParameterValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkPhonon_EffectInterfaceFunc_setParameterValue_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::EffectParameter, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.EffectInterface.setParameterValue", overloads);
        return 0;
}

static PyMethodDef SbkPhonon_EffectInterface_methods[] = {
    {"parameterValue", (PyCFunction)SbkPhonon_EffectInterfaceFunc_parameterValue, METH_O},
    {"parameters", (PyCFunction)SbkPhonon_EffectInterfaceFunc_parameters, METH_NOARGS},
    {"setParameterValue", (PyCFunction)SbkPhonon_EffectInterfaceFunc_setParameterValue, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_EffectInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.EffectInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_EffectInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_EffectInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::EffectInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_EffectInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_EffectInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::EffectInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_Phonon_EffectInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_EFFECTINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_EffectInterface_Type);

    // Fill type discovery information
    SbkPhonon_EffectInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_EffectInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_EffectInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_EffectInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"EffectInterface", (PyObject*)&SbkPhonon_EffectInterface_Type);
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::EffectInterface >("Phonon::EffectInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::EffectInterface >(typeid(Phonon::EffectInterface).name());
}


} // extern "C"

