/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_backendinterface_wrapper.h"

// Extra includes
#include <QList>
#include <QSet>
#include <pysideconversions.h>
#include <qbytearray.h>
#include <qobject.h>
#include <qstringlist.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

BackendInterfaceWrapper::BackendInterfaceWrapper() : Phonon::BackendInterface() {
    // ... middle
}

QStringList BackendInterfaceWrapper::availableMimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "availableMimeTypes"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.availableMimeTypes()' not implemented.");
        return QStringList();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.availableMimeTypes", SbkType<QStringList >()->tp_name, py_result->ob_type->tp_name);
        return QStringList();
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

bool BackendInterfaceWrapper::connectNodes(QObject * arg__1, QObject * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNodes"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.connectNodes()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QObject * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.connectNodes", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QObject * BackendInterfaceWrapper::createObject(Phonon::BackendInterface::Class c, QObject * parent, const QList<QVariant > & args)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createObject"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.createObject()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<Phonon::BackendInterface::Class >::toPython(c),
        Shiboken::Converter<QObject * >::toPython(parent),
        Shiboken::Converter<QList<QVariant >  >::toPython(args)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QObject * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.createObject", SbkType<QObject * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QObject * cpp_result(Shiboken::Converter<QObject * >::toCpp(py_result));
    return cpp_result;
}

bool BackendInterfaceWrapper::disconnectNodes(QObject * arg__1, QObject * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNodes"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.disconnectNodes()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QObject * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.disconnectNodes", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool BackendInterfaceWrapper::endConnectionChange(QSet<QObject * > arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endConnectionChange"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.endConnectionChange()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QSet<QObject * > >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.endConnectionChange", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QList<int > BackendInterfaceWrapper::objectDescriptionIndexes(Phonon::ObjectDescriptionType type) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "objectDescriptionIndexes"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.objectDescriptionIndexes()' not implemented.");
        return QList<int >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Phonon::ObjectDescriptionType >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<int >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<int > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.objectDescriptionIndexes", "list", py_result->ob_type->tp_name);
        return QList<int >();
    }
    QList<int > cpp_result(Shiboken::Converter<QList<int > >::toCpp(py_result));
    return cpp_result;
}

QHash<QByteArray, QVariant > BackendInterfaceWrapper::objectDescriptionProperties(Phonon::ObjectDescriptionType type, int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "objectDescriptionProperties"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.objectDescriptionProperties()' not implemented.");
        return QHash<QByteArray, QVariant >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Si)",
        Shiboken::Converter<Phonon::ObjectDescriptionType >::toPython(type),
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QHash<QByteArray, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QHash<QByteArray, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.objectDescriptionProperties", "hash", py_result->ob_type->tp_name);
        return QHash<QByteArray, QVariant >();
    }
    QHash<QByteArray, QVariant > cpp_result(Shiboken::Converter<QHash<QByteArray, QVariant > >::toCpp(py_result));
    return cpp_result;
}

bool BackendInterfaceWrapper::startConnectionChange(QSet<QObject * > arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startConnectionChange"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.startConnectionChange()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QSet<QObject * > >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "BackendInterface.startConnectionChange", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

BackendInterfaceWrapper::~BackendInterfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkPhonon_BackendInterface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    BackendInterfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'Phonon::BackendInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // BackendInterface()
    cptr = new BackendInterfaceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::BackendInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_availableMimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableMimeTypes()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.availableMimeTypes()' not implemented.");
        return 0;
    }
    Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->availableMimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_connectNodes(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "connectNodes", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // connectNodes(QObject*,QObject*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.connectNodes()' not implemented.");
            return 0;
        }
        Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->connectNodes(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendInterfaceFunc_connectNodes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_connectNodes_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.BackendInterface.connectNodes", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_createObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createObject", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<Phonon::BackendInterface::Class >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        Phonon::BackendInterface::Class cpp_arg0 = Shiboken::Converter<Phonon::BackendInterface::Class >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // createObject(Phonon::BackendInterface::Class,QObject*,QList<QVariant>)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.createObject()' not implemented.");
                return 0;
            }
            Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
            QObject * cpp_result = cppSelf->createObject(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QList<QVariant >  >::isConvertible(pyargs[2])) {
            QList<QVariant >  cpp_arg2 = Shiboken::Converter<QList<QVariant >  >::toCpp(pyargs[2]);
            // createObject(Phonon::BackendInterface::Class,QObject*,QList<QVariant>)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.createObject()' not implemented.");
                return 0;
            }
            Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
            QObject * cpp_result = cppSelf->createObject(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkPhonon_BackendInterfaceFunc_createObject_TypeError;
    } else goto SbkPhonon_BackendInterfaceFunc_createObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_createObject_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::BackendInterface.Class, PySide.QtCore.QObject, list = QList< QVariant >()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.BackendInterface.createObject", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_disconnectNodes(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "disconnectNodes", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // disconnectNodes(QObject*,QObject*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.disconnectNodes()' not implemented.");
            return 0;
        }
        Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->disconnectNodes(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendInterfaceFunc_disconnectNodes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_disconnectNodes_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.BackendInterface.disconnectNodes", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_endConnectionChange(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSet<QObject * > >::isConvertible(arg)) {
        QSet<QObject * > cpp_arg0 = Shiboken::Converter<QSet<QObject * > >::toCpp(arg);
        // endConnectionChange(QSet<QObject*>)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.endConnectionChange()' not implemented.");
            return 0;
        }
        Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->endConnectionChange(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendInterfaceFunc_endConnectionChange_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_endConnectionChange_TypeError:
        const char* overloads[] = {"QSet", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.BackendInterface.endConnectionChange", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_objectDescriptionIndexes(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::ObjectDescriptionType >::isConvertible(arg)) {
        Phonon::ObjectDescriptionType cpp_arg0 = Shiboken::Converter<Phonon::ObjectDescriptionType >::toCpp(arg);
        // objectDescriptionIndexes(Phonon::ObjectDescriptionType)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.objectDescriptionIndexes()' not implemented.");
            return 0;
        }
        Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
        QList<int > cpp_result = cppSelf->objectDescriptionIndexes(cpp_arg0);
        py_result = Shiboken::Converter<QList<int > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendInterfaceFunc_objectDescriptionIndexes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_objectDescriptionIndexes_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon.ObjectDescriptionType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.BackendInterface.objectDescriptionIndexes", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_objectDescriptionProperties(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "objectDescriptionProperties", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Phonon::ObjectDescriptionType >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        Phonon::ObjectDescriptionType cpp_arg0 = Shiboken::Converter<Phonon::ObjectDescriptionType >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // objectDescriptionProperties(Phonon::ObjectDescriptionType,int)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.objectDescriptionProperties()' not implemented.");
            return 0;
        }
        Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
        QHash<QByteArray, QVariant > cpp_result = cppSelf->objectDescriptionProperties(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QHash<QByteArray, QVariant > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendInterfaceFunc_objectDescriptionProperties_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_objectDescriptionProperties_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon.ObjectDescriptionType, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.BackendInterface.objectDescriptionProperties", overloads);
        return 0;
}

static PyObject* SbkPhonon_BackendInterfaceFunc_startConnectionChange(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QSet<QObject * > >::isConvertible(arg)) {
        QSet<QObject * > cpp_arg0 = Shiboken::Converter<QSet<QObject * > >::toCpp(arg);
        // startConnectionChange(QSet<QObject*>)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'BackendInterface.startConnectionChange()' not implemented.");
            return 0;
        }
        Phonon::BackendInterface* cppSelf = Shiboken::Converter<Phonon::BackendInterface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->startConnectionChange(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_BackendInterfaceFunc_startConnectionChange_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_BackendInterfaceFunc_startConnectionChange_TypeError:
        const char* overloads[] = {"QSet", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.BackendInterface.startConnectionChange", overloads);
        return 0;
}

static PyMethodDef SbkPhonon_BackendInterface_methods[] = {
    {"availableMimeTypes", (PyCFunction)SbkPhonon_BackendInterfaceFunc_availableMimeTypes, METH_NOARGS},
    {"connectNodes", (PyCFunction)SbkPhonon_BackendInterfaceFunc_connectNodes, METH_VARARGS},
    {"createObject", (PyCFunction)SbkPhonon_BackendInterfaceFunc_createObject, METH_VARARGS},
    {"disconnectNodes", (PyCFunction)SbkPhonon_BackendInterfaceFunc_disconnectNodes, METH_VARARGS},
    {"endConnectionChange", (PyCFunction)SbkPhonon_BackendInterfaceFunc_endConnectionChange, METH_O},
    {"objectDescriptionIndexes", (PyCFunction)SbkPhonon_BackendInterfaceFunc_objectDescriptionIndexes, METH_O},
    {"objectDescriptionProperties", (PyCFunction)SbkPhonon_BackendInterfaceFunc_objectDescriptionProperties, METH_VARARGS},
    {"startConnectionChange", (PyCFunction)SbkPhonon_BackendInterfaceFunc_startConnectionChange, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_BackendInterface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.BackendInterface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_BackendInterface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_BackendInterface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::BackendInterface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkPhonon_BackendInterface_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkPhonon_BackendInterface_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<Phonon::BackendInterface*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_phonon_Phonon_BackendInterface_Class_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_BackendInterface_Class_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_BackendInterface_Class_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Class",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_BackendInterface_Class_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_BackendInterface_Class_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_BackendInterface_Class_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_Phonon_BackendInterface(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_BackendInterface_Type);

    // Fill type discovery information
    SbkPhonon_BackendInterface_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkPhonon_BackendInterface_Type.type_discovery->addTypeDiscoveryFunction(&SbkPhonon_BackendInterface_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_BackendInterface_Type) < 0)
        return;

    PyDict_SetItemString(module,"BackendInterface", (PyObject*)&SbkPhonon_BackendInterface_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: Class
    SbkPySide_phononTypes[SBK_PHONON_BACKENDINTERFACE_CLASS_IDX] = &SbkPySide_phonon_Phonon_BackendInterface_Class_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_BackendInterface_Class_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type);
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
            "Class",((PyObject*)&SbkPySide_phonon_Phonon_BackendInterface_Class_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::MediaObjectClass, "MediaObjectClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "MediaObjectClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "MediaObjectClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::VolumeFaderEffectClass, "VolumeFaderEffectClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "VolumeFaderEffectClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "VolumeFaderEffectClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::AudioOutputClass, "AudioOutputClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "AudioOutputClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "AudioOutputClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::AudioDataOutputClass, "AudioDataOutputClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "AudioDataOutputClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "AudioDataOutputClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::VisualizationClass, "VisualizationClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "VisualizationClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "VisualizationClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::VideoDataOutputClass, "VideoDataOutputClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "VideoDataOutputClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "VideoDataOutputClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::EffectClass, "EffectClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "EffectClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "EffectClass", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_BackendInterface_Class_Type,
        (long) Phonon::BackendInterface::VideoWidgetClass, "VideoWidgetClass");
    PyDict_SetItemString(SbkPhonon_BackendInterface_Type.super.ht_type.tp_dict,
        "VideoWidgetClass", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_BackendInterface_Class_Type.tp_dict,
        "VideoWidgetClass", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::BackendInterface::Class");

    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::BackendInterface >("Phonon::BackendInterface*");
    Shiboken::TypeResolver::createObjectTypeResolver<Phonon::BackendInterface >(typeid(Phonon::BackendInterface).name());
}


} // extern "C"

