/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlname_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qxmlname.h>
#include <qxmlnamepool.h>

using namespace Shiboken;

static int
SbkQXmlName_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlName* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QXmlName", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QXmlName()
        cptr = new QXmlName();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QXmlNamePool & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlNamePool* cpp_arg0 = Shiboken::Converter<QXmlNamePool* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // QXmlName(QXmlNamePool&,QString,QString,QString)
            cptr = new QXmlName(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            if (numArgs == 3) {
                // QXmlName(QXmlNamePool&,QString,QString,QString)
                cptr = new QXmlName(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return -1;
                std::auto_ptr<QString > cpp_arg3_auto_ptr;
                QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
                if (!SbkQString_Check(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
                // QXmlName(QXmlNamePool&,QString,QString,QString)
                cptr = new QXmlName(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQXmlName_Init_TypeError;
        } else goto SbkQXmlName_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        // QXmlName(QXmlName)
        cptr = new QXmlName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlName_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlName >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlName_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlName_Init_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", "", "PySide.QtXmlPatterns.QXmlNamePool, PySide.QtCore.QString, PySide.QtCore.QString = QString(), PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlName", overloads);
        return -1;
}

static PyObject* SbkQXmlNameFunc_fromClarkName(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromClarkName", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QXmlNamePool & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QXmlNamePool* cpp_arg1 = Shiboken::Converter<QXmlNamePool* >::toCpp(pyargs[1]);
        // fromClarkName(QString,QXmlNamePool)
        QXmlName cpp_result = QXmlName::fromClarkName(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QXmlName >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNameFunc_fromClarkName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlNameFunc_fromClarkName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtXmlPatterns.QXmlNamePool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlName.fromClarkName", overloads);
        return 0;
}

static PyObject* SbkQXmlNameFunc_isNCName(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // isNCName(QString)
        bool cpp_result = QXmlName::isNCName(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNameFunc_isNCName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlNameFunc_isNCName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlName.isNCName", overloads);
        return 0;
}

static PyObject* SbkQXmlNameFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QXmlName* cppSelf = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlName::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlNameFunc_localName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNamePool & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNamePool* cpp_arg0 = Shiboken::Converter<QXmlNamePool* >::toCpp(arg);
        // localName(QXmlNamePool)const
        QXmlName* cppSelf = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlName::localName(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNameFunc_localName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlNameFunc_localName_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNamePool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlName.localName", overloads);
        return 0;
}

static PyObject* SbkQXmlNameFunc_namespaceUri(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNamePool & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNamePool* cpp_arg0 = Shiboken::Converter<QXmlNamePool* >::toCpp(arg);
        // namespaceUri(QXmlNamePool)const
        QXmlName* cppSelf = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlName::namespaceUri(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNameFunc_namespaceUri_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlNameFunc_namespaceUri_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNamePool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlName.namespaceUri", overloads);
        return 0;
}

static PyObject* SbkQXmlNameFunc_prefix(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNamePool & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNamePool* cpp_arg0 = Shiboken::Converter<QXmlNamePool* >::toCpp(arg);
        // prefix(QXmlNamePool)const
        QXmlName* cppSelf = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlName::prefix(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNameFunc_prefix_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlNameFunc_prefix_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNamePool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlName.prefix", overloads);
        return 0;
}

static PyObject* SbkQXmlNameFunc_toClarkName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNamePool & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNamePool* cpp_arg0 = Shiboken::Converter<QXmlNamePool* >::toCpp(arg);
        // toClarkName(QXmlNamePool)const
        QXmlName* cppSelf = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlName::toClarkName(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNameFunc_toClarkName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlNameFunc_toClarkName_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNamePool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlName.toClarkName", overloads);
        return 0;
}

static PyMethodDef SbkQXmlName_methods[] = {
    {"fromClarkName", (PyCFunction)SbkQXmlNameFunc_fromClarkName, METH_VARARGS|METH_STATIC},
    {"isNCName", (PyCFunction)SbkQXmlNameFunc_isNCName, METH_O|METH_STATIC},
    {"isNull", (PyCFunction)SbkQXmlNameFunc_isNull, METH_NOARGS},
    {"localName", (PyCFunction)SbkQXmlNameFunc_localName, METH_O},
    {"namespaceUri", (PyCFunction)SbkQXmlNameFunc_namespaceUri, METH_O},
    {"prefix", (PyCFunction)SbkQXmlNameFunc_prefix, METH_O},
    {"toClarkName", (PyCFunction)SbkQXmlNameFunc_toClarkName, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQXmlName_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QXmlName& cpp_self = *Shiboken::Converter<QXmlName* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QXmlName & >::isConvertible(other)) {
                // operator!=(const QXmlName & other) const
                QXmlName* cpp_other = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QXmlName  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQXmlName_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QXmlName & >::isConvertible(other)) {
                // operator==(const QXmlName & other) const
                QXmlName* cpp_other = Shiboken::Converter<QXmlName* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QXmlName  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQXmlName_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQXmlName_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlName_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlName",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQXmlName_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlName_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlName_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlName >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlName(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLNAME_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlName_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlName_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlName_Type));
    PyModule_AddObject(module, "QXmlName",
        ((PyObject*)&SbkQXmlName_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlName >("QXmlName");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlName >(typeid(QXmlName).name());
}


} // extern "C"

