/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlitem_wrapper.h"

// Extra includes
#include <qabstractxmlnodemodel.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQXmlItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlItem* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlItem", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlItem()
        cptr = new QXmlItem();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[0]);
        // QXmlItem(QXmlNodeModelIndex)
        cptr = new QXmlItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVariant & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // QXmlItem(QVariant)
        cptr = new QXmlItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlItem & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QXmlItem > cpp_arg0_auto_ptr;
        QXmlItem* cpp_arg0 = Shiboken::Converter<QXmlItem* >::toCpp(pyargs[0]);
        if (!SbkQXmlItem_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QXmlItem >(cpp_arg0);
        // QXmlItem(QXmlItem)
        cptr = new QXmlItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlItem_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlItem_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlItem_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QVariant", "PySide.QtXmlPatterns.QXmlItem", "PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlItem", overloads);
        return -1;
}

static PyObject* SbkQXmlItemFunc_isAtomicValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAtomicValue()const
    QXmlItem* cppSelf = Shiboken::Converter<QXmlItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlItem::isAtomicValue();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlItemFunc_isNode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNode()const
    QXmlItem* cppSelf = Shiboken::Converter<QXmlItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlItem::isNode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlItemFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QXmlItem* cppSelf = Shiboken::Converter<QXmlItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlItem::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlItemFunc_toAtomicValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toAtomicValue()const
    QXmlItem* cppSelf = Shiboken::Converter<QXmlItem* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QXmlItem::toAtomicValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlItemFunc_toNodeModelIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toNodeModelIndex()const
    QXmlItem* cppSelf = Shiboken::Converter<QXmlItem* >::toCpp((PyObject*)self);
    QXmlNodeModelIndex cpp_result = cppSelf->QXmlItem::toNodeModelIndex();
    py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQXmlItem_methods[] = {
    {"isAtomicValue", (PyCFunction)SbkQXmlItemFunc_isAtomicValue, METH_NOARGS},
    {"isNode", (PyCFunction)SbkQXmlItemFunc_isNode, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQXmlItemFunc_isNull, METH_NOARGS},
    {"toAtomicValue", (PyCFunction)SbkQXmlItemFunc_toAtomicValue, METH_NOARGS},
    {"toNodeModelIndex", (PyCFunction)SbkQXmlItemFunc_toNodeModelIndex, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlItem >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlItem(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlItem_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlItem_Type));
    PyModule_AddObject(module, "QXmlItem",
        ((PyObject*)&SbkQXmlItem_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlItem >("QXmlItem");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlItem >(typeid(QXmlItem).name());
}


} // extern "C"

