/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlformatter_wrapper.h"

// Extra includes
#include <qabstractxmlnodemodel.h>
#include <qabstractxmlreceiver.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qvariant.h>
#include <qxmlname.h>
#include <qxmlquery.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlFormatterWrapper::QXmlFormatterWrapper(const QXmlQuery & query, QIODevice * outputDevice) : QXmlFormatter(query, outputDevice) {
    // ... middle
}

void QXmlFormatterWrapper::atomicValue(const QVariant & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "atomicValue"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::atomicValue(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVariant & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::attribute(const QXmlName & name, const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "attribute"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::attribute(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlName & >::toPython(name),
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::characters(const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "characters"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::characters(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::comment(const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "comment"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::comment(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::endDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endDocument"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::endDocument();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::endElement()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endElement"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::endElement();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::endOfSequence()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endOfSequence"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::endOfSequence();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::namespaceBinding(const QXmlName & nb)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "namespaceBinding"));
    if (py_override.isNull()) {
        return this->QXmlSerializer::namespaceBinding(nb);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(nb)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::processingInstruction(const QXmlName & name, const QString & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "processingInstruction"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::processingInstruction(name, value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlName & >::toPython(name),
        Shiboken::Converter<QString & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::startDocument()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startDocument"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::startDocument();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::startElement(const QXmlName & name)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startElement"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::startElement(name);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(name)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::startOfSequence()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startOfSequence"));
    if (py_override.isNull()) {
        return this->QXmlFormatter::startOfSequence();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QXmlFormatterWrapper::whitespaceOnly(const QStringRef & value)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "whitespaceOnly"));
    if (py_override.isNull()) {
        return this->QAbstractXmlReceiver::whitespaceOnly(value);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QStringRef & >::toPython(value)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QXmlFormatterWrapper::~QXmlFormatterWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlFormatter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlFormatterWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QXmlFormatter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QXmlQuery & >::isConvertible(pyargs[0]) && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QXmlQuery > cpp_arg0_auto_ptr;
        QXmlQuery* cpp_arg0 = Shiboken::Converter<QXmlQuery* >::toCpp(pyargs[0]);
        if (!SbkQXmlQuery_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QXmlQuery >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
        // QXmlFormatter(QXmlQuery,QIODevice*)
        cptr = new QXmlFormatterWrapper(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlFormatter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlFormatter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlFormatter_Init_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlQuery, PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlFormatter", overloads);
        return -1;
}

static PyObject* SbkQXmlFormatterFunc_atomicValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // atomicValue(QVariant)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::atomicValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_atomicValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_atomicValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlFormatter.atomicValue", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_attribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0]) && Shiboken::Converter<QStringRef & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStringRef* cpp_arg1 = Shiboken::Converter<QStringRef* >::toCpp(pyargs[1]);
        // attribute(QXmlName,QStringRef)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::attribute(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_attribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlFormatter.attribute", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_characters(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringRef & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStringRef* cpp_arg0 = Shiboken::Converter<QStringRef* >::toCpp(arg);
        // characters(QStringRef)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::characters(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_characters_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_characters_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringRef", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlFormatter.characters", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_comment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // comment(QString)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::comment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_comment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_comment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlFormatter.comment", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_endDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endDocument()
    QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
    cppSelf->QXmlFormatter::endDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlFormatterFunc_endElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endElement()
    QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
    cppSelf->QXmlFormatter::endElement();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlFormatterFunc_endOfSequence(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endOfSequence()
    QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
    cppSelf->QXmlFormatter::endOfSequence();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlFormatterFunc_indentationDepth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indentationDepth()const
    QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QXmlFormatter::indentationDepth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlFormatterFunc_processingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processingInstruction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlName & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // processingInstruction(QXmlName,QString)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::processingInstruction(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_processingInstruction_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_processingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlFormatter.processingInstruction", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_setIndentationDepth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setIndentationDepth(int)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::setIndentationDepth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_setIndentationDepth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_setIndentationDepth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlFormatter.setIndentationDepth", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_startDocument(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startDocument()
    QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
    cppSelf->QXmlFormatter::startDocument();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlFormatterFunc_startElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // startElement(QXmlName)
        QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
        cppSelf->QXmlFormatter::startElement(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlFormatterFunc_startElement_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlFormatterFunc_startElement_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlFormatter.startElement", overloads);
        return 0;
}

static PyObject* SbkQXmlFormatterFunc_startOfSequence(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startOfSequence()
    QXmlFormatter* cppSelf = Shiboken::Converter<QXmlFormatter* >::toCpp((PyObject*)self);
    cppSelf->QXmlFormatter::startOfSequence();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQXmlFormatter_methods[] = {
    {"atomicValue", (PyCFunction)SbkQXmlFormatterFunc_atomicValue, METH_O},
    {"attribute", (PyCFunction)SbkQXmlFormatterFunc_attribute, METH_VARARGS},
    {"characters", (PyCFunction)SbkQXmlFormatterFunc_characters, METH_O},
    {"comment", (PyCFunction)SbkQXmlFormatterFunc_comment, METH_O},
    {"endDocument", (PyCFunction)SbkQXmlFormatterFunc_endDocument, METH_NOARGS},
    {"endElement", (PyCFunction)SbkQXmlFormatterFunc_endElement, METH_NOARGS},
    {"endOfSequence", (PyCFunction)SbkQXmlFormatterFunc_endOfSequence, METH_NOARGS},
    {"indentationDepth", (PyCFunction)SbkQXmlFormatterFunc_indentationDepth, METH_NOARGS},
    {"processingInstruction", (PyCFunction)SbkQXmlFormatterFunc_processingInstruction, METH_VARARGS},
    {"setIndentationDepth", (PyCFunction)SbkQXmlFormatterFunc_setIndentationDepth, METH_O},
    {"startDocument", (PyCFunction)SbkQXmlFormatterFunc_startDocument, METH_NOARGS},
    {"startElement", (PyCFunction)SbkQXmlFormatterFunc_startElement, METH_O},
    {"startOfSequence", (PyCFunction)SbkQXmlFormatterFunc_startOfSequence, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlFormatter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlFormatter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlFormatter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlFormatter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlFormatter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlFormatter(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLFORMATTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlFormatter_Type);

    SbkQXmlFormatter_Type.super.ht_type.tp_base = SbkPySide_QtXmlPatternsTypes[SBK_QXMLSERIALIZER_IDX];
    // Fill type discovery information
    SbkQXmlFormatter_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQXmlFormatter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlFormatter_Type));
    PyModule_AddObject(module, "QXmlFormatter",
        ((PyObject*)&SbkQXmlFormatter_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlFormatter >("QXmlFormatter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlFormatter >(typeid(QXmlFormatter).name());
}


} // extern "C"

