/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomelement_wrapper.h"

// Extra includes
#include <qdom.h>
#include <qstring.h>
#include <qtextstream.h>

using namespace Shiboken;

static int
SbkQDomElement_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomElement* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomElement", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomElement()
        cptr = new QDomElement();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomElement & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomElement* cpp_arg0 = Shiboken::Converter<QDomElement* >::toCpp(pyargs[0]);
        // QDomElement(QDomElement)
        cptr = new QDomElement(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElement_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomElement >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomElement_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomElement_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomElement", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement", overloads);
        return -1;
}

static PyObject* SbkQDomElementFunc_attribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // attribute(QString,QString)const
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QDomElement::attribute(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // attribute(QString,QString)const
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QDomElement::attribute(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomElementFunc_attribute_TypeError;
    } else goto SbkQDomElementFunc_attribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_attribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.attribute", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_attributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "attributeNS", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // attributeNS(QString,QString,QString)const
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QDomElement::attributeNS(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // attributeNS(QString,QString,QString)const
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QDomElement::attributeNS(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomElementFunc_attributeNS_TypeError;
    } else goto SbkQDomElementFunc_attributeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_attributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.attributeNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_attributeNode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // attributeNode(QString)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomElement::attributeNode(*cpp_arg0);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_attributeNode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_attributeNode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.attributeNode", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_attributeNodeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "attributeNodeNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // attributeNodeNS(QString,QString)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomElement::attributeNodeNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_attributeNodeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_attributeNodeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.attributeNodeNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_attributes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // attributes()const
    QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
    QDomNamedNodeMap cpp_result = cppSelf->QDomElement::attributes();
    py_result = Shiboken::Converter<QDomNamedNodeMap >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomElementFunc_elementsByTagName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // elementsByTagName(QString)const
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomNodeList cpp_result = cppSelf->QDomElement::elementsByTagName(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNodeList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_elementsByTagName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_elementsByTagName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.elementsByTagName", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_elementsByTagNameNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "elementsByTagNameNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // elementsByTagNameNS(QString,QString)const
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomNodeList cpp_result = cppSelf->QDomElement::elementsByTagNameNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNodeList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_elementsByTagNameNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_elementsByTagNameNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.elementsByTagNameNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_hasAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // hasAttribute(QString)const
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDomElement::hasAttribute(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_hasAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_hasAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.hasAttribute", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_hasAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "hasAttributeNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // hasAttributeNS(QString,QString)const
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDomElement::hasAttributeNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_hasAttributeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_hasAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.hasAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_nodeType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nodeType()const
    QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
    QDomNode::NodeType cpp_result = cppSelf->QDomElement::nodeType();
    py_result = Shiboken::Converter<QDomNode::NodeType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomElementFunc_removeAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeAttribute(QString)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        cppSelf->QDomElement::removeAttribute(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_removeAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomElementFunc_removeAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.removeAttribute", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_removeAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removeAttributeNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // removeAttributeNS(QString,QString)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        cppSelf->QDomElement::removeAttributeNS(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_removeAttributeNS_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomElementFunc_removeAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.removeAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_removeAttributeNode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomAttr & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomAttr* cpp_arg0 = Shiboken::Converter<QDomAttr* >::toCpp(arg);
        // removeAttributeNode(QDomAttr)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomElement::removeAttributeNode(*cpp_arg0);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_removeAttributeNode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_removeAttributeNode_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomAttr", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.removeAttributeNode", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_setAttribute(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            uint cpp_arg1 = Shiboken::Converter<uint >::toCpp(pyargs[1]);
            // setAttribute(QString,uint)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyLong_Check(pyargs[1])) {
            qulonglong cpp_arg1 = Shiboken::Converter<qulonglong >::toCpp(pyargs[1]);
            // setAttribute(QString,qulonglong)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyLong_Check(pyargs[1])) {
            qlonglong cpp_arg1 = Shiboken::Converter<qlonglong >::toCpp(pyargs[1]);
            // setAttribute(QString,qlonglong)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyFloat_Check(pyargs[1])) {
            float cpp_arg1 = Shiboken::Converter<float >::toCpp(pyargs[1]);
            // setAttribute(QString,float)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyFloat_Check(pyargs[1])) {
            double cpp_arg1 = Shiboken::Converter<double >::toCpp(pyargs[1]);
            // setAttribute(QString,double)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // setAttribute(QString,int)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // setAttribute(QString,QString)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttribute(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomElementFunc_setAttribute_TypeError;
    } else goto SbkQDomElementFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomElementFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString, float", "PySide.QtCore.QString, float", "PySide.QtCore.QString, int", "PySide.QtCore.QString, long long", "PySide.QtCore.QString, unsigned long long", "PySide.QtCore.QString, unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.setAttribute", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_setAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setAttributeNS", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
            uint cpp_arg2 = Shiboken::Converter<uint >::toCpp(pyargs[2]);
            // setAttributeNS(QString,QString,uint)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttributeNS(*cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyLong_Check(pyargs[2])) {
            qulonglong cpp_arg2 = Shiboken::Converter<qulonglong >::toCpp(pyargs[2]);
            // setAttributeNS(QString,QString,qulonglong)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttributeNS(*cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyLong_Check(pyargs[2])) {
            qlonglong cpp_arg2 = Shiboken::Converter<qlonglong >::toCpp(pyargs[2]);
            // setAttributeNS(QString,QString,qlonglong)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttributeNS(*cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyFloat_Check(pyargs[2])) {
            double cpp_arg2 = Shiboken::Converter<double >::toCpp(pyargs[2]);
            // setAttributeNS(QString,QString,double)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttributeNS(*cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setAttributeNS(QString,QString,int)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttributeNS(*cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // setAttributeNS(QString,QString,QString)
            QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
            cppSelf->QDomElement::setAttributeNS(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomElementFunc_setAttributeNS_TypeError;
    } else goto SbkQDomElementFunc_setAttributeNS_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomElementFunc_setAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString, float", "PySide.QtCore.QString, PySide.QtCore.QString, int", "PySide.QtCore.QString, PySide.QtCore.QString, long long", "PySide.QtCore.QString, PySide.QtCore.QString, unsigned long long", "PySide.QtCore.QString, PySide.QtCore.QString, unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomElement.setAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_setAttributeNode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomAttr & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomAttr* cpp_arg0 = Shiboken::Converter<QDomAttr* >::toCpp(arg);
        // setAttributeNode(QDomAttr)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomElement::setAttributeNode(*cpp_arg0);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_setAttributeNode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_setAttributeNode_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomAttr", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.setAttributeNode", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_setAttributeNodeNS(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDomAttr & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDomAttr* cpp_arg0 = Shiboken::Converter<QDomAttr* >::toCpp(arg);
        // setAttributeNodeNS(QDomAttr)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomElement::setAttributeNodeNS(*cpp_arg0);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_setAttributeNodeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomElementFunc_setAttributeNodeNS_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomAttr", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.setAttributeNodeNS", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_setTagName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setTagName(QString)
        QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
        cppSelf->QDomElement::setTagName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomElementFunc_setTagName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDomElementFunc_setTagName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomElement.setTagName", overloads);
        return 0;
}

static PyObject* SbkQDomElementFunc_tagName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tagName()const
    QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomElement::tagName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomElementFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QDomElement* cppSelf = Shiboken::Converter<QDomElement* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDomElement::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQDomElement_methods[] = {
    {"attribute", (PyCFunction)SbkQDomElementFunc_attribute, METH_VARARGS},
    {"attributeNS", (PyCFunction)SbkQDomElementFunc_attributeNS, METH_VARARGS},
    {"attributeNode", (PyCFunction)SbkQDomElementFunc_attributeNode, METH_O},
    {"attributeNodeNS", (PyCFunction)SbkQDomElementFunc_attributeNodeNS, METH_VARARGS},
    {"attributes", (PyCFunction)SbkQDomElementFunc_attributes, METH_NOARGS},
    {"elementsByTagName", (PyCFunction)SbkQDomElementFunc_elementsByTagName, METH_O},
    {"elementsByTagNameNS", (PyCFunction)SbkQDomElementFunc_elementsByTagNameNS, METH_VARARGS},
    {"hasAttribute", (PyCFunction)SbkQDomElementFunc_hasAttribute, METH_O},
    {"hasAttributeNS", (PyCFunction)SbkQDomElementFunc_hasAttributeNS, METH_VARARGS},
    {"nodeType", (PyCFunction)SbkQDomElementFunc_nodeType, METH_NOARGS},
    {"removeAttribute", (PyCFunction)SbkQDomElementFunc_removeAttribute, METH_O},
    {"removeAttributeNS", (PyCFunction)SbkQDomElementFunc_removeAttributeNS, METH_VARARGS},
    {"removeAttributeNode", (PyCFunction)SbkQDomElementFunc_removeAttributeNode, METH_O},
    {"setAttribute", (PyCFunction)SbkQDomElementFunc_setAttribute, METH_VARARGS},
    {"setAttributeNS", (PyCFunction)SbkQDomElementFunc_setAttributeNS, METH_VARARGS},
    {"setAttributeNode", (PyCFunction)SbkQDomElementFunc_setAttributeNode, METH_O},
    {"setAttributeNodeNS", (PyCFunction)SbkQDomElementFunc_setAttributeNodeNS, METH_O},
    {"setTagName", (PyCFunction)SbkQDomElementFunc_setTagName, METH_O},
    {"tagName", (PyCFunction)SbkQDomElementFunc_tagName, METH_NOARGS},
    {"text", (PyCFunction)SbkQDomElementFunc_text, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomElement_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomElement",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomElement_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomElement_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomElement >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDomElement(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMELEMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomElement_Type);

    SbkQDomElement_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQDomElement_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomElement_Type));
    PyModule_AddObject(module, "QDomElement",
        ((PyObject*)&SbkQDomElement_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomElement >("QDomElement");
    Shiboken::TypeResolver::createValueTypeResolver<QDomElement >(typeid(QDomElement).name());
}


} // extern "C"

