/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qdomdocument_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qdom.h>
#include <qiodevice.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qxml.h>

using namespace Shiboken;

static int
SbkQDomDocument_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDomDocument* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDomDocument", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDomDocument()
        cptr = new QDomDocument();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QDomDocument(QString)
        cptr = new QDomDocument(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomDocumentType & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomDocumentType* cpp_arg0 = Shiboken::Converter<QDomDocumentType* >::toCpp(pyargs[0]);
        // QDomDocument(QDomDocumentType)
        cptr = new QDomDocument(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QDomDocument & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDomDocument* cpp_arg0 = Shiboken::Converter<QDomDocument* >::toCpp(pyargs[0]);
        // QDomDocument(QDomDocument)
        cptr = new QDomDocument(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocument_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDomDocument >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDomDocument_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDomDocument_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXml.QDomDocument", "PySide.QtXml.QDomDocumentType", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument", overloads);
        return -1;
}

static PyObject* SbkQDomDocumentFunc_createAttribute(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // createAttribute(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomDocument::createAttribute(*cpp_arg0);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.createAttribute", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createAttributeNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createAttributeNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // createAttributeNS(QString,QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomAttr cpp_result = cppSelf->QDomDocument::createAttributeNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomAttr >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createAttributeNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createAttributeNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument.createAttributeNS", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createCDATASection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // createCDATASection(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomCDATASection cpp_result = cppSelf->QDomDocument::createCDATASection(*cpp_arg0);
        py_result = Shiboken::Converter<QDomCDATASection >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createCDATASection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createCDATASection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.createCDATASection", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createComment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // createComment(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomComment cpp_result = cppSelf->QDomDocument::createComment(*cpp_arg0);
        py_result = Shiboken::Converter<QDomComment >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createComment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createComment_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.createComment", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createDocumentFragment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createDocumentFragment()
    QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
    QDomDocumentFragment cpp_result = cppSelf->QDomDocument::createDocumentFragment();
    py_result = Shiboken::Converter<QDomDocumentFragment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomDocumentFunc_createElement(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // createElement(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomDocument::createElement(*cpp_arg0);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createElement_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createElement_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.createElement", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createElementNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createElementNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // createElementNS(QString,QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomDocument::createElementNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createElementNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createElementNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument.createElementNS", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createEntityReference(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // createEntityReference(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomEntityReference cpp_result = cppSelf->QDomDocument::createEntityReference(*cpp_arg0);
        py_result = Shiboken::Converter<QDomEntityReference >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createEntityReference_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createEntityReference_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.createEntityReference", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createProcessingInstruction(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createProcessingInstruction", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // createProcessingInstruction(QString,QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomProcessingInstruction cpp_result = cppSelf->QDomDocument::createProcessingInstruction(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomProcessingInstruction >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createProcessingInstruction_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createProcessingInstruction_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument.createProcessingInstruction", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_createTextNode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // createTextNode(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomText cpp_result = cppSelf->QDomDocument::createTextNode(*cpp_arg0);
        py_result = Shiboken::Converter<QDomText >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_createTextNode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_createTextNode_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.createTextNode", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_doctype(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // doctype()const
    QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
    QDomDocumentType cpp_result = cppSelf->QDomDocument::doctype();
    py_result = Shiboken::Converter<QDomDocumentType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomDocumentFunc_documentElement(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentElement()const
    QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
    QDomElement cpp_result = cppSelf->QDomDocument::documentElement();
    py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomDocumentFunc_elementById(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // elementById(QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomElement cpp_result = cppSelf->QDomDocument::elementById(*cpp_arg0);
        py_result = Shiboken::Converter<QDomElement >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_elementById_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_elementById_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.elementById", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_elementsByTagName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // elementsByTagName(QString)const
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomNodeList cpp_result = cppSelf->QDomDocument::elementsByTagName(*cpp_arg0);
        py_result = Shiboken::Converter<QDomNodeList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_elementsByTagName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_elementsByTagName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.elementsByTagName", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_elementsByTagNameNS(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "elementsByTagNameNS", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // elementsByTagNameNS(QString,QString)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomNodeList cpp_result = cppSelf->QDomDocument::elementsByTagNameNS(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QDomNodeList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_elementsByTagNameNS_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_elementsByTagNameNS_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument.elementsByTagNameNS", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_implementation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // implementation()const
    QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
    QDomImplementation cpp_result = cppSelf->QDomDocument::implementation();
    py_result = Shiboken::Converter<QDomImplementation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDomDocumentFunc_importNode(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "importNode", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDomNode & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDomNode* cpp_arg0 = Shiboken::Converter<QDomNode* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // importNode(QDomNode,bool)
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QDomNode cpp_result = cppSelf->QDomDocument::importNode(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QDomNode >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_importNode_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_importNode_TypeError:
        const char* overloads[] = {"PySide.QtXml.QDomNode, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument.importNode", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_setContent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setContent", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // setContent(QByteArray,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(*cpp_arg0, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setContent(QByteArray,bool,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(*cpp_arg0, cpp_arg1, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomDocumentFunc_setContent_TypeError;
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // setContent(QString,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(*cpp_arg0, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setContent(QString,bool,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(*cpp_arg0, cpp_arg1, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomDocumentFunc_setContent_TypeError;
    } else if (Shiboken::Converter<QXmlInputSource * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlInputSource* cpp_arg0 = Shiboken::Converter<QXmlInputSource* >::toCpp(pyargs[0]);
        if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setContent(QXmlInputSource*,bool,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(cpp_arg0, cpp_arg1, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QXmlReader * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QXmlReader* cpp_arg1 = Shiboken::Converter<QXmlReader* >::toCpp(pyargs[1]);
            // setContent(QXmlInputSource*,QXmlReader*,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(cpp_arg0, cpp_arg1, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomDocumentFunc_setContent_TypeError;
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setContent(QIODevice*,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(cpp_arg0, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setContent(QIODevice*,bool,QString*,int*,int*)
            QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - qdomdocument_setcontent - START
            QString _errorMsg_;
            int _errorLine_ = 0;
            int _errorColumn_ = 0;
            bool _ret_ = cppSelf->setContent(cpp_arg0, cpp_arg1, &_errorMsg_, &_errorLine_, &_errorColumn_);
            py_result = Shiboken::makeTuple(_ret_, _errorMsg_, _errorLine_, _errorColumn_);
            // TEMPLATE - qdomdocument_setcontent - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else goto SbkQDomDocumentFunc_setContent_TypeError;
    } else goto SbkQDomDocumentFunc_setContent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_setContent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtCore.QString, int, int", "PySide.QtCore.QIODevice, bool, PySide.QtCore.QString, int, int", "PySide.QtXml.QXmlInputSource, PySide.QtXml.QXmlReader, PySide.QtCore.QString, int, int", "PySide.QtXml.QXmlInputSource, bool, PySide.QtCore.QString, int, int", "PySide.QtCore.QByteArray, PySide.QtCore.QString, int, int", "PySide.QtCore.QByteArray, bool, PySide.QtCore.QString, int, int", "PySide.QtCore.QString, PySide.QtCore.QString, int, int", "PySide.QtCore.QString, bool, PySide.QtCore.QString, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QDomDocument.setContent", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_toByteArray(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toByteArray(int)const
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QDomDocument::toByteArray();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toByteArray(int)const
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QDomDocument::toByteArray(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_toByteArray_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_toByteArray_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.toByteArray", overloads);
        return 0;
}

static PyObject* SbkQDomDocumentFunc_toString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toString(int)const
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDomDocument::toString();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // toString(int)const
        QDomDocument* cppSelf = Shiboken::Converter<QDomDocument* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDomDocument::toString(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDomDocumentFunc_toString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDomDocumentFunc_toString_TypeError:
        const char* overloads[] = {"int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QDomDocument.toString", overloads);
        return 0;
}

static PyMethodDef SbkQDomDocument_methods[] = {
    {"createAttribute", (PyCFunction)SbkQDomDocumentFunc_createAttribute, METH_O},
    {"createAttributeNS", (PyCFunction)SbkQDomDocumentFunc_createAttributeNS, METH_VARARGS},
    {"createCDATASection", (PyCFunction)SbkQDomDocumentFunc_createCDATASection, METH_O},
    {"createComment", (PyCFunction)SbkQDomDocumentFunc_createComment, METH_O},
    {"createDocumentFragment", (PyCFunction)SbkQDomDocumentFunc_createDocumentFragment, METH_NOARGS},
    {"createElement", (PyCFunction)SbkQDomDocumentFunc_createElement, METH_O},
    {"createElementNS", (PyCFunction)SbkQDomDocumentFunc_createElementNS, METH_VARARGS},
    {"createEntityReference", (PyCFunction)SbkQDomDocumentFunc_createEntityReference, METH_O},
    {"createProcessingInstruction", (PyCFunction)SbkQDomDocumentFunc_createProcessingInstruction, METH_VARARGS},
    {"createTextNode", (PyCFunction)SbkQDomDocumentFunc_createTextNode, METH_O},
    {"doctype", (PyCFunction)SbkQDomDocumentFunc_doctype, METH_NOARGS},
    {"documentElement", (PyCFunction)SbkQDomDocumentFunc_documentElement, METH_NOARGS},
    {"elementById", (PyCFunction)SbkQDomDocumentFunc_elementById, METH_O},
    {"elementsByTagName", (PyCFunction)SbkQDomDocumentFunc_elementsByTagName, METH_O},
    {"elementsByTagNameNS", (PyCFunction)SbkQDomDocumentFunc_elementsByTagNameNS, METH_VARARGS},
    {"implementation", (PyCFunction)SbkQDomDocumentFunc_implementation, METH_NOARGS},
    {"importNode", (PyCFunction)SbkQDomDocumentFunc_importNode, METH_VARARGS},
    {"setContent", (PyCFunction)SbkQDomDocumentFunc_setContent, METH_VARARGS},
    {"toByteArray", (PyCFunction)SbkQDomDocumentFunc_toByteArray, METH_NOARGS|METH_O},
    {"toString", (PyCFunction)SbkQDomDocumentFunc_toString, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDomDocument_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QDomDocument",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDomDocument_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDomDocument_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDomDocument >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QDomDocument(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDomDocument_Type);

    SbkQDomDocument_Type.super.ht_type.tp_base = SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQDomDocument_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDomDocument_Type));
    PyModule_AddObject(module, "QDomDocument",
        ((PyObject*)&SbkQDomDocument_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QDomDocument >("QDomDocument");
    Shiboken::TypeResolver::createValueTypeResolver<QDomDocument >(typeid(QDomDocument).name());
}


} // extern "C"

