/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebpluginfactory_mimetype_wrapper.h"

// Extra includes
#include <qwebpluginfactory.h>

using namespace Shiboken;

static int
SbkQWebPluginFactory_MimeType_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebPluginFactory::MimeType* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "MimeType", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // MimeType()
        cptr = new QWebPluginFactory::MimeType();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWebPluginFactory::MimeType & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebPluginFactory::MimeType* cpp_arg0 = Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp(pyargs[0]);
        // MimeType(QWebPluginFactory::MimeType)
        cptr = new QWebPluginFactory::MimeType(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebPluginFactory_MimeType_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebPluginFactory::MimeType >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebPluginFactory_MimeType_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebPluginFactory_MimeType_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtWebKit.QWebPluginFactory::MimeType", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.MimeType", overloads);
        return -1;
}

static PyMethodDef SbkQWebPluginFactory_MimeType_methods[] = {
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQWebPluginFactory_MimeType_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QWebPluginFactory::MimeType& cpp_self = *Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QWebPluginFactory::MimeType & >::isConvertible(other)) {
                // operator!=(const QWebPluginFactory::MimeType & other) const
                QWebPluginFactory::MimeType* cpp_other = Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QWebPluginFactory::MimeType  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQWebPluginFactory_MimeType_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QWebPluginFactory::MimeType & >::isConvertible(other)) {
                // operator==(const QWebPluginFactory::MimeType & other) const
                QWebPluginFactory::MimeType* cpp_other = Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QWebPluginFactory::MimeType  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQWebPluginFactory_MimeType_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQWebPluginFactory_MimeType_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

static PyObject* SbkQWebPluginFactory_MimeType_get_description(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self)->description);
}
static int SbkQWebPluginFactory_MimeType_set_description(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'description' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'description', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self)->description = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQWebPluginFactory_MimeType_get_name(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QString >::toPython(Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self)->name);
}
static int SbkQWebPluginFactory_MimeType_set_name(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'name' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QString >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'name', 'QString' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self)->name = Shiboken::Converter<QString >::toCpp(value);

    return 0;
}

static PyObject* SbkQWebPluginFactory_MimeType_get_fileExtensions(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QStringList >::toPython(Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self)->fileExtensions);
}
static int SbkQWebPluginFactory_MimeType_set_fileExtensions(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'fileExtensions' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QStringList >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'fileExtensions', 'QStringList' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QWebPluginFactory::MimeType* >::toCpp((PyObject*)self)->fileExtensions = Shiboken::Converter<QStringList >::toCpp(value);

    return 0;
}

// Getters and Setters for MimeType
static PyGetSetDef SbkQWebPluginFactory_MimeType_getsetlist[] = {
    {const_cast<char*>("description"), (getter)SbkQWebPluginFactory_MimeType_get_description, (setter)SbkQWebPluginFactory_MimeType_set_description},
    {const_cast<char*>("name"), (getter)SbkQWebPluginFactory_MimeType_get_name, (setter)SbkQWebPluginFactory_MimeType_set_name},
    {const_cast<char*>("fileExtensions"), (getter)SbkQWebPluginFactory_MimeType_get_fileExtensions, (setter)SbkQWebPluginFactory_MimeType_set_fileExtensions},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebPluginFactory_MimeType_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.MimeType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQWebPluginFactory_MimeType_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebPluginFactory_MimeType_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQWebPluginFactory_MimeType_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebPluginFactory_MimeType_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebPluginFactory::MimeType >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QWebPluginFactory_MimeType(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBPLUGINFACTORY_MIMETYPE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebPluginFactory_MimeType_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebPluginFactory_MimeType_Type) < 0)
        return;

    PyDict_SetItemString(module,"MimeType", (PyObject*)&SbkQWebPluginFactory_MimeType_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QWebPluginFactory::MimeType >("QWebPluginFactory::MimeType");
    Shiboken::TypeResolver::createValueTypeResolver<QWebPluginFactory::MimeType >(typeid(QWebPluginFactory::MimeType).name());
}


} // extern "C"

