/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qttest_python.h"

#include "qtest_wrapper.h"

// Extra includes
#include <QtTest>
#include <qobject.h>
#include <qpoint.h>
#include <qstring.h>
#include <qwidget.h>

using namespace Shiboken;

static PyObject* SbkQTestFunc_addColumnInternal(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addColumnInternal", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        // addColumnInternal(int,const char*)
        QTest::addColumnInternal(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_addColumnInternal_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_addColumnInternal_TypeError:
        const char* overloads[] = {"int, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.addColumnInternal", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_asciiToKey(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<char >::isConvertible(arg)) {
        char cpp_arg0 = Shiboken::Converter<char >::toCpp(arg);
        // asciiToKey(char)
        Qt::Key cpp_result = QTest::asciiToKey(cpp_arg0);
        py_result = Shiboken::Converter<Qt::Key >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_asciiToKey_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_asciiToKey_TypeError:
        const char* overloads[] = {"char", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtTest.QTest.asciiToKey", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_compare_ptr_helper(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "compare_ptr_helper", 6, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && Shiboken::Converter<void * >::isConvertible(pyargs[0]) && Shiboken::Converter<void * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2]) && Shiboken::Converter<const char * >::isConvertible(pyargs[3]) && Shiboken::Converter<const char * >::isConvertible(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        const void * cpp_arg0 = Shiboken::Converter<const void * >::toCpp(pyargs[0]);
        const void * cpp_arg1 = Shiboken::Converter<const void * >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
        const char * cpp_arg4 = Shiboken::Converter<const char * >::toCpp(pyargs[4]);
        int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
        // compare_ptr_helper(const void*,const void*,const char*,const char*,const char*,int)
        bool cpp_result = QTest::compare_ptr_helper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_compare_ptr_helper_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_compare_ptr_helper_TypeError:
        const char* overloads[] = {"void, void, str, str, str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.compare_ptr_helper", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_compare_string_helper(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "compare_string_helper", 6, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2]) && Shiboken::Converter<const char * >::isConvertible(pyargs[3]) && Shiboken::Converter<const char * >::isConvertible(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
        const char * cpp_arg4 = Shiboken::Converter<const char * >::toCpp(pyargs[4]);
        int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
        // compare_string_helper(const char*,const char*,const char*,const char*,const char*,int)
        bool cpp_result = QTest::compare_string_helper(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_compare_string_helper_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_compare_string_helper_TypeError:
        const char* overloads[] = {"str, str, str, str, str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.compare_string_helper", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_currentDataTag(PyObject* self)
{
    PyObject* py_result = 0;

    // currentDataTag()
    const char * cpp_result = QTest::currentDataTag();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTestFunc_currentTestFailed(PyObject* self)
{
    PyObject* py_result = 0;

    // currentTestFailed()
    bool cpp_result = QTest::currentTestFailed();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTestFunc_currentTestFunction(PyObject* self)
{
    PyObject* py_result = 0;

    // currentTestFunction()
    const char * cpp_result = QTest::currentTestFunction();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTestFunc_ignoreMessage(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "ignoreMessage", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QtMsgType >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        QtMsgType cpp_arg0 = Shiboken::Converter<QtMsgType >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        // ignoreMessage(QtMsgType,const char*)
        QTest::ignoreMessage(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_ignoreMessage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_ignoreMessage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QtMsgType, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.ignoreMessage", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_keyClick(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "keyClick", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::Converter<Qt::Key >::isConvertible(pyargs[1])) {
            Qt::Key cpp_arg1 = Shiboken::Converter<Qt::Key >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyClick(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
                QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyClick(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyClick(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyClick_TypeError;
            } else goto SbkQTestFunc_keyClick_TypeError;
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyClick(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
                QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyClick(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyClick(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyClick_TypeError;
            } else goto SbkQTestFunc_keyClick_TypeError;
        } else goto SbkQTestFunc_keyClick_TypeError;
    } else goto SbkQTestFunc_keyClick_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_keyClick_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.Key, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", "PySide.QtGui.QWidget, char, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.keyClick", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_keyClicks(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "keyClicks", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
            QTest::keyClicks(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
            QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyClicks(cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyClicks(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQTestFunc_keyClicks_TypeError;
        } else goto SbkQTestFunc_keyClicks_TypeError;
    } else goto SbkQTestFunc_keyClicks_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_keyClicks_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QString, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.keyClicks", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_keyEvent(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "keyEvent", 3, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QTest::KeyAction >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        QTest::KeyAction cpp_arg0 = Shiboken::Converter<QTest::KeyAction >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        if (Shiboken::Converter<Qt::Key >::isConvertible(pyargs[2])) {
            Qt::Key cpp_arg2 = Shiboken::Converter<Qt::Key >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyEvent(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[3])) {
                QFlags<Qt::KeyboardModifier> cpp_arg3 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyEvent_TypeError;
            } else goto SbkQTestFunc_keyEvent_TypeError;
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[2])) {
            char cpp_arg2 = Shiboken::Converter<char >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyEvent(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[3])) {
                QFlags<Qt::KeyboardModifier> cpp_arg3 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyEvent_TypeError;
            } else goto SbkQTestFunc_keyEvent_TypeError;
        } else goto SbkQTestFunc_keyEvent_TypeError;
    } else goto SbkQTestFunc_keyEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_keyEvent_TypeError:
        const char* overloads[] = {"PySide.QtTest.QTest.KeyAction, PySide.QtGui.QWidget, PySide.QtCore.Qt.Key, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", "PySide.QtTest.QTest.KeyAction, PySide.QtGui.QWidget, char, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.keyEvent", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_keyPress(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "keyPress", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::Converter<Qt::Key >::isConvertible(pyargs[1])) {
            Qt::Key cpp_arg1 = Shiboken::Converter<Qt::Key >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyPress(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
                QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyPress(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyPress(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyPress_TypeError;
            } else goto SbkQTestFunc_keyPress_TypeError;
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyPress(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
                QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyPress(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyPress(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyPress_TypeError;
            } else goto SbkQTestFunc_keyPress_TypeError;
        } else goto SbkQTestFunc_keyPress_TypeError;
    } else goto SbkQTestFunc_keyPress_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_keyPress_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.Key, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", "PySide.QtGui.QWidget, char, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.keyPress", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_keyRelease(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "keyRelease", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (Shiboken::Converter<Qt::Key >::isConvertible(pyargs[1])) {
            Qt::Key cpp_arg1 = Shiboken::Converter<Qt::Key >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyRelease(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
                QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyRelease(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyRelease(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyRelease_TypeError;
            } else goto SbkQTestFunc_keyRelease_TypeError;
        } else if (Shiboken::Converter<char >::isConvertible(pyargs[1])) {
            char cpp_arg1 = Shiboken::Converter<char >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                QTest::keyRelease(cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
                QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyRelease(cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                    // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    QTest::keyRelease(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_keyRelease_TypeError;
            } else goto SbkQTestFunc_keyRelease_TypeError;
        } else goto SbkQTestFunc_keyRelease_TypeError;
    } else goto SbkQTestFunc_keyRelease_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_keyRelease_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.Key, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", "PySide.QtGui.QWidget, char, PySide.QtCore.Qt.KeyboardModifiers = Qt.NoModifier, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.keyRelease", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_keyToAscii(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::Key >::isConvertible(arg)) {
        Qt::Key cpp_arg0 = Shiboken::Converter<Qt::Key >::toCpp(arg);
        // keyToAscii(Qt::Key)
        char cpp_result = QTest::keyToAscii(cpp_arg0);
        py_result = Shiboken::Converter<char >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_keyToAscii_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_keyToAscii_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Key", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtTest.QTest.keyToAscii", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_mouseClick(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "mouseClick", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        Qt::MouseButton cpp_arg1 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            QTest::mouseClick(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
            QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                QTest::mouseClick(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QPoint >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QPoint* cpp_arg3 = Shiboken::Converter<QPoint* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mouseClick(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mouseClick(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_mouseClick_TypeError;
            } else goto SbkQTestFunc_mouseClick_TypeError;
        } else goto SbkQTestFunc_mouseClick_TypeError;
    } else goto SbkQTestFunc_mouseClick_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_mouseClick_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.KeyboardModifiers = 0, PySide.QtCore.QPoint = QPoint(), int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.mouseClick", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_mouseDClick(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "mouseDClick", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        Qt::MouseButton cpp_arg1 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            QTest::mouseDClick(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
            QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                QTest::mouseDClick(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QPoint >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QPoint* cpp_arg3 = Shiboken::Converter<QPoint* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mouseDClick(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mouseDClick(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_mouseDClick_TypeError;
            } else goto SbkQTestFunc_mouseDClick_TypeError;
        } else goto SbkQTestFunc_mouseDClick_TypeError;
    } else goto SbkQTestFunc_mouseDClick_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_mouseDClick_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.KeyboardModifiers = 0, PySide.QtCore.QPoint = QPoint(), int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.mouseDClick", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_mouseEvent(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "mouseEvent", 5, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QTest::MouseAction >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[2]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[3]) && Shiboken::Converter<QPoint >::isConvertible(pyargs[4])) {
        QTest::MouseAction cpp_arg0 = Shiboken::Converter<QTest::MouseAction >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        Qt::MouseButton cpp_arg2 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[2]);
        QFlags<Qt::KeyboardModifier> cpp_arg3 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        QPoint* cpp_arg4 = Shiboken::Converter<QPoint* >::toCpp(pyargs[4]);
        if (numArgs == 5) {
            // mouseEvent(QTest::MouseAction,QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            QTest::mouseEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[5])) {
            int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
            // mouseEvent(QTest::MouseAction,QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            QTest::mouseEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTestFunc_mouseEvent_TypeError;
    } else goto SbkQTestFunc_mouseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_mouseEvent_TypeError:
        const char* overloads[] = {"PySide.QtTest.QTest.MouseAction, PySide.QtGui.QWidget, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.QPoint, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.mouseEvent", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_mouseMove(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "mouseMove", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // mouseMove(QWidget*,QPoint,int)
            QTest::mouseMove(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPoint >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // mouseMove(QWidget*,QPoint,int)
                QTest::mouseMove(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // mouseMove(QWidget*,QPoint,int)
                QTest::mouseMove(cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQTestFunc_mouseMove_TypeError;
        } else goto SbkQTestFunc_mouseMove_TypeError;
    } else goto SbkQTestFunc_mouseMove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_mouseMove_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.QPoint = QPoint(), int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.mouseMove", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_mousePress(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "mousePress", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        Qt::MouseButton cpp_arg1 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            QTest::mousePress(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
            QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                QTest::mousePress(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QPoint >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QPoint* cpp_arg3 = Shiboken::Converter<QPoint* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mousePress(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mousePress(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_mousePress_TypeError;
            } else goto SbkQTestFunc_mousePress_TypeError;
        } else goto SbkQTestFunc_mousePress_TypeError;
    } else goto SbkQTestFunc_mousePress_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_mousePress_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.KeyboardModifiers = 0, PySide.QtCore.QPoint = QPoint(), int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.mousePress", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_mouseRelease(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "mouseRelease", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::MouseButton >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        Qt::MouseButton cpp_arg1 = Shiboken::Converter<Qt::MouseButton >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            QTest::mouseRelease(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[2])) {
            QFlags<Qt::KeyboardModifier> cpp_arg2 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                QTest::mouseRelease(cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QPoint >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                QPoint* cpp_arg3 = Shiboken::Converter<QPoint* >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mouseRelease(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                    QTest::mouseRelease(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQTestFunc_mouseRelease_TypeError;
            } else goto SbkQTestFunc_mouseRelease_TypeError;
        } else goto SbkQTestFunc_mouseRelease_TypeError;
    } else goto SbkQTestFunc_mouseRelease_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_mouseRelease_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.MouseButton, PySide.QtCore.Qt.KeyboardModifiers = 0, PySide.QtCore.QPoint = QPoint(), int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.mouseRelease", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_qElementData(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "qElementData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // qElementData(const char*,int)
        void * cpp_result = QTest::qElementData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<void * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_qElementData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_qElementData_TypeError:
        const char* overloads[] = {"str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.qElementData", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_qExpectFail(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qExpectFail", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1]) && Shiboken::Converter<QTest::TestFailMode >::isConvertible(pyargs[2]) && Shiboken::Converter<const char * >::isConvertible(pyargs[3]) && PyNumber_Check(pyargs[4])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        QTest::TestFailMode cpp_arg2 = Shiboken::Converter<QTest::TestFailMode >::toCpp(pyargs[2]);
        const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        // qExpectFail(const char*,const char*,QTest::TestFailMode,const char*,int)
        bool cpp_result = QTest::qExpectFail(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_qExpectFail_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_qExpectFail_TypeError:
        const char* overloads[] = {"str, str, PySide.QtTest.QTest.TestFailMode, str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.qExpectFail", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_qGlobalData(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "qGlobalData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // qGlobalData(const char*,int)
        void * cpp_result = QTest::qGlobalData(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<void * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_qGlobalData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_qGlobalData_TypeError:
        const char* overloads[] = {"str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.qGlobalData", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_qSkip(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qSkip", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<QTest::SkipMode >::isConvertible(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        QTest::SkipMode cpp_arg1 = Shiboken::Converter<QTest::SkipMode >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // qSkip(const char*,QTest::SkipMode,const char*,int)
        QTest::qSkip(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_qSkip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_qSkip_TypeError:
        const char* overloads[] = {"str, PySide.QtTest.QTest.SkipMode, str, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.qSkip", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_qWaitForWindowShown(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // qWaitForWindowShown(QWidget*)
        bool cpp_result = QTest::qWaitForWindowShown(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_qWaitForWindowShown_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_qWaitForWindowShown_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtTest.QTest.qWaitForWindowShown", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_qt_snprintf(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "qt_snprintf", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<const char * >::isConvertible(pyargs[2])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
        // qt_snprintf(char*,int,const char*)
        int cpp_result = QTest::qt_snprintf(cpp_arg0, cpp_arg1, cpp_arg2);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTestFunc_qt_snprintf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTestFunc_qt_snprintf_TypeError:
        const char* overloads[] = {"str, int, str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.qt_snprintf", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_sendKeyEvent(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "sendKeyEvent", 5, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QTest::KeyAction >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1]) && Shiboken::Converter<Qt::Key >::isConvertible(pyargs[2])) {
        QTest::KeyAction cpp_arg0 = Shiboken::Converter<QTest::KeyAction >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        Qt::Key cpp_arg2 = Shiboken::Converter<Qt::Key >::toCpp(pyargs[2]);
        if (Shiboken::Converter<char >::isConvertible(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
            char cpp_arg3 = Shiboken::Converter<char >::toCpp(pyargs[3]);
            QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                QTest::sendKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[5])) {
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                QTest::sendKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQTestFunc_sendKeyEvent_TypeError;
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[3]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            std::auto_ptr<QString > cpp_arg3_auto_ptr;
            QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
            if (!SbkQString_Check(pyargs[3]))
                cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
            QFlags<Qt::KeyboardModifier> cpp_arg4 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                QTest::sendKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[5])) {
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                QTest::sendKeyEvent(cpp_arg0, cpp_arg1, cpp_arg2, *cpp_arg3, cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQTestFunc_sendKeyEvent_TypeError;
        } else goto SbkQTestFunc_sendKeyEvent_TypeError;
    } else goto SbkQTestFunc_sendKeyEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_sendKeyEvent_TypeError:
        const char* overloads[] = {"PySide.QtTest.QTest.KeyAction, PySide.QtGui.QWidget, PySide.QtCore.Qt.Key, PySide.QtCore.QString, PySide.QtCore.Qt.KeyboardModifiers, int = -1", "PySide.QtTest.QTest.KeyAction, PySide.QtGui.QWidget, PySide.QtCore.Qt.Key, char, PySide.QtCore.Qt.KeyboardModifiers, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.sendKeyEvent", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_simulateEvent(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "simulateEvent", 6, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && SbkPySide_QtCore_Qt_KeyboardModifier_Check(pyargs[3]) && Shiboken::Converter<QString >::isConvertible(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        QFlags<Qt::KeyboardModifier> cpp_arg3 = Shiboken::Converter<QFlags<Qt::KeyboardModifier> >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        std::auto_ptr<QString > cpp_arg4_auto_ptr;
        QString* cpp_arg4 = Shiboken::Converter<QString* >::toCpp(pyargs[4]);
        if (!SbkQString_Check(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QString >(cpp_arg4);
        bool cpp_arg5 = Shiboken::Converter<bool >::toCpp(pyargs[5]);
        if (numArgs == 6) {
            // simulateEvent(QWidget*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
            QTest::simulateEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[6])) {
            int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
            // simulateEvent(QWidget*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
            QTest::simulateEvent(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5, cpp_arg6);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTestFunc_simulateEvent_TypeError;
    } else goto SbkQTestFunc_simulateEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTestFunc_simulateEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, bool, int, PySide.QtCore.Qt.KeyboardModifiers, PySide.QtCore.QString, bool, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtTest.QTest.simulateEvent", overloads);
        return 0;
}

static PyObject* SbkQTestFunc_testObject(PyObject* self)
{
    PyObject* py_result = 0;

    // testObject()
    QObject * cpp_result = QTest::testObject();
    py_result = Shiboken::Converter<QObject * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTest_methods[] = {
    {"addColumnInternal", (PyCFunction)SbkQTestFunc_addColumnInternal, METH_VARARGS|METH_STATIC},
    {"asciiToKey", (PyCFunction)SbkQTestFunc_asciiToKey, METH_O|METH_STATIC},
    {"compare_ptr_helper", (PyCFunction)SbkQTestFunc_compare_ptr_helper, METH_VARARGS|METH_STATIC},
    {"compare_string_helper", (PyCFunction)SbkQTestFunc_compare_string_helper, METH_VARARGS|METH_STATIC},
    {"currentDataTag", (PyCFunction)SbkQTestFunc_currentDataTag, METH_NOARGS|METH_STATIC},
    {"currentTestFailed", (PyCFunction)SbkQTestFunc_currentTestFailed, METH_NOARGS|METH_STATIC},
    {"currentTestFunction", (PyCFunction)SbkQTestFunc_currentTestFunction, METH_NOARGS|METH_STATIC},
    {"ignoreMessage", (PyCFunction)SbkQTestFunc_ignoreMessage, METH_VARARGS|METH_STATIC},
    {"keyClick", (PyCFunction)SbkQTestFunc_keyClick, METH_VARARGS|METH_STATIC},
    {"keyClicks", (PyCFunction)SbkQTestFunc_keyClicks, METH_VARARGS|METH_STATIC},
    {"keyEvent", (PyCFunction)SbkQTestFunc_keyEvent, METH_VARARGS|METH_STATIC},
    {"keyPress", (PyCFunction)SbkQTestFunc_keyPress, METH_VARARGS|METH_STATIC},
    {"keyRelease", (PyCFunction)SbkQTestFunc_keyRelease, METH_VARARGS|METH_STATIC},
    {"keyToAscii", (PyCFunction)SbkQTestFunc_keyToAscii, METH_O|METH_STATIC},
    {"mouseClick", (PyCFunction)SbkQTestFunc_mouseClick, METH_VARARGS|METH_STATIC},
    {"mouseDClick", (PyCFunction)SbkQTestFunc_mouseDClick, METH_VARARGS|METH_STATIC},
    {"mouseEvent", (PyCFunction)SbkQTestFunc_mouseEvent, METH_VARARGS|METH_STATIC},
    {"mouseMove", (PyCFunction)SbkQTestFunc_mouseMove, METH_VARARGS|METH_STATIC},
    {"mousePress", (PyCFunction)SbkQTestFunc_mousePress, METH_VARARGS|METH_STATIC},
    {"mouseRelease", (PyCFunction)SbkQTestFunc_mouseRelease, METH_VARARGS|METH_STATIC},
    {"qElementData", (PyCFunction)SbkQTestFunc_qElementData, METH_VARARGS|METH_STATIC},
    {"qExpectFail", (PyCFunction)SbkQTestFunc_qExpectFail, METH_VARARGS|METH_STATIC},
    {"qGlobalData", (PyCFunction)SbkQTestFunc_qGlobalData, METH_VARARGS|METH_STATIC},
    {"qSkip", (PyCFunction)SbkQTestFunc_qSkip, METH_VARARGS|METH_STATIC},
    {"qWaitForWindowShown", (PyCFunction)SbkQTestFunc_qWaitForWindowShown, METH_O|METH_STATIC},
    {"qt_snprintf", (PyCFunction)SbkQTestFunc_qt_snprintf, METH_VARARGS|METH_STATIC},
    {"sendKeyEvent", (PyCFunction)SbkQTestFunc_sendKeyEvent, METH_VARARGS|METH_STATIC},
    {"simulateEvent", (PyCFunction)SbkQTestFunc_simulateEvent, METH_VARARGS|METH_STATIC},
    {"testObject", (PyCFunction)SbkQTestFunc_testObject, METH_NOARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTest_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtTest.QTest",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTest_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            0,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtTest_QTest_LogElementType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtTest_QTest_LogElementType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtTest_QTest_LogElementType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "LogElementType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtTest_QTest_LogElementType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtTest_QTest_LogElementType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtTest_QTest_LogElementType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtTest_QTest_AttributeIndex_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtTest_QTest_AttributeIndex_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtTest_QTest_AttributeIndex_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "AttributeIndex",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtTest_QTest_AttributeIndex_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtTest_QTest_AttributeIndex_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtTest_QTest_AttributeIndex_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtTest_QTest_TestFailMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtTest_QTest_TestFailMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtTest_QTest_TestFailMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TestFailMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtTest_QTest_TestFailMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtTest_QTest_TestFailMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtTest_QTest_TestFailMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtTest_QTest_MouseAction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtTest_QTest_MouseAction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtTest_QTest_MouseAction_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MouseAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtTest_QTest_MouseAction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtTest_QTest_MouseAction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtTest_QTest_MouseAction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtTest_QTest_SkipMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtTest_QTest_SkipMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtTest_QTest_SkipMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SkipMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtTest_QTest_SkipMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtTest_QTest_SkipMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtTest_QTest_SkipMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtTest_QTest_KeyAction_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtTest_QTest_KeyAction_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtTest_QTest_KeyAction_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "KeyAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtTest_QTest_KeyAction_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtTest_QTest_KeyAction_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtTest_QTest_KeyAction_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTest(PyObject* module)
{
    SbkPySide_QtTestTypes[SBK_QTEST_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTest_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTest_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTest_Type));
    PyModule_AddObject(module, "QTest",
        ((PyObject*)&SbkQTest_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: LogElementType
    SbkPySide_QtTestTypes[SBK_QTEST_LOGELEMENTTYPE_IDX] = &SbkPySide_QtTest_QTest_LogElementType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtTest_QTest_LogElementType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtTest_QTest_LogElementType_Type);
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
            "LogElementType",((PyObject*)&SbkPySide_QtTest_QTest_LogElementType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_Undefined, "LET_Undefined");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_Undefined", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_Undefined", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_Property, "LET_Property");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_Property", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_Property", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_Properties, "LET_Properties");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_Properties", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_Properties", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_Failure, "LET_Failure");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_Failure", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_Failure", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_Error, "LET_Error");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_Error", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_Error", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_TestCase, "LET_TestCase");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_TestCase", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_TestCase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_TestSuite, "LET_TestSuite");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_TestSuite", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_TestSuite", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_Benchmark, "LET_Benchmark");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_Benchmark", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_Benchmark", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_LogElementType_Type,
        (long) QTest::LET_SystemError, "LET_SystemError");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "LET_SystemError", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_LogElementType_Type.tp_dict,
        "LET_SystemError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTest::LogElementType");

    // init enum class: AttributeIndex
    SbkPySide_QtTestTypes[SBK_QTEST_ATTRIBUTEINDEX_IDX] = &SbkPySide_QtTest_QTest_AttributeIndex_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtTest_QTest_AttributeIndex_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtTest_QTest_AttributeIndex_Type);
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
            "AttributeIndex",((PyObject*)&SbkPySide_QtTest_QTest_AttributeIndex_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Undefined, "AI_Undefined");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Undefined", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Undefined", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Name, "AI_Name");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Name", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Name", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Result, "AI_Result");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Result", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Result", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Tests, "AI_Tests");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Tests", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Tests", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Failures, "AI_Failures");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Failures", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Failures", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Errors, "AI_Errors");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Errors", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Errors", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Type, "AI_Type");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Type", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Type", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Description, "AI_Description");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Description", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Description", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_PropertyValue, "AI_PropertyValue");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_PropertyValue", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_PropertyValue", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_QTestVersion, "AI_QTestVersion");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_QTestVersion", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_QTestVersion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_QtVersion, "AI_QtVersion");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_QtVersion", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_QtVersion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_File, "AI_File");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_File", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_File", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Line, "AI_Line");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Line", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Line", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Metric, "AI_Metric");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Metric", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Metric", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Tag, "AI_Tag");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Tag", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Tag", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Value, "AI_Value");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Value", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Value", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_AttributeIndex_Type,
        (long) QTest::AI_Iterations, "AI_Iterations");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "AI_Iterations", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_AttributeIndex_Type.tp_dict,
        "AI_Iterations", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTest::AttributeIndex");

    // init enum class: TestFailMode
    SbkPySide_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX] = &SbkPySide_QtTest_QTest_TestFailMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtTest_QTest_TestFailMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtTest_QTest_TestFailMode_Type);
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
            "TestFailMode",((PyObject*)&SbkPySide_QtTest_QTest_TestFailMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_TestFailMode_Type,
        (long) QTest::Abort, "Abort");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "Abort", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_TestFailMode_Type.tp_dict,
        "Abort", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_TestFailMode_Type,
        (long) QTest::Continue, "Continue");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "Continue", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_TestFailMode_Type.tp_dict,
        "Continue", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTest::TestFailMode");

    // init enum class: MouseAction
    SbkPySide_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX] = &SbkPySide_QtTest_QTest_MouseAction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtTest_QTest_MouseAction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtTest_QTest_MouseAction_Type);
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
            "MouseAction",((PyObject*)&SbkPySide_QtTest_QTest_MouseAction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_MouseAction_Type,
        (long) QTest::MousePress, "MousePress");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "MousePress", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_MouseAction_Type.tp_dict,
        "MousePress", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_MouseAction_Type,
        (long) QTest::MouseRelease, "MouseRelease");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "MouseRelease", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_MouseAction_Type.tp_dict,
        "MouseRelease", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_MouseAction_Type,
        (long) QTest::MouseClick, "MouseClick");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "MouseClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_MouseAction_Type.tp_dict,
        "MouseClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_MouseAction_Type,
        (long) QTest::MouseDClick, "MouseDClick");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "MouseDClick", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_MouseAction_Type.tp_dict,
        "MouseDClick", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_MouseAction_Type,
        (long) QTest::MouseMove, "MouseMove");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "MouseMove", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_MouseAction_Type.tp_dict,
        "MouseMove", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTest::MouseAction");

    // init enum class: SkipMode
    SbkPySide_QtTestTypes[SBK_QTEST_SKIPMODE_IDX] = &SbkPySide_QtTest_QTest_SkipMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtTest_QTest_SkipMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtTest_QTest_SkipMode_Type);
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
            "SkipMode",((PyObject*)&SbkPySide_QtTest_QTest_SkipMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_SkipMode_Type,
        (long) QTest::SkipSingle, "SkipSingle");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "SkipSingle", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_SkipMode_Type.tp_dict,
        "SkipSingle", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_SkipMode_Type,
        (long) QTest::SkipAll, "SkipAll");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "SkipAll", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_SkipMode_Type.tp_dict,
        "SkipAll", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTest::SkipMode");

    // init enum class: KeyAction
    SbkPySide_QtTestTypes[SBK_QTEST_KEYACTION_IDX] = &SbkPySide_QtTest_QTest_KeyAction_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtTest_QTest_KeyAction_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtTest_QTest_KeyAction_Type);
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
            "KeyAction",((PyObject*)&SbkPySide_QtTest_QTest_KeyAction_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_KeyAction_Type,
        (long) QTest::Press, "Press");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "Press", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_KeyAction_Type.tp_dict,
        "Press", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_KeyAction_Type,
        (long) QTest::Release, "Release");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "Release", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_KeyAction_Type.tp_dict,
        "Release", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtTest_QTest_KeyAction_Type,
        (long) QTest::Click, "Click");
    PyDict_SetItemString(SbkQTest_Type.super.ht_type.tp_dict,
        "Click", enum_item);
    PyDict_SetItemString(SbkPySide_QtTest_QTest_KeyAction_Type.tp_dict,
        "Click", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTest::KeyAction");

}


} // extern "C"

