/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptvalueiterator_wrapper.h"

// Extra includes
#include <qscriptstring.h>
#include <qscriptvalue.h>
#include <qscriptvalueiterator.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQScriptValueIterator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptValueIterator* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptValueIterator", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // QScriptValueIterator(QScriptValue)
        cptr = new QScriptValueIterator(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueIterator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptValueIterator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptValueIterator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptValueIterator_Init_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptValueIterator", overloads);
        return -1;
}

static PyObject* SbkQScriptValueIteratorFunc_hasNext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasNext()const
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValueIterator::hasNext();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueIteratorFunc_hasPrevious(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasPrevious()const
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptValueIterator::hasPrevious();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueIteratorFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptValueIterator::name();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueIteratorFunc_next(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // next()
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    cppSelf->QScriptValueIterator::next();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptValueIteratorFunc_previous(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // previous()
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    cppSelf->QScriptValueIterator::previous();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptValueIteratorFunc_remove(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // remove()
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    cppSelf->QScriptValueIterator::remove();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptValueIteratorFunc_scriptName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scriptName()const
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    QScriptString cpp_result = cppSelf->QScriptValueIterator::scriptName();
    py_result = Shiboken::Converter<QScriptString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptValueIteratorFunc_setValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setValue(QScriptValue)
        QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
        cppSelf->QScriptValueIterator::setValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptValueIteratorFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptValueIteratorFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptValueIterator.setValue", overloads);
        return 0;
}

static PyObject* SbkQScriptValueIteratorFunc_toBack(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toBack()
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    cppSelf->QScriptValueIterator::toBack();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptValueIteratorFunc_toFront(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toFront()
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    cppSelf->QScriptValueIterator::toFront();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptValueIteratorFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QScriptValueIterator* cppSelf = Shiboken::Converter<QScriptValueIterator* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptValueIterator::value();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptValueIterator_methods[] = {
    {"hasNext", (PyCFunction)SbkQScriptValueIteratorFunc_hasNext, METH_NOARGS},
    {"hasPrevious", (PyCFunction)SbkQScriptValueIteratorFunc_hasPrevious, METH_NOARGS},
    {"name", (PyCFunction)SbkQScriptValueIteratorFunc_name, METH_NOARGS},
    {"next", (PyCFunction)SbkQScriptValueIteratorFunc_next, METH_NOARGS},
    {"previous", (PyCFunction)SbkQScriptValueIteratorFunc_previous, METH_NOARGS},
    {"remove", (PyCFunction)SbkQScriptValueIteratorFunc_remove, METH_NOARGS},
    {"scriptName", (PyCFunction)SbkQScriptValueIteratorFunc_scriptName, METH_NOARGS},
    {"setValue", (PyCFunction)SbkQScriptValueIteratorFunc_setValue, METH_O},
    {"toBack", (PyCFunction)SbkQScriptValueIteratorFunc_toBack, METH_NOARGS},
    {"toFront", (PyCFunction)SbkQScriptValueIteratorFunc_toFront, METH_NOARGS},
    {"value", (PyCFunction)SbkQScriptValueIteratorFunc_value, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptValueIterator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptValueIterator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptValueIterator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptValueIterator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptValueIterator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QScriptValueIterator(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTVALUEITERATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptValueIterator_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptValueIterator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptValueIterator_Type));
    PyModule_AddObject(module, "QScriptValueIterator",
        ((PyObject*)&SbkQScriptValueIterator_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptValueIterator >("QScriptValueIterator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptValueIterator >(typeid(QScriptValueIterator).name());
}


} // extern "C"

