/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtopengl_python.h"

#include "qglframebufferobjectformat_wrapper.h"

// Extra includes
#include <qglframebufferobject.h>

using namespace Shiboken;

static int
SbkQGLFramebufferObjectFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGLFramebufferObjectFormat* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGLFramebufferObjectFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGLFramebufferObjectFormat()
        cptr = new QGLFramebufferObjectFormat();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QGLFramebufferObjectFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGLFramebufferObjectFormat* cpp_arg0 = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp(pyargs[0]);
        // QGLFramebufferObjectFormat(QGLFramebufferObjectFormat)
        cptr = new QGLFramebufferObjectFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFramebufferObjectFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGLFramebufferObjectFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGLFramebufferObjectFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGLFramebufferObjectFormat_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtOpenGL.QGLFramebufferObjectFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtOpenGL.QGLFramebufferObjectFormat", overloads);
        return -1;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_attachment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // attachment()const
    QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
    QGLFramebufferObject::Attachment cpp_result = cppSelf->QGLFramebufferObjectFormat::attachment();
    py_result = Shiboken::Converter<QGLFramebufferObject::Attachment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_internalTextureFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // internalTextureFormat()const
    QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QGLFramebufferObjectFormat::internalTextureFormat();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_samples(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // samples()const
    QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGLFramebufferObjectFormat::samples();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_setAttachment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QGLFramebufferObject::Attachment >::isConvertible(arg)) {
        QGLFramebufferObject::Attachment cpp_arg0 = Shiboken::Converter<QGLFramebufferObject::Attachment >::toCpp(arg);
        // setAttachment(QGLFramebufferObject::Attachment)
        QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFramebufferObjectFormat::setAttachment(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFramebufferObjectFormatFunc_setAttachment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFramebufferObjectFormatFunc_setAttachment_TypeError:
        const char* overloads[] = {"PySide.QtOpenGL.QGLFramebufferObject.Attachment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFramebufferObjectFormat.setAttachment", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_setInternalTextureFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // setInternalTextureFormat(uint)
        QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFramebufferObjectFormat::setInternalTextureFormat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFramebufferObjectFormatFunc_setInternalTextureFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFramebufferObjectFormatFunc_setInternalTextureFormat_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFramebufferObjectFormat.setInternalTextureFormat", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_setSamples(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSamples(int)
        QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFramebufferObjectFormat::setSamples(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFramebufferObjectFormatFunc_setSamples_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFramebufferObjectFormatFunc_setSamples_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFramebufferObjectFormat.setSamples", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_setTextureTarget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        unsigned int cpp_arg0 = Shiboken::Converter<unsigned int >::toCpp(arg);
        // setTextureTarget(uint)
        QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
        cppSelf->QGLFramebufferObjectFormat::setTextureTarget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGLFramebufferObjectFormatFunc_setTextureTarget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGLFramebufferObjectFormatFunc_setTextureTarget_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtOpenGL.QGLFramebufferObjectFormat.setTextureTarget", overloads);
        return 0;
}

static PyObject* SbkQGLFramebufferObjectFormatFunc_textureTarget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textureTarget()const
    QGLFramebufferObjectFormat* cppSelf = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);
    unsigned int cpp_result = cppSelf->QGLFramebufferObjectFormat::textureTarget();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGLFramebufferObjectFormat_methods[] = {
    {"attachment", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_attachment, METH_NOARGS},
    {"internalTextureFormat", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_internalTextureFormat, METH_NOARGS},
    {"samples", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_samples, METH_NOARGS},
    {"setAttachment", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_setAttachment, METH_O},
    {"setInternalTextureFormat", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_setInternalTextureFormat, METH_O},
    {"setSamples", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_setSamples, METH_O},
    {"setTextureTarget", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_setTextureTarget, METH_O},
    {"textureTarget", (PyCFunction)SbkQGLFramebufferObjectFormatFunc_textureTarget, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQGLFramebufferObjectFormat_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QGLFramebufferObjectFormat& cpp_self = *Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QGLFramebufferObjectFormat & >::isConvertible(other)) {
                // operator!=(const QGLFramebufferObjectFormat & other) const
                QGLFramebufferObjectFormat* cpp_other = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QGLFramebufferObjectFormat  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQGLFramebufferObjectFormat_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QGLFramebufferObjectFormat & >::isConvertible(other)) {
                // operator==(const QGLFramebufferObjectFormat & other) const
                QGLFramebufferObjectFormat* cpp_other = Shiboken::Converter<QGLFramebufferObjectFormat* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QGLFramebufferObjectFormat  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQGLFramebufferObjectFormat_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQGLFramebufferObjectFormat_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGLFramebufferObjectFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtOpenGL.QGLFramebufferObjectFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQGLFramebufferObjectFormat_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGLFramebufferObjectFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGLFramebufferObjectFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGLFramebufferObjectFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGLFramebufferObjectFormat(PyObject* module)
{
    SbkPySide_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGLFramebufferObjectFormat_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQGLFramebufferObjectFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGLFramebufferObjectFormat_Type));
    PyModule_AddObject(module, "QGLFramebufferObjectFormat",
        ((PyObject*)&SbkQGLFramebufferObjectFormat_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QGLFramebufferObjectFormat >("QGLFramebufferObjectFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QGLFramebufferObjectFormat >(typeid(QGLFramebufferObjectFormat).name());
}


} // extern "C"

