/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qnetworkcookie_wrapper.h"

// Extra includes
#include <QDateTime>
#include <QList>
#include <qbytearray.h>
#include <qdatetime.h>
#include <qnetworkcookie.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQNetworkCookie_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkCookie* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QNetworkCookie", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QNetworkCookie(QByteArray,QByteArray)
        cptr = new QNetworkCookie();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QNetworkCookie & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QNetworkCookie* cpp_arg0 = Shiboken::Converter<QNetworkCookie* >::toCpp(pyargs[0]);
        // QNetworkCookie(QNetworkCookie)
        cptr = new QNetworkCookie(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // QNetworkCookie(QByteArray,QByteArray)
            cptr = new QNetworkCookie(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // QNetworkCookie(QByteArray,QByteArray)
            cptr = new QNetworkCookie(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQNetworkCookie_Init_TypeError;
    } else goto SbkQNetworkCookie_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QNetworkCookie >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkCookie_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQNetworkCookie_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray = QByteArray(), PySide.QtCore.QByteArray = QByteArray()", "PySide.QtNetwork.QNetworkCookie", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkCookie", overloads);
        return -1;
}

static PyObject* SbkQNetworkCookieFunc_domain(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // domain()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkCookie::domain();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_expirationDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expirationDate()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QNetworkCookie::expirationDate();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_isHttpOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isHttpOnly()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkCookie::isHttpOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_isSecure(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSecure()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkCookie::isSecure();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_isSessionCookie(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSessionCookie()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QNetworkCookie::isSessionCookie();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QNetworkCookie::name();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_parseCookies(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // parseCookies(QByteArray)
        QList<QNetworkCookie > cpp_result = QNetworkCookie::parseCookies(*cpp_arg0);
        py_result = Shiboken::Converter<QList<QNetworkCookie > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_parseCookies_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkCookieFunc_parseCookies_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.parseCookies", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_path(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // path()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QNetworkCookie::path();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkCookieFunc_setDomain(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDomain(QString)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setDomain(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setDomain_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setDomain_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setDomain", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_setExpirationDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // setExpirationDate(QDateTime)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setExpirationDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setExpirationDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setExpirationDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setExpirationDate", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_setHttpOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setHttpOnly(bool)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setHttpOnly(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setHttpOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setHttpOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setHttpOnly", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_setName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setName(QByteArray)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setName", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_setPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPath(QString)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setPath", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_setSecure(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSecure(bool)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setSecure(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setSecure_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setSecure_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setSecure", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_setValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setValue(QByteArray)
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        cppSelf->QNetworkCookie::setValue(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_setValue_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkCookieFunc_setValue_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.setValue", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_toRawForm(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // toRawForm(QNetworkCookie::RawForm)const
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QNetworkCookie::toRawForm();
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QNetworkCookie::RawForm >::isConvertible(arg)) {
        QNetworkCookie::RawForm cpp_arg0 = Shiboken::Converter<QNetworkCookie::RawForm >::toCpp(arg);
        // toRawForm(QNetworkCookie::RawForm)const
        QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QNetworkCookie::toRawForm(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkCookieFunc_toRawForm_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkCookieFunc_toRawForm_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkCookie.RawForm = Full", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkCookie.toRawForm", overloads);
        return 0;
}

static PyObject* SbkQNetworkCookieFunc_value(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // value()const
    QNetworkCookie* cppSelf = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QNetworkCookie::value();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQNetworkCookie_methods[] = {
    {"domain", (PyCFunction)SbkQNetworkCookieFunc_domain, METH_NOARGS},
    {"expirationDate", (PyCFunction)SbkQNetworkCookieFunc_expirationDate, METH_NOARGS},
    {"isHttpOnly", (PyCFunction)SbkQNetworkCookieFunc_isHttpOnly, METH_NOARGS},
    {"isSecure", (PyCFunction)SbkQNetworkCookieFunc_isSecure, METH_NOARGS},
    {"isSessionCookie", (PyCFunction)SbkQNetworkCookieFunc_isSessionCookie, METH_NOARGS},
    {"name", (PyCFunction)SbkQNetworkCookieFunc_name, METH_NOARGS},
    {"parseCookies", (PyCFunction)SbkQNetworkCookieFunc_parseCookies, METH_O|METH_STATIC},
    {"path", (PyCFunction)SbkQNetworkCookieFunc_path, METH_NOARGS},
    {"setDomain", (PyCFunction)SbkQNetworkCookieFunc_setDomain, METH_O},
    {"setExpirationDate", (PyCFunction)SbkQNetworkCookieFunc_setExpirationDate, METH_O},
    {"setHttpOnly", (PyCFunction)SbkQNetworkCookieFunc_setHttpOnly, METH_O},
    {"setName", (PyCFunction)SbkQNetworkCookieFunc_setName, METH_O},
    {"setPath", (PyCFunction)SbkQNetworkCookieFunc_setPath, METH_O},
    {"setSecure", (PyCFunction)SbkQNetworkCookieFunc_setSecure, METH_O},
    {"setValue", (PyCFunction)SbkQNetworkCookieFunc_setValue, METH_O},
    {"toRawForm", (PyCFunction)SbkQNetworkCookieFunc_toRawForm, METH_NOARGS|METH_O},
    {"value", (PyCFunction)SbkQNetworkCookieFunc_value, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQNetworkCookie_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QNetworkCookie& cpp_self = *Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QNetworkCookie & >::isConvertible(other)) {
                // operator!=(const QNetworkCookie & other) const
                QNetworkCookie* cpp_other = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QNetworkCookie  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQNetworkCookie_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QNetworkCookie & >::isConvertible(other)) {
                // operator==(const QNetworkCookie & other) const
                QNetworkCookie* cpp_other = Shiboken::Converter<QNetworkCookie* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QNetworkCookie  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQNetworkCookie_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQNetworkCookie_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkCookie_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkCookie",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQNetworkCookie_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkCookie_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkCookie_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QNetworkCookie >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtNetwork_QNetworkCookie_RawForm_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkCookie_RawForm_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RawForm",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkCookie_RawForm_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkCookie_RawForm_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkCookie_RawForm_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QNetworkCookie(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkCookie_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkCookie_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkCookie_Type));
    PyModule_AddObject(module, "QNetworkCookie",
        ((PyObject*)&SbkQNetworkCookie_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RawForm
    SbkPySide_QtNetworkTypes[SBK_QNETWORKCOOKIE_RAWFORM_IDX] = &SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type);
    PyDict_SetItemString(SbkQNetworkCookie_Type.super.ht_type.tp_dict,
            "RawForm",((PyObject*)&SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type,
        (long) QNetworkCookie::NameAndValueOnly, "NameAndValueOnly");
    PyDict_SetItemString(SbkQNetworkCookie_Type.super.ht_type.tp_dict,
        "NameAndValueOnly", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type.tp_dict,
        "NameAndValueOnly", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type,
        (long) QNetworkCookie::Full, "Full");
    PyDict_SetItemString(SbkQNetworkCookie_Type.super.ht_type.tp_dict,
        "Full", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkCookie_RawForm_Type.tp_dict,
        "Full", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkCookie::RawForm");

    Shiboken::TypeResolver::createValueTypeResolver<QNetworkCookie >("QNetworkCookie");
    Shiboken::TypeResolver::createValueTypeResolver<QNetworkCookie >(typeid(QNetworkCookie).name());
}


} // extern "C"

