/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtnetwork_python.h"

#include "qnetworkaccessmanager_wrapper.h"

// Extra includes
#include <QList>
#include <qauthenticator.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qiodevice.h>
#include <qnetworkcookiejar.h>
#include <qnetworkproxy.h>
#include <qnetworkreply.h>
#include <qnetworkrequest.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsslerror.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QNetworkAccessManagerWrapper::QNetworkAccessManagerWrapper(QObject * parent) : QNetworkAccessManager(parent), m_metaObject(0) {
    // ... middle
}

void QNetworkAccessManagerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkAccessManagerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QNetworkReply * QNetworkAccessManagerWrapper::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest & request, QIODevice * outgoingData)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createRequest"));
    if (py_override.isNull()) {
        return this->QNetworkAccessManager::createRequest(op, request, outgoingData);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSS)",
        Shiboken::Converter<QNetworkAccessManager::Operation >::toPython(op),
        Shiboken::Converter<QNetworkRequest & >::toPython(request),
        Shiboken::Converter<QIODevice * >::toPython(outgoingData)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QNetworkReply * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkAccessManager.createRequest", SbkType<QNetworkReply * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QNetworkReply * cpp_result(Shiboken::Converter<QNetworkReply * >::toCpp(py_result));
    return cpp_result;
}

void QNetworkAccessManagerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkAccessManagerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QNetworkAccessManagerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkAccessManager.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QNetworkAccessManagerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkAccessManager.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QNetworkAccessManagerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QNetworkAccessManagerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QNetworkAccessManager::staticMetaObject);
}
    return m_metaObject;
}

int QNetworkAccessManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QNetworkAccessManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QNetworkAccessManagerWrapper::~QNetworkAccessManagerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQNetworkAccessManager_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkAccessManagerWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QNetworkAccessManager", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QNetworkAccessManager(QObject*)
        cptr = new QNetworkAccessManagerWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QNetworkAccessManager(QObject*)
        cptr = new QNetworkAccessManagerWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQNetworkAccessManager_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QNetworkAccessManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkAccessManager_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQNetworkAccessManager_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkAccessManager", overloads);
        return -1;
}

static PyObject* SbkQNetworkAccessManagerFunc_cookieJar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cookieJar()const
    QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
    QNetworkCookieJar * cpp_result = cppSelf->QNetworkAccessManager::cookieJar();
    py_result = Shiboken::Converter<QNetworkCookieJar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkAccessManagerFunc_createRequest(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "createRequest", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QNetworkAccessManager::Operation >::isConvertible(pyargs[0]) && Shiboken::Converter<QNetworkRequest & >::isConvertible(pyargs[1])) {
        QNetworkAccessManager::Operation cpp_arg0 = Shiboken::Converter<QNetworkAccessManager::Operation >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QNetworkRequest* cpp_arg1 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
            QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
            QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::createRequest(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QIODevice* cpp_arg2 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[2]);
            // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
            QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
            QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::createRequest(cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkQNetworkAccessManagerFunc_createRequest_TypeError;
    } else goto SbkQNetworkAccessManagerFunc_createRequest_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkAccessManagerFunc_createRequest_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkAccessManager.Operation, PySide.QtNetwork.QNetworkRequest, PySide.QtCore.QIODevice = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkAccessManager.createRequest", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_deleteResource(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QNetworkRequest & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(arg);
        // deleteResource(QNetworkRequest)
        QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
        QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::deleteResource(*cpp_arg0);
        py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQNetworkAccessManagerFunc_deleteResource_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkAccessManagerFunc_deleteResource_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAccessManager.deleteResource", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_get(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QNetworkRequest & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(arg);
        // get(QNetworkRequest)
        QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
        QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::get(*cpp_arg0);
        py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQNetworkAccessManagerFunc_get_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkAccessManagerFunc_get_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAccessManager.get", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_head(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QNetworkRequest & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(arg);
        // head(QNetworkRequest)
        QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
        QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::head(*cpp_arg0);
        py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQNetworkAccessManagerFunc_head_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkAccessManagerFunc_head_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAccessManager.head", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_post(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "post", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QNetworkRequest & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // post(QNetworkRequest,QByteArray)
            QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
            QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::post(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (numArgs == 2 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            // post(QNetworkRequest,QIODevice*)
            QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
            QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::post(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkQNetworkAccessManagerFunc_post_TypeError;
    } else goto SbkQNetworkAccessManagerFunc_post_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkAccessManagerFunc_post_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest, PySide.QtCore.QIODevice", "PySide.QtNetwork.QNetworkRequest, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkAccessManager.post", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_proxy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // proxy()const
    QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
    QNetworkProxy cpp_result = cppSelf->QNetworkAccessManager::proxy();
    py_result = Shiboken::Converter<QNetworkProxy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkAccessManagerFunc_put(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "put", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QNetworkRequest & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QNetworkRequest* cpp_arg0 = Shiboken::Converter<QNetworkRequest* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // put(QNetworkRequest,QByteArray)
            QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
            QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::put(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (numArgs == 2 && Shiboken::Converter<QIODevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QIODevice* cpp_arg1 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[1]);
            // put(QNetworkRequest,QIODevice*)
            QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
            QNetworkReply * cpp_result = cppSelf->QNetworkAccessManager::put(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QNetworkReply * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkQNetworkAccessManagerFunc_put_TypeError;
    } else goto SbkQNetworkAccessManagerFunc_put_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQNetworkAccessManagerFunc_put_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkRequest, PySide.QtCore.QIODevice", "PySide.QtNetwork.QNetworkRequest, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkAccessManager.put", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_setCookieJar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkCookieJar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QNetworkCookieJar* cpp_arg0 = Shiboken::Converter<QNetworkCookieJar* >::toCpp(arg);
        // setCookieJar(QNetworkCookieJar*)
        QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
        cppSelf->QNetworkAccessManager::setCookieJar(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAccessManagerFunc_setCookieJar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkAccessManagerFunc_setCookieJar_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkCookieJar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAccessManager.setCookieJar", overloads);
        return 0;
}

static PyObject* SbkQNetworkAccessManagerFunc_setProxy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QNetworkProxy & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QNetworkProxy > cpp_arg0_auto_ptr;
        QNetworkProxy* cpp_arg0 = Shiboken::Converter<QNetworkProxy* >::toCpp(arg);
        if (!SbkQNetworkProxy_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QNetworkProxy >(cpp_arg0);
        // setProxy(QNetworkProxy)
        QNetworkAccessManager* cppSelf = Shiboken::Converter<QNetworkAccessManager* >::toCpp((PyObject*)self);
        cppSelf->QNetworkAccessManager::setProxy(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAccessManagerFunc_setProxy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkAccessManagerFunc_setProxy_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QNetworkProxy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAccessManager.setProxy", overloads);
        return 0;
}

static PyMethodDef SbkQNetworkAccessManager_methods[] = {
    {"cookieJar", (PyCFunction)SbkQNetworkAccessManagerFunc_cookieJar, METH_NOARGS},
    {"createRequest", (PyCFunction)SbkQNetworkAccessManagerFunc_createRequest, METH_VARARGS},
    {"deleteResource", (PyCFunction)SbkQNetworkAccessManagerFunc_deleteResource, METH_O},
    {"get", (PyCFunction)SbkQNetworkAccessManagerFunc_get, METH_O},
    {"head", (PyCFunction)SbkQNetworkAccessManagerFunc_head, METH_O},
    {"post", (PyCFunction)SbkQNetworkAccessManagerFunc_post, METH_VARARGS},
    {"proxy", (PyCFunction)SbkQNetworkAccessManagerFunc_proxy, METH_NOARGS},
    {"put", (PyCFunction)SbkQNetworkAccessManagerFunc_put, METH_VARARGS},
    {"setCookieJar", (PyCFunction)SbkQNetworkAccessManagerFunc_setCookieJar, METH_O},
    {"setProxy", (PyCFunction)SbkQNetworkAccessManagerFunc_setProxy, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkAccessManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkAccessManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkAccessManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkAccessManager_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QNetworkAccessManager >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtNetwork_QNetworkAccessManager_Operation_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QNetworkAccessManager_Operation_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Operation",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QNetworkAccessManager_Operation_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QNetworkAccessManager_Operation_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QNetworkAccessManager_Operation_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QNetworkAccessManager(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkAccessManager_Type);

    SbkQNetworkAccessManager_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQNetworkAccessManager_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkAccessManager_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkAccessManager_Type));
    PyModule_AddObject(module, "QNetworkAccessManager",
        ((PyObject*)&SbkQNetworkAccessManager_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Operation
    SbkPySide_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX] = &SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type);
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
            "Operation",((PyObject*)&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type,
        (long) QNetworkAccessManager::HeadOperation, "HeadOperation");
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
        "HeadOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type.tp_dict,
        "HeadOperation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type,
        (long) QNetworkAccessManager::GetOperation, "GetOperation");
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
        "GetOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type.tp_dict,
        "GetOperation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type,
        (long) QNetworkAccessManager::PutOperation, "PutOperation");
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
        "PutOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type.tp_dict,
        "PutOperation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type,
        (long) QNetworkAccessManager::PostOperation, "PostOperation");
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
        "PostOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type.tp_dict,
        "PostOperation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type,
        (long) QNetworkAccessManager::DeleteOperation, "DeleteOperation");
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
        "DeleteOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type.tp_dict,
        "DeleteOperation", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type,
        (long) QNetworkAccessManager::UnknownOperation, "UnknownOperation");
    PyDict_SetItemString(SbkQNetworkAccessManager_Type.super.ht_type.tp_dict,
        "UnknownOperation", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QNetworkAccessManager_Operation_Type.tp_dict,
        "UnknownOperation", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QNetworkAccessManager::Operation");

    Shiboken::TypeResolver::createObjectTypeResolver<QNetworkAccessManager >("QNetworkAccessManager*");
    Shiboken::TypeResolver::createObjectTypeResolver<QNetworkAccessManager >(typeid(QNetworkAccessManager).name());
}


} // extern "C"

