/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtmaemo5_python.h"

#include "qmaemo5datepickselector_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qmaemo5datepickselector.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMaemo5DatePickSelectorWrapper::QMaemo5DatePickSelectorWrapper(QObject * parent) : QMaemo5DatePickSelector(parent), m_metaObject(0) {
    // ... middle
}

void QMaemo5DatePickSelectorWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMaemo5DatePickSelectorWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QMaemo5DatePickSelectorWrapper::currentValueText() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "currentValueText"));
    if (py_override.isNull()) {
        return this->QMaemo5DatePickSelector::currentValueText();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMaemo5DatePickSelector.currentValueText", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

void QMaemo5DatePickSelectorWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QMaemo5DatePickSelectorWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QMaemo5DatePickSelectorWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMaemo5DatePickSelector.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QMaemo5DatePickSelectorWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMaemo5DatePickSelector.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QMaemo5DatePickSelectorWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QWidget * QMaemo5DatePickSelectorWrapper::widget(QWidget * parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widget"));
    if (py_override.isNull()) {
        return this->QMaemo5DatePickSelector::widget(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QMaemo5DatePickSelector.widget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QMaemo5DatePickSelectorWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QMaemo5DatePickSelector::staticMetaObject);
}
    return m_metaObject;
}

int QMaemo5DatePickSelectorWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QMaemo5DatePickSelector::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QMaemo5DatePickSelectorWrapper::~QMaemo5DatePickSelectorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQMaemo5DatePickSelector_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMaemo5DatePickSelectorWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QMaemo5DatePickSelector", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QMaemo5DatePickSelector(QObject*)
        cptr = new QMaemo5DatePickSelectorWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QMaemo5DatePickSelector(QObject*)
        cptr = new QMaemo5DatePickSelectorWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQMaemo5DatePickSelector_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMaemo5DatePickSelector >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMaemo5DatePickSelector_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMaemo5DatePickSelector_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMaemo5.QMaemo5DatePickSelector", overloads);
        return -1;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_currentDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentDate()const
    QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QMaemo5DatePickSelector::currentDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_currentValueText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentValueText()const
    QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QMaemo5DatePickSelector::currentValueText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_maximumYear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumYear()const
    QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMaemo5DatePickSelector::maximumYear();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_minimumYear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumYear()const
    QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMaemo5DatePickSelector::minimumYear();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_setCurrentDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setCurrentDate(QDate)
        QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
        cppSelf->QMaemo5DatePickSelector::setCurrentDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMaemo5DatePickSelectorFunc_setCurrentDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMaemo5DatePickSelectorFunc_setCurrentDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMaemo5.QMaemo5DatePickSelector.setCurrentDate", overloads);
        return 0;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_setMaximumYear(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaximumYear(int)
        QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
        cppSelf->QMaemo5DatePickSelector::setMaximumYear(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMaemo5DatePickSelectorFunc_setMaximumYear_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMaemo5DatePickSelectorFunc_setMaximumYear_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMaemo5.QMaemo5DatePickSelector.setMaximumYear", overloads);
        return 0;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_setMinimumYear(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMinimumYear(int)
        QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
        cppSelf->QMaemo5DatePickSelector::setMinimumYear(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMaemo5DatePickSelectorFunc_setMinimumYear_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQMaemo5DatePickSelectorFunc_setMinimumYear_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMaemo5.QMaemo5DatePickSelector.setMinimumYear", overloads);
        return 0;
}

static PyObject* SbkQMaemo5DatePickSelectorFunc_widget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // widget(QWidget*)
        QMaemo5DatePickSelector* cppSelf = Shiboken::Converter<QMaemo5DatePickSelector* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QMaemo5DatePickSelector::widget(cpp_arg0);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQMaemo5DatePickSelectorFunc_widget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQMaemo5DatePickSelectorFunc_widget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMaemo5.QMaemo5DatePickSelector.widget", overloads);
        return 0;
}

static PyMethodDef SbkQMaemo5DatePickSelector_methods[] = {
    {"currentDate", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_currentDate, METH_NOARGS},
    {"currentValueText", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_currentValueText, METH_NOARGS},
    {"maximumYear", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_maximumYear, METH_NOARGS},
    {"minimumYear", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_minimumYear, METH_NOARGS},
    {"setCurrentDate", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_setCurrentDate, METH_O},
    {"setMaximumYear", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_setMaximumYear, METH_O},
    {"setMinimumYear", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_setMinimumYear, METH_O},
    {"widget", (PyCFunction)SbkQMaemo5DatePickSelectorFunc_widget, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMaemo5DatePickSelector_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMaemo5.QMaemo5DatePickSelector",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMaemo5DatePickSelector_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMaemo5DatePickSelector_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMaemo5DatePickSelector >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QMaemo5DatePickSelector(PyObject* module)
{
    SbkPySide_QtMaemo5Types[SBK_QMAEMO5DATEPICKSELECTOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMaemo5DatePickSelector_Type);

    SbkQMaemo5DatePickSelector_Type.super.ht_type.tp_base = SbkPySide_QtMaemo5Types[SBK_QMAEMO5ABSTRACTPICKSELECTOR_IDX];
    // Fill type discovery information
    SbkQMaemo5DatePickSelector_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQMaemo5DatePickSelector_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMaemo5DatePickSelector_Type));
    PyModule_AddObject(module, "QMaemo5DatePickSelector",
        ((PyObject*)&SbkQMaemo5DatePickSelector_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMaemo5DatePickSelector >("QMaemo5DatePickSelector*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMaemo5DatePickSelector >(typeid(QMaemo5DatePickSelector).name());
}


} // extern "C"

