/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtilerules_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQTileRules_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTileRules* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTileRules", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QTileRules(Qt::TileRule)
        cptr = new QTileRules();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Qt::TileRule >::isConvertible(pyargs[0])) {
        Qt::TileRule cpp_arg0 = Shiboken::Converter<Qt::TileRule >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QTileRules(Qt::TileRule)
            cptr = new QTileRules(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<Qt::TileRule >::isConvertible(pyargs[1])) {
            Qt::TileRule cpp_arg1 = Shiboken::Converter<Qt::TileRule >::toCpp(pyargs[1]);
            // QTileRules(Qt::TileRule,Qt::TileRule)
            cptr = new QTileRules(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTileRules_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QTileRules & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QTileRules > cpp_arg0_auto_ptr;
        QTileRules* cpp_arg0 = Shiboken::Converter<QTileRules* >::toCpp(pyargs[0]);
        if (!SbkQTileRules_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QTileRules >(cpp_arg0);
        // QTileRules(QTileRules)
        cptr = new QTileRules(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTileRules_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTileRules >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTileRules_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTileRules_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTileRules", "PySide.QtCore.Qt.TileRule, PySide.QtCore.Qt.TileRule", "PySide.QtCore.Qt.TileRule = Qt.StretchTile", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTileRules", overloads);
        return -1;
}

static PyMethodDef SbkQTileRules_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQTileRules_get_vertical(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::TileRule >::toPython(Shiboken::Converter<QTileRules* >::toCpp((PyObject*)self)->vertical);
}
static int SbkQTileRules_set_vertical(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'vertical' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::TileRule >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'vertical', 'TileRule' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTileRules* >::toCpp((PyObject*)self)->vertical = Shiboken::Converter<Qt::TileRule >::toCpp(value);

    return 0;
}

static PyObject* SbkQTileRules_get_horizontal(SbkBaseWrapper* self)
{
    return Shiboken::Converter<Qt::TileRule >::toPython(Shiboken::Converter<QTileRules* >::toCpp((PyObject*)self)->horizontal);
}
static int SbkQTileRules_set_horizontal(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'horizontal' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<Qt::TileRule >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'horizontal', 'TileRule' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTileRules* >::toCpp((PyObject*)self)->horizontal = Shiboken::Converter<Qt::TileRule >::toCpp(value);

    return 0;
}

// Getters and Setters for QTileRules
static PyGetSetDef SbkQTileRules_getsetlist[] = {
    {const_cast<char*>("vertical"), (getter)SbkQTileRules_get_vertical, (setter)SbkQTileRules_set_vertical},
    {const_cast<char*>("horizontal"), (getter)SbkQTileRules_get_horizontal, (setter)SbkQTileRules_set_horizontal},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTileRules_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTileRules",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTileRules_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTileRules_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTileRules_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTileRules >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTileRules(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTILERULES_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTileRules_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTileRules_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTileRules_Type));
    PyModule_AddObject(module, "QTileRules",
        ((PyObject*)&SbkQTileRules_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTileRules >("QTileRules");
    Shiboken::TypeResolver::createValueTypeResolver<QTileRules >(typeid(QTileRules).name());
}


} // extern "C"

