/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextline_wrapper.h"

// Extra includes
#include <QTextLayout>
#include <qpainter.h>
#include <qpoint.h>
#include <qrect.h>

using namespace Shiboken;

static int
SbkQTextLine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextLine* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextLine", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextLine()
        cptr = new QTextLine();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextLine & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextLine* cpp_arg0 = Shiboken::Converter<QTextLine* >::toCpp(pyargs[0]);
        // QTextLine(QTextLine)
        cptr = new QTextLine(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextLine_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextLine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextLine_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextLine_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextLine", "", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLine", overloads);
        return -1;
}

static PyObject* SbkQTextLineFunc_ascent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ascent()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::ascent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_cursorToX(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cursorToX", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // cursorToX(int,QTextLine::Edge)const
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            qreal cpp_result = cppSelf->QTextLine::cursorToX(cpp_arg0);
            py_result = Shiboken::Converter<double >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QTextLine::Edge >::isConvertible(pyargs[1])) {
            QTextLine::Edge cpp_arg1 = Shiboken::Converter<QTextLine::Edge >::toCpp(pyargs[1]);
            // cursorToX(int,QTextLine::Edge)const
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            qreal cpp_result = cppSelf->QTextLine::cursorToX(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<double >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTextLineFunc_cursorToX_TypeError;
    } else goto SbkQTextLineFunc_cursorToX_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextLineFunc_cursorToX_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTextLine.Edge = Leading", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLine.cursorToX", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_descent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // descent()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::descent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_draw(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "draw", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPainter * >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        if (numArgs == 2) {
            // draw(QPainter*,QPointF,const QTextLayout::FormatRange*)const
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            cppSelf->QTextLine::draw(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QTextLayout::FormatRange * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QTextLayout::FormatRange* cpp_arg2 = Shiboken::Converter<QTextLayout::FormatRange* >::toCpp(pyargs[2]);
            // draw(QPainter*,QPointF,const QTextLayout::FormatRange*)const
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            cppSelf->QTextLine::draw(cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTextLineFunc_draw_TypeError;
    } else goto SbkQTextLineFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLineFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter, PySide.QtCore.QPointF, PySide.QtGui.QTextLayout::FormatRange = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLine.draw", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextLine::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_leading(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leading()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::leading();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_leadingIncluded(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // leadingIncluded()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextLine::leadingIncluded();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_lineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineNumber()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextLine::lineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_naturalTextRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // naturalTextRect()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QTextLine::naturalTextRect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_naturalTextWidth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // naturalTextWidth()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::naturalTextWidth();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QTextLine::position();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_rect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rect()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QTextLine::rect();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_setLeadingIncluded(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setLeadingIncluded(bool)
        QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
        cppSelf->QTextLine::setLeadingIncluded(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextLineFunc_setLeadingIncluded_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLineFunc_setLeadingIncluded_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLine.setLeadingIncluded", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_setLineWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLineWidth(qreal)
        QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
        cppSelf->QTextLine::setLineWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextLineFunc_setLineWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLineFunc_setLineWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLine.setLineWidth", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_setNumColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setNumColumns", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setNumColumns(int)
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            cppSelf->QTextLine::setNumColumns(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
            // setNumColumns(int,qreal)
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            cppSelf->QTextLine::setNumColumns(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTextLineFunc_setNumColumns_TypeError;
    } else goto SbkQTextLineFunc_setNumColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLineFunc_setNumColumns_TypeError:
        const char* overloads[] = {"int", "int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLine.setNumColumns", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_setPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setPosition(QPointF)
        QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
        cppSelf->QTextLine::setPosition(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextLineFunc_setPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextLineFunc_setPosition_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextLine.setPosition", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_textLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textLength()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextLine::textLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_textStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textStart()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextLine::textStart();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::x();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextLineFunc_xToCursor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "xToCursor", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // xToCursor(qreal,QTextLine::CursorPosition)const
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTextLine::xToCursor(cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QTextLine::CursorPosition >::isConvertible(pyargs[1])) {
            QTextLine::CursorPosition cpp_arg1 = Shiboken::Converter<QTextLine::CursorPosition >::toCpp(pyargs[1]);
            // xToCursor(qreal,QTextLine::CursorPosition)const
            QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTextLine::xToCursor(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTextLineFunc_xToCursor_TypeError;
    } else goto SbkQTextLineFunc_xToCursor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTextLineFunc_xToCursor_TypeError:
        const char* overloads[] = {"float, PySide.QtGui.QTextLine.CursorPosition = CursorBetweenCharacters", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextLine.xToCursor", overloads);
        return 0;
}

static PyObject* SbkQTextLineFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QTextLine* cppSelf = Shiboken::Converter<QTextLine* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextLine::y();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextLine_methods[] = {
    {"ascent", (PyCFunction)SbkQTextLineFunc_ascent, METH_NOARGS},
    {"cursorToX", (PyCFunction)SbkQTextLineFunc_cursorToX, METH_VARARGS},
    {"descent", (PyCFunction)SbkQTextLineFunc_descent, METH_NOARGS},
    {"draw", (PyCFunction)SbkQTextLineFunc_draw, METH_VARARGS},
    {"height", (PyCFunction)SbkQTextLineFunc_height, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextLineFunc_isValid, METH_NOARGS},
    {"leading", (PyCFunction)SbkQTextLineFunc_leading, METH_NOARGS},
    {"leadingIncluded", (PyCFunction)SbkQTextLineFunc_leadingIncluded, METH_NOARGS},
    {"lineNumber", (PyCFunction)SbkQTextLineFunc_lineNumber, METH_NOARGS},
    {"naturalTextRect", (PyCFunction)SbkQTextLineFunc_naturalTextRect, METH_NOARGS},
    {"naturalTextWidth", (PyCFunction)SbkQTextLineFunc_naturalTextWidth, METH_NOARGS},
    {"position", (PyCFunction)SbkQTextLineFunc_position, METH_NOARGS},
    {"rect", (PyCFunction)SbkQTextLineFunc_rect, METH_NOARGS},
    {"setLeadingIncluded", (PyCFunction)SbkQTextLineFunc_setLeadingIncluded, METH_O},
    {"setLineWidth", (PyCFunction)SbkQTextLineFunc_setLineWidth, METH_O},
    {"setNumColumns", (PyCFunction)SbkQTextLineFunc_setNumColumns, METH_VARARGS},
    {"setPosition", (PyCFunction)SbkQTextLineFunc_setPosition, METH_O},
    {"textLength", (PyCFunction)SbkQTextLineFunc_textLength, METH_NOARGS},
    {"textStart", (PyCFunction)SbkQTextLineFunc_textStart, METH_NOARGS},
    {"width", (PyCFunction)SbkQTextLineFunc_width, METH_NOARGS},
    {"x", (PyCFunction)SbkQTextLineFunc_x, METH_NOARGS},
    {"xToCursor", (PyCFunction)SbkQTextLineFunc_xToCursor, METH_VARARGS},
    {"y", (PyCFunction)SbkQTextLineFunc_y, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextLine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextLine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextLine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextLine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextLine >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTextLine_Edge_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextLine_Edge_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextLine_Edge_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Edge",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextLine_Edge_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextLine_Edge_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextLine_Edge_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTextLine_CursorPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextLine_CursorPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextLine_CursorPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CursorPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextLine_CursorPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextLine_CursorPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextLine_CursorPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTextLine(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTLINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextLine_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextLine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextLine_Type));
    PyModule_AddObject(module, "QTextLine",
        ((PyObject*)&SbkQTextLine_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Edge
    SbkPySide_QtGuiTypes[SBK_QTEXTLINE_EDGE_IDX] = &SbkPySide_QtGui_QTextLine_Edge_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextLine_Edge_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextLine_Edge_Type);
    PyDict_SetItemString(SbkQTextLine_Type.super.ht_type.tp_dict,
            "Edge",((PyObject*)&SbkPySide_QtGui_QTextLine_Edge_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextLine_Edge_Type,
        (long) QTextLine::Leading, "Leading");
    PyDict_SetItemString(SbkQTextLine_Type.super.ht_type.tp_dict,
        "Leading", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextLine_Edge_Type.tp_dict,
        "Leading", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextLine_Edge_Type,
        (long) QTextLine::Trailing, "Trailing");
    PyDict_SetItemString(SbkQTextLine_Type.super.ht_type.tp_dict,
        "Trailing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextLine_Edge_Type.tp_dict,
        "Trailing", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextLine::Edge");

    // init enum class: CursorPosition
    SbkPySide_QtGuiTypes[SBK_QTEXTLINE_CURSORPOSITION_IDX] = &SbkPySide_QtGui_QTextLine_CursorPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextLine_CursorPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextLine_CursorPosition_Type);
    PyDict_SetItemString(SbkQTextLine_Type.super.ht_type.tp_dict,
            "CursorPosition",((PyObject*)&SbkPySide_QtGui_QTextLine_CursorPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextLine_CursorPosition_Type,
        (long) QTextLine::CursorBetweenCharacters, "CursorBetweenCharacters");
    PyDict_SetItemString(SbkQTextLine_Type.super.ht_type.tp_dict,
        "CursorBetweenCharacters", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextLine_CursorPosition_Type.tp_dict,
        "CursorBetweenCharacters", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextLine_CursorPosition_Type,
        (long) QTextLine::CursorOnCharacter, "CursorOnCharacter");
    PyDict_SetItemString(SbkQTextLine_Type.super.ht_type.tp_dict,
        "CursorOnCharacter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextLine_CursorPosition_Type.tp_dict,
        "CursorOnCharacter", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextLine::CursorPosition");

    Shiboken::TypeResolver::createValueTypeResolver<QTextLine >("QTextLine");
    Shiboken::TypeResolver::createValueTypeResolver<QTextLine >(typeid(QTextLine).name());
}


} // extern "C"

