/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextlayout_formatrange_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQTextLayout_FormatRange_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextLayout::FormatRange* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "FormatRange", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // FormatRange()
        cptr = new QTextLayout::FormatRange();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextLayout::FormatRange & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextLayout::FormatRange* cpp_arg0 = Shiboken::Converter<QTextLayout::FormatRange* >::toCpp(pyargs[0]);
        // FormatRange(QTextLayout::FormatRange)
        cptr = new QTextLayout::FormatRange(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextLayout_FormatRange_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextLayout::FormatRange >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextLayout_FormatRange_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextLayout_FormatRange_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QTextLayout::FormatRange", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.FormatRange", overloads);
        return -1;
}

static PyMethodDef SbkQTextLayout_FormatRange_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQTextLayout_FormatRange_get_format(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QTextCharFormat >::toPython(Shiboken::Converter<QTextLayout::FormatRange* >::toCpp((PyObject*)self)->format);
}
static int SbkQTextLayout_FormatRange_set_format(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'format' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QTextCharFormat >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'format', 'QTextCharFormat' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextLayout::FormatRange* >::toCpp((PyObject*)self)->format = Shiboken::Converter<QTextCharFormat >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextLayout_FormatRange_get_length(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTextLayout::FormatRange* >::toCpp((PyObject*)self)->length);
}
static int SbkQTextLayout_FormatRange_set_length(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'length' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'length', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextLayout::FormatRange* >::toCpp((PyObject*)self)->length = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQTextLayout_FormatRange_get_start(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QTextLayout::FormatRange* >::toCpp((PyObject*)self)->start);
}
static int SbkQTextLayout_FormatRange_set_start(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'start' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'start', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QTextLayout::FormatRange* >::toCpp((PyObject*)self)->start = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

// Getters and Setters for FormatRange
static PyGetSetDef SbkQTextLayout_FormatRange_getsetlist[] = {
    {const_cast<char*>("format"), (getter)SbkQTextLayout_FormatRange_get_format, (setter)SbkQTextLayout_FormatRange_set_format},
    {const_cast<char*>("length"), (getter)SbkQTextLayout_FormatRange_get_length, (setter)SbkQTextLayout_FormatRange_set_length},
    {const_cast<char*>("start"), (getter)SbkQTextLayout_FormatRange_get_start, (setter)SbkQTextLayout_FormatRange_set_start},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextLayout_FormatRange_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.FormatRange",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextLayout_FormatRange_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQTextLayout_FormatRange_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextLayout_FormatRange_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextLayout::FormatRange >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextLayout_FormatRange(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextLayout_FormatRange_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextLayout_FormatRange_Type) < 0)
        return;

    PyDict_SetItemString(module,"FormatRange", (PyObject*)&SbkQTextLayout_FormatRange_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QTextLayout::FormatRange >("QTextLayout::FormatRange");
    Shiboken::TypeResolver::createValueTypeResolver<QTextLayout::FormatRange >(typeid(QTextLayout::FormatRange).name());
}


} // extern "C"

