/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qtabwidget_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qtabbar.h>
#include <qtabwidget.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTabWidgetWrapper::QTabWidgetWrapper(QWidget * parent) : QTabWidget(parent), m_metaObject(0) {
    // ... middle
}

void QTabWidgetWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QTabWidget::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTabWidgetWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTabWidgetWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QTabWidget::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTabWidgetWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTabWidgetWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTabWidgetWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QTabWidgetWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QTabWidget::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTabWidgetWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QTabWidgetWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QTabWidget::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QTabWidgetWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QTabWidget::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QTabWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QTabWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QTabWidgetWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QTabWidget::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabWidget.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTabWidgetWrapper::tabInserted(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabInserted"));
    if (py_override.isNull()) {
        return this->QTabWidget::tabInserted(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::tabRemoved(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabRemoved"));
    if (py_override.isNull()) {
        return this->QTabWidget::tabRemoved(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabWidgetWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabWidgetWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QTabWidgetWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTabWidget::staticMetaObject);
}
    return m_metaObject;
}

int QTabWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTabWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTabWidgetWrapper::~QTabWidgetWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTabWidget_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTabWidgetWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTabWidget", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTabWidget(QWidget*)
        cptr = new QTabWidgetWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QTabWidget(QWidget*)
        cptr = new QTabWidgetWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTabWidget_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTabWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTabWidget_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTabWidget_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget", overloads);
        return -1;
}

static PyObject* SbkQTabWidgetFunc_addTab(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addTab", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // addTab(QWidget*,QString)
            QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTabWidget::addTab(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else if (numArgs == 3 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
            QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
            if (!SbkQIcon_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // addTab(QWidget*,QIcon,QString)
            QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTabWidget::addTab(cpp_arg0, *cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQTabWidgetFunc_addTab_TypeError;
    } else goto SbkQTabWidgetFunc_addTab_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_addTab_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtGui.QIcon, PySide.QtCore.QString", "PySide.QtGui.QWidget, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.addTab", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    // Begin code injection
    
    for (int i=0; i < cppSelf->count(); i++)
        Shiboken::setParent(0, Shiboken::Converter<QWidget* >::toPython(cppSelf->widget(i)));
    cppSelf->clear();
    
    // End of code injection


    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTabWidgetFunc_cornerWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // cornerWidget(Qt::Corner)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QTabWidget::cornerWidget();
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else if (Shiboken::Converter<Qt::Corner >::isConvertible(arg)) {
        Qt::Corner cpp_arg0 = Shiboken::Converter<Qt::Corner >::toCpp(arg);
        // cornerWidget(Qt::Corner)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QTabWidget::cornerWidget(cpp_arg0);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTabWidgetFunc_cornerWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_cornerWidget_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Corner = Qt.TopRightCorner", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.cornerWidget", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabWidget::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabWidget::currentIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_currentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentWidget()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QTabWidget::currentWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_documentMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentMode()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabWidget::documentMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_elideMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // elideMode()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    Qt::TextElideMode cpp_result = cppSelf->QTabWidget::elideMode();
    py_result = Shiboken::Converter<Qt::TextElideMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTabWidget::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.event", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_iconSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconSize()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTabWidget::iconSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_indexOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // indexOf(QWidget*)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTabWidget::indexOf(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.indexOf", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_insertTab(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertTab", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // insertTab(int,QWidget*,QString)
            QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTabWidget::insertTab(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 4 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[2]) && Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QIcon > cpp_arg2_auto_ptr;
            QIcon* cpp_arg2 = Shiboken::Converter<QIcon* >::toCpp(pyargs[2]);
            if (!SbkQIcon_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QIcon >(cpp_arg2);
            if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                return 0;
            std::auto_ptr<QString > cpp_arg3_auto_ptr;
            QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
            if (!SbkQString_Check(pyargs[3]))
                cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
            // insertTab(int,QWidget*,QIcon,QString)
            QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTabWidget::insertTab(cpp_arg0, cpp_arg1, *cpp_arg2, *cpp_arg3);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQTabWidgetFunc_insertTab_TypeError;
    } else goto SbkQTabWidgetFunc_insertTab_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_insertTab_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QWidget, PySide.QtGui.QIcon, PySide.QtCore.QString", "int, PySide.QtGui.QWidget, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.insertTab", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_isMovable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMovable()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabWidget::isMovable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_isTabEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isTabEnabled(int)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTabWidget::isTabEnabled(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_isTabEnabled_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_isTabEnabled_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.isTabEnabled", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTabWidget::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_removeTab(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeTab(int)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        // Begin code injection
        
        QWidget* tab = cppSelf->widget(cpp_arg0);
        if (tab) {
            Shiboken::setParent(0, Shiboken::Converter<QWidget* >::toPython(tab));
            cppSelf->removeTab(cpp_arg0);
        }
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_removeTab_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_removeTab_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.removeTab", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setCornerWidget(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setCornerWidget", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setCornerWidget(QWidget*,Qt::Corner)
            QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
            cppSelf->QTabWidget::setCornerWidget(cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else if (Shiboken::Converter<Qt::Corner >::isConvertible(pyargs[1])) {
            Qt::Corner cpp_arg1 = Shiboken::Converter<Qt::Corner >::toCpp(pyargs[1]);
            // setCornerWidget(QWidget*,Qt::Corner)
            QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
            cppSelf->QTabWidget::setCornerWidget(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQTabWidgetFunc_setCornerWidget_TypeError;
    } else goto SbkQTabWidgetFunc_setCornerWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setCornerWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, PySide.QtCore.Qt.Corner = Qt.TopRightCorner", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.setCornerWidget", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setCurrentIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentIndex(int)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setCurrentIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setCurrentIndex", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setCurrentWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // setCurrentWidget(QWidget*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setCurrentWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setCurrentWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setCurrentWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setCurrentWidget", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setDocumentMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDocumentMode(bool)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setDocumentMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setDocumentMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setDocumentMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setDocumentMode", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setElideMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TextElideMode >::isConvertible(arg)) {
        Qt::TextElideMode cpp_arg0 = Shiboken::Converter<Qt::TextElideMode >::toCpp(arg);
        // setElideMode(Qt::TextElideMode)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setElideMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setElideMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setElideMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextElideMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setElideMode", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setIconSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setIconSize(QSize)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setIconSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setIconSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setIconSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setIconSize", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setMovable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setMovable(bool)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setMovable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setMovable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setMovable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setMovable", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabBar(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabBar * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTabBar* cpp_arg0 = Shiboken::Converter<QTabBar* >::toCpp(arg);
        // setTabBar(QTabBar*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabBar(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQTabWidgetFunc_setTabBar_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabBar_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabBar", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setTabBar", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabEnabled(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabEnabled", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setTabEnabled(int,bool)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabEnabled(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabEnabled_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.setTabEnabled", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabIcon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabIcon", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QIcon & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
        QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
        if (!SbkQIcon_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
        // setTabIcon(int,QIcon)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabIcon(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabIcon_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.setTabIcon", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabWidget::TabPosition >::isConvertible(arg)) {
        QTabWidget::TabPosition cpp_arg0 = Shiboken::Converter<QTabWidget::TabPosition >::toCpp(arg);
        // setTabPosition(QTabWidget::TabPosition)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabPosition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabPosition_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabWidget.TabPosition", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setTabPosition", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabShape(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabWidget::TabShape >::isConvertible(arg)) {
        QTabWidget::TabShape cpp_arg0 = Shiboken::Converter<QTabWidget::TabShape >::toCpp(arg);
        // setTabShape(QTabWidget::TabShape)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabShape(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabShape_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabShape_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabWidget.TabShape", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setTabShape", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setTabText(int,QString)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabText(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabText_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.setTabText", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabToolTip(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabToolTip", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setTabToolTip(int,QString)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabToolTip(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabToolTip_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.setTabToolTip", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabWhatsThis(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabWhatsThis", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setTabWhatsThis(int,QString)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabWhatsThis(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabWhatsThis_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabWidget.setTabWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setTabsClosable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTabsClosable(bool)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setTabsClosable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setTabsClosable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setTabsClosable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setTabsClosable", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_setUsesScrollButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUsesScrollButtons(bool)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::setUsesScrollButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_setUsesScrollButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_setUsesScrollButtons_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.setUsesScrollButtons", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::showEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.showEvent", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTabWidget::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_tabBar(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabBar()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QTabBar * cpp_result = cppSelf->QTabWidget::tabBar();
    py_result = Shiboken::Converter<QTabBar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_tabIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabIcon(int)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QIcon cpp_result = cppSelf->QTabWidget::tabIcon(cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_tabIcon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_tabIcon_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.tabIcon", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_tabInserted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabInserted(int)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::tabInserted(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_tabInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_tabInserted_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.tabInserted", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_tabPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabPosition()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QTabWidget::TabPosition cpp_result = cppSelf->QTabWidget::tabPosition();
    py_result = Shiboken::Converter<QTabWidget::TabPosition >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_tabRemoved(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabRemoved(int)
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        cppSelf->QTabWidget::tabRemoved(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_tabRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabWidgetFunc_tabRemoved_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.tabRemoved", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_tabShape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabShape()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    QTabWidget::TabShape cpp_result = cppSelf->QTabWidget::tabShape();
    py_result = Shiboken::Converter<QTabWidget::TabShape >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_tabText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabText(int)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTabWidget::tabText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_tabText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_tabText_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.tabText", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_tabToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabToolTip(int)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTabWidget::tabToolTip(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_tabToolTip_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_tabToolTip_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.tabToolTip", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_tabWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabWhatsThis(int)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTabWidget::tabWhatsThis(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabWidgetFunc_tabWhatsThis_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_tabWhatsThis_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.tabWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQTabWidgetFunc_tabsClosable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabsClosable()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabWidget::tabsClosable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_usesScrollButtons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // usesScrollButtons()const
    QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabWidget::usesScrollButtons();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabWidgetFunc_widget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // widget(int)const
        QTabWidget* cppSelf = Shiboken::Converter<QTabWidget* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QTabWidget::widget(cpp_arg0);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTabWidgetFunc_widget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabWidgetFunc_widget_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabWidget.widget", overloads);
        return 0;
}

static PyMethodDef SbkQTabWidget_methods[] = {
    {"addTab", (PyCFunction)SbkQTabWidgetFunc_addTab, METH_VARARGS},
    {"changeEvent", (PyCFunction)SbkQTabWidgetFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQTabWidgetFunc_clear, METH_NOARGS},
    {"cornerWidget", (PyCFunction)SbkQTabWidgetFunc_cornerWidget, METH_NOARGS|METH_O},
    {"count", (PyCFunction)SbkQTabWidgetFunc_count, METH_NOARGS},
    {"currentIndex", (PyCFunction)SbkQTabWidgetFunc_currentIndex, METH_NOARGS},
    {"currentWidget", (PyCFunction)SbkQTabWidgetFunc_currentWidget, METH_NOARGS},
    {"documentMode", (PyCFunction)SbkQTabWidgetFunc_documentMode, METH_NOARGS},
    {"elideMode", (PyCFunction)SbkQTabWidgetFunc_elideMode, METH_NOARGS},
    {"event", (PyCFunction)SbkQTabWidgetFunc_event, METH_O},
    {"iconSize", (PyCFunction)SbkQTabWidgetFunc_iconSize, METH_NOARGS},
    {"indexOf", (PyCFunction)SbkQTabWidgetFunc_indexOf, METH_O},
    {"insertTab", (PyCFunction)SbkQTabWidgetFunc_insertTab, METH_VARARGS},
    {"isMovable", (PyCFunction)SbkQTabWidgetFunc_isMovable, METH_NOARGS},
    {"isTabEnabled", (PyCFunction)SbkQTabWidgetFunc_isTabEnabled, METH_O},
    {"keyPressEvent", (PyCFunction)SbkQTabWidgetFunc_keyPressEvent, METH_O},
    {"minimumSizeHint", (PyCFunction)SbkQTabWidgetFunc_minimumSizeHint, METH_NOARGS},
    {"paintEvent", (PyCFunction)SbkQTabWidgetFunc_paintEvent, METH_O},
    {"removeTab", (PyCFunction)SbkQTabWidgetFunc_removeTab, METH_O},
    {"resizeEvent", (PyCFunction)SbkQTabWidgetFunc_resizeEvent, METH_O},
    {"setCornerWidget", (PyCFunction)SbkQTabWidgetFunc_setCornerWidget, METH_VARARGS},
    {"setCurrentIndex", (PyCFunction)SbkQTabWidgetFunc_setCurrentIndex, METH_O},
    {"setCurrentWidget", (PyCFunction)SbkQTabWidgetFunc_setCurrentWidget, METH_O},
    {"setDocumentMode", (PyCFunction)SbkQTabWidgetFunc_setDocumentMode, METH_O},
    {"setElideMode", (PyCFunction)SbkQTabWidgetFunc_setElideMode, METH_O},
    {"setIconSize", (PyCFunction)SbkQTabWidgetFunc_setIconSize, METH_O},
    {"setMovable", (PyCFunction)SbkQTabWidgetFunc_setMovable, METH_O},
    {"setTabBar", (PyCFunction)SbkQTabWidgetFunc_setTabBar, METH_O},
    {"setTabEnabled", (PyCFunction)SbkQTabWidgetFunc_setTabEnabled, METH_VARARGS},
    {"setTabIcon", (PyCFunction)SbkQTabWidgetFunc_setTabIcon, METH_VARARGS},
    {"setTabPosition", (PyCFunction)SbkQTabWidgetFunc_setTabPosition, METH_O},
    {"setTabShape", (PyCFunction)SbkQTabWidgetFunc_setTabShape, METH_O},
    {"setTabText", (PyCFunction)SbkQTabWidgetFunc_setTabText, METH_VARARGS},
    {"setTabToolTip", (PyCFunction)SbkQTabWidgetFunc_setTabToolTip, METH_VARARGS},
    {"setTabWhatsThis", (PyCFunction)SbkQTabWidgetFunc_setTabWhatsThis, METH_VARARGS},
    {"setTabsClosable", (PyCFunction)SbkQTabWidgetFunc_setTabsClosable, METH_O},
    {"setUsesScrollButtons", (PyCFunction)SbkQTabWidgetFunc_setUsesScrollButtons, METH_O},
    {"showEvent", (PyCFunction)SbkQTabWidgetFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQTabWidgetFunc_sizeHint, METH_NOARGS},
    {"tabBar", (PyCFunction)SbkQTabWidgetFunc_tabBar, METH_NOARGS},
    {"tabIcon", (PyCFunction)SbkQTabWidgetFunc_tabIcon, METH_O},
    {"tabInserted", (PyCFunction)SbkQTabWidgetFunc_tabInserted, METH_O},
    {"tabPosition", (PyCFunction)SbkQTabWidgetFunc_tabPosition, METH_NOARGS},
    {"tabRemoved", (PyCFunction)SbkQTabWidgetFunc_tabRemoved, METH_O},
    {"tabShape", (PyCFunction)SbkQTabWidgetFunc_tabShape, METH_NOARGS},
    {"tabText", (PyCFunction)SbkQTabWidgetFunc_tabText, METH_O},
    {"tabToolTip", (PyCFunction)SbkQTabWidgetFunc_tabToolTip, METH_O},
    {"tabWhatsThis", (PyCFunction)SbkQTabWidgetFunc_tabWhatsThis, METH_O},
    {"tabsClosable", (PyCFunction)SbkQTabWidgetFunc_tabsClosable, METH_NOARGS},
    {"usesScrollButtons", (PyCFunction)SbkQTabWidgetFunc_usesScrollButtons, METH_NOARGS},
    {"widget", (PyCFunction)SbkQTabWidgetFunc_widget, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTabWidgetSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QTabWidget* me = reinterpret_cast<QTabWidget*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTabWidget_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTabWidget",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTabWidget_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTabWidget_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQTabWidgetSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTabWidget >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTabWidget_TabShape_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabWidget_TabShape_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabWidget_TabShape_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TabShape",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabWidget_TabShape_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabWidget_TabShape_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTabWidget_TabShape_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTabWidget_TabPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabWidget_TabPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabWidget_TabPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "TabPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabWidget_TabPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabWidget_TabPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTabWidget_TabPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTabWidget(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTABWIDGET_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTabWidget_Type);

    SbkQTabWidget_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQTabWidget_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQTabWidget_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTabWidget_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTabWidget_Type));
    PyModule_AddObject(module, "QTabWidget",
        ((PyObject*)&SbkQTabWidget_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: TabShape
    SbkPySide_QtGuiTypes[SBK_QTABWIDGET_TABSHAPE_IDX] = &SbkPySide_QtGui_QTabWidget_TabShape_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabWidget_TabShape_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabWidget_TabShape_Type);
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
            "TabShape",((PyObject*)&SbkPySide_QtGui_QTabWidget_TabShape_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabWidget_TabShape_Type,
        (long) QTabWidget::Rounded, "Rounded");
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
        "Rounded", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabWidget_TabShape_Type.tp_dict,
        "Rounded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabWidget_TabShape_Type,
        (long) QTabWidget::Triangular, "Triangular");
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
        "Triangular", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabWidget_TabShape_Type.tp_dict,
        "Triangular", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabWidget::TabShape");

    // init enum class: TabPosition
    SbkPySide_QtGuiTypes[SBK_QTABWIDGET_TABPOSITION_IDX] = &SbkPySide_QtGui_QTabWidget_TabPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabWidget_TabPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabWidget_TabPosition_Type);
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
            "TabPosition",((PyObject*)&SbkPySide_QtGui_QTabWidget_TabPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabWidget_TabPosition_Type,
        (long) QTabWidget::North, "North");
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
        "North", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabWidget_TabPosition_Type.tp_dict,
        "North", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabWidget_TabPosition_Type,
        (long) QTabWidget::South, "South");
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
        "South", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabWidget_TabPosition_Type.tp_dict,
        "South", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabWidget_TabPosition_Type,
        (long) QTabWidget::West, "West");
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
        "West", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabWidget_TabPosition_Type.tp_dict,
        "West", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabWidget_TabPosition_Type,
        (long) QTabWidget::East, "East");
    PyDict_SetItemString(SbkQTabWidget_Type.super.ht_type.tp_dict,
        "East", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabWidget_TabPosition_Type.tp_dict,
        "East", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabWidget::TabPosition");

    Shiboken::TypeResolver::createObjectTypeResolver<QTabWidget >("QTabWidget*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTabWidget >(typeid(QTabWidget).name());
}


} // extern "C"

