/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qtabbar_wrapper.h"

// Extra includes
#include <QIcon>
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qtabbar.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTabBarWrapper::QTabBarWrapper(QWidget * parent) : QTabBar(parent), m_metaObject(0) {
    // ... middle
}

void QTabBarWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QWidget::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QTabBarWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTabBarWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QTabBar::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QTabBarWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QTabBarWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QWidget::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTabBarWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QTabBarWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QTabBarWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QTabBarWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QTabBar::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QTabBarWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QTabBarWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QTabBar::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::tabInserted(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabInserted"));
    if (py_override.isNull()) {
        return this->QTabBar::tabInserted(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::tabLayoutChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabLayoutChange"));
    if (py_override.isNull()) {
        return this->QTabBar::tabLayoutChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::tabRemoved(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabRemoved"));
    if (py_override.isNull()) {
        return this->QTabBar::tabRemoved(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QTabBarWrapper::tabSizeHint(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabSizeHint"));
    if (py_override.isNull()) {
        return this->QTabBar::tabSizeHint(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QTabBar.tabSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QTabBarWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QTabBarWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QTabBarWrapper::wheelEvent(QWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QTabBar::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QTabBarWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QTabBar::staticMetaObject);
}
    return m_metaObject;
}

int QTabBarWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QTabBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QTabBarWrapper::~QTabBarWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQTabBar_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTabBarWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTabBar", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTabBar(QWidget*)
        cptr = new QTabBarWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QTabBar(QWidget*)
        cptr = new QTabBarWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQTabBar_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTabBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTabBar_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTabBar_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar", overloads);
        return -1;
}

static PyObject* SbkQTabBarFunc_addTab(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "addTab", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addTab(QString)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTabBar::addTab(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!SbkQIcon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // addTab(QIcon,QString)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTabBar::addTab(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_addTab_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_addTab_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon, PySide.QtCore.QString", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.addTab", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabBar::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTabBar::currentIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_documentMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // documentMode()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabBar::documentMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_drawBase(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // drawBase()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabBar::drawBase();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_elideMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // elideMode()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    Qt::TextElideMode cpp_result = cppSelf->QTabBar::elideMode();
    py_result = Shiboken::Converter<Qt::TextElideMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTabBar::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.event", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_expanding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // expanding()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabBar::expanding();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::hideEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.hideEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_iconSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconSize()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTabBar::iconSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_insertTab(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertTab", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // insertTab(int,QString)
            QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTabBar::insertTab(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
            QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
            if (!SbkQIcon_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // insertTab(int,QIcon,QString)
            QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QTabBar::insertTab(cpp_arg0, *cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQTabBarFunc_insertTab_TypeError;
    } else goto SbkQTabBarFunc_insertTab_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_insertTab_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QIcon, PySide.QtCore.QString", "int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.insertTab", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_isMovable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMovable()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabBar::isMovable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_isTabEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // isTabEnabled(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QTabBar::isTabEnabled(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_isTabEnabled_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_isTabEnabled_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.isTabEnabled", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTabBar::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_moveTab(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveTab", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // moveTab(int,int)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::moveTab(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_moveTab_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_moveTab_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.moveTab", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_removeTab(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeTab(int)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::removeTab(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_removeTab_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_removeTab_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.removeTab", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_selectionBehaviorOnRemove(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionBehaviorOnRemove()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    QTabBar::SelectionBehavior cpp_result = cppSelf->QTabBar::selectionBehaviorOnRemove();
    py_result = Shiboken::Converter<QTabBar::SelectionBehavior >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_setCurrentIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentIndex(int)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setCurrentIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setCurrentIndex", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setDocumentMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDocumentMode(bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setDocumentMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setDocumentMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setDocumentMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setDocumentMode", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setDrawBase(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDrawBase(bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setDrawBase(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setDrawBase_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setDrawBase_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setDrawBase", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setElideMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TextElideMode >::isConvertible(arg)) {
        Qt::TextElideMode cpp_arg0 = Shiboken::Converter<Qt::TextElideMode >::toCpp(arg);
        // setElideMode(Qt::TextElideMode)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setElideMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setElideMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setElideMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TextElideMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setElideMode", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setExpanding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setExpanding(bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setExpanding(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setExpanding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setExpanding_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setExpanding", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setIconSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setIconSize(QSize)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setIconSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setIconSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setIconSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setIconSize", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setMovable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setMovable(bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setMovable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setMovable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setMovable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setMovable", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setSelectionBehaviorOnRemove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabBar::SelectionBehavior >::isConvertible(arg)) {
        QTabBar::SelectionBehavior cpp_arg0 = Shiboken::Converter<QTabBar::SelectionBehavior >::toCpp(arg);
        // setSelectionBehaviorOnRemove(QTabBar::SelectionBehavior)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setSelectionBehaviorOnRemove(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setSelectionBehaviorOnRemove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setSelectionBehaviorOnRemove_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabBar.SelectionBehavior", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setSelectionBehaviorOnRemove", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setShape(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTabBar::Shape >::isConvertible(arg)) {
        QTabBar::Shape cpp_arg0 = Shiboken::Converter<QTabBar::Shape >::toCpp(arg);
        // setShape(QTabBar::Shape)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setShape(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setShape_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setShape_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTabBar.Shape", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setShape", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabButton(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setTabButton", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QTabBar::ButtonPosition >::isConvertible(pyargs[1]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QTabBar::ButtonPosition cpp_arg1 = Shiboken::Converter<QTabBar::ButtonPosition >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
        // setTabButton(int,QTabBar::ButtonPosition,QWidget*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabButton(cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabButton_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabButton_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTabBar.ButtonPosition, PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabButton", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // setTabData(int,QVariant)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabData(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabData", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabEnabled(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabEnabled", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // setTabEnabled(int,bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabEnabled(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabEnabled_TypeError:
        const char* overloads[] = {"int, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabEnabled", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabIcon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabIcon", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QIcon & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
        QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
        if (!SbkQIcon_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
        // setTabIcon(int,QIcon)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabIcon(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabIcon_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabIcon", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setTabText(int,QString)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabText(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabText_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabText", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabTextColor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabTextColor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QColor > cpp_arg1_auto_ptr;
        QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
        if (!SbkQColor_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
        // setTabTextColor(int,QColor)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabTextColor(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabTextColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabTextColor_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabTextColor", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabToolTip(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabToolTip", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setTabToolTip(int,QString)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabToolTip(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabToolTip_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabToolTip", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabWhatsThis(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTabWhatsThis", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setTabWhatsThis(int,QString)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabWhatsThis(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabWhatsThis_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.setTabWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setTabsClosable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setTabsClosable(bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setTabsClosable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setTabsClosable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setTabsClosable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setTabsClosable", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_setUsesScrollButtons(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUsesScrollButtons(bool)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::setUsesScrollButtons(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_setUsesScrollButtons_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_setUsesScrollButtons_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.setUsesScrollButtons", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_shape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shape()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    QTabBar::Shape cpp_result = cppSelf->QTabBar::shape();
    py_result = Shiboken::Converter<QTabBar::Shape >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::showEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.showEvent", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QTabBar::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_tabAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // tabAt(QPoint)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QTabBar::tabAt(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabAt", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabButton(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "tabButton", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QTabBar::ButtonPosition >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QTabBar::ButtonPosition cpp_arg1 = Shiboken::Converter<QTabBar::ButtonPosition >::toCpp(pyargs[1]);
        // tabButton(int,QTabBar::ButtonPosition)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QTabBar::tabButton(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQTabBarFunc_tabButton_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabButton_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QTabBar.ButtonPosition", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTabBar.tabButton", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabData(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QTabBar::tabData(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabData_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabData", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabIcon(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QIcon cpp_result = cppSelf->QTabBar::tabIcon(cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabIcon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabIcon_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabIcon", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabInserted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabInserted(int)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::tabInserted(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabInserted_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_tabInserted_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabInserted", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabLayoutChange(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // tabLayoutChange()
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    cppSelf->QTabBar::tabLayoutChange();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTabBarFunc_tabRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabRect(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QTabBar::tabRect(cpp_arg0);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabRect_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabRect", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabRemoved(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabRemoved(int)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::tabRemoved(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabRemoved_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_tabRemoved_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabRemoved", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabSizeHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabSizeHint(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QSize cpp_result = cppSelf->QTabBar::tabSizeHint(cpp_arg0);
        py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabSizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabSizeHint_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabSizeHint", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabText(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTabBar::tabText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabText_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabText", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabTextColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabTextColor(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QColor cpp_result = cppSelf->QTabBar::tabTextColor(cpp_arg0);
        py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabTextColor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabTextColor_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabTextColor", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabToolTip(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTabBar::tabToolTip(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabToolTip_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabToolTip_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabToolTip", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // tabWhatsThis(int)const
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QTabBar::tabWhatsThis(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_tabWhatsThis_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQTabBarFunc_tabWhatsThis_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.tabWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQTabBarFunc_tabsClosable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // tabsClosable()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabBar::tabsClosable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_usesScrollButtons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // usesScrollButtons()const
    QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTabBar::usesScrollButtons();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTabBarFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QTabBar* cppSelf = Shiboken::Converter<QTabBar* >::toCpp((PyObject*)self);
        cppSelf->QTabBar::wheelEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTabBarFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTabBarFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTabBar.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQTabBar_methods[] = {
    {"addTab", (PyCFunction)SbkQTabBarFunc_addTab, METH_VARARGS},
    {"changeEvent", (PyCFunction)SbkQTabBarFunc_changeEvent, METH_O},
    {"count", (PyCFunction)SbkQTabBarFunc_count, METH_NOARGS},
    {"currentIndex", (PyCFunction)SbkQTabBarFunc_currentIndex, METH_NOARGS},
    {"documentMode", (PyCFunction)SbkQTabBarFunc_documentMode, METH_NOARGS},
    {"drawBase", (PyCFunction)SbkQTabBarFunc_drawBase, METH_NOARGS},
    {"elideMode", (PyCFunction)SbkQTabBarFunc_elideMode, METH_NOARGS},
    {"event", (PyCFunction)SbkQTabBarFunc_event, METH_O},
    {"expanding", (PyCFunction)SbkQTabBarFunc_expanding, METH_NOARGS},
    {"hideEvent", (PyCFunction)SbkQTabBarFunc_hideEvent, METH_O},
    {"iconSize", (PyCFunction)SbkQTabBarFunc_iconSize, METH_NOARGS},
    {"insertTab", (PyCFunction)SbkQTabBarFunc_insertTab, METH_VARARGS},
    {"isMovable", (PyCFunction)SbkQTabBarFunc_isMovable, METH_NOARGS},
    {"isTabEnabled", (PyCFunction)SbkQTabBarFunc_isTabEnabled, METH_O},
    {"keyPressEvent", (PyCFunction)SbkQTabBarFunc_keyPressEvent, METH_O},
    {"minimumSizeHint", (PyCFunction)SbkQTabBarFunc_minimumSizeHint, METH_NOARGS},
    {"mouseMoveEvent", (PyCFunction)SbkQTabBarFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQTabBarFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQTabBarFunc_mouseReleaseEvent, METH_O},
    {"moveTab", (PyCFunction)SbkQTabBarFunc_moveTab, METH_VARARGS},
    {"paintEvent", (PyCFunction)SbkQTabBarFunc_paintEvent, METH_O},
    {"removeTab", (PyCFunction)SbkQTabBarFunc_removeTab, METH_O},
    {"resizeEvent", (PyCFunction)SbkQTabBarFunc_resizeEvent, METH_O},
    {"selectionBehaviorOnRemove", (PyCFunction)SbkQTabBarFunc_selectionBehaviorOnRemove, METH_NOARGS},
    {"setCurrentIndex", (PyCFunction)SbkQTabBarFunc_setCurrentIndex, METH_O},
    {"setDocumentMode", (PyCFunction)SbkQTabBarFunc_setDocumentMode, METH_O},
    {"setDrawBase", (PyCFunction)SbkQTabBarFunc_setDrawBase, METH_O},
    {"setElideMode", (PyCFunction)SbkQTabBarFunc_setElideMode, METH_O},
    {"setExpanding", (PyCFunction)SbkQTabBarFunc_setExpanding, METH_O},
    {"setIconSize", (PyCFunction)SbkQTabBarFunc_setIconSize, METH_O},
    {"setMovable", (PyCFunction)SbkQTabBarFunc_setMovable, METH_O},
    {"setSelectionBehaviorOnRemove", (PyCFunction)SbkQTabBarFunc_setSelectionBehaviorOnRemove, METH_O},
    {"setShape", (PyCFunction)SbkQTabBarFunc_setShape, METH_O},
    {"setTabButton", (PyCFunction)SbkQTabBarFunc_setTabButton, METH_VARARGS},
    {"setTabData", (PyCFunction)SbkQTabBarFunc_setTabData, METH_VARARGS},
    {"setTabEnabled", (PyCFunction)SbkQTabBarFunc_setTabEnabled, METH_VARARGS},
    {"setTabIcon", (PyCFunction)SbkQTabBarFunc_setTabIcon, METH_VARARGS},
    {"setTabText", (PyCFunction)SbkQTabBarFunc_setTabText, METH_VARARGS},
    {"setTabTextColor", (PyCFunction)SbkQTabBarFunc_setTabTextColor, METH_VARARGS},
    {"setTabToolTip", (PyCFunction)SbkQTabBarFunc_setTabToolTip, METH_VARARGS},
    {"setTabWhatsThis", (PyCFunction)SbkQTabBarFunc_setTabWhatsThis, METH_VARARGS},
    {"setTabsClosable", (PyCFunction)SbkQTabBarFunc_setTabsClosable, METH_O},
    {"setUsesScrollButtons", (PyCFunction)SbkQTabBarFunc_setUsesScrollButtons, METH_O},
    {"shape", (PyCFunction)SbkQTabBarFunc_shape, METH_NOARGS},
    {"showEvent", (PyCFunction)SbkQTabBarFunc_showEvent, METH_O},
    {"sizeHint", (PyCFunction)SbkQTabBarFunc_sizeHint, METH_NOARGS},
    {"tabAt", (PyCFunction)SbkQTabBarFunc_tabAt, METH_O},
    {"tabButton", (PyCFunction)SbkQTabBarFunc_tabButton, METH_VARARGS},
    {"tabData", (PyCFunction)SbkQTabBarFunc_tabData, METH_O},
    {"tabIcon", (PyCFunction)SbkQTabBarFunc_tabIcon, METH_O},
    {"tabInserted", (PyCFunction)SbkQTabBarFunc_tabInserted, METH_O},
    {"tabLayoutChange", (PyCFunction)SbkQTabBarFunc_tabLayoutChange, METH_NOARGS},
    {"tabRect", (PyCFunction)SbkQTabBarFunc_tabRect, METH_O},
    {"tabRemoved", (PyCFunction)SbkQTabBarFunc_tabRemoved, METH_O},
    {"tabSizeHint", (PyCFunction)SbkQTabBarFunc_tabSizeHint, METH_O},
    {"tabText", (PyCFunction)SbkQTabBarFunc_tabText, METH_O},
    {"tabTextColor", (PyCFunction)SbkQTabBarFunc_tabTextColor, METH_O},
    {"tabToolTip", (PyCFunction)SbkQTabBarFunc_tabToolTip, METH_O},
    {"tabWhatsThis", (PyCFunction)SbkQTabBarFunc_tabWhatsThis, METH_O},
    {"tabsClosable", (PyCFunction)SbkQTabBarFunc_tabsClosable, METH_NOARGS},
    {"usesScrollButtons", (PyCFunction)SbkQTabBarFunc_usesScrollButtons, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQTabBarFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTabBarSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QTabBar* me = reinterpret_cast<QTabBar*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTabBar_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTabBar",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTabBar_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTabBar_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQTabBarSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTabBar >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QTabBar_SelectionBehavior_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabBar_SelectionBehavior_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabBar_SelectionBehavior_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SelectionBehavior",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabBar_SelectionBehavior_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabBar_SelectionBehavior_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTabBar_SelectionBehavior_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTabBar_ButtonPosition_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabBar_ButtonPosition_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabBar_ButtonPosition_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ButtonPosition",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabBar_ButtonPosition_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabBar_ButtonPosition_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTabBar_ButtonPosition_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QTabBar_Shape_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTabBar_Shape_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTabBar_Shape_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Shape",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTabBar_Shape_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTabBar_Shape_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTabBar_Shape_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QTabBar(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTABBAR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTabBar_Type);

    SbkQTabBar_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQTabBar_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQTabBar_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTabBar_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTabBar_Type));
    PyModule_AddObject(module, "QTabBar",
        ((PyObject*)&SbkQTabBar_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SelectionBehavior
    SbkPySide_QtGuiTypes[SBK_QTABBAR_SELECTIONBEHAVIOR_IDX] = &SbkPySide_QtGui_QTabBar_SelectionBehavior_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabBar_SelectionBehavior_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabBar_SelectionBehavior_Type);
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
            "SelectionBehavior",((PyObject*)&SbkPySide_QtGui_QTabBar_SelectionBehavior_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_SelectionBehavior_Type,
        (long) QTabBar::SelectLeftTab, "SelectLeftTab");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "SelectLeftTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_SelectionBehavior_Type.tp_dict,
        "SelectLeftTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_SelectionBehavior_Type,
        (long) QTabBar::SelectRightTab, "SelectRightTab");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "SelectRightTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_SelectionBehavior_Type.tp_dict,
        "SelectRightTab", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_SelectionBehavior_Type,
        (long) QTabBar::SelectPreviousTab, "SelectPreviousTab");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "SelectPreviousTab", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_SelectionBehavior_Type.tp_dict,
        "SelectPreviousTab", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabBar::SelectionBehavior");

    // init enum class: ButtonPosition
    SbkPySide_QtGuiTypes[SBK_QTABBAR_BUTTONPOSITION_IDX] = &SbkPySide_QtGui_QTabBar_ButtonPosition_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabBar_ButtonPosition_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabBar_ButtonPosition_Type);
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
            "ButtonPosition",((PyObject*)&SbkPySide_QtGui_QTabBar_ButtonPosition_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_ButtonPosition_Type,
        (long) QTabBar::LeftSide, "LeftSide");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "LeftSide", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_ButtonPosition_Type.tp_dict,
        "LeftSide", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_ButtonPosition_Type,
        (long) QTabBar::RightSide, "RightSide");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "RightSide", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_ButtonPosition_Type.tp_dict,
        "RightSide", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabBar::ButtonPosition");

    // init enum class: Shape
    SbkPySide_QtGuiTypes[SBK_QTABBAR_SHAPE_IDX] = &SbkPySide_QtGui_QTabBar_Shape_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTabBar_Shape_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTabBar_Shape_Type);
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
            "Shape",((PyObject*)&SbkPySide_QtGui_QTabBar_Shape_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::RoundedNorth, "RoundedNorth");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "RoundedNorth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "RoundedNorth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::RoundedSouth, "RoundedSouth");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "RoundedSouth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "RoundedSouth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::RoundedWest, "RoundedWest");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "RoundedWest", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "RoundedWest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::RoundedEast, "RoundedEast");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "RoundedEast", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "RoundedEast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::TriangularNorth, "TriangularNorth");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "TriangularNorth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "TriangularNorth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::TriangularSouth, "TriangularSouth");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "TriangularSouth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "TriangularSouth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::TriangularWest, "TriangularWest");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "TriangularWest", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "TriangularWest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTabBar_Shape_Type,
        (long) QTabBar::TriangularEast, "TriangularEast");
    PyDict_SetItemString(SbkQTabBar_Type.super.ht_type.tp_dict,
        "TriangularEast", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTabBar_Shape_Type.tp_dict,
        "TriangularEast", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTabBar::Shape");

    Shiboken::TypeResolver::createObjectTypeResolver<QTabBar >("QTabBar*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTabBar >(typeid(QTabBar).name());
}


} // extern "C"

