/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qshortcut_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qkeysequence.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QShortcutWrapper::QShortcutWrapper(QWidget * parent) : QShortcut(parent), m_metaObject(0) {
    // ... middle
}

QShortcutWrapper::QShortcutWrapper(const QKeySequence & key, QWidget * parent, const char * member, const char * ambiguousMember, Qt::ShortcutContext context) : QShortcut(key, parent, member, ambiguousMember, context), m_metaObject(0) {
    // ... middle
}

void QShortcutWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QShortcutWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QShortcutWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QShortcutWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QShortcutWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QShortcut::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QShortcut.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QShortcutWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QShortcut.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QShortcutWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QShortcutWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QShortcut::staticMetaObject);
}
    return m_metaObject;
}

int QShortcutWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QShortcut::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QShortcutWrapper::~QShortcutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQShortcut_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QShortcutWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QShortcut", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QShortcut(QWidget*)
        cptr = new QShortcutWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QKeySequence >::isConvertible(pyargs[0]) && Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(pyargs[0]);
        if (!SbkQKeySequence_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
            cptr = new QShortcutWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[2])) {
            const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
                cptr = new QShortcutWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(pyargs[1], self);
            } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[3])) {
                const char * cpp_arg3 = Shiboken::Converter<const char * >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
                    cptr = new QShortcutWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(pyargs[1], self);
                } else if (Shiboken::Converter<Qt::ShortcutContext >::isConvertible(pyargs[4])) {
                    Qt::ShortcutContext cpp_arg4 = Shiboken::Converter<Qt::ShortcutContext >::toCpp(pyargs[4]);
                    // QShortcut(QKeySequence,QWidget*,const char*,const char*,Qt::ShortcutContext)
                    cptr = new QShortcutWrapper(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                    Shiboken::setParent(pyargs[1], self);
                } else goto SbkQShortcut_Init_TypeError;
            } else goto SbkQShortcut_Init_TypeError;
        } else if (PyCallable_Check(pyargs[2])) {
            if (numArgs == 3) {
                // QShortcut(QKeySequence,QWidget*,PyCallable*,Qt::ShortcutContext)
                overloadId = 0;
                // Begin code injection
                
                cptr = new QShortcutWrapper((*cpp_arg0), cpp_arg1);
                
                // End of code injection

                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<Qt::ShortcutContext >::isConvertible(pyargs[3])) {
                Qt::ShortcutContext cpp_arg3 = Shiboken::Converter<Qt::ShortcutContext >::toCpp(pyargs[3]);
                // QShortcut(QKeySequence,QWidget*,PyCallable*,Qt::ShortcutContext)
                overloadId = 0;
                // Begin code injection
                
                cptr = new QShortcutWrapper((*cpp_arg0), cpp_arg1);
                
                // End of code injection

                //CppGenerator::writeParentChildManagement
            } else goto SbkQShortcut_Init_TypeError;
        } else goto SbkQShortcut_Init_TypeError;
    } else goto SbkQShortcut_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QShortcut >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQShortcut_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    switch(overloadId) {
        case 0:
        {
            // Begin code injection
            
            Shiboken::AutoDecRef result(PyObject_CallMethod(self, "connect", "OsO", self, SIGNAL(activated()), pyargs[3-1]));
            if (!result.isNull())
                Shiboken::setParent(pyargs[2-1], self);
            
            // End of code injection
        }
}

    return 1;

    SbkQShortcut_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence, PySide.QtGui.QWidget, PyCallable, PySide.QtCore.Qt.ShortcutContext = Qt.WindowShortcut", "PySide.QtGui.QWidget", "PySide.QtGui.QKeySequence, PySide.QtGui.QWidget, str = None, str = None, PySide.QtCore.Qt.ShortcutContext = Qt.WindowShortcut", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QShortcut", overloads);
        return -1;
}

static PyObject* SbkQShortcutFunc_autoRepeat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoRepeat()const
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QShortcut::autoRepeat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQShortcutFunc_context(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // context()
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    Qt::ShortcutContext cpp_result = cppSelf->QShortcut::context();
    py_result = Shiboken::Converter<Qt::ShortcutContext >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQShortcutFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QShortcut::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQShortcutFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQShortcutFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QShortcut.event", overloads);
        return 0;
}

static PyObject* SbkQShortcutFunc_id(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // id()const
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QShortcut::id();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQShortcutFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QShortcut::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQShortcutFunc_key(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // key()const
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    QKeySequence cpp_result = cppSelf->QShortcut::key();
    py_result = Shiboken::Converter<QKeySequence >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQShortcutFunc_parentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentWidget()const
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QShortcut::parentWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQShortcutFunc_setAutoRepeat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoRepeat(bool)
        QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
        cppSelf->QShortcut::setAutoRepeat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQShortcutFunc_setAutoRepeat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQShortcutFunc_setAutoRepeat_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QShortcut.setAutoRepeat", overloads);
        return 0;
}

static PyObject* SbkQShortcutFunc_setContext(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ShortcutContext >::isConvertible(arg)) {
        Qt::ShortcutContext cpp_arg0 = Shiboken::Converter<Qt::ShortcutContext >::toCpp(arg);
        // setContext(Qt::ShortcutContext)
        QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
        cppSelf->QShortcut::setContext(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQShortcutFunc_setContext_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQShortcutFunc_setContext_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ShortcutContext", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QShortcut.setContext", overloads);
        return 0;
}

static PyObject* SbkQShortcutFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
        cppSelf->QShortcut::setEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQShortcutFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQShortcutFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QShortcut.setEnabled", overloads);
        return 0;
}

static PyObject* SbkQShortcutFunc_setKey(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeySequence & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(arg);
        if (!SbkQKeySequence_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        // setKey(QKeySequence)
        QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
        cppSelf->QShortcut::setKey(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQShortcutFunc_setKey_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQShortcutFunc_setKey_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QShortcut.setKey", overloads);
        return 0;
}

static PyObject* SbkQShortcutFunc_setWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWhatsThis(QString)
        QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
        cppSelf->QShortcut::setWhatsThis(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQShortcutFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQShortcutFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QShortcut.setWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQShortcutFunc_whatsThis(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // whatsThis()const
    QShortcut* cppSelf = Shiboken::Converter<QShortcut* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QShortcut::whatsThis();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQShortcut_methods[] = {
    {"autoRepeat", (PyCFunction)SbkQShortcutFunc_autoRepeat, METH_NOARGS},
    {"context", (PyCFunction)SbkQShortcutFunc_context, METH_NOARGS},
    {"event", (PyCFunction)SbkQShortcutFunc_event, METH_O},
    {"id", (PyCFunction)SbkQShortcutFunc_id, METH_NOARGS},
    {"isEnabled", (PyCFunction)SbkQShortcutFunc_isEnabled, METH_NOARGS},
    {"key", (PyCFunction)SbkQShortcutFunc_key, METH_NOARGS},
    {"parentWidget", (PyCFunction)SbkQShortcutFunc_parentWidget, METH_NOARGS},
    {"setAutoRepeat", (PyCFunction)SbkQShortcutFunc_setAutoRepeat, METH_O},
    {"setContext", (PyCFunction)SbkQShortcutFunc_setContext, METH_O},
    {"setEnabled", (PyCFunction)SbkQShortcutFunc_setEnabled, METH_O},
    {"setKey", (PyCFunction)SbkQShortcutFunc_setKey, METH_O},
    {"setWhatsThis", (PyCFunction)SbkQShortcutFunc_setWhatsThis, METH_O},
    {"whatsThis", (PyCFunction)SbkQShortcutFunc_whatsThis, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQShortcut_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QShortcut",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQShortcut_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQShortcut_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QShortcut >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QShortcut(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSHORTCUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQShortcut_Type);

    SbkQShortcut_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQShortcut_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQShortcut_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQShortcut_Type));
    PyModule_AddObject(module, "QShortcut",
        ((PyObject*)&SbkQShortcut_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QShortcut >("QShortcut*");
    Shiboken::TypeResolver::createObjectTypeResolver<QShortcut >(typeid(QShortcut).name());
}


} // extern "C"

