/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qregexpvalidator_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qlocale.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qregexp.h>
#include <qstring.h>
#include <qthread.h>
#include <qvalidator.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QRegExpValidatorWrapper::QRegExpValidatorWrapper(QObject * parent) : QRegExpValidator(parent), m_metaObject(0) {
    // ... middle
}

QRegExpValidatorWrapper::QRegExpValidatorWrapper(const QRegExp & rx, QObject * parent) : QRegExpValidator(rx, parent), m_metaObject(0) {
    // ... middle
}

void QRegExpValidatorWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QRegExpValidatorWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QRegExpValidatorWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QRegExpValidatorWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QRegExpValidatorWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QRegExpValidator.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QRegExpValidatorWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QRegExpValidator.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QRegExpValidatorWrapper::fixup(QString & arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fixup"));
    if (py_override.isNull()) {
        return this->QValidator::fixup(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QRegExpValidatorWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QValidator::State QRegExpValidatorWrapper::validate(QString & input, int & pos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validate"));
    if (py_override.isNull()) {
        return this->QRegExpValidator::validate(input, pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QString & >::toPython(input),
        Shiboken::Converter<int  >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QValidator::State();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QValidator::State >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QRegExpValidator.validate", SbkType<QValidator::State >()->tp_name, py_result->ob_type->tp_name);
        return QValidator::State();
    }
    QValidator::State cpp_result(Shiboken::Converter<QValidator::State >::toCpp(py_result));
    return cpp_result;
}

const QMetaObject* QRegExpValidatorWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QRegExpValidator::staticMetaObject);
}
    return m_metaObject;
}

int QRegExpValidatorWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QRegExpValidator::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QRegExpValidatorWrapper::~QRegExpValidatorWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQRegExpValidator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QRegExpValidatorWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QRegExpValidator", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // QRegExpValidator(QRegExp,QObject*)
        cptr = new QRegExpValidatorWrapper(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], self);
    } else if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QRegExpValidator(QObject*)
        cptr = new QRegExpValidatorWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQRegExpValidator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QRegExpValidator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQRegExpValidator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQRegExpValidator_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", "PySide.QtCore.QRegExp, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRegExpValidator", overloads);
        return -1;
}

static PyObject* SbkQRegExpValidatorFunc_regExp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // regExp()const
    QRegExpValidator* cppSelf = Shiboken::Converter<QRegExpValidator* >::toCpp((PyObject*)self);
    const QRegExp & cpp_result = cppSelf->QRegExpValidator::regExp();
    py_result = Shiboken::Converter<QRegExp & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRegExpValidatorFunc_setRegExp(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRegExp & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(arg);
        // setRegExp(QRegExp)
        QRegExpValidator* cppSelf = Shiboken::Converter<QRegExpValidator* >::toCpp((PyObject*)self);
        cppSelf->QRegExpValidator::setRegExp(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpValidatorFunc_setRegExp_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRegExpValidatorFunc_setRegExp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QRegExpValidator.setRegExp", overloads);
        return 0;
}

static PyObject* SbkQRegExpValidatorFunc_validate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "validate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int  cpp_arg1 = Shiboken::Converter<int  >::toCpp(pyargs[1]);
        // validate(QString&,int&)const
        QRegExpValidator* cppSelf = Shiboken::Converter<QRegExpValidator* >::toCpp((PyObject*)self);
        QValidator::State cpp_result = cppSelf->QRegExpValidator::validate(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QValidator::State >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRegExpValidatorFunc_validate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRegExpValidatorFunc_validate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QRegExpValidator.validate", overloads);
        return 0;
}

static PyMethodDef SbkQRegExpValidator_methods[] = {
    {"regExp", (PyCFunction)SbkQRegExpValidatorFunc_regExp, METH_NOARGS},
    {"setRegExp", (PyCFunction)SbkQRegExpValidatorFunc_setRegExp, METH_O},
    {"validate", (PyCFunction)SbkQRegExpValidatorFunc_validate, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQRegExpValidator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QRegExpValidator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQRegExpValidator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQRegExpValidator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QRegExpValidator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QRegExpValidator(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QREGEXPVALIDATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQRegExpValidator_Type);

    SbkQRegExpValidator_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QVALIDATOR_IDX];
    // Fill type discovery information
    SbkQRegExpValidator_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQRegExpValidator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQRegExpValidator_Type));
    PyModule_AddObject(module, "QRegExpValidator",
        ((PyObject*)&SbkQRegExpValidator_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QRegExpValidator >("QRegExpValidator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QRegExpValidator >(typeid(QRegExpValidator).name());
}


} // extern "C"

