/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qprinterinfo_wrapper.h"

// Extra includes
#include <QList>
#include <qprinter.h>
#include <qprinterinfo.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQPrinterInfo_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPrinterInfo* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPrinterInfo", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPrinterInfo()
        cptr = new QPrinterInfo();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPrinter & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPrinter* cpp_arg0 = Shiboken::Converter<QPrinter* >::toCpp(pyargs[0]);
        // QPrinterInfo(QPrinter)
        cptr = new QPrinterInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPrinterInfo & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPrinterInfo > cpp_arg0_auto_ptr;
        QPrinterInfo* cpp_arg0 = Shiboken::Converter<QPrinterInfo* >::toCpp(pyargs[0]);
        if (!SbkQPrinterInfo_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPrinterInfo >(cpp_arg0);
        // QPrinterInfo(QPrinterInfo)
        cptr = new QPrinterInfo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPrinterInfo_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPrinterInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPrinterInfo_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPrinterInfo_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPrinter", "PySide.QtGui.QPrinterInfo", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPrinterInfo", overloads);
        return -1;
}

static PyObject* SbkQPrinterInfoFunc_availablePrinters(PyObject* self)
{
    PyObject* py_result = 0;

    // availablePrinters()
    QList<QPrinterInfo > cpp_result = QPrinterInfo::availablePrinters();
    py_result = Shiboken::Converter<QList<QPrinterInfo > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrinterInfoFunc_defaultPrinter(PyObject* self)
{
    PyObject* py_result = 0;

    // defaultPrinter()
    QPrinterInfo cpp_result = QPrinterInfo::defaultPrinter();
    py_result = Shiboken::Converter<QPrinterInfo >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrinterInfoFunc_isDefault(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isDefault()const
    QPrinterInfo* cppSelf = Shiboken::Converter<QPrinterInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinterInfo::isDefault();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrinterInfoFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QPrinterInfo* cppSelf = Shiboken::Converter<QPrinterInfo* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPrinterInfo::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrinterInfoFunc_printerName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // printerName()const
    QPrinterInfo* cppSelf = Shiboken::Converter<QPrinterInfo* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QPrinterInfo::printerName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPrinterInfoFunc_supportedPaperSizes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedPaperSizes()const
    QPrinterInfo* cppSelf = Shiboken::Converter<QPrinterInfo* >::toCpp((PyObject*)self);
    QList<QPrinter::PageSize > cpp_result = cppSelf->QPrinterInfo::supportedPaperSizes();
    py_result = Shiboken::Converter<QList<QPrinter::PageSize > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPrinterInfo_methods[] = {
    {"availablePrinters", (PyCFunction)SbkQPrinterInfoFunc_availablePrinters, METH_NOARGS|METH_STATIC},
    {"defaultPrinter", (PyCFunction)SbkQPrinterInfoFunc_defaultPrinter, METH_NOARGS|METH_STATIC},
    {"isDefault", (PyCFunction)SbkQPrinterInfoFunc_isDefault, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQPrinterInfoFunc_isNull, METH_NOARGS},
    {"printerName", (PyCFunction)SbkQPrinterInfoFunc_printerName, METH_NOARGS},
    {"supportedPaperSizes", (PyCFunction)SbkQPrinterInfoFunc_supportedPaperSizes, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPrinterInfo_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPrinterInfo",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPrinterInfo_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPrinterInfo_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPrinterInfo >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QPrinterInfo(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPRINTERINFO_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPrinterInfo_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPrinterInfo_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPrinterInfo_Type));
    PyModule_AddObject(module, "QPrinterInfo",
        ((PyObject*)&SbkQPrinterInfo_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPrinterInfo >("QPrinterInfo");
    Shiboken::TypeResolver::createValueTypeResolver<QPrinterInfo >(typeid(QPrinterInfo).name());
}


} // extern "C"

