/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpolygon_wrapper.h"

// Extra includes
#include <QList>
#include <QMatrix>
#include <QTransform>
#include <QVector>
#include <qdatastream.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQPolygon_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPolygon* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QPolygon", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QPolygon()
        cptr = new QPolygon();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // QPolygon(int)
        cptr = new QPolygon(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVector<QPoint >  >::isConvertible(pyargs[0])) {
        QVector<QPoint >  cpp_arg0 = Shiboken::Converter<QVector<QPoint >  >::toCpp(pyargs[0]);
        // QPolygon(QVector<QPoint>)
        cptr = new QPolygon(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QPolygon(QRect,bool)
            cptr = new QPolygon(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // QPolygon(QRect,bool)
            cptr = new QPolygon(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygon_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QPolygon & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(pyargs[0]);
        if (!SbkQPolygon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // QPolygon(QPolygon)
        cptr = new QPolygon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygon_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPolygon >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPolygon_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPolygon_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPolygon", "PySide.QtCore.QRect, bool = false", "list", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon", overloads);
        return -1;
}

static PyObject* SbkQPolygonFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // append(QPoint)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.append", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        const QPoint & cpp_result = cppSelf->QPolygon::at(cpp_arg0);
        py_result = Shiboken::Converter<QPoint & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.at", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_boundingRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundingRect()const
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QPolygon::boundingRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFunc_capacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capacity()const
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPolygon::capacity();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    cppSelf->QPolygon::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // contains(QPoint)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygon::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.contains", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_containsPoint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "containsPoint", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::FillRule >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        Qt::FillRule cpp_arg1 = Shiboken::Converter<Qt::FillRule >::toCpp(pyargs[1]);
        // containsPoint(QPoint,Qt::FillRule)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygon::containsPoint(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_containsPoint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_containsPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.Qt.FillRule", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.containsPoint", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPolygon::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // count(QPoint)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPolygon::count(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_count_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.count", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_empty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // empty()const
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPolygon::empty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFunc_endsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // endsWith(QPoint)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygon::endsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_endsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_endsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.endsWith", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_fill(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fill", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // fill(QPoint,int)
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            QVector<QPoint > & cpp_result = cppSelf->QPolygon::fill(*cpp_arg0);
            py_result = Shiboken::Converter<QVector<QPoint >  >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // fill(QPoint,int)
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            QVector<QPoint > & cpp_result = cppSelf->QPolygon::fill(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVector<QPoint >  >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFunc_fill_TypeError;
    } else goto SbkQPolygonFunc_fill_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_fill_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.fill", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_fromList(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QList<QPoint >  >::isConvertible(arg)) {
        QList<QPoint >  cpp_arg0 = Shiboken::Converter<QList<QPoint >  >::toCpp(arg);
        // fromList(QList<QPoint>)
        QVector<QPoint > cpp_result = QPolygon::fromList(cpp_arg0);
        py_result = Shiboken::Converter<QVector<QPoint > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_fromList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_fromList_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.fromList", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_indexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // indexOf(QPoint,int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygon::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QPoint,int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygon::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFunc_indexOf_TypeError;
    } else goto SbkQPolygonFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.indexOf", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!SbkQPolygon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // intersected(QPolygon)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QPolygon::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.intersected", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPolygon::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFunc_lastIndexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // lastIndexOf(QPoint,int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygon::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QPoint,int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QPolygon::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFunc_lastIndexOf_TypeError;
    } else goto SbkQPolygonFunc_lastIndexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_lastIndexOf_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.lastIndexOf", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_mid(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mid", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // mid(int,int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            QVector<QPoint > cpp_result = cppSelf->QPolygon::mid(cpp_arg0);
            py_result = Shiboken::Converter<QVector<QPoint > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // mid(int,int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            QVector<QPoint > cpp_result = cppSelf->QPolygon::mid(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVector<QPoint > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFunc_mid_TypeError;
    } else goto SbkQPolygonFunc_mid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_mid_TypeError:
        const char* overloads[] = {"int, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.mid", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_pop_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_back()
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    cppSelf->QPolygon::pop_back();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFunc_pop_front(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_front()
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    cppSelf->QPolygon::pop_front();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFunc_prepend(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // prepend(QPoint)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::prepend(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_prepend_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_prepend_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.prepend", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_push_back(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // push_back(QPoint)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::push_back(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_push_back_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_push_back_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.push_back", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_push_front(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // push_front(QPoint)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::push_front(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_push_front_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_push_front_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.push_front", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_remove(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "remove", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // remove(int)
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            cppSelf->QPolygon::remove(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // remove(int,int)
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            cppSelf->QPolygon::remove(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFunc_remove_TypeError;
    } else goto SbkQPolygonFunc_remove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_remove_TypeError:
        const char* overloads[] = {"int", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.remove", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // replace(int,QPoint)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::replace(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_replace_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.replace", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_reserve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // reserve(int)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::reserve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_reserve_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_reserve_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.reserve", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_resize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // resize(int)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::resize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_resize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_resize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.resize", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_setSharable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSharable(bool)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::setSharable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_setSharable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_setSharable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.setSharable", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPolygon::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFunc_squeeze(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // squeeze()
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    cppSelf->QPolygon::squeeze();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPolygonFunc_startsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // startsWith(QPoint)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPolygon::startsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_startsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_startsWith_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.startsWith", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_subtracted(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!SbkQPolygon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // subtracted(QPolygon)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QPolygon::subtracted(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_subtracted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_subtracted_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.subtracted", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_toList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toList()const
    QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
    QList<QPoint > cpp_result = cppSelf->QPolygon::toList();
    py_result = Shiboken::Converter<QList<QPoint > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPolygonFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translate(int,int)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translate(QPoint)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        cppSelf->QPolygon::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPolygonFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.translate", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translated(int,int)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QPolygon::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translated(QPoint)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QPolygon::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.translated", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_united(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPolygon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!SbkQPolygon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // united(QPolygon)const
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = cppSelf->QPolygon::united(*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc_united_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_united_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.united", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // value(int)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            QPoint cpp_result = cppSelf->QPolygon::value(cpp_arg0);
            py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
            // value(int,QPoint)const
            QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
            QPoint cpp_result = cppSelf->QPolygon::value(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPolygonFunc_value_TypeError;
    } else goto SbkQPolygonFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc_value_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPolygon.value", overloads);
        return 0;
}

static PyMethodDef SbkQPolygon_methods[] = {
    {"append", (PyCFunction)SbkQPolygonFunc_append, METH_O},
    {"at", (PyCFunction)SbkQPolygonFunc_at, METH_O},
    {"boundingRect", (PyCFunction)SbkQPolygonFunc_boundingRect, METH_NOARGS},
    {"capacity", (PyCFunction)SbkQPolygonFunc_capacity, METH_NOARGS},
    {"clear", (PyCFunction)SbkQPolygonFunc_clear, METH_NOARGS},
    {"contains", (PyCFunction)SbkQPolygonFunc_contains, METH_O},
    {"containsPoint", (PyCFunction)SbkQPolygonFunc_containsPoint, METH_VARARGS},
    {"count", (PyCFunction)SbkQPolygonFunc_count, METH_NOARGS|METH_O},
    {"empty", (PyCFunction)SbkQPolygonFunc_empty, METH_NOARGS},
    {"endsWith", (PyCFunction)SbkQPolygonFunc_endsWith, METH_O},
    {"fill", (PyCFunction)SbkQPolygonFunc_fill, METH_VARARGS},
    {"fromList", (PyCFunction)SbkQPolygonFunc_fromList, METH_O|METH_STATIC},
    {"indexOf", (PyCFunction)SbkQPolygonFunc_indexOf, METH_VARARGS},
    {"intersected", (PyCFunction)SbkQPolygonFunc_intersected, METH_O},
    {"isEmpty", (PyCFunction)SbkQPolygonFunc_isEmpty, METH_NOARGS},
    {"lastIndexOf", (PyCFunction)SbkQPolygonFunc_lastIndexOf, METH_VARARGS},
    {"mid", (PyCFunction)SbkQPolygonFunc_mid, METH_VARARGS},
    {"pop_back", (PyCFunction)SbkQPolygonFunc_pop_back, METH_NOARGS},
    {"pop_front", (PyCFunction)SbkQPolygonFunc_pop_front, METH_NOARGS},
    {"prepend", (PyCFunction)SbkQPolygonFunc_prepend, METH_O},
    {"push_back", (PyCFunction)SbkQPolygonFunc_push_back, METH_O},
    {"push_front", (PyCFunction)SbkQPolygonFunc_push_front, METH_O},
    {"remove", (PyCFunction)SbkQPolygonFunc_remove, METH_VARARGS},
    {"replace", (PyCFunction)SbkQPolygonFunc_replace, METH_VARARGS},
    {"reserve", (PyCFunction)SbkQPolygonFunc_reserve, METH_O},
    {"resize", (PyCFunction)SbkQPolygonFunc_resize, METH_O},
    {"setSharable", (PyCFunction)SbkQPolygonFunc_setSharable, METH_O},
    {"size", (PyCFunction)SbkQPolygonFunc_size, METH_NOARGS},
    {"squeeze", (PyCFunction)SbkQPolygonFunc_squeeze, METH_NOARGS},
    {"startsWith", (PyCFunction)SbkQPolygonFunc_startsWith, METH_O},
    {"subtracted", (PyCFunction)SbkQPolygonFunc_subtracted, METH_O},
    {"toList", (PyCFunction)SbkQPolygonFunc_toList, METH_NOARGS},
    {"translate", (PyCFunction)SbkQPolygonFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQPolygonFunc_translated, METH_VARARGS},
    {"united", (PyCFunction)SbkQPolygonFunc_united, METH_O},
    {"value", (PyCFunction)SbkQPolygonFunc_value, METH_VARARGS},
    {0} // Sentinel
};

static PyObject* SbkQPolygonFunc___mul__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPolygon_Check(arg) && !SbkQPolygon_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rmul__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rmul__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QTransform & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // operator*(QPolygon,QTransform)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (!isReverse && Shiboken::Converter<QMatrix & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // operator*(QPolygon,QMatrix)
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QPolygon cpp_result = (*cppSelf) * (*cpp_arg0);
        py_result = Shiboken::Converter<QPolygon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPolygonFunc___mul___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc___mul___TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.__mul__", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPolygon_Check(arg) && !SbkQPolygon_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QPolygon) [reverse operator]
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQPolygonFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQPolygonFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQPolygon_Check(arg) && !SbkQPolygon_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QPolygon&) [reverse operator]
        QPolygon* cppSelf = Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQPolygonFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPolygonFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPolygon.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPolygon_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)SbkQPolygonFunc___mul__,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQPolygonFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQPolygonFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQPolygon_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QPolygon& cpp_self = *Shiboken::Converter<QPolygon* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QVector<QPoint >  >::isConvertible(other)) {
                // operator!=(const QVector<QPoint > & v) const
                const QVector<QPoint > & cpp_other = Shiboken::Converter<QVector<QPoint >  >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQPolygon_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QVector<QPoint >  >::isConvertible(other)) {
                // operator==(const QVector<QPoint > & v) const
                const QVector<QPoint > & cpp_other = Shiboken::Converter<QVector<QPoint >  >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQPolygon_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQPolygon_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPolygon_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPolygon",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPolygon_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPolygon_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPolygon_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPolygon_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPolygon >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QPolygon(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPOLYGON_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPolygon_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPolygon_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPolygon_Type));
    PyModule_AddObject(module, "QPolygon",
        ((PyObject*)&SbkQPolygon_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPolygon >("QPolygon");
    Shiboken::TypeResolver::createValueTypeResolver<QPolygon >(typeid(QPolygon).name());
}


} // extern "C"

