/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpainter_wrapper.h"

// Extra includes
#include <QPainterPath>
#include <QPixmap>
#include <QVector>
#include <QWidget>
#include <qbrush.h>
#include <qcolor.h>
#include <qfont.h>
#include <qimage.h>
#include <qline.h>
#include <qmatrix.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpainterpath.h>
#include <qpen.h>
#include <qpicture.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qpolygon.h>
#include <qrect.h>
#include <qregion.h>
#include <qstring.h>
#include <qtextoption.h>
#include <qtransform.h>
#include <qwidget.h>

using namespace Shiboken;

static int
SbkQPainter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPainter* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QPainter", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QPainter()
        cptr = new QPainter();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[0]);
        // QPainter(QPaintDevice*)
        cptr = new QPainter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPainter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPainter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPainter_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter", overloads);
        return -1;
}

static PyObject* SbkQPainterFunc_background(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // background()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPainter::background();
    py_result = Shiboken::Converter<QBrush & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_backgroundMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundMode()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    Qt::BGMode cpp_result = cppSelf->QPainter::backgroundMode();
    py_result = Shiboken::Converter<Qt::BGMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_begin(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(arg);
        // begin(QPaintDevice*)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainter::begin(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_begin_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPainterFunc_begin_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.begin", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_beginNativePainting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // beginNativePainting()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    cppSelf->QPainter::beginNativePainting();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPainterFunc_boundingRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterFunc_boundingRect_TypeError;

    if (!PyArg_UnpackTuple(args, "boundingRect", 2, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QString & >::isConvertible(pyargs[5])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        if (Shiboken::cppObjectIsInvalid(pyargs[5]))
            return 0;
        std::auto_ptr<QString > cpp_arg5_auto_ptr;
        QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
        if (!SbkQString_Check(pyargs[5]))
            cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
        // boundingRect(int,int,int,int,int,QString)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QPainter::boundingRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, *cpp_arg5);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // boundingRect(QRect,int,QString)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        QRect cpp_result = cppSelf->QPainter::boundingRect(*cpp_arg0, cpp_arg1, *cpp_arg2);
        py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // boundingRect(QRectF,int,QString)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            QRectF cpp_result = cppSelf->QPainter::boundingRect(*cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // boundingRect(QRectF,QString,QTextOption)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                QRectF cpp_result = cppSelf->QPainter::boundingRect(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QTextOption & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QTextOption > cpp_arg2_auto_ptr;
                QTextOption* cpp_arg2 = Shiboken::Converter<QTextOption* >::toCpp(pyargs[2]);
                if (!SbkQTextOption_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QTextOption >(cpp_arg2);
                // boundingRect(QRectF,QString,QTextOption)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                QRectF cpp_result = cppSelf->QPainter::boundingRect(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_boundingRect_TypeError;
        } else goto SbkQPainterFunc_boundingRect_TypeError;
    } else goto SbkQPainterFunc_boundingRect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPainterFunc_boundingRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, PySide.QtCore.QString", "PySide.QtCore.QRectF, PySide.QtCore.QString, PySide.QtGui.QTextOption = QTextOption()", "PySide.QtCore.QRectF, int, PySide.QtCore.QString", "int, int, int, int, int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.boundingRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_brush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brush()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QBrush & cpp_result = cppSelf->QPainter::brush();
    py_result = Shiboken::Converter<QBrush & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_brushOrigin(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // brushOrigin()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QPainter::brushOrigin();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_clipPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clipPath()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QPainterPath cpp_result = cppSelf->QPainter::clipPath();
    py_result = Shiboken::Converter<QPainterPath >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_clipRegion(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clipRegion()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QRegion cpp_result = cppSelf->QPainter::clipRegion();
    py_result = Shiboken::Converter<QRegion >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_combinedMatrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // combinedMatrix()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QMatrix cpp_result = cppSelf->QPainter::combinedMatrix();
    py_result = Shiboken::Converter<QMatrix >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_combinedTransform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // combinedTransform()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QTransform cpp_result = cppSelf->QPainter::combinedTransform();
    py_result = Shiboken::Converter<QTransform >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_compositionMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // compositionMode()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QPainter::CompositionMode cpp_result = cppSelf->QPainter::compositionMode();
    py_result = Shiboken::Converter<QPainter::CompositionMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QPaintDevice * cpp_result = cppSelf->QPainter::device();
    py_result = Shiboken::Converter<QPaintDevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_deviceMatrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // deviceMatrix()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QMatrix & cpp_result = cppSelf->QPainter::deviceMatrix();
    py_result = Shiboken::Converter<QMatrix & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_deviceTransform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // deviceTransform()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QTransform & cpp_result = cppSelf->QPainter::deviceTransform();
    py_result = Shiboken::Converter<QTransform & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_drawArc(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterFunc_drawArc_TypeError;

    if (!PyArg_UnpackTuple(args, "drawArc", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
        // drawArc(int,int,int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawArc(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawArc(QRect,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawArc(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawArc(QRectF,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawArc(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawArc_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawArc_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, int", "PySide.QtCore.QRectF, int, int", "int, int, int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawArc", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawChord(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterFunc_drawChord_TypeError;

    if (!PyArg_UnpackTuple(args, "drawChord", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
        // drawChord(int,int,int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawChord(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawChord(QRect,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawChord(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawChord(QRectF,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawChord(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawChord_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawChord_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, int", "PySide.QtCore.QRectF, int, int", "int, int, int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawChord", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawConvexPolygon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPolygon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!SbkQPolygon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // drawConvexPolygon(QPolygon)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawConvexPolygon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPolygonF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!SbkQPolygonF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // drawConvexPolygon(QPolygonF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawConvexPolygon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawConvexPolygon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawConvexPolygon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon", "PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawConvexPolygon", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawEllipse(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQPainterFunc_drawEllipse_TypeError;

    if (!PyArg_UnpackTuple(args, "drawEllipse", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // drawEllipse(int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawEllipse(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // drawEllipse(QRect)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawEllipse(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // drawEllipse(QRectF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawEllipse(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawEllipse(QPoint,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawEllipse(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        // drawEllipse(QPointF,qreal,qreal)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawEllipse(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawEllipse_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawEllipse_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, int, int", "PySide.QtCore.QPointF, float, float", "PySide.QtCore.QRect", "PySide.QtCore.QRectF", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawEllipse", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawImage(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawImage", 2, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QImage & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QImage* cpp_arg2 = Shiboken::Converter<QImage* >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawImage(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (numArgs == 4) {
                // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[4])) {
                int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                if (numArgs == 5) {
                    // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                    cppSelf->QPainter::drawImage(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[5])) {
                    int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                    if (numArgs == 6) {
                        // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                        cppSelf->QPainter::drawImage(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                        //CppGenerator::writeParentChildManagement
                    } else if (PyNumber_Check(pyargs[6])) {
                        int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                        if (numArgs == 7) {
                            // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                            cppSelf->QPainter::drawImage(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6);
                            //CppGenerator::writeParentChildManagement
                        } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[7])) {
                            QFlags<Qt::ImageConversionFlag> cpp_arg7 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[7]);
                            // drawImage(int,int,QImage,int,int,int,int,QFlags<Qt::ImageConversionFlag>)
                            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                            cppSelf->QPainter::drawImage(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7);
                            //CppGenerator::writeParentChildManagement
                        } else goto SbkQPainterFunc_drawImage_TypeError;
                    } else goto SbkQPainterFunc_drawImage_TypeError;
                } else goto SbkQPainterFunc_drawImage_TypeError;
            } else goto SbkQPainterFunc_drawImage_TypeError;
        } else goto SbkQPainterFunc_drawImage_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && Shiboken::Converter<QImage & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QImage* cpp_arg1 = Shiboken::Converter<QImage* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawImage(QRect,QImage)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // drawImage(QRect,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[3])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[3]);
                // drawImage(QRect,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawImage_TypeError;
        } else goto SbkQPainterFunc_drawImage_TypeError;
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QImage & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QImage* cpp_arg1 = Shiboken::Converter<QImage* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawImage(QRectF,QImage)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg2_auto_ptr;
            QRectF* cpp_arg2 = Shiboken::Converter<QRectF* >::toCpp(pyargs[2]);
            if (!SbkQRectF_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QRectF >(cpp_arg2);
            if (numArgs == 3) {
                // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[3])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[3]);
                // drawImage(QRectF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawImage_TypeError;
        } else goto SbkQPainterFunc_drawImage_TypeError;
    } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QImage & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QImage* cpp_arg1 = Shiboken::Converter<QImage* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawImage(QPoint,QImage)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // drawImage(QPoint,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[3])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[3]);
                // drawImage(QPoint,QImage,QRect,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawImage_TypeError;
        } else goto SbkQPainterFunc_drawImage_TypeError;
    } else if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QImage & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QImage* cpp_arg1 = Shiboken::Converter<QImage* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // drawImage(QPointF,QImage)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg2_auto_ptr;
            QRectF* cpp_arg2 = Shiboken::Converter<QRectF* >::toCpp(pyargs[2]);
            if (!SbkQRectF_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QRectF >(cpp_arg2);
            if (numArgs == 3) {
                // drawImage(QPointF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[3])) {
                QFlags<Qt::ImageConversionFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[3]);
                // drawImage(QPointF,QImage,QRectF,QFlags<Qt::ImageConversionFlag>)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawImage(*cpp_arg0, *cpp_arg1, *cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawImage_TypeError;
        } else goto SbkQPainterFunc_drawImage_TypeError;
    } else goto SbkQPainterFunc_drawImage_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawImage_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtGui.QImage", "PySide.QtCore.QPoint, PySide.QtGui.QImage, PySide.QtCore.QRect, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", "PySide.QtCore.QPointF, PySide.QtGui.QImage", "PySide.QtCore.QPointF, PySide.QtGui.QImage, PySide.QtCore.QRectF, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", "PySide.QtCore.QRect, PySide.QtGui.QImage", "PySide.QtCore.QRect, PySide.QtGui.QImage, PySide.QtCore.QRect, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", "PySide.QtCore.QRectF, PySide.QtGui.QImage", "PySide.QtCore.QRectF, PySide.QtGui.QImage, PySide.QtCore.QRectF, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", "int, int, PySide.QtGui.QImage, int = 0, int = 0, int = -1, int = -1, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawImage", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQPainterFunc_drawLine_TypeError;

    if (!PyArg_UnpackTuple(args, "drawLine", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // drawLine(int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLine(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // drawLine(QPoint,QPoint)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLine(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
        QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
        if (!SbkQPointF_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
        // drawLine(QPointF,QPointF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLine(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLine & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLine* cpp_arg0 = Shiboken::Converter<QLine* >::toCpp(pyargs[0]);
        // drawLine(QLine)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLine(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLineF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QLineF > cpp_arg0_auto_ptr;
        QLineF* cpp_arg0 = Shiboken::Converter<QLineF* >::toCpp(pyargs[0]);
        if (!SbkQLineF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QLineF >(cpp_arg0);
        // drawLine(QLineF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLine(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawLine_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawLine_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLine", "PySide.QtCore.QLineF", "PySide.QtCore.QPoint, PySide.QtCore.QPoint", "PySide.QtCore.QPointF, PySide.QtCore.QPointF", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawLine", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawLines(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QLine >  >::isConvertible(arg)) {
        QVector<QLine >  cpp_arg0 = Shiboken::Converter<QVector<QLine >  >::toCpp(arg);
        // drawLines(QVector<QLine>)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLines(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawLines_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawLines_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawLines", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawLinesF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QLineF >  >::isConvertible(arg)) {
        QVector<QLineF >  cpp_arg0 = Shiboken::Converter<QVector<QLineF >  >::toCpp(arg);
        // drawLines(QVector<QLineF>)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLines(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawLinesF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawLinesF_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawLinesF", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawLinesFromPoints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QPoint >  >::isConvertible(arg)) {
        QVector<QPoint >  cpp_arg0 = Shiboken::Converter<QVector<QPoint >  >::toCpp(arg);
        // drawLines(QVector<QPoint>)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLines(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawLinesFromPoints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawLinesFromPoints_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawLinesFromPoints", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawLinesFromPointsF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QPointF >  >::isConvertible(arg)) {
        QVector<QPointF >  cpp_arg0 = Shiboken::Converter<QVector<QPointF >  >::toCpp(arg);
        // drawLines(QVector<QPointF>)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawLines(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawLinesFromPointsF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawLinesFromPointsF_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawLinesFromPointsF", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainterPath & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(arg);
        // drawPath(QPainterPath)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPath(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawPath", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPicture(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawPicture", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QPicture & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QPicture* cpp_arg2 = Shiboken::Converter<QPicture* >::toCpp(pyargs[2]);
        // drawPicture(int,int,QPicture)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPicture(cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPicture & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPicture* cpp_arg1 = Shiboken::Converter<QPicture* >::toCpp(pyargs[1]);
        // drawPicture(QPoint,QPicture)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPicture(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPicture & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPicture* cpp_arg1 = Shiboken::Converter<QPicture* >::toCpp(pyargs[1]);
        // drawPicture(QPointF,QPicture)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPicture(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawPicture_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPicture_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtGui.QPicture", "PySide.QtCore.QPointF, PySide.QtGui.QPicture", "int, int, PySide.QtGui.QPicture", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawPicture", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPie(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterFunc_drawPie_TypeError;

    if (!PyArg_UnpackTuple(args, "drawPie", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (numArgs == 6 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
        int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
        // drawPie(int,int,int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPie(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawPie(QRect,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPie(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        // drawPie(QRectF,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPie(*cpp_arg0, cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawPie_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPie_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int, int", "PySide.QtCore.QRectF, int, int", "int, int, int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawPie", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 6 || numArgs == 8)
        goto SbkQPainterFunc_drawPixmap_TypeError;

    if (!PyArg_UnpackTuple(args, "drawPixmap", 2, 9, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7]), &(pyargs[8])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[4])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QPixmap > cpp_arg4_auto_ptr;
            QPixmap* cpp_arg4 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[4]);
            if (!SbkQPixmap_Check(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg4);
            if (numArgs == 5) {
                // drawPixmap(int,int,int,int,QPixmap)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawPixmap(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (numArgs == 9 && PyNumber_Check(pyargs[5]) && PyNumber_Check(pyargs[6]) && PyNumber_Check(pyargs[7]) && PyNumber_Check(pyargs[8])) {
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                int cpp_arg7 = Shiboken::Converter<int >::toCpp(pyargs[7]);
                int cpp_arg8 = Shiboken::Converter<int >::toCpp(pyargs[8]);
                // drawPixmap(int,int,int,int,QPixmap,int,int,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawPixmap(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5, cpp_arg6, cpp_arg7, cpp_arg8);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawPixmap_TypeError;
        } else if (Shiboken::Converter<QPixmap & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QPixmap > cpp_arg2_auto_ptr;
            QPixmap* cpp_arg2 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[2]);
            if (!SbkQPixmap_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg2);
            if (numArgs == 3) {
                // drawPixmap(int,int,QPixmap)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawPixmap(cpp_arg0, cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (numArgs == 7 && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5]) && PyNumber_Check(pyargs[6])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                // drawPixmap(int,int,QPixmap,int,int,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawPixmap(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawPixmap_TypeError;
        } else goto SbkQPainterFunc_drawPixmap_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (numArgs == 2) {
            // drawPixmap(QRect,QPixmap)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
            // drawPixmap(QRect,QPixmap,QRect)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawPixmap_TypeError;
    } else if (numArgs == 3 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1]) && Shiboken::Converter<QRectF & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg2_auto_ptr;
        QRectF* cpp_arg2 = Shiboken::Converter<QRectF* >::toCpp(pyargs[2]);
        if (!SbkQRectF_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QRectF >(cpp_arg2);
        // drawPixmap(QRectF,QPixmap,QRectF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (numArgs == 2) {
            // drawPixmap(QPoint,QPixmap)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QRect* cpp_arg2 = Shiboken::Converter<QRect* >::toCpp(pyargs[2]);
            // drawPixmap(QPoint,QPixmap,QRect)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawPixmap_TypeError;
    } else if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (numArgs == 2) {
            // drawPixmap(QPointF,QPixmap)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QRectF > cpp_arg2_auto_ptr;
            QRectF* cpp_arg2 = Shiboken::Converter<QRectF* >::toCpp(pyargs[2]);
            if (!SbkQRectF_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QRectF >(cpp_arg2);
            // drawPixmap(QPointF,QPixmap,QRectF)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPixmap(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawPixmap_TypeError;
    } else goto SbkQPainterFunc_drawPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPixmap_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtGui.QPixmap", "PySide.QtCore.QPoint, PySide.QtGui.QPixmap, PySide.QtCore.QRect", "PySide.QtCore.QPointF, PySide.QtGui.QPixmap", "PySide.QtCore.QPointF, PySide.QtGui.QPixmap, PySide.QtCore.QRectF", "PySide.QtCore.QRect, PySide.QtGui.QPixmap", "PySide.QtCore.QRect, PySide.QtGui.QPixmap, PySide.QtCore.QRect", "PySide.QtCore.QRectF, PySide.QtGui.QPixmap, PySide.QtCore.QRectF", "int, int, PySide.QtGui.QPixmap", "int, int, PySide.QtGui.QPixmap, int, int, int, int", "int, int, int, int, PySide.QtGui.QPixmap", "int, int, int, int, PySide.QtGui.QPixmap, int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawPixmap", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPoint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawPoint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // drawPoint(int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPoint(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // drawPoint(QPoint)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPoint(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // drawPoint(QPointF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPoint(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawPoint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPoint_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawPoint", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPoints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPolygon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!SbkQPolygon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // drawPoints(QPolygon)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPoints(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPolygonF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!SbkQPolygonF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // drawPoints(QPolygonF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPoints(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawPoints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPoints_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon", "PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawPoints", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPolygon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "drawPolygon", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPolygon & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(pyargs[0]);
        if (!SbkQPolygon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        if (numArgs == 1) {
            // drawPolygon(QPolygon,Qt::FillRule)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPolygon(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::FillRule >::isConvertible(pyargs[1])) {
            Qt::FillRule cpp_arg1 = Shiboken::Converter<Qt::FillRule >::toCpp(pyargs[1]);
            // drawPolygon(QPolygon,Qt::FillRule)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPolygon(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawPolygon_TypeError;
    } else if (Shiboken::Converter<QPolygonF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(pyargs[0]);
        if (!SbkQPolygonF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        if (numArgs == 1) {
            // drawPolygon(QPolygonF,Qt::FillRule)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPolygon(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::FillRule >::isConvertible(pyargs[1])) {
            Qt::FillRule cpp_arg1 = Shiboken::Converter<Qt::FillRule >::toCpp(pyargs[1]);
            // drawPolygon(QPolygonF,Qt::FillRule)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawPolygon(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawPolygon_TypeError;
    } else goto SbkQPainterFunc_drawPolygon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPolygon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon, PySide.QtCore.Qt.FillRule = Qt.OddEvenFill", "PySide.QtGui.QPolygonF, PySide.QtCore.Qt.FillRule = Qt.OddEvenFill", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawPolygon", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawPolyline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPolygon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygon > cpp_arg0_auto_ptr;
        QPolygon* cpp_arg0 = Shiboken::Converter<QPolygon* >::toCpp(arg);
        if (!SbkQPolygon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygon >(cpp_arg0);
        // drawPolyline(QPolygon)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPolyline(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPolygonF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPolygonF > cpp_arg0_auto_ptr;
        QPolygonF* cpp_arg0 = Shiboken::Converter<QPolygonF* >::toCpp(arg);
        if (!SbkQPolygonF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPolygonF >(cpp_arg0);
        // drawPolyline(QPolygonF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawPolyline(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawPolyline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawPolyline_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPolygon", "PySide.QtGui.QPolygonF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawPolyline", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQPainterFunc_drawRect_TypeError;

    if (!PyArg_UnpackTuple(args, "drawRect", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // drawRect(int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // drawRect(QRect)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // drawRect(QRectF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawRects(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QRect >  >::isConvertible(arg)) {
        QVector<QRect >  cpp_arg0 = Shiboken::Converter<QVector<QRect >  >::toCpp(arg);
        // drawRects(QVector<QRect>)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawRects(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawRects_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawRects_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawRects", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawRectsF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QRectF >  >::isConvertible(arg)) {
        QVector<QRectF >  cpp_arg0 = Shiboken::Converter<QVector<QRectF >  >::toCpp(arg);
        // drawRects(QVector<QRectF>)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawRects(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawRectsF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawRectsF_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.drawRectsF", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawRoundRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawRoundRect", 1, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // drawRoundRect(int,int,int,int,int,int)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[4])) {
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // drawRoundRect(int,int,int,int,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawRoundRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[5])) {
                int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
                // drawRoundRect(int,int,int,int,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawRoundRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawRoundRect_TypeError;
        } else goto SbkQPainterFunc_drawRoundRect_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // drawRoundRect(QRect,int,int)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundRect(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // drawRoundRect(QRect,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawRoundRect(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // drawRoundRect(QRect,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawRoundRect(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawRoundRect_TypeError;
        } else goto SbkQPainterFunc_drawRoundRect_TypeError;
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // drawRoundRect(QRectF,int,int)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundRect(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // drawRoundRect(QRectF,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawRoundRect(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // drawRoundRect(QRectF,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawRoundRect(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawRoundRect_TypeError;
        } else goto SbkQPainterFunc_drawRoundRect_TypeError;
    } else goto SbkQPainterFunc_drawRoundRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawRoundRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, int = 25, int = 25", "PySide.QtCore.QRectF, int = 25, int = 25", "int, int, int, int, int = 25, int = 25", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawRoundRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawRoundedRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 5)
        goto SbkQPainterFunc_drawRoundedRect_TypeError;

    if (!PyArg_UnpackTuple(args, "drawRoundedRect", 3, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && PyNumber_Check(pyargs[5])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        qreal cpp_arg4 = Shiboken::Converter<qreal >::toCpp(pyargs[4]);
        qreal cpp_arg5 = Shiboken::Converter<qreal >::toCpp(pyargs[5]);
        if (numArgs == 6) {
            // drawRoundedRect(int,int,int,int,qreal,qreal,Qt::SizeMode)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundedRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::SizeMode >::isConvertible(pyargs[6])) {
            Qt::SizeMode cpp_arg6 = Shiboken::Converter<Qt::SizeMode >::toCpp(pyargs[6]);
            // drawRoundedRect(int,int,int,int,qreal,qreal,Qt::SizeMode)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundedRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5, cpp_arg6);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawRoundedRect_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawRoundedRect(QRect,qreal,qreal,Qt::SizeMode)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundedRect(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::SizeMode >::isConvertible(pyargs[3])) {
            Qt::SizeMode cpp_arg3 = Shiboken::Converter<Qt::SizeMode >::toCpp(pyargs[3]);
            // drawRoundedRect(QRect,qreal,qreal,Qt::SizeMode)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundedRect(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawRoundedRect_TypeError;
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // drawRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundedRect(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::SizeMode >::isConvertible(pyargs[3])) {
            Qt::SizeMode cpp_arg3 = Shiboken::Converter<Qt::SizeMode >::toCpp(pyargs[3]);
            // drawRoundedRect(QRectF,qreal,qreal,Qt::SizeMode)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawRoundedRect(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawRoundedRect_TypeError;
    } else goto SbkQPainterFunc_drawRoundedRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawRoundedRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, float, float, PySide.QtCore.Qt.SizeMode = Qt.AbsoluteSize", "PySide.QtCore.QRectF, float, float, PySide.QtCore.Qt.SizeMode = Qt.AbsoluteSize", "int, int, int, int, float, float, PySide.QtCore.Qt.SizeMode = Qt.AbsoluteSize", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawRoundedRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4 || numArgs == 5)
        goto SbkQPainterFunc_drawText_TypeError;

    if (!PyArg_UnpackTuple(args, "drawText", 2, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 6 && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4]) && Shiboken::Converter<QString & >::isConvertible(pyargs[5])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                return 0;
            std::auto_ptr<QString > cpp_arg5_auto_ptr;
            QString* cpp_arg5 = Shiboken::Converter<QString* >::toCpp(pyargs[5]);
            if (!SbkQString_Check(pyargs[5]))
                cpp_arg5_auto_ptr = std::auto_ptr<QString >(cpp_arg5);
            // drawText(int,int,int,int,int,QString,QRect*)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_args,QRect* - START
            QRect rect_;
            cppSelf->drawText(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, *cpp_arg5, &rect_);
            py_result = Shiboken::Converter<QRect >::toPython(rect_);
            // TEMPLATE - fix_args,QRect* - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 3 && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // drawText(int,int,QString)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawText(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
            py_result = Py_None;
            Py_INCREF(Py_None);
        } else goto SbkQPainterFunc_drawText_TypeError;
    } else if (numArgs == 3 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        // drawText(QRect,int,QString,QRect*)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        // Begin code injection
        
        // TEMPLATE - fix_args,QRect* - START
        QRect rect_;
        cppSelf->drawText(*cpp_arg0, cpp_arg1, *cpp_arg2, &rect_);
        py_result = Shiboken::Converter<QRect >::toPython(rect_);
        // TEMPLATE - fix_args,QRect* - END
        
        // End of code injection


        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            // drawText(QRectF,int,QString,QRectF*)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            // Begin code injection
            
            // TEMPLATE - fix_args,QRectF* - START
            QRectF rect_;
            cppSelf->drawText(*cpp_arg0, cpp_arg1, *cpp_arg2, &rect_);
            py_result = Shiboken::Converter<QRectF >::toPython(rect_);
            // TEMPLATE - fix_args,QRectF* - END
            
            // End of code injection


            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // drawText(QRectF,QString,QTextOption)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawText(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
                py_result = Py_None;
                Py_INCREF(Py_None);
            } else if (Shiboken::Converter<QTextOption & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QTextOption > cpp_arg2_auto_ptr;
                QTextOption* cpp_arg2 = Shiboken::Converter<QTextOption* >::toCpp(pyargs[2]);
                if (!SbkQTextOption_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QTextOption >(cpp_arg2);
                // drawText(QRectF,QString,QTextOption)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawText(*cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
                py_result = Py_None;
                Py_INCREF(Py_None);
            } else goto SbkQPainterFunc_drawText_TypeError;
        } else goto SbkQPainterFunc_drawText_TypeError;
    } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // drawText(QPoint,QString)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawText(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // drawText(QPointF,QString)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawText(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQPainterFunc_drawText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPainterFunc_drawText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QString", "PySide.QtCore.QPointF, PySide.QtCore.QString", "PySide.QtCore.QRect, int, PySide.QtCore.QString, PySide.QtCore.QRect", "PySide.QtCore.QRectF, PySide.QtCore.QString, PySide.QtGui.QTextOption = QTextOption()", "PySide.QtCore.QRectF, int, PySide.QtCore.QString, PySide.QtCore.QRectF", "int, int, PySide.QtCore.QString", "int, int, int, int, int, PySide.QtCore.QString, PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawText", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawTextItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "drawTextItem", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QTextItem & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QTextItem* cpp_arg2 = Shiboken::Converter<QTextItem* >::toCpp(pyargs[2]);
        // drawTextItem(int,int,QTextItem)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawTextItem(cpp_arg0, cpp_arg1, *cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QTextItem & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTextItem* cpp_arg1 = Shiboken::Converter<QTextItem* >::toCpp(pyargs[1]);
        // drawTextItem(QPoint,QTextItem)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawTextItem(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QTextItem & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTextItem* cpp_arg1 = Shiboken::Converter<QTextItem* >::toCpp(pyargs[1]);
        // drawTextItem(QPointF,QTextItem)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::drawTextItem(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_drawTextItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawTextItem_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtGui.QTextItem", "PySide.QtCore.QPointF, PySide.QtGui.QTextItem", "int, int, PySide.QtGui.QTextItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawTextItem", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_drawTiledPixmap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 4)
        goto SbkQPainterFunc_drawTiledPixmap_TypeError;

    if (!PyArg_UnpackTuple(args, "drawTiledPixmap", 2, 7, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[4])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg4_auto_ptr;
        QPixmap* cpp_arg4 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[4]);
        if (!SbkQPixmap_Check(pyargs[4]))
            cpp_arg4_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg4);
        if (numArgs == 5) {
            // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawTiledPixmap(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[5])) {
            int cpp_arg5 = Shiboken::Converter<int >::toCpp(pyargs[5]);
            if (numArgs == 6) {
                // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawTiledPixmap(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[6])) {
                int cpp_arg6 = Shiboken::Converter<int >::toCpp(pyargs[6]);
                // drawTiledPixmap(int,int,int,int,QPixmap,int,int)
                QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
                cppSelf->QPainter::drawTiledPixmap(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4, cpp_arg5, cpp_arg6);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQPainterFunc_drawTiledPixmap_TypeError;
        } else goto SbkQPainterFunc_drawTiledPixmap_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (numArgs == 2) {
            // drawTiledPixmap(QRect,QPixmap,QPoint)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawTiledPixmap(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
            // drawTiledPixmap(QRect,QPixmap,QPoint)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawTiledPixmap(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawTiledPixmap_TypeError;
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPixmap > cpp_arg1_auto_ptr;
        QPixmap* cpp_arg1 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[1]);
        if (!SbkQPixmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg1);
        if (numArgs == 2) {
            // drawTiledPixmap(QRectF,QPixmap,QPointF)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawTiledPixmap(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QPointF > cpp_arg2_auto_ptr;
            QPointF* cpp_arg2 = Shiboken::Converter<QPointF* >::toCpp(pyargs[2]);
            if (!SbkQPointF_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QPointF >(cpp_arg2);
            // drawTiledPixmap(QRectF,QPixmap,QPointF)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::drawTiledPixmap(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_drawTiledPixmap_TypeError;
    } else goto SbkQPainterFunc_drawTiledPixmap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_drawTiledPixmap_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtGui.QPixmap, PySide.QtCore.QPoint = QPoint()", "PySide.QtCore.QRectF, PySide.QtGui.QPixmap, PySide.QtCore.QPointF = QPointF()", "int, int, int, int, PySide.QtGui.QPixmap, int = 0, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.drawTiledPixmap", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_end(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // end()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainter::end();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_endNativePainting(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // endNativePainting()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    cppSelf->QPainter::endNativePainting();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPainterFunc_eraseRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQPainterFunc_eraseRect_TypeError;

    if (!PyArg_UnpackTuple(args, "eraseRect", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // eraseRect(int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::eraseRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // eraseRect(QRect)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::eraseRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // eraseRect(QRectF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::eraseRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_eraseRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_eraseRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "PySide.QtCore.QRectF", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.eraseRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_fillPath(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fillPath", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainterPath & >::isConvertible(pyargs[0]) && Shiboken::Converter<QBrush & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
        QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
        if (!SbkQBrush_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
        // fillPath(QPainterPath,QBrush)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::fillPath(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_fillPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_fillPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath, PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.fillPath", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_fillRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3 || numArgs == 4)
        goto SbkQPainterFunc_fillRect_TypeError;

    if (!PyArg_UnpackTuple(args, "fillRect", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 5 && Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyargs[4])) {
            Qt::GlobalColor cpp_arg4 = Shiboken::Converter<Qt::GlobalColor >::toCpp(pyargs[4]);
            // fillRect(int,int,int,int,Qt::GlobalColor)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 5 && Shiboken::Converter<QColor & >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QColor > cpp_arg4_auto_ptr;
            QColor* cpp_arg4 = Shiboken::Converter<QColor* >::toCpp(pyargs[4]);
            if (!SbkQColor_Check(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QColor >(cpp_arg4);
            // fillRect(int,int,int,int,QColor)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 5 && Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyargs[4])) {
            Qt::BrushStyle cpp_arg4 = Shiboken::Converter<Qt::BrushStyle >::toCpp(pyargs[4]);
            // fillRect(int,int,int,int,Qt::BrushStyle)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 5 && Shiboken::Converter<QBrush & >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return 0;
            std::auto_ptr<QBrush > cpp_arg4_auto_ptr;
            QBrush* cpp_arg4 = Shiboken::Converter<QBrush* >::toCpp(pyargs[4]);
            if (!SbkQBrush_Check(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QBrush >(cpp_arg4);
            // fillRect(int,int,int,int,QBrush)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_fillRect_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 2 && Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyargs[1])) {
            Qt::GlobalColor cpp_arg1 = Shiboken::Converter<Qt::GlobalColor >::toCpp(pyargs[1]);
            // fillRect(QRect,Qt::GlobalColor)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyargs[1])) {
            Qt::BrushStyle cpp_arg1 = Shiboken::Converter<Qt::BrushStyle >::toCpp(pyargs[1]);
            // fillRect(QRect,Qt::BrushStyle)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // fillRect(QRect,QColor)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QBrush & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
            QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
            if (!SbkQBrush_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
            // fillRect(QRect,QBrush)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_fillRect_TypeError;
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 2 && Shiboken::Converter<Qt::GlobalColor >::isConvertible(pyargs[1])) {
            Qt::GlobalColor cpp_arg1 = Shiboken::Converter<Qt::GlobalColor >::toCpp(pyargs[1]);
            // fillRect(QRectF,Qt::GlobalColor)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<Qt::BrushStyle >::isConvertible(pyargs[1])) {
            Qt::BrushStyle cpp_arg1 = Shiboken::Converter<Qt::BrushStyle >::toCpp(pyargs[1]);
            // fillRect(QRectF,Qt::BrushStyle)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QColor & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QColor > cpp_arg1_auto_ptr;
            QColor* cpp_arg1 = Shiboken::Converter<QColor* >::toCpp(pyargs[1]);
            if (!SbkQColor_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QColor >(cpp_arg1);
            // fillRect(QRectF,QColor)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QBrush & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QBrush > cpp_arg1_auto_ptr;
            QBrush* cpp_arg1 = Shiboken::Converter<QBrush* >::toCpp(pyargs[1]);
            if (!SbkQBrush_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QBrush >(cpp_arg1);
            // fillRect(QRectF,QBrush)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::fillRect(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_fillRect_TypeError;
    } else goto SbkQPainterFunc_fillRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_fillRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtGui.QBrush", "PySide.QtCore.QRect, PySide.QtGui.QColor", "PySide.QtCore.QRect, PySide.QtCore.Qt.BrushStyle", "PySide.QtCore.QRect, PySide.QtCore.Qt.GlobalColor", "PySide.QtCore.QRectF, PySide.QtGui.QBrush", "PySide.QtCore.QRectF, PySide.QtGui.QColor", "PySide.QtCore.QRectF, PySide.QtCore.Qt.BrushStyle", "PySide.QtCore.QRectF, PySide.QtCore.Qt.GlobalColor", "int, int, int, int, PySide.QtCore.Qt.BrushStyle", "int, int, int, int, PySide.QtCore.Qt.GlobalColor", "int, int, int, int, PySide.QtGui.QBrush", "int, int, int, int, PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.fillRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QFont & cpp_result = cppSelf->QPainter::font();
    py_result = Shiboken::Converter<QFont & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_hasClipping(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasClipping()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainter::hasClipping();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_initFrom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // initFrom(const QWidget*)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::initFrom(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_initFrom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_initFrom_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.initFrom", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainter::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_layoutDirection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // layoutDirection()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    Qt::LayoutDirection cpp_result = cppSelf->QPainter::layoutDirection();
    py_result = Shiboken::Converter<Qt::LayoutDirection >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_opacity(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // opacity()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QPainter::opacity();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->QPainter::paintEngine();
    py_result = Shiboken::Converter<QPaintEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_pen(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pen()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QPen & cpp_result = cppSelf->QPainter::pen();
    py_result = Shiboken::Converter<QPen & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_renderHints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // renderHints()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QFlags<QPainter::RenderHint> cpp_result = cppSelf->QPainter::renderHints();
    py_result = Shiboken::Converter<QFlags<QPainter::RenderHint> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_resetMatrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetMatrix()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    cppSelf->QPainter::resetMatrix();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPainterFunc_resetTransform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // resetTransform()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    cppSelf->QPainter::resetTransform();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPainterFunc_restore(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // restore()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    cppSelf->QPainter::restore();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPainterFunc_restoreRedirected(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QPaintDevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(arg);
        // restoreRedirected(const QPaintDevice*)
        QPainter::restoreRedirected(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_restoreRedirected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_restoreRedirected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.restoreRedirected", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_rotate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // rotate(qreal)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::rotate(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_rotate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_rotate_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.rotate", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_save(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // save()
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    cppSelf->QPainter::save();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQPainterFunc_scale(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "scale", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // scale(qreal,qreal)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::scale(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_scale_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_scale_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.scale", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setBackground(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QBrush & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!SbkQBrush_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBackground(QBrush)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBackground(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setBackground_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setBackground_TypeError:
        const char* overloads[] = {"PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setBackground", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setBackgroundMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::BGMode >::isConvertible(arg)) {
        Qt::BGMode cpp_arg0 = Shiboken::Converter<Qt::BGMode >::toCpp(arg);
        // setBackgroundMode(Qt::BGMode)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBackgroundMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setBackgroundMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setBackgroundMode_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.BGMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setBackgroundMode", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setBrush(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::BrushStyle >::isConvertible(arg)) {
        Qt::BrushStyle cpp_arg0 = Shiboken::Converter<Qt::BrushStyle >::toCpp(arg);
        // setBrush(Qt::BrushStyle)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBrush(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QBrush & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QBrush > cpp_arg0_auto_ptr;
        QBrush* cpp_arg0 = Shiboken::Converter<QBrush* >::toCpp(arg);
        if (!SbkQBrush_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QBrush >(cpp_arg0);
        // setBrush(QBrush)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBrush(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setBrush_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setBrush_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.BrushStyle", "PySide.QtGui.QBrush", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setBrush", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setBrushOrigin(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setBrushOrigin", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setBrushOrigin(int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBrushOrigin(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // setBrushOrigin(QPoint)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBrushOrigin(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setBrushOrigin(QPointF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setBrushOrigin(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setBrushOrigin_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setBrushOrigin_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setBrushOrigin", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setClipPath(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setClipPath", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPainterPath & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setClipPath(QPainterPath,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipPath(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ClipOperation >::isConvertible(pyargs[1])) {
            Qt::ClipOperation cpp_arg1 = Shiboken::Converter<Qt::ClipOperation >::toCpp(pyargs[1]);
            // setClipPath(QPainterPath,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipPath(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setClipPath_TypeError;
    } else goto SbkQPainterFunc_setClipPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setClipPath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath, PySide.QtCore.Qt.ClipOperation = Qt.ReplaceClip", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setClipPath", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setClipRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQPainterFunc_setClipRect_TypeError;

    if (!PyArg_UnpackTuple(args, "setClipRect", 1, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (numArgs == 4) {
            // setClipRect(int,int,int,int,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ClipOperation >::isConvertible(pyargs[4])) {
            Qt::ClipOperation cpp_arg4 = Shiboken::Converter<Qt::ClipOperation >::toCpp(pyargs[4]);
            // setClipRect(int,int,int,int,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setClipRect_TypeError;
    } else if (Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setClipRect(QRect,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRect(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ClipOperation >::isConvertible(pyargs[1])) {
            Qt::ClipOperation cpp_arg1 = Shiboken::Converter<Qt::ClipOperation >::toCpp(pyargs[1]);
            // setClipRect(QRect,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRect(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setClipRect_TypeError;
    } else if (Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        if (numArgs == 1) {
            // setClipRect(QRectF,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRect(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ClipOperation >::isConvertible(pyargs[1])) {
            Qt::ClipOperation cpp_arg1 = Shiboken::Converter<Qt::ClipOperation >::toCpp(pyargs[1]);
            // setClipRect(QRectF,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRect(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setClipRect_TypeError;
    } else goto SbkQPainterFunc_setClipRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setClipRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect, PySide.QtCore.Qt.ClipOperation = Qt.ReplaceClip", "PySide.QtCore.QRectF, PySide.QtCore.Qt.ClipOperation = Qt.ReplaceClip", "int, int, int, int, PySide.QtCore.Qt.ClipOperation = Qt.ReplaceClip", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setClipRect", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setClipRegion(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setClipRegion", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QRegion & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRegion > cpp_arg0_auto_ptr;
        QRegion* cpp_arg0 = Shiboken::Converter<QRegion* >::toCpp(pyargs[0]);
        if (!SbkQRegion_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRegion >(cpp_arg0);
        if (numArgs == 1) {
            // setClipRegion(QRegion,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRegion(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::ClipOperation >::isConvertible(pyargs[1])) {
            Qt::ClipOperation cpp_arg1 = Shiboken::Converter<Qt::ClipOperation >::toCpp(pyargs[1]);
            // setClipRegion(QRegion,Qt::ClipOperation)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setClipRegion(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setClipRegion_TypeError;
    } else goto SbkQPainterFunc_setClipRegion_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setClipRegion_TypeError:
        const char* overloads[] = {"PySide.QtGui.QRegion, PySide.QtCore.Qt.ClipOperation = Qt.ReplaceClip", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setClipRegion", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setClipping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setClipping(bool)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setClipping(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setClipping_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setClipping_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setClipping", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setCompositionMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainter::CompositionMode >::isConvertible(arg)) {
        QPainter::CompositionMode cpp_arg0 = Shiboken::Converter<QPainter::CompositionMode >::toCpp(arg);
        // setCompositionMode(QPainter::CompositionMode)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setCompositionMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setCompositionMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setCompositionMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter.CompositionMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setCompositionMode", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setFont(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setFont", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setLayoutDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::LayoutDirection >::isConvertible(arg)) {
        Qt::LayoutDirection cpp_arg0 = Shiboken::Converter<Qt::LayoutDirection >::toCpp(arg);
        // setLayoutDirection(Qt::LayoutDirection)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setLayoutDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setLayoutDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setLayoutDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.LayoutDirection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setLayoutDirection", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setOpacity(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setOpacity(qreal)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setOpacity(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setOpacity_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setOpacity_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setOpacity", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setPen(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setPen(QColor)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setPen(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<Qt::PenStyle >::isConvertible(arg)) {
        Qt::PenStyle cpp_arg0 = Shiboken::Converter<Qt::PenStyle >::toCpp(arg);
        // setPen(Qt::PenStyle)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setPen(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPen & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPen > cpp_arg0_auto_ptr;
        QPen* cpp_arg0 = Shiboken::Converter<QPen* >::toCpp(arg);
        if (!SbkQPen_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPen >(cpp_arg0);
        // setPen(QPen)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setPen(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setPen_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setPen_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.PenStyle", "PySide.QtGui.QColor", "PySide.QtGui.QPen", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setPen", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setRedirected(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRedirected", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[0]) && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPaintDevice* cpp_arg0 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPaintDevice* cpp_arg1 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // setRedirected(const QPaintDevice*,QPaintDevice*,QPoint)
            QPainter::setRedirected(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QPoint & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QPoint* cpp_arg2 = Shiboken::Converter<QPoint* >::toCpp(pyargs[2]);
            // setRedirected(const QPaintDevice*,QPaintDevice*,QPoint)
            QPainter::setRedirected(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setRedirected_TypeError;
    } else goto SbkQPainterFunc_setRedirected_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setRedirected_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice, PySide.QtGui.QPaintDevice, PySide.QtCore.QPoint = QPoint()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setRedirected", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setRenderHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRenderHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QPainter::RenderHint >::isConvertible(pyargs[0])) {
        QPainter::RenderHint cpp_arg0 = Shiboken::Converter<QPainter::RenderHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setRenderHint(QPainter::RenderHint,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setRenderHint(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setRenderHint(QPainter::RenderHint,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setRenderHint(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setRenderHint_TypeError;
    } else goto SbkQPainterFunc_setRenderHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setRenderHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter.RenderHint, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setRenderHint", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setRenderHints(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRenderHints", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (SbkPySide_QtGui_QPainter_RenderHint_Check(pyargs[0])) {
        QFlags<QPainter::RenderHint> cpp_arg0 = Shiboken::Converter<QFlags<QPainter::RenderHint> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setRenderHints(QFlags<QPainter::RenderHint>,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setRenderHints(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setRenderHints(QFlags<QPainter::RenderHint>,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setRenderHints(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setRenderHints_TypeError;
    } else goto SbkQPainterFunc_setRenderHints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setRenderHints_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter.RenderHints, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setRenderHints", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setTransform(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTransform", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTransform & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setTransform(QTransform,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setTransform(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setTransform(QTransform,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setTransform(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setTransform_TypeError;
    } else goto SbkQPainterFunc_setTransform_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setTransform_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setTransform", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setViewTransformEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setViewTransformEnabled(bool)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setViewTransformEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setViewTransformEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setViewTransformEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setViewTransformEnabled", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setViewport(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQPainterFunc_setViewport_TypeError;

    if (!PyArg_UnpackTuple(args, "setViewport", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setViewport(int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setViewport(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // setViewport(QRect)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setViewport(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setViewport_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setViewport_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setViewport", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setWindow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQPainterFunc_setWindow_TypeError;

    if (!PyArg_UnpackTuple(args, "setWindow", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setWindow(int,int,int,int)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setWindow(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // setWindow(QRect)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setWindow(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setWindow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setWindow_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setWindow", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setWorldMatrix(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setWorldMatrix", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QMatrix & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setWorldMatrix(QMatrix,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setWorldMatrix(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setWorldMatrix(QMatrix,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setWorldMatrix(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setWorldMatrix_TypeError;
    } else goto SbkQPainterFunc_setWorldMatrix_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setWorldMatrix_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setWorldMatrix", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setWorldMatrixEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setWorldMatrixEnabled(bool)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::setWorldMatrixEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_setWorldMatrixEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setWorldMatrixEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.setWorldMatrixEnabled", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_setWorldTransform(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setWorldTransform", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QTransform & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setWorldTransform(QTransform,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setWorldTransform(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setWorldTransform(QTransform,bool)
            QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
            cppSelf->QPainter::setWorldTransform(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQPainterFunc_setWorldTransform_TypeError;
    } else goto SbkQPainterFunc_setWorldTransform_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_setWorldTransform_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTransform, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.setWorldTransform", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_shear(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "shear", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // shear(qreal,qreal)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::shear(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_shear_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_shear_TypeError:
        const char* overloads[] = {"float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.shear", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_strokePath(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "strokePath", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPainterPath & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPen & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPainterPath* cpp_arg0 = Shiboken::Converter<QPainterPath* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QPen > cpp_arg1_auto_ptr;
        QPen* cpp_arg1 = Shiboken::Converter<QPen* >::toCpp(pyargs[1]);
        if (!SbkQPen_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QPen >(cpp_arg1);
        // strokePath(QPainterPath,QPen)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::strokePath(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_strokePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_strokePath_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainterPath, PySide.QtGui.QPen", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.strokePath", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_testRenderHint(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPainter::RenderHint >::isConvertible(arg)) {
        QPainter::RenderHint cpp_arg0 = Shiboken::Converter<QPainter::RenderHint >::toCpp(arg);
        // testRenderHint(QPainter::RenderHint)const
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QPainter::testRenderHint(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_testRenderHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPainterFunc_testRenderHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter.RenderHint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPainter.testRenderHint", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_transform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // transform()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QTransform & cpp_result = cppSelf->QPainter::transform();
    py_result = Shiboken::Converter<QTransform & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translate(QPoint)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translate(QPointF)
        QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
        cppSelf->QPainter::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPainterFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QPainter.translate", overloads);
        return 0;
}

static PyObject* SbkQPainterFunc_viewTransformEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewTransformEnabled()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainter::viewTransformEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_viewport(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // viewport()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QPainter::viewport();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_window(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // window()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QPainter::window();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_worldMatrix(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // worldMatrix()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QMatrix & cpp_result = cppSelf->QPainter::worldMatrix();
    py_result = Shiboken::Converter<QMatrix & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_worldMatrixEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // worldMatrixEnabled()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainter::worldMatrixEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterFunc_worldTransform(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // worldTransform()const
    QPainter* cppSelf = Shiboken::Converter<QPainter* >::toCpp((PyObject*)self);
    const QTransform & cpp_result = cppSelf->QPainter::worldTransform();
    py_result = Shiboken::Converter<QTransform & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPainter_methods[] = {
    {"background", (PyCFunction)SbkQPainterFunc_background, METH_NOARGS},
    {"backgroundMode", (PyCFunction)SbkQPainterFunc_backgroundMode, METH_NOARGS},
    {"begin", (PyCFunction)SbkQPainterFunc_begin, METH_O},
    {"beginNativePainting", (PyCFunction)SbkQPainterFunc_beginNativePainting, METH_NOARGS},
    {"boundingRect", (PyCFunction)SbkQPainterFunc_boundingRect, METH_VARARGS},
    {"brush", (PyCFunction)SbkQPainterFunc_brush, METH_NOARGS},
    {"brushOrigin", (PyCFunction)SbkQPainterFunc_brushOrigin, METH_NOARGS},
    {"clipPath", (PyCFunction)SbkQPainterFunc_clipPath, METH_NOARGS},
    {"clipRegion", (PyCFunction)SbkQPainterFunc_clipRegion, METH_NOARGS},
    {"combinedMatrix", (PyCFunction)SbkQPainterFunc_combinedMatrix, METH_NOARGS},
    {"combinedTransform", (PyCFunction)SbkQPainterFunc_combinedTransform, METH_NOARGS},
    {"compositionMode", (PyCFunction)SbkQPainterFunc_compositionMode, METH_NOARGS},
    {"device", (PyCFunction)SbkQPainterFunc_device, METH_NOARGS},
    {"deviceMatrix", (PyCFunction)SbkQPainterFunc_deviceMatrix, METH_NOARGS},
    {"deviceTransform", (PyCFunction)SbkQPainterFunc_deviceTransform, METH_NOARGS},
    {"drawArc", (PyCFunction)SbkQPainterFunc_drawArc, METH_VARARGS},
    {"drawChord", (PyCFunction)SbkQPainterFunc_drawChord, METH_VARARGS},
    {"drawConvexPolygon", (PyCFunction)SbkQPainterFunc_drawConvexPolygon, METH_O},
    {"drawEllipse", (PyCFunction)SbkQPainterFunc_drawEllipse, METH_VARARGS},
    {"drawImage", (PyCFunction)SbkQPainterFunc_drawImage, METH_VARARGS},
    {"drawLine", (PyCFunction)SbkQPainterFunc_drawLine, METH_VARARGS},
    {"drawLines", (PyCFunction)SbkQPainterFunc_drawLines, METH_O},
    {"drawLinesF", (PyCFunction)SbkQPainterFunc_drawLinesF, METH_O},
    {"drawLinesFromPoints", (PyCFunction)SbkQPainterFunc_drawLinesFromPoints, METH_O},
    {"drawLinesFromPointsF", (PyCFunction)SbkQPainterFunc_drawLinesFromPointsF, METH_O},
    {"drawPath", (PyCFunction)SbkQPainterFunc_drawPath, METH_O},
    {"drawPicture", (PyCFunction)SbkQPainterFunc_drawPicture, METH_VARARGS},
    {"drawPie", (PyCFunction)SbkQPainterFunc_drawPie, METH_VARARGS},
    {"drawPixmap", (PyCFunction)SbkQPainterFunc_drawPixmap, METH_VARARGS},
    {"drawPoint", (PyCFunction)SbkQPainterFunc_drawPoint, METH_VARARGS},
    {"drawPoints", (PyCFunction)SbkQPainterFunc_drawPoints, METH_O},
    {"drawPolygon", (PyCFunction)SbkQPainterFunc_drawPolygon, METH_VARARGS},
    {"drawPolyline", (PyCFunction)SbkQPainterFunc_drawPolyline, METH_O},
    {"drawRect", (PyCFunction)SbkQPainterFunc_drawRect, METH_VARARGS},
    {"drawRects", (PyCFunction)SbkQPainterFunc_drawRects, METH_O},
    {"drawRectsF", (PyCFunction)SbkQPainterFunc_drawRectsF, METH_O},
    {"drawRoundRect", (PyCFunction)SbkQPainterFunc_drawRoundRect, METH_VARARGS},
    {"drawRoundedRect", (PyCFunction)SbkQPainterFunc_drawRoundedRect, METH_VARARGS},
    {"drawText", (PyCFunction)SbkQPainterFunc_drawText, METH_VARARGS},
    {"drawTextItem", (PyCFunction)SbkQPainterFunc_drawTextItem, METH_VARARGS},
    {"drawTiledPixmap", (PyCFunction)SbkQPainterFunc_drawTiledPixmap, METH_VARARGS},
    {"end", (PyCFunction)SbkQPainterFunc_end, METH_NOARGS},
    {"endNativePainting", (PyCFunction)SbkQPainterFunc_endNativePainting, METH_NOARGS},
    {"eraseRect", (PyCFunction)SbkQPainterFunc_eraseRect, METH_VARARGS},
    {"fillPath", (PyCFunction)SbkQPainterFunc_fillPath, METH_VARARGS},
    {"fillRect", (PyCFunction)SbkQPainterFunc_fillRect, METH_VARARGS},
    {"font", (PyCFunction)SbkQPainterFunc_font, METH_NOARGS},
    {"hasClipping", (PyCFunction)SbkQPainterFunc_hasClipping, METH_NOARGS},
    {"initFrom", (PyCFunction)SbkQPainterFunc_initFrom, METH_O},
    {"isActive", (PyCFunction)SbkQPainterFunc_isActive, METH_NOARGS},
    {"layoutDirection", (PyCFunction)SbkQPainterFunc_layoutDirection, METH_NOARGS},
    {"opacity", (PyCFunction)SbkQPainterFunc_opacity, METH_NOARGS},
    {"paintEngine", (PyCFunction)SbkQPainterFunc_paintEngine, METH_NOARGS},
    {"pen", (PyCFunction)SbkQPainterFunc_pen, METH_NOARGS},
    {"renderHints", (PyCFunction)SbkQPainterFunc_renderHints, METH_NOARGS},
    {"resetMatrix", (PyCFunction)SbkQPainterFunc_resetMatrix, METH_NOARGS},
    {"resetTransform", (PyCFunction)SbkQPainterFunc_resetTransform, METH_NOARGS},
    {"restore", (PyCFunction)SbkQPainterFunc_restore, METH_NOARGS},
    {"restoreRedirected", (PyCFunction)SbkQPainterFunc_restoreRedirected, METH_O|METH_STATIC},
    {"rotate", (PyCFunction)SbkQPainterFunc_rotate, METH_O},
    {"save", (PyCFunction)SbkQPainterFunc_save, METH_NOARGS},
    {"scale", (PyCFunction)SbkQPainterFunc_scale, METH_VARARGS},
    {"setBackground", (PyCFunction)SbkQPainterFunc_setBackground, METH_O},
    {"setBackgroundMode", (PyCFunction)SbkQPainterFunc_setBackgroundMode, METH_O},
    {"setBrush", (PyCFunction)SbkQPainterFunc_setBrush, METH_O},
    {"setBrushOrigin", (PyCFunction)SbkQPainterFunc_setBrushOrigin, METH_VARARGS},
    {"setClipPath", (PyCFunction)SbkQPainterFunc_setClipPath, METH_VARARGS},
    {"setClipRect", (PyCFunction)SbkQPainterFunc_setClipRect, METH_VARARGS},
    {"setClipRegion", (PyCFunction)SbkQPainterFunc_setClipRegion, METH_VARARGS},
    {"setClipping", (PyCFunction)SbkQPainterFunc_setClipping, METH_O},
    {"setCompositionMode", (PyCFunction)SbkQPainterFunc_setCompositionMode, METH_O},
    {"setFont", (PyCFunction)SbkQPainterFunc_setFont, METH_O},
    {"setLayoutDirection", (PyCFunction)SbkQPainterFunc_setLayoutDirection, METH_O},
    {"setOpacity", (PyCFunction)SbkQPainterFunc_setOpacity, METH_O},
    {"setPen", (PyCFunction)SbkQPainterFunc_setPen, METH_O},
    {"setRedirected", (PyCFunction)SbkQPainterFunc_setRedirected, METH_VARARGS|METH_STATIC},
    {"setRenderHint", (PyCFunction)SbkQPainterFunc_setRenderHint, METH_VARARGS},
    {"setRenderHints", (PyCFunction)SbkQPainterFunc_setRenderHints, METH_VARARGS},
    {"setTransform", (PyCFunction)SbkQPainterFunc_setTransform, METH_VARARGS},
    {"setViewTransformEnabled", (PyCFunction)SbkQPainterFunc_setViewTransformEnabled, METH_O},
    {"setViewport", (PyCFunction)SbkQPainterFunc_setViewport, METH_VARARGS},
    {"setWindow", (PyCFunction)SbkQPainterFunc_setWindow, METH_VARARGS},
    {"setWorldMatrix", (PyCFunction)SbkQPainterFunc_setWorldMatrix, METH_VARARGS},
    {"setWorldMatrixEnabled", (PyCFunction)SbkQPainterFunc_setWorldMatrixEnabled, METH_O},
    {"setWorldTransform", (PyCFunction)SbkQPainterFunc_setWorldTransform, METH_VARARGS},
    {"shear", (PyCFunction)SbkQPainterFunc_shear, METH_VARARGS},
    {"strokePath", (PyCFunction)SbkQPainterFunc_strokePath, METH_VARARGS},
    {"testRenderHint", (PyCFunction)SbkQPainterFunc_testRenderHint, METH_O},
    {"transform", (PyCFunction)SbkQPainterFunc_transform, METH_NOARGS},
    {"translate", (PyCFunction)SbkQPainterFunc_translate, METH_VARARGS},
    {"viewTransformEnabled", (PyCFunction)SbkQPainterFunc_viewTransformEnabled, METH_NOARGS},
    {"viewport", (PyCFunction)SbkQPainterFunc_viewport, METH_NOARGS},
    {"window", (PyCFunction)SbkQPainterFunc_window, METH_NOARGS},
    {"worldMatrix", (PyCFunction)SbkQPainterFunc_worldMatrix, METH_NOARGS},
    {"worldMatrixEnabled", (PyCFunction)SbkQPainterFunc_worldMatrixEnabled, METH_NOARGS},
    {"worldTransform", (PyCFunction)SbkQPainterFunc_worldTransform, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPainter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPainter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPainter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPainter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPainter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QPainter_CompositionMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPainter_CompositionMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPainter_CompositionMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "CompositionMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPainter_CompositionMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPainter_CompositionMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPainter_CompositionMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtGui_QPainter_RenderHint___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPainter::RenderHints >::toPython(
        ((QPainter::RenderHints) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QPainter::RenderHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QPainter_RenderHint___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPainter::RenderHints >::toPython(
        ((QPainter::RenderHints) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QPainter::RenderHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QPainter_RenderHint___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPainter::RenderHints >::toPython(
        ((QPainter::RenderHints) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QPainter::RenderHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QPainter_RenderHint___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QPainter::RenderHints >::toPython(
        ~ Shiboken::Converter< QPainter::RenderHints >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QPainter_RenderHint_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QPainter_RenderHint___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QPainter_RenderHint___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QPainter_RenderHint___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QPainter_RenderHint___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QPainter_RenderHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPainter_RenderHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPainter_RenderHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QPainter_RenderHint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPainter_RenderHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPainter_RenderHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPainter_RenderHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPainter_RenderHints_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPainter_RenderHints_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderHints",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QPainter_RenderHint_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPainter_RenderHints_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPainter_RenderHints_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QPainter_RenderHints_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QPainter(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPainter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPainter_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPainter_Type));
    PyModule_AddObject(module, "QPainter",
        ((PyObject*)&SbkQPainter_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: CompositionMode
    SbkPySide_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX] = &SbkPySide_QtGui_QPainter_CompositionMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPainter_CompositionMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPainter_CompositionMode_Type);
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
            "CompositionMode",((PyObject*)&SbkPySide_QtGui_QPainter_CompositionMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_SourceOver, "CompositionMode_SourceOver");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_SourceOver", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_SourceOver", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_DestinationOver, "CompositionMode_DestinationOver");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_DestinationOver", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_DestinationOver", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Clear, "CompositionMode_Clear");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Clear", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Clear", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Source, "CompositionMode_Source");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Source", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Source", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Destination, "CompositionMode_Destination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Destination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Destination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_SourceIn, "CompositionMode_SourceIn");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_SourceIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_SourceIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_DestinationIn, "CompositionMode_DestinationIn");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_DestinationIn", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_DestinationIn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_SourceOut, "CompositionMode_SourceOut");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_SourceOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_SourceOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_DestinationOut, "CompositionMode_DestinationOut");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_DestinationOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_DestinationOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_SourceAtop, "CompositionMode_SourceAtop");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_SourceAtop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_SourceAtop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_DestinationAtop, "CompositionMode_DestinationAtop");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_DestinationAtop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_DestinationAtop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Xor, "CompositionMode_Xor");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Xor", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Xor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Plus, "CompositionMode_Plus");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Plus", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Plus", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Multiply, "CompositionMode_Multiply");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Multiply", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Multiply", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Screen, "CompositionMode_Screen");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Screen", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Screen", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Overlay, "CompositionMode_Overlay");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Overlay", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Overlay", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Darken, "CompositionMode_Darken");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Darken", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Darken", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Lighten, "CompositionMode_Lighten");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Lighten", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Lighten", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_ColorDodge, "CompositionMode_ColorDodge");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_ColorDodge", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_ColorDodge", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_ColorBurn, "CompositionMode_ColorBurn");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_ColorBurn", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_ColorBurn", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_HardLight, "CompositionMode_HardLight");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_HardLight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_HardLight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_SoftLight, "CompositionMode_SoftLight");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_SoftLight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_SoftLight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Difference, "CompositionMode_Difference");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Difference", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Difference", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::CompositionMode_Exclusion, "CompositionMode_Exclusion");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "CompositionMode_Exclusion", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "CompositionMode_Exclusion", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_SourceOrDestination, "RasterOp_SourceOrDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_SourceOrDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_SourceOrDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_SourceAndDestination, "RasterOp_SourceAndDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_SourceAndDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_SourceAndDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_SourceXorDestination, "RasterOp_SourceXorDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_SourceXorDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_SourceXorDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_NotSourceAndNotDestination, "RasterOp_NotSourceAndNotDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_NotSourceAndNotDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_NotSourceAndNotDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_NotSourceOrNotDestination, "RasterOp_NotSourceOrNotDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_NotSourceOrNotDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_NotSourceOrNotDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_NotSourceXorDestination, "RasterOp_NotSourceXorDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_NotSourceXorDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_NotSourceXorDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_NotSource, "RasterOp_NotSource");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_NotSource", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_NotSource", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_NotSourceAndDestination, "RasterOp_NotSourceAndDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_NotSourceAndDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_NotSourceAndDestination", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_CompositionMode_Type,
        (long) QPainter::RasterOp_SourceAndNotDestination, "RasterOp_SourceAndNotDestination");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "RasterOp_SourceAndNotDestination", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_CompositionMode_Type.tp_dict,
        "RasterOp_SourceAndNotDestination", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPainter::CompositionMode");

    // init enum class: RenderHint
    SbkPySide_QtGuiTypes[SBK_QPAINTER_RENDERHINT_IDX] = &SbkPySide_QtGui_QPainter_RenderHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPainter_RenderHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPainter_RenderHint_Type);
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
            "RenderHint",((PyObject*)&SbkPySide_QtGui_QPainter_RenderHint_Type));

    // init flags class: QFlags<QPainter::RenderHint>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT__IDX] = &SbkPySide_QtGui_QPainter_RenderHints_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPainter_RenderHints_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPainter_RenderHints_Type);
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
            "RenderHints",((PyObject*)&SbkPySide_QtGui_QPainter_RenderHints_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_RenderHint_Type,
        (long) QPainter::Antialiasing, "Antialiasing");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "Antialiasing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_RenderHint_Type.tp_dict,
        "Antialiasing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_RenderHint_Type,
        (long) QPainter::TextAntialiasing, "TextAntialiasing");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "TextAntialiasing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_RenderHint_Type.tp_dict,
        "TextAntialiasing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_RenderHint_Type,
        (long) QPainter::SmoothPixmapTransform, "SmoothPixmapTransform");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "SmoothPixmapTransform", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_RenderHint_Type.tp_dict,
        "SmoothPixmapTransform", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_RenderHint_Type,
        (long) QPainter::HighQualityAntialiasing, "HighQualityAntialiasing");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "HighQualityAntialiasing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_RenderHint_Type.tp_dict,
        "HighQualityAntialiasing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPainter_RenderHint_Type,
        (long) QPainter::NonCosmeticDefaultPen, "NonCosmeticDefaultPen");
    PyDict_SetItemString(SbkQPainter_Type.super.ht_type.tp_dict,
        "NonCosmeticDefaultPen", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPainter_RenderHint_Type.tp_dict,
        "NonCosmeticDefaultPen", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPainter::RenderHint");

    Shiboken::TypeResolver::createObjectTypeResolver<QPainter >("QPainter*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPainter >(typeid(QPainter).name());
}


} // extern "C"

