/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qmoveevent_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QMoveEventWrapper::QMoveEventWrapper(const QPoint & pos, const QPoint & oldPos) : QMoveEvent(pos, oldPos) {
    // ... middle
}

QMoveEventWrapper::~QMoveEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQMoveEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMoveEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QMoveEvent", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // QMoveEvent(QPoint,QPoint)
        cptr = new QMoveEventWrapper(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQMoveEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QMoveEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQMoveEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQMoveEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QMoveEvent", overloads);
        return -1;
}

static PyObject* SbkQMoveEventFunc_oldPos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // oldPos()const
    QMoveEvent* cppSelf = Shiboken::Converter<QMoveEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QMoveEvent::oldPos();
    py_result = Shiboken::Converter<QPoint & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQMoveEventFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QMoveEvent* cppSelf = Shiboken::Converter<QMoveEvent* >::toCpp((PyObject*)self);
    const QPoint & cpp_result = cppSelf->QMoveEvent::pos();
    py_result = Shiboken::Converter<QPoint & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQMoveEvent_methods[] = {
    {"oldPos", (PyCFunction)SbkQMoveEventFunc_oldPos, METH_NOARGS},
    {"pos", (PyCFunction)SbkQMoveEventFunc_pos, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQMoveEvent_get_oldp(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QMoveEvent* >::toCpp((PyObject*)self)->oldp);
}
static int SbkQMoveEvent_set_oldp(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'oldp' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'oldp', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QMoveEvent* >::toCpp((PyObject*)self)->oldp = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

static PyObject* SbkQMoveEvent_get_p(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPoint >::toPython(Shiboken::Converter<QMoveEvent* >::toCpp((PyObject*)self)->p);
}
static int SbkQMoveEvent_set_p(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'p' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPoint >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'p', 'QPoint' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QMoveEvent* >::toCpp((PyObject*)self)->p = Shiboken::Converter<QPoint >::toCpp(value);

    return 0;
}

// Getters and Setters for QMoveEvent
static PyGetSetDef SbkQMoveEvent_getsetlist[] = {
    {const_cast<char*>("oldp"), (getter)SbkQMoveEvent_get_oldp, (setter)SbkQMoveEvent_set_oldp},
    {const_cast<char*>("p"), (getter)SbkQMoveEvent_get_p, (setter)SbkQMoveEvent_set_p},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMoveEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QMoveEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMoveEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQMoveEvent_getsetlist,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMoveEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QMoveEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQMoveEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQMoveEvent_Type);
     if ( reinterpret_cast<QMoveEvent*>(cptr)->type() == QEvent::Move)
        return &SbkQMoveEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QMoveEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QMOVEEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMoveEvent_Type);

    SbkQMoveEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQMoveEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQMoveEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQMoveEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQMoveEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMoveEvent_Type));
    PyModule_AddObject(module, "QMoveEvent",
        ((PyObject*)&SbkQMoveEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QMoveEvent >("QMoveEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QMoveEvent >(typeid(QMoveEvent).name());
}


} // extern "C"

