/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qlineedit_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcompleter.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qmenu.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvalidator.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QLineEditWrapper::QLineEditWrapper(QWidget * parent) : QLineEdit(parent), m_metaObject(0) {
    // ... middle
}

QLineEditWrapper::QLineEditWrapper(const QString & arg__1, QWidget * parent) : QLineEdit(arg__1, parent), m_metaObject(0) {
    // ... middle
}

void QLineEditWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLineEditWrapper::changeEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::changeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLineEditWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::contextMenuEvent(QContextMenuEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QLineEditWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::dragLeaveEvent(QDragLeaveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::dragLeaveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::dragMoveEvent(QDragMoveEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::dragMoveEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QLineEditWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QLineEdit::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QLineEditWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::focusInEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QLineEditWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::focusOutEvent(QFocusEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QLineEditWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::hideEvent(QHideEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QWidget::hideEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLineEditWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QLineEditWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QLineEdit::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::keyPressEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::keyReleaseEvent(QKeyEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QWidget::keyReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLineEditWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QLineEditWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QLineEditWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QLineEdit::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::mousePressEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::mousePressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::mouseReleaseEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::mouseReleaseEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QLineEditWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::paintEvent(QPaintEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QLineEdit::paintEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::resizeEvent(QResizeEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLineEditWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::showEvent(QShowEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QWidget::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QSize QLineEditWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QLineEdit::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QLineEdit.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QLineEditWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QLineEditWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QLineEditWrapper::wheelEvent(QWheelEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QWidget::wheelEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QLineEditWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QLineEdit::staticMetaObject);
}
    return m_metaObject;
}

int QLineEditWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QLineEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QLineEditWrapper::~QLineEditWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQLineEdit_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLineEditWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QLineEdit", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QLineEdit(QWidget*)
        cptr = new QLineEditWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QLineEdit(QString,QWidget*)
            cptr = new QLineEditWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QLineEdit(QString,QWidget*)
            cptr = new QLineEditWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQLineEdit_Init_TypeError;
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QLineEdit(QWidget*)
        cptr = new QLineEditWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQLineEdit_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QLineEdit >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLineEdit_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQLineEdit_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", "PySide.QtCore.QString, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLineEdit", overloads);
        return -1;
}

static PyObject* SbkQLineEditFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QLineEdit::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_backspace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // backspace()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::backspace();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_completer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completer()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QCompleter * cpp_result = cppSelf->QLineEdit::completer();
    py_result = Shiboken::Converter<QCompleter * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::contextMenuEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.contextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_copy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // copy()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::copy();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_createStandardContextMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // createStandardContextMenu()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QLineEdit::createStandardContextMenu();
    py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_cursorBackward(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cursorBackward", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // cursorBackward(bool,int)
            QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
            cppSelf->QLineEdit::cursorBackward(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // cursorBackward(bool,int)
            QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
            cppSelf->QLineEdit::cursorBackward(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLineEditFunc_cursorBackward_TypeError;
    } else goto SbkQLineEditFunc_cursorBackward_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_cursorBackward_TypeError:
        const char* overloads[] = {"bool, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLineEdit.cursorBackward", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_cursorForward(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "cursorForward", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // cursorForward(bool,int)
            QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
            cppSelf->QLineEdit::cursorForward(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // cursorForward(bool,int)
            QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
            cppSelf->QLineEdit::cursorForward(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQLineEditFunc_cursorForward_TypeError;
    } else goto SbkQLineEditFunc_cursorForward_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_cursorForward_TypeError:
        const char* overloads[] = {"bool, int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLineEdit.cursorForward", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_cursorPosition(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursorPosition()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLineEdit::cursorPosition();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_cursorPositionAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // cursorPositionAt(QPoint)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QLineEdit::cursorPositionAt(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_cursorPositionAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineEditFunc_cursorPositionAt_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.cursorPositionAt", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_cursorRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cursorRect()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QLineEdit::cursorRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_cursorWordBackward(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // cursorWordBackward(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::cursorWordBackward(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_cursorWordBackward_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_cursorWordBackward_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.cursorWordBackward", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_cursorWordForward(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // cursorWordForward(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::cursorWordForward(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_cursorWordForward_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_cursorWordForward_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.cursorWordForward", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_cut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // cut()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::cut();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_del_(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // del()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::del();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_deselect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // deselect()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::deselect();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_displayText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // displayText()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLineEdit::displayText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_dragEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dragEnabled()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::dragEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_dragEnterEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragEnterEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragEnterEvent* cpp_arg0 = Shiboken::Converter<QDragEnterEvent* >::toCpp(arg);
        // dragEnterEvent(QDragEnterEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::dragEnterEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_dragEnterEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_dragEnterEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragEnterEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.dragEnterEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_dragLeaveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragLeaveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragLeaveEvent* cpp_arg0 = Shiboken::Converter<QDragLeaveEvent* >::toCpp(arg);
        // dragLeaveEvent(QDragLeaveEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::dragLeaveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_dragLeaveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_dragLeaveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragLeaveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.dragLeaveEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_dragMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDragMoveEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDragMoveEvent* cpp_arg0 = Shiboken::Converter<QDragMoveEvent* >::toCpp(arg);
        // dragMoveEvent(QDragMoveEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::dragMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_dragMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_dragMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDragMoveEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.dragMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_dropEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDropEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDropEvent* cpp_arg0 = Shiboken::Converter<QDropEvent* >::toCpp(arg);
        // dropEvent(QDropEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::dropEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_dropEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_dropEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDropEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.dropEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_echoMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // echoMode()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QLineEdit::EchoMode cpp_result = cppSelf->QLineEdit::echoMode();
    py_result = Shiboken::Converter<QLineEdit::EchoMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_end(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // end(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::end(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_end_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_end_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.end", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QLineEdit::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineEditFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.event", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::focusInEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.focusInEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::focusOutEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.focusOutEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_getTextMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "getTextMargins", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int * cpp_arg0 = Shiboken::Converter<int * >::toCpp(pyargs[0]);
        int * cpp_arg1 = Shiboken::Converter<int * >::toCpp(pyargs[1]);
        int * cpp_arg2 = Shiboken::Converter<int * >::toCpp(pyargs[2]);
        int * cpp_arg3 = Shiboken::Converter<int * >::toCpp(pyargs[3]);
        // getTextMargins(int*,int*,int*,int*)const
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::getTextMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_getTextMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_getTextMargins_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLineEdit.getTextMargins", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_hasAcceptableInput(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasAcceptableInput()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::hasAcceptableInput();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_hasFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFrame()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::hasFrame();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_hasSelectedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasSelectedText()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::hasSelectedText();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_home(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // home(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::home(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_home_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_home_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.home", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_inputMask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // inputMask()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLineEdit::inputMask();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::inputMethodEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.inputMethodEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QLineEdit::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineEditFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.inputMethodQuery", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_insert(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // insert(QString)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::insert(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_insert_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_insert_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.insert", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_isModified(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isModified()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::isModified();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_isReadOnly(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadOnly()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::isReadOnly();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_isRedoAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRedoAvailable()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::isRedoAvailable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_isUndoAvailable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isUndoAvailable()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLineEdit::isUndoAvailable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_maxLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxLength()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLineEdit::maxLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLineEdit::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_mouseDoubleClickEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseDoubleClickEvent(QMouseEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::mouseDoubleClickEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_mouseDoubleClickEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_mouseDoubleClickEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.mouseDoubleClickEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_mouseMoveEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseMoveEvent(QMouseEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::mouseMoveEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_mouseMoveEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_mouseMoveEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.mouseMoveEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_paste(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // paste()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::paste();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_placeholderText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // placeholderText()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLineEdit::placeholderText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_redo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // redo()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::redo();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_selectAll(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // selectAll()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::selectAll();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_selectedText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectedText()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLineEdit::selectedText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_selectionStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // selectionStart()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLineEdit::selectionStart();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setAlignment(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setAlignment", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setCompleter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCompleter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCompleter* cpp_arg0 = Shiboken::Converter<QCompleter* >::toCpp(arg);
        // setCompleter(QCompleter*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setCompleter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQLineEditFunc_setCompleter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setCompleter_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCompleter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setCompleter", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setCursorPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCursorPosition(int)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setCursorPosition(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setCursorPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setCursorPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setCursorPosition", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setDragEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDragEnabled(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setDragEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setDragEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setDragEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setDragEnabled", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setEchoMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLineEdit::EchoMode >::isConvertible(arg)) {
        QLineEdit::EchoMode cpp_arg0 = Shiboken::Converter<QLineEdit::EchoMode >::toCpp(arg);
        // setEchoMode(QLineEdit::EchoMode)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setEchoMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setEchoMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setEchoMode_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLineEdit.EchoMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setEchoMode", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFrame(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setFrame(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setFrame_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setFrame", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setInputMask(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setInputMask(QString)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setInputMask(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setInputMask_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setInputMask_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setInputMask", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setMaxLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaxLength(int)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setMaxLength(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setMaxLength_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setMaxLength_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setMaxLength", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setModified(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setModified(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setModified(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setModified_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setModified_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setModified", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setPlaceholderText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setPlaceholderText(QString)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setPlaceholderText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setPlaceholderText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setPlaceholderText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setPlaceholderText", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setReadOnly(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setReadOnly(bool)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setReadOnly(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setReadOnly_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setReadOnly_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setReadOnly", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setSelection(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setSelection", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setSelection(int,int)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setSelection(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setSelection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setSelection_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLineEdit.setSelection", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setText", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setTextMargins(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto SbkQLineEditFunc_setTextMargins_TypeError;

    if (!PyArg_UnpackTuple(args, "setTextMargins", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setTextMargins(int,int,int,int)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setTextMargins(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QMargins & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMargins* cpp_arg0 = Shiboken::Converter<QMargins* >::toCpp(pyargs[0]);
        // setTextMargins(QMargins)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setTextMargins(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineEditFunc_setTextMargins_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setTextMargins_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMargins", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QLineEdit.setTextMargins", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_setValidator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QValidator * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QValidator* cpp_arg0 = Shiboken::Converter<QValidator* >::toCpp(arg);
        // setValidator(const QValidator*)
        QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
        cppSelf->QLineEdit::setValidator(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQLineEditFunc_setValidator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineEditFunc_setValidator_TypeError:
        const char* overloads[] = {"PySide.QtGui.QValidator", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QLineEdit.setValidator", overloads);
        return 0;
}

static PyObject* SbkQLineEditFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QLineEdit::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QLineEdit::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_textMargins(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textMargins()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    QMargins cpp_result = cppSelf->QLineEdit::textMargins();
    py_result = Shiboken::Converter<QMargins >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineEditFunc_undo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // undo()
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    cppSelf->QLineEdit::undo();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQLineEditFunc_validator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // validator()const
    QLineEdit* cppSelf = Shiboken::Converter<QLineEdit* >::toCpp((PyObject*)self);
    const QValidator * cpp_result = cppSelf->QLineEdit::validator();
    py_result = Shiboken::Converter<QValidator * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQLineEdit_methods[] = {
    {"alignment", (PyCFunction)SbkQLineEditFunc_alignment, METH_NOARGS},
    {"backspace", (PyCFunction)SbkQLineEditFunc_backspace, METH_NOARGS},
    {"changeEvent", (PyCFunction)SbkQLineEditFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQLineEditFunc_clear, METH_NOARGS},
    {"completer", (PyCFunction)SbkQLineEditFunc_completer, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQLineEditFunc_contextMenuEvent, METH_O},
    {"copy", (PyCFunction)SbkQLineEditFunc_copy, METH_NOARGS},
    {"createStandardContextMenu", (PyCFunction)SbkQLineEditFunc_createStandardContextMenu, METH_NOARGS},
    {"cursorBackward", (PyCFunction)SbkQLineEditFunc_cursorBackward, METH_VARARGS},
    {"cursorForward", (PyCFunction)SbkQLineEditFunc_cursorForward, METH_VARARGS},
    {"cursorPosition", (PyCFunction)SbkQLineEditFunc_cursorPosition, METH_NOARGS},
    {"cursorPositionAt", (PyCFunction)SbkQLineEditFunc_cursorPositionAt, METH_O},
    {"cursorRect", (PyCFunction)SbkQLineEditFunc_cursorRect, METH_NOARGS},
    {"cursorWordBackward", (PyCFunction)SbkQLineEditFunc_cursorWordBackward, METH_O},
    {"cursorWordForward", (PyCFunction)SbkQLineEditFunc_cursorWordForward, METH_O},
    {"cut", (PyCFunction)SbkQLineEditFunc_cut, METH_NOARGS},
    {"del_", (PyCFunction)SbkQLineEditFunc_del_, METH_NOARGS},
    {"deselect", (PyCFunction)SbkQLineEditFunc_deselect, METH_NOARGS},
    {"displayText", (PyCFunction)SbkQLineEditFunc_displayText, METH_NOARGS},
    {"dragEnabled", (PyCFunction)SbkQLineEditFunc_dragEnabled, METH_NOARGS},
    {"dragEnterEvent", (PyCFunction)SbkQLineEditFunc_dragEnterEvent, METH_O},
    {"dragLeaveEvent", (PyCFunction)SbkQLineEditFunc_dragLeaveEvent, METH_O},
    {"dragMoveEvent", (PyCFunction)SbkQLineEditFunc_dragMoveEvent, METH_O},
    {"dropEvent", (PyCFunction)SbkQLineEditFunc_dropEvent, METH_O},
    {"echoMode", (PyCFunction)SbkQLineEditFunc_echoMode, METH_NOARGS},
    {"end", (PyCFunction)SbkQLineEditFunc_end, METH_O},
    {"event", (PyCFunction)SbkQLineEditFunc_event, METH_O},
    {"focusInEvent", (PyCFunction)SbkQLineEditFunc_focusInEvent, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQLineEditFunc_focusOutEvent, METH_O},
    {"getTextMargins", (PyCFunction)SbkQLineEditFunc_getTextMargins, METH_VARARGS},
    {"hasAcceptableInput", (PyCFunction)SbkQLineEditFunc_hasAcceptableInput, METH_NOARGS},
    {"hasFrame", (PyCFunction)SbkQLineEditFunc_hasFrame, METH_NOARGS},
    {"hasSelectedText", (PyCFunction)SbkQLineEditFunc_hasSelectedText, METH_NOARGS},
    {"home", (PyCFunction)SbkQLineEditFunc_home, METH_O},
    {"inputMask", (PyCFunction)SbkQLineEditFunc_inputMask, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQLineEditFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQLineEditFunc_inputMethodQuery, METH_O},
    {"insert", (PyCFunction)SbkQLineEditFunc_insert, METH_O},
    {"isModified", (PyCFunction)SbkQLineEditFunc_isModified, METH_NOARGS},
    {"isReadOnly", (PyCFunction)SbkQLineEditFunc_isReadOnly, METH_NOARGS},
    {"isRedoAvailable", (PyCFunction)SbkQLineEditFunc_isRedoAvailable, METH_NOARGS},
    {"isUndoAvailable", (PyCFunction)SbkQLineEditFunc_isUndoAvailable, METH_NOARGS},
    {"keyPressEvent", (PyCFunction)SbkQLineEditFunc_keyPressEvent, METH_O},
    {"maxLength", (PyCFunction)SbkQLineEditFunc_maxLength, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQLineEditFunc_minimumSizeHint, METH_NOARGS},
    {"mouseDoubleClickEvent", (PyCFunction)SbkQLineEditFunc_mouseDoubleClickEvent, METH_O},
    {"mouseMoveEvent", (PyCFunction)SbkQLineEditFunc_mouseMoveEvent, METH_O},
    {"mousePressEvent", (PyCFunction)SbkQLineEditFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQLineEditFunc_mouseReleaseEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQLineEditFunc_paintEvent, METH_O},
    {"paste", (PyCFunction)SbkQLineEditFunc_paste, METH_NOARGS},
    {"placeholderText", (PyCFunction)SbkQLineEditFunc_placeholderText, METH_NOARGS},
    {"redo", (PyCFunction)SbkQLineEditFunc_redo, METH_NOARGS},
    {"selectAll", (PyCFunction)SbkQLineEditFunc_selectAll, METH_NOARGS},
    {"selectedText", (PyCFunction)SbkQLineEditFunc_selectedText, METH_NOARGS},
    {"selectionStart", (PyCFunction)SbkQLineEditFunc_selectionStart, METH_NOARGS},
    {"setAlignment", (PyCFunction)SbkQLineEditFunc_setAlignment, METH_O},
    {"setCompleter", (PyCFunction)SbkQLineEditFunc_setCompleter, METH_O},
    {"setCursorPosition", (PyCFunction)SbkQLineEditFunc_setCursorPosition, METH_O},
    {"setDragEnabled", (PyCFunction)SbkQLineEditFunc_setDragEnabled, METH_O},
    {"setEchoMode", (PyCFunction)SbkQLineEditFunc_setEchoMode, METH_O},
    {"setFrame", (PyCFunction)SbkQLineEditFunc_setFrame, METH_O},
    {"setInputMask", (PyCFunction)SbkQLineEditFunc_setInputMask, METH_O},
    {"setMaxLength", (PyCFunction)SbkQLineEditFunc_setMaxLength, METH_O},
    {"setModified", (PyCFunction)SbkQLineEditFunc_setModified, METH_O},
    {"setPlaceholderText", (PyCFunction)SbkQLineEditFunc_setPlaceholderText, METH_O},
    {"setReadOnly", (PyCFunction)SbkQLineEditFunc_setReadOnly, METH_O},
    {"setSelection", (PyCFunction)SbkQLineEditFunc_setSelection, METH_VARARGS},
    {"setText", (PyCFunction)SbkQLineEditFunc_setText, METH_O},
    {"setTextMargins", (PyCFunction)SbkQLineEditFunc_setTextMargins, METH_VARARGS},
    {"setValidator", (PyCFunction)SbkQLineEditFunc_setValidator, METH_O},
    {"sizeHint", (PyCFunction)SbkQLineEditFunc_sizeHint, METH_NOARGS},
    {"text", (PyCFunction)SbkQLineEditFunc_text, METH_NOARGS},
    {"textMargins", (PyCFunction)SbkQLineEditFunc_textMargins, METH_NOARGS},
    {"undo", (PyCFunction)SbkQLineEditFunc_undo, METH_NOARGS},
    {"validator", (PyCFunction)SbkQLineEditFunc_validator, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQLineEditSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QLineEdit* me = reinterpret_cast<QLineEdit*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLineEdit_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QLineEdit",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLineEdit_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLineEdit_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQLineEditSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QLineEdit >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QLineEdit_EchoMode_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QLineEdit_EchoMode_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QLineEdit_EchoMode_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EchoMode",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QLineEdit_EchoMode_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QLineEdit_EchoMode_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QLineEdit_EchoMode_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QLineEdit(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QLINEEDIT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLineEdit_Type);

    SbkQLineEdit_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQLineEdit_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQLineEdit_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQLineEdit_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLineEdit_Type));
    PyModule_AddObject(module, "QLineEdit",
        ((PyObject*)&SbkQLineEdit_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: EchoMode
    SbkPySide_QtGuiTypes[SBK_QLINEEDIT_ECHOMODE_IDX] = &SbkPySide_QtGui_QLineEdit_EchoMode_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QLineEdit_EchoMode_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QLineEdit_EchoMode_Type);
    PyDict_SetItemString(SbkQLineEdit_Type.super.ht_type.tp_dict,
            "EchoMode",((PyObject*)&SbkPySide_QtGui_QLineEdit_EchoMode_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLineEdit_EchoMode_Type,
        (long) QLineEdit::Normal, "Normal");
    PyDict_SetItemString(SbkQLineEdit_Type.super.ht_type.tp_dict,
        "Normal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLineEdit_EchoMode_Type.tp_dict,
        "Normal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLineEdit_EchoMode_Type,
        (long) QLineEdit::NoEcho, "NoEcho");
    PyDict_SetItemString(SbkQLineEdit_Type.super.ht_type.tp_dict,
        "NoEcho", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLineEdit_EchoMode_Type.tp_dict,
        "NoEcho", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLineEdit_EchoMode_Type,
        (long) QLineEdit::Password, "Password");
    PyDict_SetItemString(SbkQLineEdit_Type.super.ht_type.tp_dict,
        "Password", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLineEdit_EchoMode_Type.tp_dict,
        "Password", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QLineEdit_EchoMode_Type,
        (long) QLineEdit::PasswordEchoOnEdit, "PasswordEchoOnEdit");
    PyDict_SetItemString(SbkQLineEdit_Type.super.ht_type.tp_dict,
        "PasswordEchoOnEdit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QLineEdit_EchoMode_Type.tp_dict,
        "PasswordEchoOnEdit", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QLineEdit::EchoMode");

    Shiboken::TypeResolver::createObjectTypeResolver<QLineEdit >("QLineEdit*");
    Shiboken::TypeResolver::createObjectTypeResolver<QLineEdit >(typeid(QLineEdit).name());
}


} // extern "C"

