/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qitemselection_wrapper.h"

// Extra includes
#include <QList>
#include <QVector>
#include <qabstractitemmodel.h>
#include <qitemselectionmodel.h>

using namespace Shiboken;

static int
SbkQItemSelection_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QItemSelection* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QItemSelection", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QItemSelection()
        cptr = new QItemSelection();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // QItemSelection(QModelIndex,QModelIndex)
        cptr = new QItemSelection(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QItemSelection & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        // QItemSelection(QItemSelection)
        cptr = new QItemSelection(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelection_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QItemSelection >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQItemSelection_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQItemSelection_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection", "", "PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection", overloads);
        return -1;
}

static PyObject* SbkQItemSelectionFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // append(QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QList<QItemSelectionRange >  >::isConvertible(arg)) {
        QList<QItemSelectionRange >  cpp_arg0 = Shiboken::Converter<QList<QItemSelectionRange >  >::toCpp(arg);
        // append(QList<QItemSelectionRange>)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::append(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.append", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        const QItemSelectionRange & cpp_result = cppSelf->QItemSelection::at(cpp_arg0);
        py_result = Shiboken::Converter<QItemSelectionRange & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.at", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    cppSelf->QItemSelection::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQItemSelectionFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // contains(QModelIndex)const
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelection::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.contains", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_count(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // count()const
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QItemSelection::count();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // count(QItemSelectionRange)const
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QItemSelection::count(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_count_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_count_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.count", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_detachShared(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // detachShared()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    cppSelf->QItemSelection::detachShared();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQItemSelectionFunc_empty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // empty()const
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QItemSelection::empty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_endsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // endsWith(QItemSelectionRange)const
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelection::endsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_endsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_endsWith_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.endsWith", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_fromVector(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QVector<QItemSelectionRange >  >::isConvertible(arg)) {
        QVector<QItemSelectionRange >  cpp_arg0 = Shiboken::Converter<QVector<QItemSelectionRange >  >::toCpp(arg);
        // fromVector(QVector<QItemSelectionRange>)
        QList<QItemSelectionRange > cpp_result = QItemSelection::fromVector(cpp_arg0);
        py_result = Shiboken::Converter<QList<QItemSelectionRange > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_fromVector_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_fromVector_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.fromVector", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_indexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "indexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // indexOf(QItemSelectionRange,int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QItemSelection::indexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // indexOf(QItemSelectionRange,int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QItemSelection::indexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQItemSelectionFunc_indexOf_TypeError;
    } else goto SbkQItemSelectionFunc_indexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_indexOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.indexOf", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_indexes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // indexes()const
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    QList<QModelIndex > cpp_result = cppSelf->QItemSelection::indexes();
    py_result = Shiboken::Converter<QList<QModelIndex > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QItemSelection::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_lastIndexOf(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "lastIndexOf", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // lastIndexOf(QItemSelectionRange,int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QItemSelection::lastIndexOf(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // lastIndexOf(QItemSelectionRange,int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QItemSelection::lastIndexOf(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQItemSelectionFunc_lastIndexOf_TypeError;
    } else goto SbkQItemSelectionFunc_lastIndexOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_lastIndexOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.lastIndexOf", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelection::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_merge(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "merge", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QItemSelection & >::isConvertible(pyargs[0]) && SbkPySide_QtGui_QItemSelectionModel_SelectionFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelection* cpp_arg0 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[0]);
        QFlags<QItemSelectionModel::SelectionFlag> cpp_arg1 = Shiboken::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::toCpp(pyargs[1]);
        // merge(QItemSelection,QFlags<QItemSelectionModel::SelectionFlag>)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::merge(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_merge_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_merge_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelection, PySide.QtGui.QItemSelectionModel.SelectionFlags", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.merge", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_mid(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mid", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // mid(int,int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            QList<QItemSelectionRange > cpp_result = cppSelf->QItemSelection::mid(cpp_arg0);
            py_result = Shiboken::Converter<QList<QItemSelectionRange > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // mid(int,int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            QList<QItemSelectionRange > cpp_result = cppSelf->QItemSelection::mid(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QList<QItemSelectionRange > >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQItemSelectionFunc_mid_TypeError;
    } else goto SbkQItemSelectionFunc_mid_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_mid_TypeError:
        const char* overloads[] = {"int, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.mid", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_move(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "move", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // move(int,int)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::move(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_move_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_move_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.move", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_pop_back(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_back()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    cppSelf->QItemSelection::pop_back();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQItemSelectionFunc_pop_front(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // pop_front()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    cppSelf->QItemSelection::pop_front();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQItemSelectionFunc_prepend(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // prepend(QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::prepend(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_prepend_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_prepend_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.prepend", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_push_back(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // push_back(QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::push_back(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_push_back_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_push_back_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.push_back", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_push_front(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // push_front(QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::push_front(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_push_front_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_push_front_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.push_front", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_removeAll(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // removeAll(QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QItemSelection::removeAll(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_removeAll_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_removeAll_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.removeAll", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_removeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeAt(int)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::removeAt(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_removeAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_removeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.removeAt", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_removeFirst(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeFirst()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    cppSelf->QItemSelection::removeFirst();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQItemSelectionFunc_removeLast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // removeLast()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    cppSelf->QItemSelection::removeLast();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQItemSelectionFunc_removeOne(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // removeOne(QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelection::removeOne(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_removeOne_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_removeOne_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.removeOne", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_replace(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QItemSelectionRange & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemSelectionRange* cpp_arg1 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[1]);
        // replace(int,QItemSelectionRange)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::replace(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_replace_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_replace_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.replace", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_select(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "select", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
        // select(QModelIndex,QModelIndex)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::select(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_select_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_select_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.select", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_setSharable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSharable(bool)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::setSharable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_setSharable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_setSharable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.setSharable", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QItemSelection::size();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_split(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "split", 3, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (numArgs == 3 && Shiboken::Converter<QItemSelectionRange & >::isConvertible(pyargs[0]) && Shiboken::Converter<QItemSelectionRange & >::isConvertible(pyargs[1]) && Shiboken::Converter<QItemSelection * >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QItemSelectionRange* cpp_arg1 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        QItemSelection* cpp_arg2 = Shiboken::Converter<QItemSelection* >::toCpp(pyargs[2]);
        // split(QItemSelectionRange,QItemSelectionRange,QItemSelection*)
        QItemSelection::split(*cpp_arg0, *cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_split_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_split_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange, PySide.QtGui.QItemSelectionRange, PySide.QtGui.QItemSelection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.split", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_startsWith(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QItemSelectionRange & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QItemSelectionRange* cpp_arg0 = Shiboken::Converter<QItemSelectionRange* >::toCpp(arg);
        // startsWith(QItemSelectionRange)const
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QItemSelection::startsWith(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_startsWith_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_startsWith_TypeError:
        const char* overloads[] = {"PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.startsWith", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_swap(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "swap", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // swap(int,int)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        cppSelf->QItemSelection::swap(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_swap_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQItemSelectionFunc_swap_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.swap", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_takeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeAt(int)
        QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
        QItemSelectionRange cpp_result = cppSelf->QItemSelection::takeAt(cpp_arg0);
        py_result = Shiboken::Converter<QItemSelectionRange >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQItemSelectionFunc_takeAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_takeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemSelection.takeAt", overloads);
        return 0;
}

static PyObject* SbkQItemSelectionFunc_takeFirst(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // takeFirst()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    QItemSelectionRange cpp_result = cppSelf->QItemSelection::takeFirst();
    py_result = Shiboken::Converter<QItemSelectionRange >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_takeLast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // takeLast()
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    QItemSelectionRange cpp_result = cppSelf->QItemSelection::takeLast();
    py_result = Shiboken::Converter<QItemSelectionRange >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_toVector(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toVector()const
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    QVector<QItemSelectionRange > cpp_result = cppSelf->QItemSelection::toVector();
    py_result = Shiboken::Converter<QVector<QItemSelectionRange > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQItemSelectionFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // value(int)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            QItemSelectionRange cpp_result = cppSelf->QItemSelection::value(cpp_arg0);
            py_result = Shiboken::Converter<QItemSelectionRange >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QItemSelectionRange & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QItemSelectionRange* cpp_arg1 = Shiboken::Converter<QItemSelectionRange* >::toCpp(pyargs[1]);
            // value(int,QItemSelectionRange)const
            QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
            QItemSelectionRange cpp_result = cppSelf->QItemSelection::value(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QItemSelectionRange >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQItemSelectionFunc_value_TypeError;
    } else goto SbkQItemSelectionFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemSelectionFunc_value_TypeError:
        const char* overloads[] = {"int", "int, PySide.QtGui.QItemSelectionRange", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QItemSelection.value", overloads);
        return 0;
}

static PyMethodDef SbkQItemSelection_methods[] = {
    {"append", (PyCFunction)SbkQItemSelectionFunc_append, METH_O},
    {"at", (PyCFunction)SbkQItemSelectionFunc_at, METH_O},
    {"clear", (PyCFunction)SbkQItemSelectionFunc_clear, METH_NOARGS},
    {"contains", (PyCFunction)SbkQItemSelectionFunc_contains, METH_O},
    {"count", (PyCFunction)SbkQItemSelectionFunc_count, METH_NOARGS|METH_O},
    {"detachShared", (PyCFunction)SbkQItemSelectionFunc_detachShared, METH_NOARGS},
    {"empty", (PyCFunction)SbkQItemSelectionFunc_empty, METH_NOARGS},
    {"endsWith", (PyCFunction)SbkQItemSelectionFunc_endsWith, METH_O},
    {"fromVector", (PyCFunction)SbkQItemSelectionFunc_fromVector, METH_O|METH_STATIC},
    {"indexOf", (PyCFunction)SbkQItemSelectionFunc_indexOf, METH_VARARGS},
    {"indexes", (PyCFunction)SbkQItemSelectionFunc_indexes, METH_NOARGS},
    {"isEmpty", (PyCFunction)SbkQItemSelectionFunc_isEmpty, METH_NOARGS},
    {"lastIndexOf", (PyCFunction)SbkQItemSelectionFunc_lastIndexOf, METH_VARARGS},
    {"length", (PyCFunction)SbkQItemSelectionFunc_length, METH_NOARGS},
    {"merge", (PyCFunction)SbkQItemSelectionFunc_merge, METH_VARARGS},
    {"mid", (PyCFunction)SbkQItemSelectionFunc_mid, METH_VARARGS},
    {"move", (PyCFunction)SbkQItemSelectionFunc_move, METH_VARARGS},
    {"pop_back", (PyCFunction)SbkQItemSelectionFunc_pop_back, METH_NOARGS},
    {"pop_front", (PyCFunction)SbkQItemSelectionFunc_pop_front, METH_NOARGS},
    {"prepend", (PyCFunction)SbkQItemSelectionFunc_prepend, METH_O},
    {"push_back", (PyCFunction)SbkQItemSelectionFunc_push_back, METH_O},
    {"push_front", (PyCFunction)SbkQItemSelectionFunc_push_front, METH_O},
    {"removeAll", (PyCFunction)SbkQItemSelectionFunc_removeAll, METH_O},
    {"removeAt", (PyCFunction)SbkQItemSelectionFunc_removeAt, METH_O},
    {"removeFirst", (PyCFunction)SbkQItemSelectionFunc_removeFirst, METH_NOARGS},
    {"removeLast", (PyCFunction)SbkQItemSelectionFunc_removeLast, METH_NOARGS},
    {"removeOne", (PyCFunction)SbkQItemSelectionFunc_removeOne, METH_O},
    {"replace", (PyCFunction)SbkQItemSelectionFunc_replace, METH_VARARGS},
    {"select", (PyCFunction)SbkQItemSelectionFunc_select, METH_VARARGS},
    {"setSharable", (PyCFunction)SbkQItemSelectionFunc_setSharable, METH_O},
    {"size", (PyCFunction)SbkQItemSelectionFunc_size, METH_NOARGS},
    {"split", (PyCFunction)SbkQItemSelectionFunc_split, METH_VARARGS|METH_STATIC},
    {"startsWith", (PyCFunction)SbkQItemSelectionFunc_startsWith, METH_O},
    {"swap", (PyCFunction)SbkQItemSelectionFunc_swap, METH_VARARGS},
    {"takeAt", (PyCFunction)SbkQItemSelectionFunc_takeAt, METH_O},
    {"takeFirst", (PyCFunction)SbkQItemSelectionFunc_takeFirst, METH_NOARGS},
    {"takeLast", (PyCFunction)SbkQItemSelectionFunc_takeLast, METH_NOARGS},
    {"toVector", (PyCFunction)SbkQItemSelectionFunc_toVector, METH_NOARGS},
    {"value", (PyCFunction)SbkQItemSelectionFunc_value, METH_VARARGS},
    {0} // Sentinel
};

// type has number operators
static PyNumberMethods SbkQItemSelection_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

Py_ssize_t SbkQItemSelectionFunc___len__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    QItemSelection* cppSelf = Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    return cppSelf->count();
    
    // End of code injection
}

static PySequenceMethods PyQItemSelection_as_sequence = {
    /*sq_length*/ &SbkQItemSelectionFunc___len__,
    /*sq_concat*/ 0,
    /*sq_repeat*/ 0,
    /*sq_item*/ 0,
    /*sq_slice*/ 0,
    /*sq_ass_item*/ 0,
    /*sq_ass_slice*/ 0,
    /*sq_contains*/ 0,
    /*sq_inplace_concat*/ 0,
    /*sq_inplace_repeat*/ 0
};

// Rich comparison
static PyObject* SbkQItemSelection_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QItemSelection& cpp_self = *Shiboken::Converter<QItemSelection* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QList<QItemSelectionRange >  >::isConvertible(other)) {
                // operator!=(const QList<QItemSelectionRange > & l) const
                const QList<QItemSelectionRange > & cpp_other = Shiboken::Converter<QList<QItemSelectionRange >  >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQItemSelection_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QList<QItemSelectionRange >  >::isConvertible(other)) {
                // operator==(const QList<QItemSelectionRange > & l) const
                const QList<QItemSelectionRange > & cpp_other = Shiboken::Converter<QList<QItemSelectionRange >  >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQItemSelection_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQItemSelection_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQItemSelection_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QItemSelection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQItemSelection_as_number,
    /*tp_as_sequence*/      &PyQItemSelection_as_sequence,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQItemSelection_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQItemSelection_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQItemSelection_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QItemSelection >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QItemSelection(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QITEMSELECTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQItemSelection_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQItemSelection_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQItemSelection_Type));
    PyModule_AddObject(module, "QItemSelection",
        ((PyObject*)&SbkQItemSelection_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QItemSelection >("QItemSelection");
    Shiboken::TypeResolver::createValueTypeResolver<QItemSelection >(typeid(QItemSelection).name());
}


} // extern "C"

