/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qitemeditorcreatorbase_wrapper.h"

// Extra includes
#include <qbytearray.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QItemEditorCreatorBaseWrapper::QItemEditorCreatorBaseWrapper() : QItemEditorCreatorBase() {
    // ... middle
}

QWidget * QItemEditorCreatorBaseWrapper::createWidget(QWidget * parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "createWidget"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QItemEditorCreatorBase.createWidget()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWidget * >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QWidget * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemEditorCreatorBase.createWidget", SbkType<QWidget * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QWidget * cpp_result(Shiboken::Converter<QWidget * >::toCpp(py_result));
    return cpp_result;
}

QByteArray QItemEditorCreatorBaseWrapper::valuePropertyName() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "valuePropertyName"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QItemEditorCreatorBase.valuePropertyName()' not implemented.");
        return QByteArray();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QByteArray();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QByteArray >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QItemEditorCreatorBase.valuePropertyName", SbkType<QByteArray >()->tp_name, py_result->ob_type->tp_name);
        return QByteArray();
    }
    QByteArray cpp_result(Shiboken::Converter<QByteArray >::toCpp(py_result));
    return cpp_result;
}

QItemEditorCreatorBaseWrapper::~QItemEditorCreatorBaseWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQItemEditorCreatorBase_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QItemEditorCreatorBaseWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QITEMEDITORCREATORBASE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QItemEditorCreatorBase' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QItemEditorCreatorBase()
    cptr = new QItemEditorCreatorBaseWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QItemEditorCreatorBase >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQItemEditorCreatorBaseFunc_createWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // createWidget(QWidget*)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QItemEditorCreatorBase.createWidget()' not implemented.");
            return 0;
        }
        QItemEditorCreatorBase* cppSelf = Shiboken::Converter<QItemEditorCreatorBase* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->createWidget(cpp_arg0);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQItemEditorCreatorBaseFunc_createWidget_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQItemEditorCreatorBaseFunc_createWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QItemEditorCreatorBase.createWidget", overloads);
        return 0;
}

static PyObject* SbkQItemEditorCreatorBaseFunc_valuePropertyName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // valuePropertyName()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QItemEditorCreatorBase.valuePropertyName()' not implemented.");
        return 0;
    }
    QItemEditorCreatorBase* cppSelf = Shiboken::Converter<QItemEditorCreatorBase* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->valuePropertyName();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQItemEditorCreatorBase_methods[] = {
    {"createWidget", (PyCFunction)SbkQItemEditorCreatorBaseFunc_createWidget, METH_O},
    {"valuePropertyName", (PyCFunction)SbkQItemEditorCreatorBaseFunc_valuePropertyName, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQItemEditorCreatorBase_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QItemEditorCreatorBase",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQItemEditorCreatorBase_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQItemEditorCreatorBase_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QItemEditorCreatorBase >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQItemEditorCreatorBase_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQItemEditorCreatorBase_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QItemEditorCreatorBase*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QItemEditorCreatorBase(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QITEMEDITORCREATORBASE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQItemEditorCreatorBase_Type);

    // Fill type discovery information
    SbkQItemEditorCreatorBase_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQItemEditorCreatorBase_Type.type_discovery->addTypeDiscoveryFunction(&SbkQItemEditorCreatorBase_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQItemEditorCreatorBase_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQItemEditorCreatorBase_Type));
    PyModule_AddObject(module, "QItemEditorCreatorBase",
        ((PyObject*)&SbkQItemEditorCreatorBase_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QItemEditorCreatorBase >("QItemEditorCreatorBase*");
    Shiboken::TypeResolver::createObjectTypeResolver<QItemEditorCreatorBase >(typeid(QItemEditorCreatorBase).name());
}


} // extern "C"

