/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qimagereader_wrapper.h"

// Extra includes
#include <QColor>
#include <QImage>
#include <QList>
#include <QRect>
#include <QSize>
#include <QStringList>
#include <qbytearray.h>
#include <qcolor.h>
#include <qimage.h>
#include <qimagereader.h>
#include <qiodevice.h>
#include <qrect.h>
#include <qsize.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQImageReader_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QImageReader* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QImageReader", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QImageReader()
        cptr = new QImageReader();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QImageReader(QString,QByteArray)
            cptr = new QImageReader(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // QImageReader(QString,QByteArray)
            cptr = new QImageReader(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQImageReader_Init_TypeError;
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QImageReader(QIODevice*,QByteArray)
            cptr = new QImageReader(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QByteArray > cpp_arg1_auto_ptr;
            QByteArray* cpp_arg1 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[1]);
            if (!SbkQByteArray_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg1);
            // QImageReader(QIODevice*,QByteArray)
            cptr = new QImageReader(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQImageReader_Init_TypeError;
    } else goto SbkQImageReader_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QImageReader >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQImageReader_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQImageReader_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice, PySide.QtCore.QByteArray = QByteArray()", "PySide.QtCore.QString, PySide.QtCore.QByteArray = QByteArray()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QImageReader", overloads);
        return -1;
}

static PyObject* SbkQImageReaderFunc_autoDetectImageFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoDetectImageFormat()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QImageReader::autoDetectImageFormat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_backgroundColor(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // backgroundColor()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QColor cpp_result = cppSelf->QImageReader::backgroundColor();
    py_result = Shiboken::Converter<QColor >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_canRead(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // canRead()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QImageReader::canRead();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_clipRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // clipRect()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QImageReader::clipRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_currentImageNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentImageNumber()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageReader::currentImageNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_currentImageRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentImageRect()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QImageReader::currentImageRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_decideFormatFromContent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // decideFormatFromContent()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QImageReader::decideFormatFromContent();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_device(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // device()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QIODevice * cpp_result = cppSelf->QImageReader::device();
    py_result = Shiboken::Converter<QIODevice * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QImageReader::ImageReaderError cpp_result = cppSelf->QImageReader::error();
    py_result = Shiboken::Converter<QImageReader::ImageReaderError >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QImageReader::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QImageReader::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_format(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // format()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QByteArray cpp_result = cppSelf->QImageReader::format();
    py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_imageCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // imageCount()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageReader::imageCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_imageFormat(PyObject* self, PyObject* arg)
{
    if (self) {
        if (Shiboken::cppObjectIsInvalid(self))
            return 0;
    }

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // imageFormat()const
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        QImage::Format cpp_result = cppSelf->QImageReader::imageFormat();
        py_result = Shiboken::Converter<QImage::Format >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // imageFormat(QString)
        QByteArray cpp_result = QImageReader::imageFormat(*cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // imageFormat(QIODevice*)
        QByteArray cpp_result = QImageReader::imageFormat(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_imageFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQImageReaderFunc_imageFormat_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QIODevice", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.imageFormat", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_jumpToImage(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // jumpToImage(int)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QImageReader::jumpToImage(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_jumpToImage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQImageReaderFunc_jumpToImage_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.jumpToImage", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_jumpToNextImage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // jumpToNextImage()
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QImageReader::jumpToNextImage();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_loopCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // loopCount()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageReader::loopCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_nextImageDelay(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nextImageDelay()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageReader::nextImageDelay();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_quality(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // quality()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QImageReader::quality();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_read(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // read()
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QImage cpp_result = cppSelf->QImageReader::read();
    py_result = Shiboken::Converter<QImage >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_scaledClipRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scaledClipRect()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QImageReader::scaledClipRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_scaledSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scaledSize()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QImageReader::scaledSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_setAutoDetectImageFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoDetectImageFormat(bool)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setAutoDetectImageFormat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setAutoDetectImageFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setAutoDetectImageFormat_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setAutoDetectImageFormat", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setBackgroundColor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QColor & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QColor > cpp_arg0_auto_ptr;
        QColor* cpp_arg0 = Shiboken::Converter<QColor* >::toCpp(arg);
        if (!SbkQColor_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QColor >(cpp_arg0);
        // setBackgroundColor(QColor)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setBackgroundColor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setBackgroundColor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setBackgroundColor_TypeError:
        const char* overloads[] = {"PySide.QtGui.QColor", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setBackgroundColor", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setClipRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setClipRect(QRect)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setClipRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setClipRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setClipRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setClipRect", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setDecideFormatFromContent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDecideFormatFromContent(bool)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setDecideFormatFromContent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setDecideFormatFromContent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setDecideFormatFromContent_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setDecideFormatFromContent", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setDevice(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIODevice * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(arg);
        // setDevice(QIODevice*)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setDevice(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQImageReaderFunc_setDevice_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setDevice_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setDevice", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setFileName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setFileName", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QByteArray & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(arg);
        if (!SbkQByteArray_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        // setFormat(QByteArray)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setFormat", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setQuality(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setQuality(int)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setQuality(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setQuality_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setQuality_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setQuality", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setScaledClipRect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRect & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(arg);
        // setScaledClipRect(QRect)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setScaledClipRect(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setScaledClipRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setScaledClipRect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setScaledClipRect", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_setScaledSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setScaledSize(QSize)
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        cppSelf->QImageReader::setScaledSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_setScaledSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQImageReaderFunc_setScaledSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.setScaledSize", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QImageReader::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_supportedImageFormats(PyObject* self)
{
    PyObject* py_result = 0;

    // supportedImageFormats()
    QList<QByteArray > cpp_result = QImageReader::supportedImageFormats();
    py_result = Shiboken::Converter<QList<QByteArray > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_supportsAnimation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportsAnimation()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QImageReader::supportsAnimation();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQImageReaderFunc_supportsOption(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QImageIOHandler::ImageOption >::isConvertible(arg)) {
        QImageIOHandler::ImageOption cpp_arg0 = Shiboken::Converter<QImageIOHandler::ImageOption >::toCpp(arg);
        // supportsOption(QImageIOHandler::ImageOption)const
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QImageReader::supportsOption(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_supportsOption_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQImageReaderFunc_supportsOption_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImageIOHandler.ImageOption", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.supportsOption", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_text(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // text(QString)const
        QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QImageReader::text(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQImageReaderFunc_text_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQImageReaderFunc_text_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QImageReader.text", overloads);
        return 0;
}

static PyObject* SbkQImageReaderFunc_textKeys(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // textKeys()const
    QImageReader* cppSelf = Shiboken::Converter<QImageReader* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QImageReader::textKeys();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQImageReaderMethod_imageFormat = {
    "imageFormat", (PyCFunction)SbkQImageReaderFunc_imageFormat, METH_NOARGS|METH_O|METH_STATIC
};

static PyMethodDef SbkQImageReader_methods[] = {
    {"autoDetectImageFormat", (PyCFunction)SbkQImageReaderFunc_autoDetectImageFormat, METH_NOARGS},
    {"backgroundColor", (PyCFunction)SbkQImageReaderFunc_backgroundColor, METH_NOARGS},
    {"canRead", (PyCFunction)SbkQImageReaderFunc_canRead, METH_NOARGS},
    {"clipRect", (PyCFunction)SbkQImageReaderFunc_clipRect, METH_NOARGS},
    {"currentImageNumber", (PyCFunction)SbkQImageReaderFunc_currentImageNumber, METH_NOARGS},
    {"currentImageRect", (PyCFunction)SbkQImageReaderFunc_currentImageRect, METH_NOARGS},
    {"decideFormatFromContent", (PyCFunction)SbkQImageReaderFunc_decideFormatFromContent, METH_NOARGS},
    {"device", (PyCFunction)SbkQImageReaderFunc_device, METH_NOARGS},
    {"error", (PyCFunction)SbkQImageReaderFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQImageReaderFunc_errorString, METH_NOARGS},
    {"fileName", (PyCFunction)SbkQImageReaderFunc_fileName, METH_NOARGS},
    {"format", (PyCFunction)SbkQImageReaderFunc_format, METH_NOARGS},
    {"imageCount", (PyCFunction)SbkQImageReaderFunc_imageCount, METH_NOARGS},
    SbkQImageReaderMethod_imageFormat,
    {"jumpToImage", (PyCFunction)SbkQImageReaderFunc_jumpToImage, METH_O},
    {"jumpToNextImage", (PyCFunction)SbkQImageReaderFunc_jumpToNextImage, METH_NOARGS},
    {"loopCount", (PyCFunction)SbkQImageReaderFunc_loopCount, METH_NOARGS},
    {"nextImageDelay", (PyCFunction)SbkQImageReaderFunc_nextImageDelay, METH_NOARGS},
    {"quality", (PyCFunction)SbkQImageReaderFunc_quality, METH_NOARGS},
    {"read", (PyCFunction)SbkQImageReaderFunc_read, METH_NOARGS},
    {"scaledClipRect", (PyCFunction)SbkQImageReaderFunc_scaledClipRect, METH_NOARGS},
    {"scaledSize", (PyCFunction)SbkQImageReaderFunc_scaledSize, METH_NOARGS},
    {"setAutoDetectImageFormat", (PyCFunction)SbkQImageReaderFunc_setAutoDetectImageFormat, METH_O},
    {"setBackgroundColor", (PyCFunction)SbkQImageReaderFunc_setBackgroundColor, METH_O},
    {"setClipRect", (PyCFunction)SbkQImageReaderFunc_setClipRect, METH_O},
    {"setDecideFormatFromContent", (PyCFunction)SbkQImageReaderFunc_setDecideFormatFromContent, METH_O},
    {"setDevice", (PyCFunction)SbkQImageReaderFunc_setDevice, METH_O},
    {"setFileName", (PyCFunction)SbkQImageReaderFunc_setFileName, METH_O},
    {"setFormat", (PyCFunction)SbkQImageReaderFunc_setFormat, METH_O},
    {"setQuality", (PyCFunction)SbkQImageReaderFunc_setQuality, METH_O},
    {"setScaledClipRect", (PyCFunction)SbkQImageReaderFunc_setScaledClipRect, METH_O},
    {"setScaledSize", (PyCFunction)SbkQImageReaderFunc_setScaledSize, METH_O},
    {"size", (PyCFunction)SbkQImageReaderFunc_size, METH_NOARGS},
    {"supportedImageFormats", (PyCFunction)SbkQImageReaderFunc_supportedImageFormats, METH_NOARGS|METH_STATIC},
    {"supportsAnimation", (PyCFunction)SbkQImageReaderFunc_supportsAnimation, METH_NOARGS},
    {"supportsOption", (PyCFunction)SbkQImageReaderFunc_supportsOption, METH_O},
    {"text", (PyCFunction)SbkQImageReaderFunc_text, METH_O},
    {"textKeys", (PyCFunction)SbkQImageReaderFunc_textKeys, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQImageReader_getattro(PyObject* self, PyObject* name)
{
    if (self) {
        if (SbkBaseWrapper_instanceDict(self)) {
            PyObject* meth = PyDict_GetItem(SbkBaseWrapper_instanceDict(self), name);
            if (meth) {
                Py_INCREF(meth);
                return meth;
            }
        }
        const char* cname = PyString_AS_STRING(name);
        if (strcmp(cname, "imageFormat") == 0)
            return PyCFunction_NewEx(&SbkQImageReaderMethod_imageFormat, self, 0);
    }
    return PyObject_GenericGetAttr(self, name);
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQImageReader_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QImageReader",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         SbkQImageReader_getattro,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQImageReader_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQImageReader_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QImageReader >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QImageReader_ImageReaderError_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QImageReader_ImageReaderError_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QImageReader_ImageReaderError_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ImageReaderError",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QImageReader_ImageReaderError_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QImageReader_ImageReaderError_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QImageReader_ImageReaderError_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QImageReader(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QIMAGEREADER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQImageReader_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQImageReader_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQImageReader_Type));
    PyModule_AddObject(module, "QImageReader",
        ((PyObject*)&SbkQImageReader_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ImageReaderError
    SbkPySide_QtGuiTypes[SBK_QIMAGEREADER_IMAGEREADERERROR_IDX] = &SbkPySide_QtGui_QImageReader_ImageReaderError_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QImageReader_ImageReaderError_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QImageReader_ImageReaderError_Type);
    PyDict_SetItemString(SbkQImageReader_Type.super.ht_type.tp_dict,
            "ImageReaderError",((PyObject*)&SbkPySide_QtGui_QImageReader_ImageReaderError_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageReader_ImageReaderError_Type,
        (long) QImageReader::UnknownError, "UnknownError");
    PyDict_SetItemString(SbkQImageReader_Type.super.ht_type.tp_dict,
        "UnknownError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageReader_ImageReaderError_Type.tp_dict,
        "UnknownError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageReader_ImageReaderError_Type,
        (long) QImageReader::FileNotFoundError, "FileNotFoundError");
    PyDict_SetItemString(SbkQImageReader_Type.super.ht_type.tp_dict,
        "FileNotFoundError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageReader_ImageReaderError_Type.tp_dict,
        "FileNotFoundError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageReader_ImageReaderError_Type,
        (long) QImageReader::DeviceError, "DeviceError");
    PyDict_SetItemString(SbkQImageReader_Type.super.ht_type.tp_dict,
        "DeviceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageReader_ImageReaderError_Type.tp_dict,
        "DeviceError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageReader_ImageReaderError_Type,
        (long) QImageReader::UnsupportedFormatError, "UnsupportedFormatError");
    PyDict_SetItemString(SbkQImageReader_Type.super.ht_type.tp_dict,
        "UnsupportedFormatError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageReader_ImageReaderError_Type.tp_dict,
        "UnsupportedFormatError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QImageReader_ImageReaderError_Type,
        (long) QImageReader::InvalidDataError, "InvalidDataError");
    PyDict_SetItemString(SbkQImageReader_Type.super.ht_type.tp_dict,
        "InvalidDataError", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QImageReader_ImageReaderError_Type.tp_dict,
        "InvalidDataError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QImageReader::ImageReaderError");

    Shiboken::TypeResolver::createObjectTypeResolver<QImageReader >("QImageReader*");
    Shiboken::TypeResolver::createObjectTypeResolver<QImageReader >(typeid(QImageReader).name());
}


} // extern "C"

