/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SBK_QHEADERVIEWWRAPPER_H
#define SBK_QHEADERVIEWWRAPPER_H

#define protected public

#include <shiboken.h>

#include <qheaderview.h>

namespace PySide { class DynamicQMetaObject; }

class QHeaderViewWrapper : public QHeaderView
{
public:
    QHeaderViewWrapper(Qt::Orientation orientation, QWidget * parent = 0);
    virtual void actionEvent(QActionEvent * arg__1);
    virtual void changeEvent(QEvent * arg__1);
    virtual void childEvent(QChildEvent * arg__1);
    virtual void closeEditor(QWidget * editor, QAbstractItemDelegate::EndEditHint hint);
    virtual void closeEvent(QCloseEvent * arg__1);
    virtual void commitData(QWidget * editor);
    virtual void connectNotify(const char * signal);
    virtual void contextMenuEvent(QContextMenuEvent * arg__1);
    virtual void currentChanged(const QModelIndex & current, const QModelIndex & old);
    virtual void customEvent(QEvent * arg__1);
    virtual void dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);
    virtual int devType() const;
    virtual void disconnectNotify(const char * signal);
    virtual void doItemsLayout();
    virtual void dragEnterEvent(QDragEnterEvent * event);
    virtual void dragLeaveEvent(QDragLeaveEvent * event);
    virtual void dragMoveEvent(QDragMoveEvent * event);
    virtual void dropEvent(QDropEvent * event);
    virtual bool edit(const QModelIndex & index, QAbstractItemView::EditTrigger trigger, QEvent * event);
    virtual void editorDestroyed(QObject * editor);
    virtual void enterEvent(QEvent * arg__1);
    virtual bool event(QEvent * e);
    virtual bool eventFilter(QObject * arg__1, QEvent * arg__2);
    virtual void focusInEvent(QFocusEvent * event);
    virtual bool focusNextPrevChild(bool next);
    virtual void focusOutEvent(QFocusEvent * event);
    virtual int heightForWidth(int arg__1) const;
    virtual void hideEvent(QHideEvent * arg__1);
    virtual int horizontalOffset() const;
    virtual void horizontalScrollbarAction(int action);
    virtual void horizontalScrollbarValueChanged(int value);
    virtual QModelIndex indexAt(const QPoint & p) const;
    virtual void inputMethodEvent(QInputMethodEvent * event);
    virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const;
    virtual bool isIndexHidden(const QModelIndex & index) const;
    virtual void keyPressEvent(QKeyEvent * event);
    virtual void keyReleaseEvent(QKeyEvent * arg__1);
    virtual void keyboardSearch(const QString & search);
    virtual void languageChange();
    virtual void leaveEvent(QEvent * arg__1);
    virtual const QMetaObject * metaObject() const;
    virtual int metric(QPaintDevice::PaintDeviceMetric arg__1) const;
    virtual QSize minimumSizeHint() const;
    virtual void mouseDoubleClickEvent(QMouseEvent * e);
    virtual void mouseMoveEvent(QMouseEvent * e);
    virtual void mousePressEvent(QMouseEvent * e);
    virtual void mouseReleaseEvent(QMouseEvent * e);
    virtual void moveEvent(QMoveEvent * arg__1);
    virtual QPaintEngine * paintEngine() const;
    virtual void paintEvent(QPaintEvent * e);
    virtual void paintSection(QPainter * painter, const QRect & rect, int logicalIndex) const;
    virtual void reset();
    virtual void resizeEvent(QResizeEvent * event);
    virtual void rowsAboutToBeRemoved(const QModelIndex & parent, int start, int end);
    virtual void rowsInserted(const QModelIndex & parent, int start, int end);
    virtual void scrollContentsBy(int dx, int dy);
    virtual void scrollTo(const QModelIndex & index, QAbstractItemView::ScrollHint hint);
    virtual QSize sectionSizeFromContents(int logicalIndex) const;
    virtual void selectAll();
    virtual QList<QModelIndex > selectedIndexes() const;
    virtual void selectionChanged(const QItemSelection & selected, const QItemSelection & deselected);
    virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex & index, const QEvent * event = 0) const;
    virtual void setModel(QAbstractItemModel * model);
    virtual void setRootIndex(const QModelIndex & index);
    virtual void setSelection(const QRect & rect, QFlags<QItemSelectionModel::SelectionFlag> flags);
    virtual void setSelectionModel(QItemSelectionModel * selectionModel);
    virtual void setVisible(bool visible);
    virtual void showEvent(QShowEvent * arg__1);
    virtual QSize sizeHint() const;
    virtual int sizeHintForColumn(int column) const;
    virtual int sizeHintForRow(int row) const;
    virtual void startDrag(QFlags<Qt::DropAction> supportedActions);
    virtual void tabletEvent(QTabletEvent * arg__1);
    virtual void timerEvent(QTimerEvent * event);
    virtual void updateEditorData();
    virtual void updateEditorGeometries();
    virtual void updateGeometries();
    virtual int verticalOffset() const;
    virtual void verticalScrollbarAction(int action);
    virtual void verticalScrollbarValueChanged(int value);
    virtual QStyleOptionViewItem viewOptions() const;
    virtual bool viewportEvent(QEvent * e);
    virtual QRect visualRect(const QModelIndex & index) const;
    virtual QRegion visualRegionForSelection(const QItemSelection & selection) const;
    virtual void wheelEvent(QWheelEvent * arg__1);
    virtual ~QHeaderViewWrapper();
public:
    virtual int qt_metacall(QMetaObject::Call call, int id, void** args);
private:
    mutable PySide::DynamicQMetaObject* m_metaObject;
};

#endif // SBK_QHEADERVIEWWRAPPER_H

