/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qgraphicsblureffect_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qgraphicseffect.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsBlurEffectWrapper::QGraphicsBlurEffectWrapper(QObject * parent) : QGraphicsBlurEffect(parent), m_metaObject(0) {
    // ... middle
}

QRectF QGraphicsBlurEffectWrapper::boundingRectFor(const QRectF & rect) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "boundingRectFor"));
    if (py_override.isNull()) {
        return this->QGraphicsBlurEffect::boundingRectFor(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRectF & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QRectF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QRectF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsBlurEffect.boundingRectFor", SbkType<QRectF >()->tp_name, py_result->ob_type->tp_name);
        return QRectF();
    }
    QRectF cpp_result(Shiboken::Converter<QRectF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsBlurEffectWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsBlurEffectWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsBlurEffectWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QGraphicsBlurEffectWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsBlurEffectWrapper::draw(QPainter * painter)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "draw"));
    if (py_override.isNull()) {
        return this->QGraphicsBlurEffect::draw(painter);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPainter * >::toPython(painter)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QGraphicsBlurEffectWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsBlurEffect.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QGraphicsBlurEffectWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsBlurEffect.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QGraphicsBlurEffectWrapper::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sourceChanged"));
    if (py_override.isNull()) {
        return this->QGraphicsEffect::sourceChanged(flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsBlurEffectWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QGraphicsBlurEffectWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QGraphicsBlurEffect::staticMetaObject);
}
    return m_metaObject;
}

int QGraphicsBlurEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QGraphicsBlurEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QGraphicsBlurEffectWrapper::~QGraphicsBlurEffectWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsBlurEffect_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsBlurEffectWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsBlurEffect", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsBlurEffect(QObject*)
        cptr = new QGraphicsBlurEffectWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QGraphicsBlurEffect(QObject*)
        cptr = new QGraphicsBlurEffectWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsBlurEffect_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsBlurEffect >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsBlurEffect_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsBlurEffect_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsBlurEffect", overloads);
        return -1;
}

static PyObject* SbkQGraphicsBlurEffectFunc_blurHints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blurHints()const
    QGraphicsBlurEffect* cppSelf = Shiboken::Converter<QGraphicsBlurEffect* >::toCpp((PyObject*)self);
    QFlags<QGraphicsBlurEffect::BlurHint> cpp_result = cppSelf->QGraphicsBlurEffect::blurHints();
    py_result = Shiboken::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsBlurEffectFunc_blurRadius(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // blurRadius()const
    QGraphicsBlurEffect* cppSelf = Shiboken::Converter<QGraphicsBlurEffect* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsBlurEffect::blurRadius();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsBlurEffectFunc_boundingRectFor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // boundingRectFor(QRectF)const
        QGraphicsBlurEffect* cppSelf = Shiboken::Converter<QGraphicsBlurEffect* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QGraphicsBlurEffect::boundingRectFor(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsBlurEffectFunc_boundingRectFor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsBlurEffectFunc_boundingRectFor_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsBlurEffect.boundingRectFor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsBlurEffectFunc_draw(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPainter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPainter* cpp_arg0 = Shiboken::Converter<QPainter* >::toCpp(arg);
        // draw(QPainter*)
        QGraphicsBlurEffect* cppSelf = Shiboken::Converter<QGraphicsBlurEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsBlurEffect::draw(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsBlurEffectFunc_draw_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsBlurEffectFunc_draw_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPainter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsBlurEffect.draw", overloads);
        return 0;
}

static PyObject* SbkQGraphicsBlurEffectFunc_setBlurHints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Check(arg)) {
        QFlags<QGraphicsBlurEffect::BlurHint> cpp_arg0 = Shiboken::Converter<QFlags<QGraphicsBlurEffect::BlurHint> >::toCpp(arg);
        // setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint>)
        QGraphicsBlurEffect* cppSelf = Shiboken::Converter<QGraphicsBlurEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsBlurEffect::setBlurHints(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsBlurEffectFunc_setBlurHints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsBlurEffectFunc_setBlurHints_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsBlurEffect.BlurHints", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsBlurEffect.setBlurHints", overloads);
        return 0;
}

static PyObject* SbkQGraphicsBlurEffectFunc_setBlurRadius(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBlurRadius(qreal)
        QGraphicsBlurEffect* cppSelf = Shiboken::Converter<QGraphicsBlurEffect* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsBlurEffect::setBlurRadius(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsBlurEffectFunc_setBlurRadius_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsBlurEffectFunc_setBlurRadius_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsBlurEffect.setBlurRadius", overloads);
        return 0;
}

static PyMethodDef SbkQGraphicsBlurEffect_methods[] = {
    {"blurHints", (PyCFunction)SbkQGraphicsBlurEffectFunc_blurHints, METH_NOARGS},
    {"blurRadius", (PyCFunction)SbkQGraphicsBlurEffectFunc_blurRadius, METH_NOARGS},
    {"boundingRectFor", (PyCFunction)SbkQGraphicsBlurEffectFunc_boundingRectFor, METH_O},
    {"draw", (PyCFunction)SbkQGraphicsBlurEffectFunc_draw, METH_O},
    {"setBlurHints", (PyCFunction)SbkQGraphicsBlurEffectFunc_setBlurHints, METH_O},
    {"setBlurRadius", (PyCFunction)SbkQGraphicsBlurEffectFunc_setBlurRadius, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsBlurEffect_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsBlurEffect",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsBlurEffect_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsBlurEffect_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsBlurEffect >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toPython(
        ((QGraphicsBlurEffect::BlurHints) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toPython(
        ((QGraphicsBlurEffect::BlurHints) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toPython(
        ((QGraphicsBlurEffect::BlurHints) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toPython(
        ~ Shiboken::Converter< QGraphicsBlurEffect::BlurHints >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BlurHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BlurHints",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QGraphicsBlurEffect(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSBLUREFFECT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsBlurEffect_Type);

    SbkQGraphicsBlurEffect_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSEFFECT_IDX];
    // Fill type discovery information
    SbkQGraphicsBlurEffect_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsBlurEffect_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsBlurEffect_Type));
    PyModule_AddObject(module, "QGraphicsBlurEffect",
        ((PyObject*)&SbkQGraphicsBlurEffect_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: BlurHint
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX] = &SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type);
    PyDict_SetItemString(SbkQGraphicsBlurEffect_Type.super.ht_type.tp_dict,
            "BlurHint",((PyObject*)&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type));

    // init flags class: QFlags<QGraphicsBlurEffect::BlurHint>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT__IDX] = &SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Type);
    PyDict_SetItemString(SbkQGraphicsBlurEffect_Type.super.ht_type.tp_dict,
            "BlurHints",((PyObject*)&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHints_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type,
        (long) QGraphicsBlurEffect::PerformanceHint, "PerformanceHint");
    PyDict_SetItemString(SbkQGraphicsBlurEffect_Type.super.ht_type.tp_dict,
        "PerformanceHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type.tp_dict,
        "PerformanceHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type,
        (long) QGraphicsBlurEffect::QualityHint, "QualityHint");
    PyDict_SetItemString(SbkQGraphicsBlurEffect_Type.super.ht_type.tp_dict,
        "QualityHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type.tp_dict,
        "QualityHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type,
        (long) QGraphicsBlurEffect::AnimationHint, "AnimationHint");
    PyDict_SetItemString(SbkQGraphicsBlurEffect_Type.super.ht_type.tp_dict,
        "AnimationHint", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QGraphicsBlurEffect_BlurHint_Type.tp_dict,
        "AnimationHint", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QGraphicsBlurEffect::BlurHint");

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsBlurEffect >("QGraphicsBlurEffect*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsBlurEffect >(typeid(QGraphicsBlurEffect).name());
}


} // extern "C"

