/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qdatetimeedit_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcalendarwidget.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstyle.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QDateTimeEditWrapper::QDateTimeEditWrapper(QWidget * parent) : QDateTimeEdit(parent), m_metaObject(0) {
    // ... middle
}

QDateTimeEditWrapper::QDateTimeEditWrapper(const QDate & d, QWidget * parent) : QDateTimeEdit(d, parent), m_metaObject(0) {
    // ... middle
}

QDateTimeEditWrapper::QDateTimeEditWrapper(const QDateTime & dt, QWidget * parent) : QDateTimeEdit(dt, parent), m_metaObject(0) {
    // ... middle
}

QDateTimeEditWrapper::QDateTimeEditWrapper(const QTime & t, QWidget * parent) : QDateTimeEdit(t, parent), m_metaObject(0) {
    // ... middle
}

QDateTimeEditWrapper::QDateTimeEditWrapper(const QVariant & val, QVariant::Type parserType, QWidget * parent) : QDateTimeEdit(val, parserType, parent), m_metaObject(0) {
    // ... middle
}

void QDateTimeEditWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDateTimeEditWrapper::changeEvent(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::changeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::clear()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "clear"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::clear();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::closeEvent(QCloseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::closeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::contextMenuEvent(QContextMenuEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QDateTime QDateTimeEditWrapper::dateTimeFromText(const QString & text) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dateTimeFromText"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::dateTimeFromText(text);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(text)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QDateTime();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QDateTime >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.dateTimeFromText", SbkType<QDateTime >()->tp_name, py_result->ob_type->tp_name);
        return QDateTime();
    }
    QDateTime cpp_result(Shiboken::Converter<QDateTime >::toCpp(py_result));
    return cpp_result;
}

int QDateTimeEditWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDateTimeEditWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDateTimeEditWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDateTimeEditWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDateTimeEditWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QDateTimeEditWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QDateTimeEditWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::fixup(QString & input) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fixup"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::fixup(input);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QString & >::toPython(input)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::focusInEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QDateTimeEditWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::focusOutEvent(QFocusEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QDateTimeEditWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::hideEvent(QHideEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::hideEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QWidget::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QDateTimeEditWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::keyPressEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::keyReleaseEvent(QKeyEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QDateTimeEditWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QDateTimeEditWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDateTimeEditWrapper::mouseMoveEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::mousePressEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::mouseReleaseEvent(QMouseEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QDateTimeEditWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::paintEvent(QPaintEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::paintEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::resizeEvent(QResizeEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDateTimeEditWrapper::showEvent(QShowEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::showEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QDateTimeEditWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::stepBy(int steps)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stepBy"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::stepBy(steps);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        steps
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<QAbstractSpinBox::StepEnabledFlag> QDateTimeEditWrapper::stepEnabled() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stepEnabled"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::stepEnabled();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QAbstractSpinBox::StepEnabledFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.stepEnabled", SbkType<QFlags<QAbstractSpinBox::StepEnabledFlag> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<QAbstractSpinBox::StepEnabledFlag>();
    }
    QFlags<QAbstractSpinBox::StepEnabledFlag> cpp_result(Shiboken::Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QString QDateTimeEditWrapper::textFromDateTime(const QDateTime & dt) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "textFromDateTime"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::textFromDateTime(dt);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDateTime & >::toPython(dt)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.textFromDateTime", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::timerEvent(QTimerEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QAbstractSpinBox::timerEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QValidator::State QDateTimeEditWrapper::validate(QString & input, int & pos) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "validate"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::validate(input, pos);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QString & >::toPython(input),
        Shiboken::Converter<int  >::toPython(pos)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QValidator::State();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QValidator::State >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDateTimeEdit.validate", SbkType<QValidator::State >()->tp_name, py_result->ob_type->tp_name);
        return QValidator::State();
    }
    QValidator::State cpp_result(Shiboken::Converter<QValidator::State >::toCpp(py_result));
    return cpp_result;
}

void QDateTimeEditWrapper::wheelEvent(QWheelEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QDateTimeEdit::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QDateTimeEditWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QDateTimeEdit::staticMetaObject);
}
    return m_metaObject;
}

int QDateTimeEditWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QDateTimeEdit::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QDateTimeEditWrapper::~QDateTimeEditWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQDateTimeEdit_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDateTimeEditWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QDateTimeEdit", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QDateTimeEdit(QWidget*)
        cptr = new QDateTimeEditWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QTime & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QDateTimeEdit(QTime,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QDateTimeEdit(QTime,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQDateTimeEdit_Init_TypeError;
    } else if (Shiboken::Converter<QDateTime & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QDateTimeEdit(QDateTime,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QDateTimeEdit(QDateTime,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQDateTimeEdit_Init_TypeError;
    } else if (Shiboken::Converter<QDate & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QDateTimeEdit(QDate,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QWidget* cpp_arg1 = Shiboken::Converter<QWidget* >::toCpp(pyargs[1]);
            // QDateTimeEdit(QDate,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQDateTimeEdit_Init_TypeError;
    } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant::Type >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        QVariant::Type cpp_arg1 = Shiboken::Converter<QVariant::Type >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QDateTimeEdit(QVariant,QVariant::Type,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            QWidget* cpp_arg2 = Shiboken::Converter<QWidget* >::toCpp(pyargs[2]);
            // QDateTimeEdit(QVariant,QVariant::Type,QWidget*)
            cptr = new QDateTimeEditWrapper(*cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else goto SbkQDateTimeEdit_Init_TypeError;
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QDateTimeEdit(QWidget*)
        cptr = new QDateTimeEditWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQDateTimeEdit_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDateTimeEdit >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDateTimeEdit_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDateTimeEdit_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", "PySide.QtCore.QDate, PySide.QtGui.QWidget = None", "PySide.QtCore.QDateTime, PySide.QtGui.QWidget = None", "PySide.QtCore.QTime, PySide.QtGui.QWidget = None", "PySide.QtCore.QVariant, PySide.QtCore.QVariant.Type, PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDateTimeEdit", overloads);
        return -1;
}

static PyObject* SbkQDateTimeEditFunc_calendarPopup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // calendarPopup()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDateTimeEdit::calendarPopup();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_calendarWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // calendarWidget()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QCalendarWidget * cpp_result = cppSelf->QDateTimeEdit::calendarWidget();
    py_result = Shiboken::Converter<QCalendarWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_clearMaximumDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMaximumDate()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clearMaximumDate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_clearMaximumDateTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMaximumDateTime()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clearMaximumDateTime();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_clearMaximumTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMaximumTime()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clearMaximumTime();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_clearMinimumDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMinimumDate()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clearMinimumDate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_clearMinimumDateTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMinimumDateTime()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clearMinimumDateTime();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_clearMinimumTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMinimumTime()
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    cppSelf->QDateTimeEdit::clearMinimumTime();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDateTimeEditFunc_currentSection(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentSection()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDateTimeEdit::Section cpp_result = cppSelf->QDateTimeEdit::currentSection();
    py_result = Shiboken::Converter<QDateTimeEdit::Section >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_currentSectionIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentSectionIndex()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDateTimeEdit::currentSectionIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_date(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // date()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QDateTimeEdit::date();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_dateTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dateTime()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QDateTimeEdit::dateTime();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_dateTimeFromText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // dateTimeFromText(QString)const
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QDateTimeEdit::dateTimeFromText(*cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_dateTimeFromText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_dateTimeFromText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.dateTimeFromText", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_displayFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // displayFormat()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QDateTimeEdit::displayFormat();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_displayedSections(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // displayedSections()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QFlags<QDateTimeEdit::Section> cpp_result = cppSelf->QDateTimeEdit::displayedSections();
    py_result = Shiboken::Converter<QFlags<QDateTimeEdit::Section> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDateTimeEdit::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.event", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_fixup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fixup(QString&)const
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::fixup(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_fixup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_fixup_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.fixup", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::focusInEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.focusInEvent", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_focusNextPrevChild(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // focusNextPrevChild(bool)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QDateTimeEdit::focusNextPrevChild(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_focusNextPrevChild_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_focusNextPrevChild_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.focusNextPrevChild", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_maximumDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumDate()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QDateTimeEdit::maximumDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_maximumDateTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumDateTime()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QDateTimeEdit::maximumDateTime();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_maximumTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumTime()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QTime cpp_result = cppSelf->QDateTimeEdit::maximumTime();
    py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_minimumDate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumDate()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDate cpp_result = cppSelf->QDateTimeEdit::minimumDate();
    py_result = Shiboken::Converter<QDate >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_minimumDateTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumDateTime()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QDateTimeEdit::minimumDateTime();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_minimumTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumTime()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QTime cpp_result = cppSelf->QDateTimeEdit::minimumTime();
    py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_sectionAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // sectionAt(int)const
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        QDateTimeEdit::Section cpp_result = cppSelf->QDateTimeEdit::sectionAt(cpp_arg0);
        py_result = Shiboken::Converter<QDateTimeEdit::Section >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_sectionAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_sectionAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.sectionAt", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_sectionCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sectionCount()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDateTimeEdit::sectionCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_sectionText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDateTimeEdit::Section >::isConvertible(arg)) {
        QDateTimeEdit::Section cpp_arg0 = Shiboken::Converter<QDateTimeEdit::Section >::toCpp(arg);
        // sectionText(QDateTimeEdit::Section)const
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDateTimeEdit::sectionText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_sectionText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_sectionText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDateTimeEdit.Section", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.sectionText", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setCalendarPopup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCalendarPopup(bool)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setCalendarPopup(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setCalendarPopup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setCalendarPopup_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setCalendarPopup", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setCalendarWidget(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCalendarWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCalendarWidget* cpp_arg0 = Shiboken::Converter<QCalendarWidget* >::toCpp(arg);
        // setCalendarWidget(QCalendarWidget*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setCalendarWidget(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQDateTimeEditFunc_setCalendarWidget_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setCalendarWidget_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCalendarWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setCalendarWidget", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setCurrentSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTimeEdit::Section >::isConvertible(arg)) {
        QDateTimeEdit::Section cpp_arg0 = Shiboken::Converter<QDateTimeEdit::Section >::toCpp(arg);
        // setCurrentSection(QDateTimeEdit::Section)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setCurrentSection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setCurrentSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setCurrentSection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDateTimeEdit.Section", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setCurrentSection", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setCurrentSectionIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentSectionIndex(int)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setCurrentSectionIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setCurrentSectionIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setCurrentSectionIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setCurrentSectionIndex", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setDate(QDate)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setDate", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setDateRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDateRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDate & >::isConvertible(pyargs[0]) && Shiboken::Converter<QDate & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDate* cpp_arg1 = Shiboken::Converter<QDate* >::toCpp(pyargs[1]);
        // setDateRange(QDate,QDate)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setDateRange(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setDateRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setDateRange_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate, PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDateTimeEdit.setDateRange", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setDateTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // setDateTime(QDateTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setDateTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setDateTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setDateTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setDateTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setDateTimeRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDateTimeRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QDateTime & >::isConvertible(pyargs[0]) && Shiboken::Converter<QDateTime & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QDateTime* cpp_arg1 = Shiboken::Converter<QDateTime* >::toCpp(pyargs[1]);
        // setDateTimeRange(QDateTime,QDateTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setDateTimeRange(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setDateTimeRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setDateTimeRange_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime, PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDateTimeEdit.setDateTimeRange", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setDisplayFormat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setDisplayFormat(QString)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setDisplayFormat(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setDisplayFormat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setDisplayFormat_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setDisplayFormat", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setMaximumDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setMaximumDate(QDate)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setMaximumDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setMaximumDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setMaximumDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setMaximumDate", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setMaximumDateTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // setMaximumDateTime(QDateTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setMaximumDateTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setMaximumDateTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setMaximumDateTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setMaximumDateTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setMaximumTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // setMaximumTime(QTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setMaximumTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setMaximumTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setMaximumTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setMaximumTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setMinimumDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDate & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);
        // setMinimumDate(QDate)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setMinimumDate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setMinimumDate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setMinimumDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setMinimumDate", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setMinimumDateTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // setMinimumDateTime(QDateTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setMinimumDateTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setMinimumDateTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setMinimumDateTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setMinimumDateTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setMinimumTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // setMinimumTime(QTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setMinimumTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setMinimumTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setMinimumTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setMinimumTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setSelectedSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDateTimeEdit::Section >::isConvertible(arg)) {
        QDateTimeEdit::Section cpp_arg0 = Shiboken::Converter<QDateTimeEdit::Section >::toCpp(arg);
        // setSelectedSection(QDateTimeEdit::Section)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setSelectedSection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setSelectedSection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setSelectedSection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDateTimeEdit.Section", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setSelectedSection", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(arg);
        // setTime(QTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setTime(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setTimeRange(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setTimeRange", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QTime & >::isConvertible(pyargs[0]) && Shiboken::Converter<QTime & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QTime* cpp_arg0 = Shiboken::Converter<QTime* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QTime* cpp_arg1 = Shiboken::Converter<QTime* >::toCpp(pyargs[1]);
        // setTimeRange(QTime,QTime)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setTimeRange(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setTimeRange_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setTimeRange_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTime, PySide.QtCore.QTime", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDateTimeEdit.setTimeRange", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_setTimeSpec(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::TimeSpec >::isConvertible(arg)) {
        Qt::TimeSpec cpp_arg0 = Shiboken::Converter<Qt::TimeSpec >::toCpp(arg);
        // setTimeSpec(Qt::TimeSpec)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::setTimeSpec(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_setTimeSpec_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_setTimeSpec_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.TimeSpec", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.setTimeSpec", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QDateTimeEdit::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_stepBy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // stepBy(int)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::stepBy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_stepBy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_stepBy_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.stepBy", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_stepEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stepEnabled()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QFlags<QAbstractSpinBox::StepEnabledFlag> cpp_result = cppSelf->QDateTimeEdit::stepEnabled();
    py_result = Shiboken::Converter<QFlags<QAbstractSpinBox::StepEnabledFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_textFromDateTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // textFromDateTime(QDateTime)const
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QDateTimeEdit::textFromDateTime(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_textFromDateTime_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_textFromDateTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.textFromDateTime", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_time(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // time()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    QTime cpp_result = cppSelf->QDateTimeEdit::time();
    py_result = Shiboken::Converter<QTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_timeSpec(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // timeSpec()const
    QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
    Qt::TimeSpec cpp_result = cppSelf->QDateTimeEdit::timeSpec();
    py_result = Shiboken::Converter<Qt::TimeSpec >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDateTimeEditFunc_validate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "validate", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        int  cpp_arg1 = Shiboken::Converter<int  >::toCpp(pyargs[1]);
        // validate(QString&,int&)const
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        QValidator::State cpp_result = cppSelf->QDateTimeEdit::validate(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QValidator::State >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_validate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDateTimeEditFunc_validate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDateTimeEdit.validate", overloads);
        return 0;
}

static PyObject* SbkQDateTimeEditFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QDateTimeEdit* cppSelf = Shiboken::Converter<QDateTimeEdit* >::toCpp((PyObject*)self);
        cppSelf->QDateTimeEdit::wheelEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDateTimeEditFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDateTimeEditFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDateTimeEdit.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQDateTimeEdit_methods[] = {
    {"calendarPopup", (PyCFunction)SbkQDateTimeEditFunc_calendarPopup, METH_NOARGS},
    {"calendarWidget", (PyCFunction)SbkQDateTimeEditFunc_calendarWidget, METH_NOARGS},
    {"clear", (PyCFunction)SbkQDateTimeEditFunc_clear, METH_NOARGS},
    {"clearMaximumDate", (PyCFunction)SbkQDateTimeEditFunc_clearMaximumDate, METH_NOARGS},
    {"clearMaximumDateTime", (PyCFunction)SbkQDateTimeEditFunc_clearMaximumDateTime, METH_NOARGS},
    {"clearMaximumTime", (PyCFunction)SbkQDateTimeEditFunc_clearMaximumTime, METH_NOARGS},
    {"clearMinimumDate", (PyCFunction)SbkQDateTimeEditFunc_clearMinimumDate, METH_NOARGS},
    {"clearMinimumDateTime", (PyCFunction)SbkQDateTimeEditFunc_clearMinimumDateTime, METH_NOARGS},
    {"clearMinimumTime", (PyCFunction)SbkQDateTimeEditFunc_clearMinimumTime, METH_NOARGS},
    {"currentSection", (PyCFunction)SbkQDateTimeEditFunc_currentSection, METH_NOARGS},
    {"currentSectionIndex", (PyCFunction)SbkQDateTimeEditFunc_currentSectionIndex, METH_NOARGS},
    {"date", (PyCFunction)SbkQDateTimeEditFunc_date, METH_NOARGS},
    {"dateTime", (PyCFunction)SbkQDateTimeEditFunc_dateTime, METH_NOARGS},
    {"dateTimeFromText", (PyCFunction)SbkQDateTimeEditFunc_dateTimeFromText, METH_O},
    {"displayFormat", (PyCFunction)SbkQDateTimeEditFunc_displayFormat, METH_NOARGS},
    {"displayedSections", (PyCFunction)SbkQDateTimeEditFunc_displayedSections, METH_NOARGS},
    {"event", (PyCFunction)SbkQDateTimeEditFunc_event, METH_O},
    {"fixup", (PyCFunction)SbkQDateTimeEditFunc_fixup, METH_O},
    {"focusInEvent", (PyCFunction)SbkQDateTimeEditFunc_focusInEvent, METH_O},
    {"focusNextPrevChild", (PyCFunction)SbkQDateTimeEditFunc_focusNextPrevChild, METH_O},
    {"keyPressEvent", (PyCFunction)SbkQDateTimeEditFunc_keyPressEvent, METH_O},
    {"maximumDate", (PyCFunction)SbkQDateTimeEditFunc_maximumDate, METH_NOARGS},
    {"maximumDateTime", (PyCFunction)SbkQDateTimeEditFunc_maximumDateTime, METH_NOARGS},
    {"maximumTime", (PyCFunction)SbkQDateTimeEditFunc_maximumTime, METH_NOARGS},
    {"minimumDate", (PyCFunction)SbkQDateTimeEditFunc_minimumDate, METH_NOARGS},
    {"minimumDateTime", (PyCFunction)SbkQDateTimeEditFunc_minimumDateTime, METH_NOARGS},
    {"minimumTime", (PyCFunction)SbkQDateTimeEditFunc_minimumTime, METH_NOARGS},
    {"mousePressEvent", (PyCFunction)SbkQDateTimeEditFunc_mousePressEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQDateTimeEditFunc_paintEvent, METH_O},
    {"sectionAt", (PyCFunction)SbkQDateTimeEditFunc_sectionAt, METH_O},
    {"sectionCount", (PyCFunction)SbkQDateTimeEditFunc_sectionCount, METH_NOARGS},
    {"sectionText", (PyCFunction)SbkQDateTimeEditFunc_sectionText, METH_O},
    {"setCalendarPopup", (PyCFunction)SbkQDateTimeEditFunc_setCalendarPopup, METH_O},
    {"setCalendarWidget", (PyCFunction)SbkQDateTimeEditFunc_setCalendarWidget, METH_O},
    {"setCurrentSection", (PyCFunction)SbkQDateTimeEditFunc_setCurrentSection, METH_O},
    {"setCurrentSectionIndex", (PyCFunction)SbkQDateTimeEditFunc_setCurrentSectionIndex, METH_O},
    {"setDate", (PyCFunction)SbkQDateTimeEditFunc_setDate, METH_O},
    {"setDateRange", (PyCFunction)SbkQDateTimeEditFunc_setDateRange, METH_VARARGS},
    {"setDateTime", (PyCFunction)SbkQDateTimeEditFunc_setDateTime, METH_O},
    {"setDateTimeRange", (PyCFunction)SbkQDateTimeEditFunc_setDateTimeRange, METH_VARARGS},
    {"setDisplayFormat", (PyCFunction)SbkQDateTimeEditFunc_setDisplayFormat, METH_O},
    {"setMaximumDate", (PyCFunction)SbkQDateTimeEditFunc_setMaximumDate, METH_O},
    {"setMaximumDateTime", (PyCFunction)SbkQDateTimeEditFunc_setMaximumDateTime, METH_O},
    {"setMaximumTime", (PyCFunction)SbkQDateTimeEditFunc_setMaximumTime, METH_O},
    {"setMinimumDate", (PyCFunction)SbkQDateTimeEditFunc_setMinimumDate, METH_O},
    {"setMinimumDateTime", (PyCFunction)SbkQDateTimeEditFunc_setMinimumDateTime, METH_O},
    {"setMinimumTime", (PyCFunction)SbkQDateTimeEditFunc_setMinimumTime, METH_O},
    {"setSelectedSection", (PyCFunction)SbkQDateTimeEditFunc_setSelectedSection, METH_O},
    {"setTime", (PyCFunction)SbkQDateTimeEditFunc_setTime, METH_O},
    {"setTimeRange", (PyCFunction)SbkQDateTimeEditFunc_setTimeRange, METH_VARARGS},
    {"setTimeSpec", (PyCFunction)SbkQDateTimeEditFunc_setTimeSpec, METH_O},
    {"sizeHint", (PyCFunction)SbkQDateTimeEditFunc_sizeHint, METH_NOARGS},
    {"stepBy", (PyCFunction)SbkQDateTimeEditFunc_stepBy, METH_O},
    {"stepEnabled", (PyCFunction)SbkQDateTimeEditFunc_stepEnabled, METH_NOARGS},
    {"textFromDateTime", (PyCFunction)SbkQDateTimeEditFunc_textFromDateTime, METH_O},
    {"time", (PyCFunction)SbkQDateTimeEditFunc_time, METH_NOARGS},
    {"timeSpec", (PyCFunction)SbkQDateTimeEditFunc_timeSpec, METH_NOARGS},
    {"validate", (PyCFunction)SbkQDateTimeEditFunc_validate, METH_VARARGS},
    {"wheelEvent", (PyCFunction)SbkQDateTimeEditFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQDateTimeEditSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QDateTimeEdit* me = reinterpret_cast<QDateTimeEdit*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_IDX]))
        return static_cast<QAbstractSpinBox*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDateTimeEdit_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDateTimeEdit",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDateTimeEdit_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDateTimeEdit_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQDateTimeEditSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDateTimeEdit >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QDateTimeEdit_Section___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDateTimeEdit::Sections >::toPython(
        ((QDateTimeEdit::Sections) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QDateTimeEdit::Sections >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QDateTimeEdit_Section___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDateTimeEdit::Sections >::toPython(
        ((QDateTimeEdit::Sections) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QDateTimeEdit::Sections >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QDateTimeEdit_Section___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDateTimeEdit::Sections >::toPython(
        ((QDateTimeEdit::Sections) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QDateTimeEdit::Sections >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QDateTimeEdit_Section___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QDateTimeEdit::Sections >::toPython(
        ~ Shiboken::Converter< QDateTimeEdit::Sections >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QDateTimeEdit_Section_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QDateTimeEdit_Section___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QDateTimeEdit_Section___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QDateTimeEdit_Section___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QDateTimeEdit_Section___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QDateTimeEdit_Section_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDateTimeEdit_Section_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDateTimeEdit_Section_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Section",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QDateTimeEdit_Section_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDateTimeEdit_Section_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDateTimeEdit_Section_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDateTimeEdit_Section_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDateTimeEdit_Sections_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDateTimeEdit_Sections_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Sections",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QDateTimeEdit_Section_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDateTimeEdit_Sections_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDateTimeEdit_Sections_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QDateTimeEdit_Sections_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QDateTimeEdit(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDATETIMEEDIT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDateTimeEdit_Type);

    SbkQDateTimeEdit_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QABSTRACTSPINBOX_IDX];
    SbkQDateTimeEdit_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQDateTimeEdit_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQDateTimeEdit_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDateTimeEdit_Type));
    PyModule_AddObject(module, "QDateTimeEdit",
        ((PyObject*)&SbkQDateTimeEdit_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Section
    SbkPySide_QtGuiTypes[SBK_QDATETIMEEDIT_SECTION_IDX] = &SbkPySide_QtGui_QDateTimeEdit_Section_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDateTimeEdit_Section_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDateTimeEdit_Section_Type);
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
            "Section",((PyObject*)&SbkPySide_QtGui_QDateTimeEdit_Section_Type));

    // init flags class: QFlags<QDateTimeEdit::Section>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QDATETIMEEDIT_SECTION__IDX] = &SbkPySide_QtGui_QDateTimeEdit_Sections_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDateTimeEdit_Sections_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDateTimeEdit_Sections_Type);
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
            "Sections",((PyObject*)&SbkPySide_QtGui_QDateTimeEdit_Sections_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::NoSection, "NoSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "NoSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "NoSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::AmPmSection, "AmPmSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "AmPmSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "AmPmSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::MSecSection, "MSecSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "MSecSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "MSecSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::SecondSection, "SecondSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "SecondSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "SecondSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::MinuteSection, "MinuteSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "MinuteSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "MinuteSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::HourSection, "HourSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "HourSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "HourSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::DaySection, "DaySection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "DaySection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "DaySection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::MonthSection, "MonthSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "MonthSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "MonthSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::YearSection, "YearSection");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "YearSection", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "YearSection", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::TimeSections_Mask, "TimeSections_Mask");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "TimeSections_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "TimeSections_Mask", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDateTimeEdit_Section_Type,
        (long) QDateTimeEdit::DateSections_Mask, "DateSections_Mask");
    PyDict_SetItemString(SbkQDateTimeEdit_Type.super.ht_type.tp_dict,
        "DateSections_Mask", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDateTimeEdit_Section_Type.tp_dict,
        "DateSections_Mask", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDateTimeEdit::Section");

    Shiboken::TypeResolver::createObjectTypeResolver<QDateTimeEdit >("QDateTimeEdit*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDateTimeEdit >(typeid(QDateTimeEdit).name());
}


} // extern "C"

