/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qcursor_wrapper.h"

// Extra includes
#include <QPixmap>
#include <Qt>
#include <qbitmap.h>
#include <qcursor.h>
#include <qdatastream.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQCursor_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QCursor* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QCursor", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QCursor()
        cptr = new QCursor();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPixmap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!SbkQPixmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        if (numArgs == 1) {
            // QCursor(QPixmap,int,int)
            cptr = new QCursor(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QCursor(QPixmap,int,int)
                cptr = new QCursor(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QCursor(QPixmap,int,int)
                cptr = new QCursor(*cpp_arg0, cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQCursor_Init_TypeError;
        } else goto SbkQCursor_Init_TypeError;
    } else if (Shiboken::Converter<QBitmap & >::isConvertible(pyargs[0]) && Shiboken::Converter<QBitmap & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QBitmap > cpp_arg0_auto_ptr;
        QBitmap* cpp_arg0 = Shiboken::Converter<QBitmap* >::toCpp(pyargs[0]);
        if (!SbkQBitmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QBitmap >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QBitmap > cpp_arg1_auto_ptr;
        QBitmap* cpp_arg1 = Shiboken::Converter<QBitmap* >::toCpp(pyargs[1]);
        if (!SbkQBitmap_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QBitmap >(cpp_arg1);
        if (numArgs == 2) {
            // QCursor(QBitmap,QBitmap,int,int)
            cptr = new QCursor(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // QCursor(QBitmap,QBitmap,int,int)
                cptr = new QCursor(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[3])) {
                int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
                // QCursor(QBitmap,QBitmap,int,int)
                cptr = new QCursor(*cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQCursor_Init_TypeError;
        } else goto SbkQCursor_Init_TypeError;
    } else if (numArgs == 1 && PyLong_Check(pyargs[0])) {
        Qt::HANDLE cpp_arg0 = Shiboken::Converter<Qt::HANDLE >::toCpp(pyargs[0]);
        // QCursor(Qt::HANDLE)
        cptr = new QCursor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<Qt::CursorShape >::isConvertible(pyargs[0])) {
        Qt::CursorShape cpp_arg0 = Shiboken::Converter<Qt::CursorShape >::toCpp(pyargs[0]);
        // QCursor(Qt::CursorShape)
        cptr = new QCursor(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QCursor & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QCursor > cpp_arg0_auto_ptr;
        QCursor* cpp_arg0 = Shiboken::Converter<QCursor* >::toCpp(pyargs[0]);
        if (!SbkQCursor_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QCursor >(cpp_arg0);
        // QCursor(QCursor)
        cptr = new QCursor(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCursor_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QCursor >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQCursor_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQCursor_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.Qt.CursorShape", "Qt::HANDLE", "PySide.QtGui.QBitmap, PySide.QtGui.QBitmap, int = -1, int = -1", "PySide.QtGui.QCursor", "PySide.QtGui.QPixmap, int = -1, int = -1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCursor", overloads);
        return -1;
}

static PyObject* SbkQCursorFunc_bitmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bitmap()const
    QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
    const QBitmap * cpp_result = cppSelf->QCursor::bitmap();
    py_result = Shiboken::Converter<QBitmap * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCursorFunc_hotSpot(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hotSpot()const
    QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QCursor::hotSpot();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCursorFunc_mask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mask()const
    QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
    const QBitmap * cpp_result = cppSelf->QCursor::mask();
    py_result = Shiboken::Converter<QBitmap * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCursorFunc_pixmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixmap()const
    QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
    QPixmap cpp_result = cppSelf->QCursor::pixmap();
    py_result = Shiboken::Converter<QPixmap >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCursorFunc_pos(PyObject* self)
{
    PyObject* py_result = 0;

    // pos()
    QPoint cpp_result = QCursor::pos();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQCursorFunc_setPos(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPos", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setPos(int,int)
        QCursor::setPos(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // setPos(QPoint)
        QCursor::setPos(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCursorFunc_setPos_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCursorFunc_setPos_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QCursor.setPos", overloads);
        return 0;
}

static PyObject* SbkQCursorFunc_setShape(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::CursorShape >::isConvertible(arg)) {
        Qt::CursorShape cpp_arg0 = Shiboken::Converter<Qt::CursorShape >::toCpp(arg);
        // setShape(Qt::CursorShape)
        QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
        cppSelf->QCursor::setShape(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQCursorFunc_setShape_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCursorFunc_setShape_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.CursorShape", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCursor.setShape", overloads);
        return 0;
}

static PyObject* SbkQCursorFunc_shape(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shape()const
    QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
    Qt::CursorShape cpp_result = cppSelf->QCursor::shape();
    py_result = Shiboken::Converter<Qt::CursorShape >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQCursor_methods[] = {
    {"bitmap", (PyCFunction)SbkQCursorFunc_bitmap, METH_NOARGS},
    {"hotSpot", (PyCFunction)SbkQCursorFunc_hotSpot, METH_NOARGS},
    {"mask", (PyCFunction)SbkQCursorFunc_mask, METH_NOARGS},
    {"pixmap", (PyCFunction)SbkQCursorFunc_pixmap, METH_NOARGS},
    {"pos", (PyCFunction)SbkQCursorFunc_pos, METH_NOARGS|METH_STATIC},
    {"setPos", (PyCFunction)SbkQCursorFunc_setPos, METH_VARARGS|METH_STATIC},
    {"setShape", (PyCFunction)SbkQCursorFunc_setShape, METH_O},
    {"shape", (PyCFunction)SbkQCursorFunc_shape, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQCursorFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQCursor_Check(arg) && !SbkQCursor_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QCursor) [reverse operator]
        QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQCursorFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCursorFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCursor.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQCursorFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQCursor_Check(arg) && !SbkQCursor_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QCursor&) [reverse operator]
        QCursor* cppSelf = Shiboken::Converter<QCursor* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQCursorFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQCursorFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QCursor.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQCursor_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQCursorFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQCursorFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCursor_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QCursor",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQCursor_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCursor_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCursor_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QCursor >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QCursor(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCURSOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCursor_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQCursor_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCursor_Type));
    PyModule_AddObject(module, "QCursor",
        ((PyObject*)&SbkQCursor_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QCursor >("QCursor");
    Shiboken::TypeResolver::createValueTypeResolver<QCursor >(typeid(QCursor).name());
}


} // extern "C"

