/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include <set>
#include "pyside_qtgui_python.h"

#include "qcombobox_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qabstractitemview.h>
#include <qaction.h>
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcombobox.h>
#include <qcompleter.h>
#include <qcoreevent.h>
#include <qcursor.h>
#include <qevent.h>
#include <qfont.h>
#include <qgraphicseffect.h>
#include <qgraphicsproxywidget.h>
#include <qicon.h>
#include <qinputcontext.h>
#include <qkeysequence.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlocale.h>
#include <qmargins.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qsizepolicy.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qstyle.h>
#include <qvalidator.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QComboBoxWrapper::QComboBoxWrapper(QWidget * parent) : QComboBox(parent), m_metaObject(0) {
    // ... middle
}

void QComboBoxWrapper::actionEvent(QActionEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "actionEvent"));
    if (py_override.isNull()) {
        return this->QWidget::actionEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QActionEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::changeEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "changeEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::changeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::closeEvent(QCloseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closeEvent"));
    if (py_override.isNull()) {
        return this->QWidget::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QCloseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::contextMenuEvent(QContextMenuEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "contextMenuEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::contextMenuEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QContextMenuEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QComboBoxWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QWidget::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::dragEnterEvent(QDragEnterEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragEnterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragEnterEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::dragLeaveEvent(QDragLeaveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragLeaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragLeaveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::dragMoveEvent(QDragMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dragMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDragMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::dropEvent(QDropEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropEvent"));
    if (py_override.isNull()) {
        return this->QWidget::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QDropEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::enterEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "enterEvent"));
    if (py_override.isNull()) {
        return this->QWidget::enterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

bool QComboBoxWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QComboBox::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QComboBoxWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::focusInEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusInEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::focusInEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QComboBoxWrapper::focusNextPrevChild(bool next)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusNextPrevChild"));
    if (py_override.isNull()) {
        return this->QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(next)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.focusNextPrevChild", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::focusOutEvent(QFocusEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "focusOutEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::focusOutEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFocusEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QComboBoxWrapper::heightForWidth(int arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "heightForWidth"));
    if (py_override.isNull()) {
        return this->QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.heightForWidth", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::hideEvent(QHideEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hideEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::hideEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QHideEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::hidePopup()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hidePopup"));
    if (py_override.isNull()) {
        return this->QComboBox::hidePopup();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::inputMethodEvent(QInputMethodEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QInputMethodEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QVariant QComboBoxWrapper::inputMethodQuery(Qt::InputMethodQuery arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "inputMethodQuery"));
    if (py_override.isNull()) {
        return this->QComboBox::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<Qt::InputMethodQuery >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.inputMethodQuery", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::keyPressEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyPressEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::keyPressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::keyReleaseEvent(QKeyEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "keyReleaseEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::keyReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QKeyEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::languageChange()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "languageChange"));
    if (py_override.isNull()) {
        return this->QWidget::languageChange();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::leaveEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "leaveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::leaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QComboBoxWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QSize QComboBoxWrapper::minimumSizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "minimumSizeHint"));
    if (py_override.isNull()) {
        return this->QComboBox::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.minimumSizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::mouseDoubleClickEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseDoubleClickEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseDoubleClickEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::mouseMoveEvent(QMouseEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseMoveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::mouseMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::mousePressEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mousePressEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::mousePressEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::mouseReleaseEvent(QMouseEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mouseReleaseEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::mouseReleaseEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMouseEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::moveEvent(QMoveEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "moveEvent"));
    if (py_override.isNull()) {
        return this->QWidget::moveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QMoveEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QPaintEngine * QComboBoxWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::paintEvent(QPaintEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::paintEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::resizeEvent(QResizeEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "resizeEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::resizeEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QResizeEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::setVisible(bool visible)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setVisible"));
    if (py_override.isNull()) {
        return this->QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<bool >::toPython(visible)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::showEvent(QShowEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::showEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QShowEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::showPopup()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "showPopup"));
    if (py_override.isNull()) {
        return this->QComboBox::showPopup();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QComboBoxWrapper::sizeHint() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QComboBox::sizeHint();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QComboBox.sizeHint", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

void QComboBoxWrapper::tabletEvent(QTabletEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "tabletEvent"));
    if (py_override.isNull()) {
        return this->QWidget::tabletEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTabletEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QComboBoxWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QComboBoxWrapper::wheelEvent(QWheelEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wheelEvent"));
    if (py_override.isNull()) {
        return this->QComboBox::wheelEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QWheelEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QComboBoxWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QComboBox::staticMetaObject);
}
    return m_metaObject;
}

int QComboBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QComboBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QComboBoxWrapper::~QComboBoxWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQComboBox_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QComboBoxWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QComboBox", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QComboBox(QWidget*)
        cptr = new QComboBoxWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        // QComboBox(QWidget*)
        cptr = new QComboBoxWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQComboBox_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QComboBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQComboBox_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQComboBox_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox", overloads);
        return -1;
}

static PyObject* SbkQComboBoxFunc_addItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addItem", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // addItem(QString,QVariant)
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            cppSelf->QComboBox::addItem(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
            QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
            if (!SbkQVariant_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
            // addItem(QString,QVariant)
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            cppSelf->QComboBox::addItem(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQComboBoxFunc_addItem_TypeError;
    } else if (Shiboken::Converter<QIcon & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!SbkQIcon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (numArgs == 2) {
            // addItem(QIcon,QString,QVariant)
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            cppSelf->QComboBox::addItem(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
            QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
            if (!SbkQVariant_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
            // addItem(QIcon,QString,QVariant)
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            cppSelf->QComboBox::addItem(*cpp_arg0, *cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQComboBoxFunc_addItem_TypeError;
    } else goto SbkQComboBoxFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon, PySide.QtCore.QString, PySide.QtCore.QVariant = QVariant()", "PySide.QtCore.QString, PySide.QtCore.QVariant = QVariant()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.addItem", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_addItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // addItems(QStringList)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::addItems(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_addItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_addItems_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.addItems", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_changeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // changeEvent(QEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::changeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_changeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_changeEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.changeEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    cppSelf->QComboBox::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQComboBoxFunc_clearEditText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearEditText()
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    cppSelf->QComboBox::clearEditText();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQComboBoxFunc_completer(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // completer()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QCompleter * cpp_result = cppSelf->QComboBox::completer();
    py_result = Shiboken::Converter<QCompleter * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_contextMenuEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QContextMenuEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QContextMenuEvent* cpp_arg0 = Shiboken::Converter<QContextMenuEvent* >::toCpp(arg);
        // contextMenuEvent(QContextMenuEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::contextMenuEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_contextMenuEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_contextMenuEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QContextMenuEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.contextMenuEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QComboBox::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QComboBox::currentIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_currentText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentText()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QComboBox::currentText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_duplicatesEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // duplicatesEnabled()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QComboBox::duplicatesEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QComboBox::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.event", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_findData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "findData", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        if (numArgs == 1) {
            // findData(QVariant,int,QFlags<Qt::MatchFlag>)const
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QComboBox::findData(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // findData(QVariant,int,QFlags<Qt::MatchFlag>)const
                QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QComboBox::findData(*cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[2])) {
                QFlags<Qt::MatchFlag> cpp_arg2 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[2]);
                // findData(QVariant,int,QFlags<Qt::MatchFlag>)const
                QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
                int cpp_result = cppSelf->QComboBox::findData(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<int >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQComboBoxFunc_findData_TypeError;
        } else goto SbkQComboBoxFunc_findData_TypeError;
    } else goto SbkQComboBoxFunc_findData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_findData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant, int = Qt.UserRole, PySide.QtCore.Qt.MatchFlags = Qt.MatchExactly|Qt.MatchCaseSensitive", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.findData", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_findText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "findText", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // findText(QString,QFlags<Qt::MatchFlag>)const
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QComboBox::findText(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_MatchFlag_Check(pyargs[1])) {
            QFlags<Qt::MatchFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::MatchFlag> >::toCpp(pyargs[1]);
            // findText(QString,QFlags<Qt::MatchFlag>)const
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QComboBox::findText(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQComboBoxFunc_findText_TypeError;
    } else goto SbkQComboBoxFunc_findText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_findText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.Qt.MatchFlags = Qt.MatchExactly|Qt.MatchCaseSensitive", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.findText", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_focusInEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusInEvent(QFocusEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::focusInEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_focusInEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_focusInEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.focusInEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_focusOutEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFocusEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QFocusEvent* cpp_arg0 = Shiboken::Converter<QFocusEvent* >::toCpp(arg);
        // focusOutEvent(QFocusEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::focusOutEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_focusOutEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_focusOutEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFocusEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.focusOutEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_hasFrame(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasFrame()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QComboBox::hasFrame();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_hideEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHideEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QHideEvent* cpp_arg0 = Shiboken::Converter<QHideEvent* >::toCpp(arg);
        // hideEvent(QHideEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::hideEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_hideEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_hideEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QHideEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.hideEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_hidePopup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // hidePopup()
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    cppSelf->QComboBox::hidePopup();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQComboBoxFunc_iconSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconSize()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QComboBox::iconSize();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_inputMethodEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QInputMethodEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QInputMethodEvent* cpp_arg0 = Shiboken::Converter<QInputMethodEvent* >::toCpp(arg);
        // inputMethodEvent(QInputMethodEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::inputMethodEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_inputMethodEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_inputMethodEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QInputMethodEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.inputMethodEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_inputMethodQuery(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::InputMethodQuery >::isConvertible(arg)) {
        Qt::InputMethodQuery cpp_arg0 = Shiboken::Converter<Qt::InputMethodQuery >::toCpp(arg);
        // inputMethodQuery(Qt::InputMethodQuery)const
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QComboBox::inputMethodQuery(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_inputMethodQuery_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_inputMethodQuery_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.InputMethodQuery", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.inputMethodQuery", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_insertItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertItem", 2, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // insertItem(int,QString,QVariant)
                QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
                cppSelf->QComboBox::insertItem(cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                    return 0;
                std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
                QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
                if (!SbkQVariant_Check(pyargs[2]))
                    cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
                // insertItem(int,QString,QVariant)
                QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
                cppSelf->QComboBox::insertItem(cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQComboBoxFunc_insertItem_TypeError;
        } else if (Shiboken::Converter<QIcon & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
            QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
            if (!SbkQIcon_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QString > cpp_arg2_auto_ptr;
            QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
            if (!SbkQString_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
            if (numArgs == 3) {
                // insertItem(int,QIcon,QString,QVariant)
                QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
                cppSelf->QComboBox::insertItem(cpp_arg0, *cpp_arg1, *cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[3])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[3]))
                    return 0;
                std::auto_ptr<QVariant > cpp_arg3_auto_ptr;
                QVariant* cpp_arg3 = Shiboken::Converter<QVariant* >::toCpp(pyargs[3]);
                if (!SbkQVariant_Check(pyargs[3]))
                    cpp_arg3_auto_ptr = std::auto_ptr<QVariant >(cpp_arg3);
                // insertItem(int,QIcon,QString,QVariant)
                QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
                cppSelf->QComboBox::insertItem(cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQComboBoxFunc_insertItem_TypeError;
        } else goto SbkQComboBoxFunc_insertItem_TypeError;
    } else goto SbkQComboBoxFunc_insertItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_insertItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QIcon, PySide.QtCore.QString, PySide.QtCore.QVariant = QVariant()", "int, PySide.QtCore.QString, PySide.QtCore.QVariant = QVariant()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.insertItem", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_insertItems(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertItems", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!SbkQStringList_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // insertItems(int,QStringList)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::insertItems(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_insertItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_insertItems_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.insertItems", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_insertPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // insertPolicy()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QComboBox::InsertPolicy cpp_result = cppSelf->QComboBox::insertPolicy();
    py_result = Shiboken::Converter<QComboBox::InsertPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_insertSeparator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // insertSeparator(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::insertSeparator(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_insertSeparator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_insertSeparator_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.insertSeparator", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_isEditable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEditable()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QComboBox::isEditable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_itemData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemData", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // itemData(int,int)const
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QComboBox::itemData(cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // itemData(int,int)const
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QComboBox::itemData(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQComboBoxFunc_itemData_TypeError;
    } else goto SbkQComboBoxFunc_itemData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_itemData_TypeError:
        const char* overloads[] = {"int, int = Qt.UserRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.itemData", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_itemDelegate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemDelegate()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QAbstractItemDelegate * cpp_result = cppSelf->QComboBox::itemDelegate();
    py_result = Shiboken::Converter<QAbstractItemDelegate * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_itemIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemIcon(int)const
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        QIcon cpp_result = cppSelf->QComboBox::itemIcon(cpp_arg0);
        py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_itemIcon_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_itemIcon_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.itemIcon", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_itemText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // itemText(int)const
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QComboBox::itemText(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_itemText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQComboBoxFunc_itemText_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.itemText", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_keyPressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyPressEvent(QKeyEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::keyPressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_keyPressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_keyPressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.keyPressEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_keyReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeyEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QKeyEvent* cpp_arg0 = Shiboken::Converter<QKeyEvent* >::toCpp(arg);
        // keyReleaseEvent(QKeyEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::keyReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_keyReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_keyReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeyEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.keyReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_lineEdit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lineEdit()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QLineEdit * cpp_result = cppSelf->QComboBox::lineEdit();
    py_result = Shiboken::Converter<QLineEdit * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_maxCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxCount()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QComboBox::maxCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_maxVisibleItems(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maxVisibleItems()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QComboBox::maxVisibleItems();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_minimumContentsLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumContentsLength()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QComboBox::minimumContentsLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_minimumSizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumSizeHint()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QComboBox::minimumSizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QAbstractItemModel * cpp_result = cppSelf->QComboBox::model();
    py_result = Shiboken::Converter<QAbstractItemModel * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_modelColumn(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // modelColumn()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QComboBox::modelColumn();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_mousePressEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mousePressEvent(QMouseEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::mousePressEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_mousePressEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_mousePressEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.mousePressEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_mouseReleaseEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMouseEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMouseEvent* cpp_arg0 = Shiboken::Converter<QMouseEvent* >::toCpp(arg);
        // mouseReleaseEvent(QMouseEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::mouseReleaseEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_mouseReleaseEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_mouseReleaseEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMouseEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.mouseReleaseEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_paintEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPaintEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPaintEvent* cpp_arg0 = Shiboken::Converter<QPaintEvent* >::toCpp(arg);
        // paintEvent(QPaintEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::paintEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_paintEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_paintEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.paintEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_removeItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeItem(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::removeItem(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_removeItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_removeItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.removeItem", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_resizeEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QResizeEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QResizeEvent* cpp_arg0 = Shiboken::Converter<QResizeEvent* >::toCpp(arg);
        // resizeEvent(QResizeEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::resizeEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_resizeEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_resizeEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QResizeEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.resizeEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_rootModelIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rootModelIndex()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QComboBox::rootModelIndex();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_setCompleter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QCompleter * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QCompleter* cpp_arg0 = Shiboken::Converter<QCompleter* >::toCpp(arg);
        // setCompleter(QCompleter*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setCompleter(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQComboBoxFunc_setCompleter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setCompleter_TypeError:
        const char* overloads[] = {"PySide.QtGui.QCompleter", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setCompleter", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setCurrentIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentIndex(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setCurrentIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setCurrentIndex", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setDuplicatesEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDuplicatesEnabled(bool)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setDuplicatesEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setDuplicatesEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setDuplicatesEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setDuplicatesEnabled", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setEditText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setEditText(QString)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setEditText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setEditText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setEditText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setEditText", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setEditable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEditable(bool)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setEditable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setEditable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setEditable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setEditable", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setFrame(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFrame(bool)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setFrame(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setFrame_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setFrame_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setFrame", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setIconSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSize & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(arg);
        // setIconSize(QSize)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setIconSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setIconSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setIconSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSize", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setIconSize", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setInsertPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QComboBox::InsertPolicy >::isConvertible(arg)) {
        QComboBox::InsertPolicy cpp_arg0 = Shiboken::Converter<QComboBox::InsertPolicy >::toCpp(arg);
        // setInsertPolicy(QComboBox::InsertPolicy)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setInsertPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setInsertPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setInsertPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QComboBox.InsertPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setInsertPolicy", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setItemData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setItemData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // setItemData(int,QVariant,int)
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            cppSelf->QComboBox::setItemData(cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setItemData(int,QVariant,int)
            QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
            cppSelf->QComboBox::setItemData(cpp_arg0, *cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQComboBoxFunc_setItemData_TypeError;
    } else goto SbkQComboBoxFunc_setItemData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setItemData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QVariant, int = Qt.UserRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.setItemData", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setItemDelegate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemDelegate * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemDelegate* cpp_arg0 = Shiboken::Converter<QAbstractItemDelegate* >::toCpp(arg);
        // setItemDelegate(QAbstractItemDelegate*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setItemDelegate(cpp_arg0);

        // Ownership transferences.
        BindingManager::instance().transferOwnershipToCpp(arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setItemDelegate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setItemDelegate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemDelegate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setItemDelegate", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setItemIcon(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemIcon", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QIcon & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QIcon > cpp_arg1_auto_ptr;
        QIcon* cpp_arg1 = Shiboken::Converter<QIcon* >::toCpp(pyargs[1]);
        if (!SbkQIcon_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QIcon >(cpp_arg1);
        // setItemIcon(int,QIcon)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setItemIcon(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setItemIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setItemIcon_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.setItemIcon", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setItemText(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemText", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // setItemText(int,QString)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setItemText(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setItemText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setItemText_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QComboBox.setItemText", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setLineEdit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QLineEdit * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QLineEdit* cpp_arg0 = Shiboken::Converter<QLineEdit* >::toCpp(arg);
        // setLineEdit(QLineEdit*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setLineEdit(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQComboBoxFunc_setLineEdit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setLineEdit_TypeError:
        const char* overloads[] = {"PySide.QtGui.QLineEdit", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setLineEdit", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setMaxCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaxCount(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setMaxCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setMaxCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setMaxCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setMaxCount", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setMaxVisibleItems(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMaxVisibleItems(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setMaxVisibleItems(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setMaxVisibleItems_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setMaxVisibleItems_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setMaxVisibleItems", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setMinimumContentsLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setMinimumContentsLength(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setMinimumContentsLength(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setMinimumContentsLength_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setMinimumContentsLength_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setMinimumContentsLength", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setModel(QAbstractItemModel*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setModel(cpp_arg0);
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setModel(QAbstractItemModel*)1", arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setModel", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setModelColumn(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setModelColumn(int)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setModelColumn(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setModelColumn_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setModelColumn_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setModelColumn", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setRootModelIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setRootModelIndex(QModelIndex)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setRootModelIndex(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setRootModelIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setRootModelIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setRootModelIndex", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setSizeAdjustPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QComboBox::SizeAdjustPolicy >::isConvertible(arg)) {
        QComboBox::SizeAdjustPolicy cpp_arg0 = Shiboken::Converter<QComboBox::SizeAdjustPolicy >::toCpp(arg);
        // setSizeAdjustPolicy(QComboBox::SizeAdjustPolicy)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setSizeAdjustPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_setSizeAdjustPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setSizeAdjustPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QComboBox.SizeAdjustPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setSizeAdjustPolicy", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setValidator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QValidator * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QValidator* cpp_arg0 = Shiboken::Converter<QValidator* >::toCpp(arg);
        // setValidator(const QValidator*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setValidator(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQComboBoxFunc_setValidator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setValidator_TypeError:
        const char* overloads[] = {"PySide.QtGui.QValidator", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setValidator", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_setView(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemView * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemView* cpp_arg0 = Shiboken::Converter<QAbstractItemView* >::toCpp(arg);
        // setView(QAbstractItemView*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::setView(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQComboBoxFunc_setView_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_setView_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemView", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.setView", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_showEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QShowEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QShowEvent* cpp_arg0 = Shiboken::Converter<QShowEvent* >::toCpp(arg);
        // showEvent(QShowEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::showEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_showEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_showEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QShowEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.showEvent", overloads);
        return 0;
}

static PyObject* SbkQComboBoxFunc_showPopup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // showPopup()
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    cppSelf->QComboBox::showPopup();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQComboBoxFunc_sizeAdjustPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeAdjustPolicy()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QComboBox::SizeAdjustPolicy cpp_result = cppSelf->QComboBox::sizeAdjustPolicy();
    py_result = Shiboken::Converter<QComboBox::SizeAdjustPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_sizeHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sizeHint()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QComboBox::sizeHint();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_validator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // validator()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    const QValidator * cpp_result = cppSelf->QComboBox::validator();
    py_result = Shiboken::Converter<QValidator * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_view(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // view()const
    QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
    QAbstractItemView * cpp_result = cppSelf->QComboBox::view();
    py_result = Shiboken::Converter<QAbstractItemView * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQComboBoxFunc_wheelEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWheelEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWheelEvent* cpp_arg0 = Shiboken::Converter<QWheelEvent* >::toCpp(arg);
        // wheelEvent(QWheelEvent*)
        QComboBox* cppSelf = Shiboken::Converter<QComboBox* >::toCpp((PyObject*)self);
        cppSelf->QComboBox::wheelEvent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQComboBoxFunc_wheelEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQComboBoxFunc_wheelEvent_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWheelEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QComboBox.wheelEvent", overloads);
        return 0;
}

static PyMethodDef SbkQComboBox_methods[] = {
    {"addItem", (PyCFunction)SbkQComboBoxFunc_addItem, METH_VARARGS},
    {"addItems", (PyCFunction)SbkQComboBoxFunc_addItems, METH_O},
    {"changeEvent", (PyCFunction)SbkQComboBoxFunc_changeEvent, METH_O},
    {"clear", (PyCFunction)SbkQComboBoxFunc_clear, METH_NOARGS},
    {"clearEditText", (PyCFunction)SbkQComboBoxFunc_clearEditText, METH_NOARGS},
    {"completer", (PyCFunction)SbkQComboBoxFunc_completer, METH_NOARGS},
    {"contextMenuEvent", (PyCFunction)SbkQComboBoxFunc_contextMenuEvent, METH_O},
    {"count", (PyCFunction)SbkQComboBoxFunc_count, METH_NOARGS},
    {"currentIndex", (PyCFunction)SbkQComboBoxFunc_currentIndex, METH_NOARGS},
    {"currentText", (PyCFunction)SbkQComboBoxFunc_currentText, METH_NOARGS},
    {"duplicatesEnabled", (PyCFunction)SbkQComboBoxFunc_duplicatesEnabled, METH_NOARGS},
    {"event", (PyCFunction)SbkQComboBoxFunc_event, METH_O},
    {"findData", (PyCFunction)SbkQComboBoxFunc_findData, METH_VARARGS},
    {"findText", (PyCFunction)SbkQComboBoxFunc_findText, METH_VARARGS},
    {"focusInEvent", (PyCFunction)SbkQComboBoxFunc_focusInEvent, METH_O},
    {"focusOutEvent", (PyCFunction)SbkQComboBoxFunc_focusOutEvent, METH_O},
    {"hasFrame", (PyCFunction)SbkQComboBoxFunc_hasFrame, METH_NOARGS},
    {"hideEvent", (PyCFunction)SbkQComboBoxFunc_hideEvent, METH_O},
    {"hidePopup", (PyCFunction)SbkQComboBoxFunc_hidePopup, METH_NOARGS},
    {"iconSize", (PyCFunction)SbkQComboBoxFunc_iconSize, METH_NOARGS},
    {"inputMethodEvent", (PyCFunction)SbkQComboBoxFunc_inputMethodEvent, METH_O},
    {"inputMethodQuery", (PyCFunction)SbkQComboBoxFunc_inputMethodQuery, METH_O},
    {"insertItem", (PyCFunction)SbkQComboBoxFunc_insertItem, METH_VARARGS},
    {"insertItems", (PyCFunction)SbkQComboBoxFunc_insertItems, METH_VARARGS},
    {"insertPolicy", (PyCFunction)SbkQComboBoxFunc_insertPolicy, METH_NOARGS},
    {"insertSeparator", (PyCFunction)SbkQComboBoxFunc_insertSeparator, METH_O},
    {"isEditable", (PyCFunction)SbkQComboBoxFunc_isEditable, METH_NOARGS},
    {"itemData", (PyCFunction)SbkQComboBoxFunc_itemData, METH_VARARGS},
    {"itemDelegate", (PyCFunction)SbkQComboBoxFunc_itemDelegate, METH_NOARGS},
    {"itemIcon", (PyCFunction)SbkQComboBoxFunc_itemIcon, METH_O},
    {"itemText", (PyCFunction)SbkQComboBoxFunc_itemText, METH_O},
    {"keyPressEvent", (PyCFunction)SbkQComboBoxFunc_keyPressEvent, METH_O},
    {"keyReleaseEvent", (PyCFunction)SbkQComboBoxFunc_keyReleaseEvent, METH_O},
    {"lineEdit", (PyCFunction)SbkQComboBoxFunc_lineEdit, METH_NOARGS},
    {"maxCount", (PyCFunction)SbkQComboBoxFunc_maxCount, METH_NOARGS},
    {"maxVisibleItems", (PyCFunction)SbkQComboBoxFunc_maxVisibleItems, METH_NOARGS},
    {"minimumContentsLength", (PyCFunction)SbkQComboBoxFunc_minimumContentsLength, METH_NOARGS},
    {"minimumSizeHint", (PyCFunction)SbkQComboBoxFunc_minimumSizeHint, METH_NOARGS},
    {"model", (PyCFunction)SbkQComboBoxFunc_model, METH_NOARGS},
    {"modelColumn", (PyCFunction)SbkQComboBoxFunc_modelColumn, METH_NOARGS},
    {"mousePressEvent", (PyCFunction)SbkQComboBoxFunc_mousePressEvent, METH_O},
    {"mouseReleaseEvent", (PyCFunction)SbkQComboBoxFunc_mouseReleaseEvent, METH_O},
    {"paintEvent", (PyCFunction)SbkQComboBoxFunc_paintEvent, METH_O},
    {"removeItem", (PyCFunction)SbkQComboBoxFunc_removeItem, METH_O},
    {"resizeEvent", (PyCFunction)SbkQComboBoxFunc_resizeEvent, METH_O},
    {"rootModelIndex", (PyCFunction)SbkQComboBoxFunc_rootModelIndex, METH_NOARGS},
    {"setCompleter", (PyCFunction)SbkQComboBoxFunc_setCompleter, METH_O},
    {"setCurrentIndex", (PyCFunction)SbkQComboBoxFunc_setCurrentIndex, METH_O},
    {"setDuplicatesEnabled", (PyCFunction)SbkQComboBoxFunc_setDuplicatesEnabled, METH_O},
    {"setEditText", (PyCFunction)SbkQComboBoxFunc_setEditText, METH_O},
    {"setEditable", (PyCFunction)SbkQComboBoxFunc_setEditable, METH_O},
    {"setFrame", (PyCFunction)SbkQComboBoxFunc_setFrame, METH_O},
    {"setIconSize", (PyCFunction)SbkQComboBoxFunc_setIconSize, METH_O},
    {"setInsertPolicy", (PyCFunction)SbkQComboBoxFunc_setInsertPolicy, METH_O},
    {"setItemData", (PyCFunction)SbkQComboBoxFunc_setItemData, METH_VARARGS},
    {"setItemDelegate", (PyCFunction)SbkQComboBoxFunc_setItemDelegate, METH_O},
    {"setItemIcon", (PyCFunction)SbkQComboBoxFunc_setItemIcon, METH_VARARGS},
    {"setItemText", (PyCFunction)SbkQComboBoxFunc_setItemText, METH_VARARGS},
    {"setLineEdit", (PyCFunction)SbkQComboBoxFunc_setLineEdit, METH_O},
    {"setMaxCount", (PyCFunction)SbkQComboBoxFunc_setMaxCount, METH_O},
    {"setMaxVisibleItems", (PyCFunction)SbkQComboBoxFunc_setMaxVisibleItems, METH_O},
    {"setMinimumContentsLength", (PyCFunction)SbkQComboBoxFunc_setMinimumContentsLength, METH_O},
    {"setModel", (PyCFunction)SbkQComboBoxFunc_setModel, METH_O},
    {"setModelColumn", (PyCFunction)SbkQComboBoxFunc_setModelColumn, METH_O},
    {"setRootModelIndex", (PyCFunction)SbkQComboBoxFunc_setRootModelIndex, METH_O},
    {"setSizeAdjustPolicy", (PyCFunction)SbkQComboBoxFunc_setSizeAdjustPolicy, METH_O},
    {"setValidator", (PyCFunction)SbkQComboBoxFunc_setValidator, METH_O},
    {"setView", (PyCFunction)SbkQComboBoxFunc_setView, METH_O},
    {"showEvent", (PyCFunction)SbkQComboBoxFunc_showEvent, METH_O},
    {"showPopup", (PyCFunction)SbkQComboBoxFunc_showPopup, METH_NOARGS},
    {"sizeAdjustPolicy", (PyCFunction)SbkQComboBoxFunc_sizeAdjustPolicy, METH_NOARGS},
    {"sizeHint", (PyCFunction)SbkQComboBoxFunc_sizeHint, METH_NOARGS},
    {"validator", (PyCFunction)SbkQComboBoxFunc_validator, METH_NOARGS},
    {"view", (PyCFunction)SbkQComboBoxFunc_view, METH_NOARGS},
    {"wheelEvent", (PyCFunction)SbkQComboBoxFunc_wheelEvent, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQComboBoxSpecialCastFunction(void* obj, SbkBaseWrapperType* desiredType)
{
    QComboBox* me = reinterpret_cast<QComboBox*>(obj);
    if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX]))
        return static_cast<QWidget*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast<QObject*>(me);
    else if (desiredType == reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast<QPaintDevice*>(me);
    return me;
}


// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQComboBox_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QComboBox",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQComboBox_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQComboBox_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      &SbkQComboBoxSpecialCastFunction,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QComboBox >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QComboBox_InsertPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QComboBox_InsertPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QComboBox_InsertPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "InsertPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QComboBox_InsertPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QComboBox_InsertPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QComboBox_InsertPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SizeAdjustPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QComboBox(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQComboBox_Type);

    SbkQComboBox_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX];
    SbkQComboBox_Type.mi_init = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QWIDGET_IDX])->mi_init;

    // Fill type discovery information
    SbkQComboBox_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQComboBox_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQComboBox_Type));
    PyModule_AddObject(module, "QComboBox",
        ((PyObject*)&SbkQComboBox_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: InsertPolicy
    SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_INSERTPOLICY_IDX] = &SbkPySide_QtGui_QComboBox_InsertPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QComboBox_InsertPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type);
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
            "InsertPolicy",((PyObject*)&SbkPySide_QtGui_QComboBox_InsertPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::NoInsert, "NoInsert");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "NoInsert", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "NoInsert", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::InsertAtTop, "InsertAtTop");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "InsertAtTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "InsertAtTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::InsertAtCurrent, "InsertAtCurrent");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "InsertAtCurrent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "InsertAtCurrent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::InsertAtBottom, "InsertAtBottom");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "InsertAtBottom", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "InsertAtBottom", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::InsertAfterCurrent, "InsertAfterCurrent");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "InsertAfterCurrent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "InsertAfterCurrent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::InsertBeforeCurrent, "InsertBeforeCurrent");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "InsertBeforeCurrent", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "InsertBeforeCurrent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_InsertPolicy_Type,
        (long) QComboBox::InsertAlphabetically, "InsertAlphabetically");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "InsertAlphabetically", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_InsertPolicy_Type.tp_dict,
        "InsertAlphabetically", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QComboBox::InsertPolicy");

    // init enum class: SizeAdjustPolicy
    SbkPySide_QtGuiTypes[SBK_QCOMBOBOX_SIZEADJUSTPOLICY_IDX] = &SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type);
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
            "SizeAdjustPolicy",((PyObject*)&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type,
        (long) QComboBox::AdjustToContents, "AdjustToContents");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "AdjustToContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type.tp_dict,
        "AdjustToContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type,
        (long) QComboBox::AdjustToContentsOnFirstShow, "AdjustToContentsOnFirstShow");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "AdjustToContentsOnFirstShow", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type.tp_dict,
        "AdjustToContentsOnFirstShow", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type,
        (long) QComboBox::AdjustToMinimumContentsLength, "AdjustToMinimumContentsLength");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "AdjustToMinimumContentsLength", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type.tp_dict,
        "AdjustToMinimumContentsLength", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type,
        (long) QComboBox::AdjustToMinimumContentsLengthWithIcon, "AdjustToMinimumContentsLengthWithIcon");
    PyDict_SetItemString(SbkQComboBox_Type.super.ht_type.tp_dict,
        "AdjustToMinimumContentsLengthWithIcon", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QComboBox_SizeAdjustPolicy_Type.tp_dict,
        "AdjustToMinimumContentsLengthWithIcon", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QComboBox::SizeAdjustPolicy");

    Shiboken::TypeResolver::createObjectTypeResolver<QComboBox >("QComboBox*");
    Shiboken::TypeResolver::createObjectTypeResolver<QComboBox >(typeid(QComboBox).name());
}


} // extern "C"

