/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qaction_wrapper.h"

// Extra includes
#include <QList>
#include <qaction.h>
#include <qactiongroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qfont.h>
#include <qgraphicswidget.h>
#include <qicon.h>
#include <qkeysequence.h>
#include <qmenu.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QActionWrapper::QActionWrapper(QObject * parent) : QAction(parent), m_metaObject(0) {
    // ... middle
}

QActionWrapper::QActionWrapper(const QIcon & icon, const QString & text, QObject * parent) : QAction(icon, text, parent), m_metaObject(0) {
    // ... middle
}

QActionWrapper::QActionWrapper(const QString & text, QObject * parent) : QAction(text, parent), m_metaObject(0) {
    // ... middle
}

void QActionWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QActionWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QActionWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QActionWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QActionWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QAction::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAction.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QActionWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAction.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QActionWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QActionWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAction::staticMetaObject);
}
    return m_metaObject;
}

int QActionWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QActionWrapper::~QActionWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAction_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QActionWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QAction", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        // QAction(QString,QObject*)
        cptr = new QActionWrapper(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[1], self);
    } else if (numArgs == 3 && Shiboken::Converter<QIcon & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(pyargs[0]);
        if (!SbkQIcon_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return -1;
        QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
        // QAction(QIcon,QString,QObject*)
        cptr = new QActionWrapper(*cpp_arg0, *cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[2], self);
    } else if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAction(QObject*)
        cptr = new QActionWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAction_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAction_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAction_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", "PySide.QtGui.QIcon, PySide.QtCore.QString, PySide.QtCore.QObject", "PySide.QtCore.QString, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QAction", overloads);
        return -1;
}

static PyObject* SbkQActionFunc_actionGroup(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // actionGroup()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QActionGroup * cpp_result = cppSelf->QAction::actionGroup();
    py_result = Shiboken::Converter<QActionGroup * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_activate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction::ActionEvent >::isConvertible(arg)) {
        QAction::ActionEvent cpp_arg0 = Shiboken::Converter<QAction::ActionEvent >::toCpp(arg);
        // activate(QAction::ActionEvent)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::activate(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_activate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_activate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction.ActionEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.activate", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_associatedGraphicsWidgets(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // associatedGraphicsWidgets()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QList<QGraphicsWidget * > cpp_result = cppSelf->QAction::associatedGraphicsWidgets();
    py_result = Shiboken::Converter<QList<QGraphicsWidget * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_associatedWidgets(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // associatedWidgets()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QList<QWidget * > cpp_result = cppSelf->QAction::associatedWidgets();
    py_result = Shiboken::Converter<QList<QWidget * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_autoRepeat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // autoRepeat()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::autoRepeat();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QAction::data();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAction::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQActionFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.event", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QAction::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_hover(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // hover()
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    cppSelf->QAction::hover();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQActionFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QAction::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_iconText(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // iconText()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAction::iconText();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_isCheckable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCheckable()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::isCheckable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_isChecked(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isChecked()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::isChecked();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_isEnabled(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnabled()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::isEnabled();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_isIconVisibleInMenu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isIconVisibleInMenu()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::isIconVisibleInMenu();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_isSeparator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSeparator()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::isSeparator();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_isVisible(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isVisible()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAction::isVisible();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_menu(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // menu()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QMenu * cpp_result = cppSelf->QAction::menu();
    py_result = Shiboken::Converter<QMenu * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_menuRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // menuRole()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QAction::MenuRole cpp_result = cppSelf->QAction::menuRole();
    py_result = Shiboken::Converter<QAction::MenuRole >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_parentWidget(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // parentWidget()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QWidget * cpp_result = cppSelf->QAction::parentWidget();
    py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_priority(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // priority()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QAction::Priority cpp_result = cppSelf->QAction::priority();
    py_result = Shiboken::Converter<QAction::Priority >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_setActionGroup(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QActionGroup * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QActionGroup* cpp_arg0 = Shiboken::Converter<QActionGroup* >::toCpp(arg);
        // setActionGroup(QActionGroup*)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setActionGroup(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setActionGroup_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setActionGroup_TypeError:
        const char* overloads[] = {"PySide.QtGui.QActionGroup", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setActionGroup", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setAutoRepeat(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAutoRepeat(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setAutoRepeat(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setAutoRepeat_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setAutoRepeat_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setAutoRepeat", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setCheckable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setCheckable(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setCheckable(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setCheckable_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setCheckable_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setCheckable", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setChecked(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setChecked(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setChecked(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setChecked_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setChecked_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setChecked", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setData(QVariant)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setData", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setDisabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setDisabled(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setDisabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setDisabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setDisabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setDisabled", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setEnabled(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setEnabled(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setEnabled(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setEnabled_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setEnabled_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setEnabled", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setFont(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // setFont(QFont)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setFont(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setFont_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setFont_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setFont", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setIcon(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QIcon & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QIcon > cpp_arg0_auto_ptr;
        QIcon* cpp_arg0 = Shiboken::Converter<QIcon* >::toCpp(arg);
        if (!SbkQIcon_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QIcon >(cpp_arg0);
        // setIcon(QIcon)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setIcon(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setIcon_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setIcon_TypeError:
        const char* overloads[] = {"PySide.QtGui.QIcon", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setIcon", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setIconText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setIconText(QString)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setIconText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setIconText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setIconText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setIconText", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setIconVisibleInMenu(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setIconVisibleInMenu(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setIconVisibleInMenu(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setIconVisibleInMenu_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setIconVisibleInMenu_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setIconVisibleInMenu", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setMenu(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QMenu * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMenu* cpp_arg0 = Shiboken::Converter<QMenu* >::toCpp(arg);
        // setMenu(QMenu*)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setMenu(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQActionFunc_setMenu_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setMenu_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMenu", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setMenu", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setMenuRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction::MenuRole >::isConvertible(arg)) {
        QAction::MenuRole cpp_arg0 = Shiboken::Converter<QAction::MenuRole >::toCpp(arg);
        // setMenuRole(QAction::MenuRole)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setMenuRole(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setMenuRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setMenuRole_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction.MenuRole", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setMenuRole", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setPriority(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction::Priority >::isConvertible(arg)) {
        QAction::Priority cpp_arg0 = Shiboken::Converter<QAction::Priority >::toCpp(arg);
        // setPriority(QAction::Priority)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setPriority(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setPriority_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setPriority_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction.Priority", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setPriority", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setSeparator(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setSeparator(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setSeparator(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setSeparator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setSeparator_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setSeparator", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setShortcut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QKeySequence & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QKeySequence > cpp_arg0_auto_ptr;
        QKeySequence* cpp_arg0 = Shiboken::Converter<QKeySequence* >::toCpp(arg);
        if (!SbkQKeySequence_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QKeySequence >(cpp_arg0);
        // setShortcut(QKeySequence)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setShortcut(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setShortcut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setShortcut_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setShortcut", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setShortcutContext(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::ShortcutContext >::isConvertible(arg)) {
        Qt::ShortcutContext cpp_arg0 = Shiboken::Converter<Qt::ShortcutContext >::toCpp(arg);
        // setShortcutContext(Qt::ShortcutContext)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setShortcutContext(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setShortcutContext_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setShortcutContext_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ShortcutContext", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setShortcutContext", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setShortcuts(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QList<QKeySequence >  >::isConvertible(arg)) {
        QList<QKeySequence >  cpp_arg0 = Shiboken::Converter<QList<QKeySequence >  >::toCpp(arg);
        // setShortcuts(QList<QKeySequence>)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setShortcuts(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QKeySequence::StandardKey >::isConvertible(arg)) {
        QKeySequence::StandardKey cpp_arg0 = Shiboken::Converter<QKeySequence::StandardKey >::toCpp(arg);
        // setShortcuts(QKeySequence::StandardKey)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setShortcuts(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setShortcuts_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setShortcuts_TypeError:
        const char* overloads[] = {"PySide.QtGui.QKeySequence.StandardKey", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setShortcuts", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setSoftKeyRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAction::SoftKeyRole >::isConvertible(arg)) {
        QAction::SoftKeyRole cpp_arg0 = Shiboken::Converter<QAction::SoftKeyRole >::toCpp(arg);
        // setSoftKeyRole(QAction::SoftKeyRole)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setSoftKeyRole(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setSoftKeyRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setSoftKeyRole_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAction.SoftKeyRole", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setSoftKeyRole", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setStatusTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setStatusTip(QString)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setStatusTip(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setStatusTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setStatusTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setStatusTip", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setText(QString)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setText(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setText_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setText_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setText", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setToolTip(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setToolTip(QString)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setToolTip(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setToolTip_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setToolTip_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setToolTip", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setVisible(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setVisible(bool)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setVisible(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setVisible_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setVisible_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setVisible", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_setWhatsThis(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setWhatsThis(QString)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        cppSelf->QAction::setWhatsThis(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_setWhatsThis_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQActionFunc_setWhatsThis_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.setWhatsThis", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_shortcut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shortcut()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QKeySequence cpp_result = cppSelf->QAction::shortcut();
    py_result = Shiboken::Converter<QKeySequence >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_shortcutContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shortcutContext()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    Qt::ShortcutContext cpp_result = cppSelf->QAction::shortcutContext();
    py_result = Shiboken::Converter<Qt::ShortcutContext >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_shortcuts(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // shortcuts()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QList<QKeySequence > cpp_result = cppSelf->QAction::shortcuts();
    py_result = Shiboken::Converter<QList<QKeySequence > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_showStatusText(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // showStatusText(QWidget*)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAction::showStatusText();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // showStatusText(QWidget*)
        QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAction::showStatusText(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQActionFunc_showStatusText_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQActionFunc_showStatusText_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QAction.showStatusText", overloads);
        return 0;
}

static PyObject* SbkQActionFunc_softKeyRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // softKeyRole()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QAction::SoftKeyRole cpp_result = cppSelf->QAction::softKeyRole();
    py_result = Shiboken::Converter<QAction::SoftKeyRole >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_statusTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // statusTip()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAction::statusTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAction::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_toggle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toggle()
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    cppSelf->QAction::toggle();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQActionFunc_toolTip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toolTip()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAction::toolTip();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQActionFunc_trigger(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // trigger()
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    cppSelf->QAction::trigger();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQActionFunc_whatsThis(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // whatsThis()const
    QAction* cppSelf = Shiboken::Converter<QAction* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QAction::whatsThis();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQAction_methods[] = {
    {"actionGroup", (PyCFunction)SbkQActionFunc_actionGroup, METH_NOARGS},
    {"activate", (PyCFunction)SbkQActionFunc_activate, METH_O},
    {"associatedGraphicsWidgets", (PyCFunction)SbkQActionFunc_associatedGraphicsWidgets, METH_NOARGS},
    {"associatedWidgets", (PyCFunction)SbkQActionFunc_associatedWidgets, METH_NOARGS},
    {"autoRepeat", (PyCFunction)SbkQActionFunc_autoRepeat, METH_NOARGS},
    {"data", (PyCFunction)SbkQActionFunc_data, METH_NOARGS},
    {"event", (PyCFunction)SbkQActionFunc_event, METH_O},
    {"font", (PyCFunction)SbkQActionFunc_font, METH_NOARGS},
    {"hover", (PyCFunction)SbkQActionFunc_hover, METH_NOARGS},
    {"icon", (PyCFunction)SbkQActionFunc_icon, METH_NOARGS},
    {"iconText", (PyCFunction)SbkQActionFunc_iconText, METH_NOARGS},
    {"isCheckable", (PyCFunction)SbkQActionFunc_isCheckable, METH_NOARGS},
    {"isChecked", (PyCFunction)SbkQActionFunc_isChecked, METH_NOARGS},
    {"isEnabled", (PyCFunction)SbkQActionFunc_isEnabled, METH_NOARGS},
    {"isIconVisibleInMenu", (PyCFunction)SbkQActionFunc_isIconVisibleInMenu, METH_NOARGS},
    {"isSeparator", (PyCFunction)SbkQActionFunc_isSeparator, METH_NOARGS},
    {"isVisible", (PyCFunction)SbkQActionFunc_isVisible, METH_NOARGS},
    {"menu", (PyCFunction)SbkQActionFunc_menu, METH_NOARGS},
    {"menuRole", (PyCFunction)SbkQActionFunc_menuRole, METH_NOARGS},
    {"parentWidget", (PyCFunction)SbkQActionFunc_parentWidget, METH_NOARGS},
    {"priority", (PyCFunction)SbkQActionFunc_priority, METH_NOARGS},
    {"setActionGroup", (PyCFunction)SbkQActionFunc_setActionGroup, METH_O},
    {"setAutoRepeat", (PyCFunction)SbkQActionFunc_setAutoRepeat, METH_O},
    {"setCheckable", (PyCFunction)SbkQActionFunc_setCheckable, METH_O},
    {"setChecked", (PyCFunction)SbkQActionFunc_setChecked, METH_O},
    {"setData", (PyCFunction)SbkQActionFunc_setData, METH_O},
    {"setDisabled", (PyCFunction)SbkQActionFunc_setDisabled, METH_O},
    {"setEnabled", (PyCFunction)SbkQActionFunc_setEnabled, METH_O},
    {"setFont", (PyCFunction)SbkQActionFunc_setFont, METH_O},
    {"setIcon", (PyCFunction)SbkQActionFunc_setIcon, METH_O},
    {"setIconText", (PyCFunction)SbkQActionFunc_setIconText, METH_O},
    {"setIconVisibleInMenu", (PyCFunction)SbkQActionFunc_setIconVisibleInMenu, METH_O},
    {"setMenu", (PyCFunction)SbkQActionFunc_setMenu, METH_O},
    {"setMenuRole", (PyCFunction)SbkQActionFunc_setMenuRole, METH_O},
    {"setPriority", (PyCFunction)SbkQActionFunc_setPriority, METH_O},
    {"setSeparator", (PyCFunction)SbkQActionFunc_setSeparator, METH_O},
    {"setShortcut", (PyCFunction)SbkQActionFunc_setShortcut, METH_O},
    {"setShortcutContext", (PyCFunction)SbkQActionFunc_setShortcutContext, METH_O},
    {"setShortcuts", (PyCFunction)SbkQActionFunc_setShortcuts, METH_O},
    {"setSoftKeyRole", (PyCFunction)SbkQActionFunc_setSoftKeyRole, METH_O},
    {"setStatusTip", (PyCFunction)SbkQActionFunc_setStatusTip, METH_O},
    {"setText", (PyCFunction)SbkQActionFunc_setText, METH_O},
    {"setToolTip", (PyCFunction)SbkQActionFunc_setToolTip, METH_O},
    {"setVisible", (PyCFunction)SbkQActionFunc_setVisible, METH_O},
    {"setWhatsThis", (PyCFunction)SbkQActionFunc_setWhatsThis, METH_O},
    {"shortcut", (PyCFunction)SbkQActionFunc_shortcut, METH_NOARGS},
    {"shortcutContext", (PyCFunction)SbkQActionFunc_shortcutContext, METH_NOARGS},
    {"shortcuts", (PyCFunction)SbkQActionFunc_shortcuts, METH_NOARGS},
    {"showStatusText", (PyCFunction)SbkQActionFunc_showStatusText, METH_NOARGS|METH_O},
    {"softKeyRole", (PyCFunction)SbkQActionFunc_softKeyRole, METH_NOARGS},
    {"statusTip", (PyCFunction)SbkQActionFunc_statusTip, METH_NOARGS},
    {"text", (PyCFunction)SbkQActionFunc_text, METH_NOARGS},
    {"toggle", (PyCFunction)SbkQActionFunc_toggle, METH_NOARGS},
    {"toolTip", (PyCFunction)SbkQActionFunc_toolTip, METH_NOARGS},
    {"trigger", (PyCFunction)SbkQActionFunc_trigger, METH_NOARGS},
    {"whatsThis", (PyCFunction)SbkQActionFunc_whatsThis, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAction_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QAction",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAction_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAction_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAction >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QAction_Priority_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAction_Priority_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAction_Priority_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Priority",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAction_Priority_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAction_Priority_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QAction_Priority_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAction_ActionEvent_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAction_ActionEvent_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAction_ActionEvent_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ActionEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAction_ActionEvent_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAction_ActionEvent_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QAction_ActionEvent_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAction_SoftKeyRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAction_SoftKeyRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAction_SoftKeyRole_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SoftKeyRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAction_SoftKeyRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAction_SoftKeyRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QAction_SoftKeyRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QAction_MenuRole_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QAction_MenuRole_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QAction_MenuRole_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "MenuRole",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QAction_MenuRole_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QAction_MenuRole_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QAction_MenuRole_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QAction(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QACTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAction_Type);

    SbkQAction_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAction_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAction_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAction_Type));
    PyModule_AddObject(module, "QAction",
        ((PyObject*)&SbkQAction_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Priority
    SbkPySide_QtGuiTypes[SBK_QACTION_PRIORITY_IDX] = &SbkPySide_QtGui_QAction_Priority_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAction_Priority_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAction_Priority_Type);
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
            "Priority",((PyObject*)&SbkPySide_QtGui_QAction_Priority_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_Priority_Type,
        (long) QAction::LowPriority, "LowPriority");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "LowPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_Priority_Type.tp_dict,
        "LowPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_Priority_Type,
        (long) QAction::NormalPriority, "NormalPriority");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "NormalPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_Priority_Type.tp_dict,
        "NormalPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_Priority_Type,
        (long) QAction::HighPriority, "HighPriority");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "HighPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_Priority_Type.tp_dict,
        "HighPriority", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAction::Priority");

    // init enum class: ActionEvent
    SbkPySide_QtGuiTypes[SBK_QACTION_ACTIONEVENT_IDX] = &SbkPySide_QtGui_QAction_ActionEvent_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAction_ActionEvent_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAction_ActionEvent_Type);
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
            "ActionEvent",((PyObject*)&SbkPySide_QtGui_QAction_ActionEvent_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_ActionEvent_Type,
        (long) QAction::Trigger, "Trigger");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "Trigger", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_ActionEvent_Type.tp_dict,
        "Trigger", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_ActionEvent_Type,
        (long) QAction::Hover, "Hover");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "Hover", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_ActionEvent_Type.tp_dict,
        "Hover", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAction::ActionEvent");

    // init enum class: SoftKeyRole
    SbkPySide_QtGuiTypes[SBK_QACTION_SOFTKEYROLE_IDX] = &SbkPySide_QtGui_QAction_SoftKeyRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAction_SoftKeyRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAction_SoftKeyRole_Type);
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
            "SoftKeyRole",((PyObject*)&SbkPySide_QtGui_QAction_SoftKeyRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_SoftKeyRole_Type,
        (long) QAction::NoSoftKey, "NoSoftKey");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "NoSoftKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_SoftKeyRole_Type.tp_dict,
        "NoSoftKey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_SoftKeyRole_Type,
        (long) QAction::PositiveSoftKey, "PositiveSoftKey");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "PositiveSoftKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_SoftKeyRole_Type.tp_dict,
        "PositiveSoftKey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_SoftKeyRole_Type,
        (long) QAction::NegativeSoftKey, "NegativeSoftKey");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "NegativeSoftKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_SoftKeyRole_Type.tp_dict,
        "NegativeSoftKey", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_SoftKeyRole_Type,
        (long) QAction::SelectSoftKey, "SelectSoftKey");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "SelectSoftKey", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_SoftKeyRole_Type.tp_dict,
        "SelectSoftKey", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAction::SoftKeyRole");

    // init enum class: MenuRole
    SbkPySide_QtGuiTypes[SBK_QACTION_MENUROLE_IDX] = &SbkPySide_QtGui_QAction_MenuRole_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QAction_MenuRole_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QAction_MenuRole_Type);
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
            "MenuRole",((PyObject*)&SbkPySide_QtGui_QAction_MenuRole_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::NoRole, "NoRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "NoRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "NoRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::TextHeuristicRole, "TextHeuristicRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "TextHeuristicRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "TextHeuristicRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::ApplicationSpecificRole, "ApplicationSpecificRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "ApplicationSpecificRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "ApplicationSpecificRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::AboutQtRole, "AboutQtRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "AboutQtRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "AboutQtRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::AboutRole, "AboutRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "AboutRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "AboutRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::PreferencesRole, "PreferencesRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "PreferencesRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "PreferencesRole", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QAction_MenuRole_Type,
        (long) QAction::QuitRole, "QuitRole");
    PyDict_SetItemString(SbkQAction_Type.super.ht_type.tp_dict,
        "QuitRole", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QAction_MenuRole_Type.tp_dict,
        "QuitRole", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAction::MenuRole");

    Shiboken::TypeResolver::createObjectTypeResolver<QAction >("QAction*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAction >(typeid(QAction).name());
}


} // extern "C"

