/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qabstracttextdocumentlayout_paintcontext_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQAbstractTextDocumentLayout_PaintContext_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractTextDocumentLayout::PaintContext* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "PaintContext", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // PaintContext()
        cptr = new QAbstractTextDocumentLayout::PaintContext();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAbstractTextDocumentLayout::PaintContext* cpp_arg0 = Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp(pyargs[0]);
        // PaintContext(QAbstractTextDocumentLayout::PaintContext)
        cptr = new QAbstractTextDocumentLayout::PaintContext(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractTextDocumentLayout_PaintContext_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractTextDocumentLayout::PaintContext >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractTextDocumentLayout_PaintContext_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractTextDocumentLayout_PaintContext_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractTextDocumentLayout::PaintContext", "", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.PaintContext", overloads);
        return -1;
}

static PyMethodDef SbkQAbstractTextDocumentLayout_PaintContext_methods[] = {
    {0} // Sentinel
};

static PyObject* SbkQAbstractTextDocumentLayout_PaintContext_get_palette(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPalette >::toPython(Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp((PyObject*)self)->palette);
}
static int SbkQAbstractTextDocumentLayout_PaintContext_set_palette(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'palette' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPalette >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'palette', 'QPalette' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp((PyObject*)self)->palette = Shiboken::Converter<QPalette >::toCpp(value);

    return 0;
}

static PyObject* SbkQAbstractTextDocumentLayout_PaintContext_get_cursorPosition(SbkBaseWrapper* self)
{
    return Shiboken::Converter<int >::toPython(Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp((PyObject*)self)->cursorPosition);
}
static int SbkQAbstractTextDocumentLayout_PaintContext_set_cursorPosition(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'cursorPosition' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cursorPosition', 'int' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp((PyObject*)self)->cursorPosition = Shiboken::Converter<int >::toCpp(value);

    return 0;
}

static PyObject* SbkQAbstractTextDocumentLayout_PaintContext_get_clip(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QRectF >::toPython(Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp((PyObject*)self)->clip);
}
static int SbkQAbstractTextDocumentLayout_PaintContext_set_clip(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'clip' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QRectF >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'clip', 'QRectF' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QAbstractTextDocumentLayout::PaintContext* >::toCpp((PyObject*)self)->clip = Shiboken::Converter<QRectF >::toCpp(value);

    return 0;
}

// Getters and Setters for PaintContext
static PyGetSetDef SbkQAbstractTextDocumentLayout_PaintContext_getsetlist[] = {
    {const_cast<char*>("palette"), (getter)SbkQAbstractTextDocumentLayout_PaintContext_get_palette, (setter)SbkQAbstractTextDocumentLayout_PaintContext_set_palette},
    {const_cast<char*>("cursorPosition"), (getter)SbkQAbstractTextDocumentLayout_PaintContext_get_cursorPosition, (setter)SbkQAbstractTextDocumentLayout_PaintContext_set_cursorPosition},
    {const_cast<char*>("clip"), (getter)SbkQAbstractTextDocumentLayout_PaintContext_get_clip, (setter)SbkQAbstractTextDocumentLayout_PaintContext_set_clip},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractTextDocumentLayout_PaintContext_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.PaintContext",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractTextDocumentLayout_PaintContext_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQAbstractTextDocumentLayout_PaintContext_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractTextDocumentLayout_PaintContext_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractTextDocumentLayout::PaintContext >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAbstractTextDocumentLayout_PaintContext(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_PAINTCONTEXT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractTextDocumentLayout_PaintContext_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractTextDocumentLayout_PaintContext_Type) < 0)
        return;

    PyDict_SetItemString(module,"PaintContext", (PyObject*)&SbkQAbstractTextDocumentLayout_PaintContext_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QAbstractTextDocumentLayout::PaintContext >("QAbstractTextDocumentLayout::PaintContext");
    Shiboken::TypeResolver::createValueTypeResolver<QAbstractTextDocumentLayout::PaintContext >(typeid(QAbstractTextDocumentLayout::PaintContext).name());
}


} // extern "C"

